/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import au.com.glenix.ApplicationController;
import au.com.glenix.TransactionEditShortApportionedVBox;
import au.com.glenix.TransactionsTableController;
import au.com.glenix.trn.Business;
import au.com.glenix.trn.GlenixTrnXBRL;
import au.com.glenix.trn.HomeOffice;
import au.com.glenix.trn.Transaction;
import au.com.glenix.trn.TransactionLine;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import org.w3c.dom.Document;

public class TransactionsTableHomeOfficeController
extends TransactionsTableController {
    private HomeOffice homeOffice = null;
    private String homeOfficeIdentifier = null;

    public TransactionsTableHomeOfficeController(ApplicationController xbrlFileController) {
        super(xbrlFileController);
    }

    public void setHomeOffice(HomeOffice homeOffice) {
        this.homeOffice = homeOffice;
        if (homeOffice == null) {
            this.homeOfficeIdentifier = null;
            ((TransactionEditShortApportionedVBox)this.transactionEditFormVBox).setApportionmentRate(0.0);
        } else {
            this.homeOfficeIdentifier = homeOffice.getHomeOfficeIdentifier();
            Double total = homeOffice.getHomeOfficeHomeTotalAreaAsDouble();
            Double rate = 0.0;
            if (total != 0.0) {
                rate = homeOffice.getHomeOfficeFloorAreaAsDouble() / total;
            }
            ((TransactionEditShortApportionedVBox)this.transactionEditFormVBox).setApportionmentRate(rate);
        }
        this.updateFilter();
    }

    @Override
    public void setTransactionDefaults() throws Exception {
        if (this.transaction == null) {
            return;
        }
        String tt = this.transaction.getTransactionType();
        if (tt == null) {
            this.transaction.setTransactionType("purchase_invoice");
        }
        int lines = this.transaction.getTransactionLineCount();
        for (int i = 0; i < lines; ++i) {
            TransactionLine tl = this.transaction.getTransactionLine(i);
            if (tl == null) continue;
            tl.setHomeOfficeIdentifier(this.homeOfficeIdentifier);
        }
    }

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        super.initialize(url, rb);
        this.page_heading.setText("Home office expenses worksheet");
        this.setGlenixElementDescription("Home office expenses worksheet");
    }

    @Override
    protected boolean checkTransactionType(Transaction t) {
        if (t == null) {
            return false;
        }
        if (this.homeOfficeIdentifier == null) {
            return false;
        }
        String tt = t.getTransactionType();
        if (tt == null) {
            return false;
        }
        if (!(tt.equals("purchase_invoice") || tt.equals("purchase_credit") || tt.equals("cash_payment"))) {
            return false;
        }
        HomeOffice ho = t.getHomeOffice();
        if (ho == null) {
            return false;
        }
        String hoi = ho.getHomeOfficeIdentifier();
        if (hoi == null || !hoi.equals(this.homeOfficeIdentifier)) {
            return false;
        }
        String ts = t.getTransactionStatus();
        return ts != null && ts.equals("posted");
    }

    @Override
    protected void validateTransaction() throws Exception {
        super.validateTransaction();
        if (!((TransactionEditShortApportionedVBox)this.transactionEditFormVBox).allLinesHaveApportionment()) {
            throw new Exception("Error, a transaction line is missing full amount, apportionment method or amount");
        }
    }

    @FXML
    private void gotoHomeOfficeEdit() {
        try {
            this.xbrlFileController.gotoHomeOfficeEdit(this.homeOffice);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    private void gotoHomeOfficeList() {
        try {
            this.xbrlFileController.gotoHomeOfficeList();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @Override
    protected void saveTransaction() throws Exception {
        Document resultDoc = this.dBuilder.newDocument();
        this.transactionEditFormVBox.buildGlenixXBRLTransactionPart(resultDoc, null);
        this.transaction.loadDocumentElementOverwrite(resultDoc, resultDoc.getDocumentElement());
        this.setTransactionDefaults();
        this.xbrlFileController.saveTransactionCacheHomeOffice(this.transaction, this.homeOfficeIdentifier);
        GlenixTrnXBRL trns = this.xbrlFileController.getTransactionsForHomeOffice(this.homeOfficeIdentifier);
        Business newb = trns.getBusiness();
        if (newb != this.business) {
            this.setBusinessTransactions(newb);
        }
    }
}

