/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import au.com.glenix.ApplicationController;
import au.com.glenix.TransactionsTableController;
import au.com.glenix.trn.FuelTaxCredit;
import au.com.glenix.trn.Transaction;
import au.com.glenix.trn.TransactionLine;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.fxml.FXML;

public class TransactionsTableFuelTaxCreditController
extends TransactionsTableController {
    private FuelTaxCredit fuelTaxCredit = null;
    private String fuelTaxCreditIdentifier = null;

    public TransactionsTableFuelTaxCreditController(ApplicationController xbrlFileController) {
        super(xbrlFileController);
    }

    public void setFuelTaxCredit(FuelTaxCredit fuelTaxCredit) {
        this.fuelTaxCredit = fuelTaxCredit;
        this.fuelTaxCreditIdentifier = fuelTaxCredit == null ? null : fuelTaxCredit.getFuelTaxCreditIdentifier();
        this.updateFilter();
    }

    @Override
    public void setTransactionDefaults() throws Exception {
        if (this.transaction == null) {
            return;
        }
        String tt = this.transaction.getTransactionType();
        if (tt == null) {
            this.transaction.setTransactionType("purchase_invoice");
        }
        int lines = this.transaction.getTransactionLineCount();
        for (int i = 0; i < lines; ++i) {
            TransactionLine tl = this.transaction.getTransactionLine(i);
            if (tl == null) continue;
            tl.setFuelTaxCreditIdentifier(this.fuelTaxCreditIdentifier);
        }
    }

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        super.initialize(url, rb);
        this.page_heading.setText("Fuel tax credit worksheet");
        this.setGlenixElementDescription("Fuel tax credit worksheet");
    }

    @Override
    protected boolean checkTransactionType(Transaction t) {
        if (t == null) {
            return false;
        }
        if (this.fuelTaxCreditIdentifier == null) {
            return false;
        }
        String tt = t.getTransactionType();
        if (tt == null) {
            return false;
        }
        if (!(tt.equals("purchase_invoice") || tt.equals("purchase_credit") || tt.equals("cash_payment"))) {
            return false;
        }
        FuelTaxCredit ho = t.getFuelTaxCredit();
        if (ho == null) {
            return false;
        }
        String hoi = ho.getFuelTaxCreditIdentifier();
        if (hoi == null || !hoi.equals(this.fuelTaxCreditIdentifier)) {
            return false;
        }
        String ts = t.getTransactionStatus();
        return ts != null && ts.equals("posted");
    }

    @FXML
    private void gotoFuelTaxCreditEdit() {
        try {
            this.xbrlFileController.gotoFuelTaxCreditEdit(this.fuelTaxCredit);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    private void gotoFuelTaxCreditList() {
        try {
            this.xbrlFileController.gotoFuelTaxCreditList();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }
}

