/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import au.com.glenix.ApplicationController;
import au.com.glenix.TransactionEditShortFormVBox;
import au.com.glenix.trn.Account;
import au.com.glenix.trn.ActivityStatement;
import au.com.glenix.trn.Batch;
import au.com.glenix.trn.Business;
import au.com.glenix.trn.DocumentLayout;
import au.com.glenix.trn.GlenixTrnXBRL;
import au.com.glenix.trn.LayoutImage;
import au.com.glenix.trn.Provision;
import au.com.glenix.trn.Transaction;
import au.com.glenix.trn.TransactionLine;
import au.com.glenix.widget.GlenixBranchController;
import au.com.glenix.widget.GlenixLabelDate;
import au.com.glenix.widget.GlenixLabelText;
import au.com.glenix.widget.GlenixPDFWrapper;
import au.com.glenix.widget.GlenixPDFWrapperNewPageCallback;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.math.RoundingMode;
import java.net.URL;
import java.text.DecimalFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TransactionsTableController
extends GlenixBranchController
implements GlenixPDFWrapperNewPageCallback {
    protected DocumentBuilder dBuilder;
    protected GlenixTrnXBRL glenixTrnXBRL = null;
    protected Business business = null;
    @FXML
    protected Label error_message;
    @FXML
    protected Label page_heading;
    @FXML
    protected TableView transactionTable;
    @FXML
    protected TableColumn transactionCounterpartyColumn;
    @FXML
    protected TableColumn amountColumn;
    @FXML
    protected TableColumn accountColumn;
    @FXML
    protected TableColumn provisionColumn;
    @FXML
    protected TableColumn transactionCommentColumn;
    @FXML
    protected TableColumn transactionDateColumn;
    @FXML
    protected TableColumn taxAmountColumn;
    @FXML
    protected TransactionEditShortFormVBox transactionEditFormVBox;
    @FXML
    protected GlenixLabelText filterText;
    @FXML
    protected GlenixLabelDate filterFromDate;
    @FXML
    protected GlenixLabelDate filterToDate;
    protected ApplicationController xbrlFileController = null;
    protected ObservableList<Transaction> transactionObservableList = null;
    protected FilteredList<Transaction> filteredItems = null;
    protected String pattern = "dd MMM yyyy";
    protected DateTimeFormatter displayDateFormatter;
    protected Transaction transaction = null;
    @FXML
    protected Label total_label;
    protected DecimalFormat amountFormat;
    protected DecimalFormat quantityFormat;
    protected LocalDate lastLocalDate = null;
    protected HashSet<String> validTransactionTypes = new HashSet();
    protected boolean suspendselectchange = false;
    @FXML
    protected ScrollPane transaction_scroll_pane;
    @FXML
    protected Region otherpane;
    @FXML
    protected VBox resizevbox;

    public TransactionsTableController(ApplicationController xbrlFileController) {
        this.xbrlFileController = xbrlFileController;
        this.amountFormat = new DecimalFormat("$#,##0.00");
        this.amountFormat.setRoundingMode(RoundingMode.HALF_UP);
        this.quantityFormat = new DecimalFormat("#,##0.######");
        this.quantityFormat.setRoundingMode(RoundingMode.HALF_UP);
    }

    public Set<String> getValidTransactionTypes() {
        return this.validTransactionTypes;
    }

    protected void setupActionColumn() {
        if (this.transactionTable != null) {
            this.transactionTable.setRowFactory(tv -> {
                TableRow row = new TableRow();
                row.setOnMouseClicked(event -> {
                    block12: {
                        if (event.getClickCount() != 1 && event.getClickCount() == 2) {
                            if (!row.isEmpty()) {
                                Transaction transaction = (Transaction)row.getItem();
                                if (transaction != null) {
                                    try {
                                        String batchIdentifier = transaction.getBatchIdentifier();
                                        if (batchIdentifier != null && !batchIdentifier.isEmpty()) {
                                            String tt = transaction.getTransactionType();
                                            if (tt == null || tt.equals("pay_slip")) {
                                                this.xbrlFileController.gotoBatchPaySlipEdit(transaction, batchIdentifier);
                                            } else {
                                                this.xbrlFileController.gotoBatchTransactionEdit(transaction, batchIdentifier);
                                            }
                                            break block12;
                                        }
                                        String homeOfficeIdentifier = transaction.getHomeOfficeIdentifier();
                                        if (homeOfficeIdentifier != null && !homeOfficeIdentifier.isEmpty()) {
                                            this.xbrlFileController.gotoHomeOfficeTransactionsE(transaction, homeOfficeIdentifier);
                                            break block12;
                                        }
                                        String fuelTaxCreditIdentifier = transaction.getFuelTaxCreditIdentifier();
                                        if (fuelTaxCreditIdentifier != null && !fuelTaxCreditIdentifier.isEmpty()) {
                                            this.xbrlFileController.gotoFuelTaxCreditTransactionsE(transaction, fuelTaxCreditIdentifier);
                                            break block12;
                                        }
                                        this.error_message.setText(null);
                                        this.xbrlFileController.setStatusBarMessage(null);
                                        this.loadTransaction(transaction);
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                        this.error_message.setText("Error, could not go to transaction edit page.");
                                        this.xbrlFileController.setStatusBarMessage("Error, could not go to transaction edit page.");
                                    }
                                } else {
                                    this.error_message.setText("Error, could not get transaction.");
                                    this.xbrlFileController.setStatusBarMessage("Error, could not get transaction.");
                                }
                            } else {
                                this.clearTransaction();
                            }
                        }
                    }
                });
                return row;
            });
            this.transactionTable.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<Transaction>(){

                public void changed(ObservableValue<? extends Transaction> observable, Transaction oldValue, final Transaction newValue) {
                    if (!TransactionsTableController.this.suspendselectchange && newValue != null && newValue != TransactionsTableController.this.transaction) {
                        TransactionsTableController.this.error_message.setText("Loading...");
                        new Thread(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    Thread.sleep(100L);
                                    Platform.runLater(() -> TransactionsTableController.this.loadTransaction(newValue));
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        }).start();
                    }
                }
            });
        }
    }

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setNamespaceAware(true);
            this.dBuilder = dbFactory.newDocumentBuilder();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
        this.displayDateFormatter = DateTimeFormatter.ofPattern(this.pattern);
        if (this.transactionEditFormVBox != null) {
            this.lastLocalDate = LocalDate.now();
            this.transactionEditFormVBox.setTransactionLocalDate(this.lastLocalDate);
        }
        this.setupActionColumn();
        if (this.transactionCounterpartyColumn != null) {
            this.transactionCounterpartyColumn.setCellFactory((Callback)new Callback<TableColumn<Transaction, String>, TableCell<Transaction, String>>(){

                public TableCell call(TableColumn<Transaction, String> param) {
                    TableCell<Transaction, String> cell = new TableCell<Transaction, String>(){

                        public void updateItem(String item, boolean empty) {
                            super.updateItem((Object)item, empty);
                            this.setGraphic(null);
                            if (empty) {
                                this.setText(null);
                            } else {
                                Transaction t = (Transaction)this.getTableView().getItems().get(this.getIndex());
                                String id = t.getCounterpartyIdentifier();
                                boolean isset = false;
                                if (id != null) {
                                    try {
                                        Transaction ct = TransactionsTableController.this.xbrlFileController.getCounterpartyTransaction(id);
                                        if (ct != null) {
                                            this.setText(ct.getCounterpartyLegalName());
                                            isset = true;
                                        }
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                                if (!isset) {
                                    this.setText(null);
                                }
                            }
                        }
                    };
                    return cell;
                }
            });
        }
        if (this.transactionDateColumn != null) {
            this.transactionDateColumn.setCellFactory((Callback)new Callback<TableColumn<Transaction, LocalDate>, TableCell<Transaction, LocalDate>>(){

                public TableCell call(TableColumn<Transaction, LocalDate> param) {
                    TableCell<Transaction, LocalDate> cell = new TableCell<Transaction, LocalDate>(){

                        public void updateItem(LocalDate item, boolean empty) {
                            super.updateItem((Object)item, empty);
                            this.setGraphic(null);
                            if (empty) {
                                this.setText(null);
                            } else if (item == null) {
                                this.setText(null);
                            } else {
                                this.setText(TransactionsTableController.this.displayDateFormatter.format(item));
                            }
                        }
                    };
                    return cell;
                }
            });
        }
        if (this.amountColumn != null) {
            this.amountColumn.setCellFactory((Callback)new Callback<TableColumn<Transaction, Double>, TableCell<Transaction, Double>>(){

                public TableCell call(TableColumn<Transaction, Double> param) {
                    TableCell<Transaction, Double> cell = new TableCell<Transaction, Double>(){

                        public void updateItem(Double item, boolean empty) {
                            super.updateItem((Object)item, empty);
                            this.setGraphic(null);
                            if (empty || item == null) {
                                this.setText(null);
                            } else {
                                this.setText(TransactionsTableController.this.amountFormat.format(item));
                            }
                        }
                    };
                    return cell;
                }
            });
        }
        if (this.taxAmountColumn != null) {
            this.taxAmountColumn.setCellFactory((Callback)new Callback<TableColumn<Transaction, Double>, TableCell<Transaction, Double>>(){

                public TableCell call(TableColumn<Transaction, Double> param) {
                    TableCell<Transaction, Double> cell = new TableCell<Transaction, Double>(){

                        public void updateItem(Double item, boolean empty) {
                            super.updateItem((Object)item, empty);
                            this.setGraphic(null);
                            if (empty || item == null) {
                                this.setText(null);
                            } else {
                                this.setText(TransactionsTableController.this.amountFormat.format(item));
                            }
                        }
                    };
                    return cell;
                }
            });
        }
        if (this.accountColumn != null) {
            this.accountColumn.setCellFactory((Callback)new Callback<TableColumn<Transaction, Account>, TableCell<Transaction, Account>>(){

                public TableCell call(TableColumn<Transaction, Account> param) {
                    TableCell<Transaction, Account> cell = new TableCell<Transaction, Account>(){

                        public void updateItem(Account item, boolean empty) {
                            super.updateItem((Object)item, empty);
                            this.setGraphic(null);
                            if (empty) {
                                this.setText(null);
                            } else {
                                Transaction t = (Transaction)this.getTableView().getItems().get(this.getIndex());
                                String id = t.getUniqueAccountIdentifier();
                                boolean isset = false;
                                if (id != null) {
                                    try {
                                        Transaction ct = TransactionsTableController.this.xbrlFileController.getAccountTransaction(id);
                                        if (ct != null) {
                                            this.setText(ct.getAccountName());
                                            isset = true;
                                        }
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                                if (!isset) {
                                    this.setText("split...");
                                }
                            }
                        }
                    };
                    return cell;
                }
            });
        }
        if (this.provisionColumn != null) {
            this.provisionColumn.setCellFactory((Callback)new Callback<TableColumn<Transaction, Provision>, TableCell<Transaction, Provision>>(){

                public TableCell call(TableColumn<Transaction, Provision> param) {
                    TableCell<Transaction, Provision> cell = new TableCell<Transaction, Provision>(){

                        public void updateItem(Provision item, boolean empty) {
                            super.updateItem((Object)item, empty);
                            this.setGraphic(null);
                            if (empty) {
                                this.setText(null);
                            } else {
                                Transaction t = (Transaction)this.getTableView().getItems().get(this.getIndex());
                                String id = t.getUniqueProvisionIdentifier();
                                boolean isset = false;
                                if (id != null) {
                                    try {
                                        Transaction ct = TransactionsTableController.this.xbrlFileController.getProvisionTransaction(id);
                                        if (ct != null) {
                                            this.setText(ct.getProvisionName());
                                            isset = true;
                                        }
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                                if (!isset) {
                                    this.setText("split...");
                                }
                            }
                        }
                    };
                    return cell;
                }
            });
        }
        if (this.resizevbox != null && this.otherpane != null && this.transaction_scroll_pane != null && this.transactionEditFormVBox != null) {
            this.transactionEditFormVBox.heightProperty().addListener((ChangeListener)new ChangeListener<Number>(){

                public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                    double height = TransactionsTableController.this.resizevbox.getHeight();
                    height -= TransactionsTableController.this.error_message.getHeight();
                    double vbheight = TransactionsTableController.this.transactionEditFormVBox.getHeight();
                    if ((height -= vbheight) < 300.0) {
                        height = 300.0;
                    }
                    TransactionsTableController.this.otherpane.setPrefHeight(height);
                    TransactionsTableController.this.otherpane.setMaxHeight(height);
                    TransactionsTableController.this.transaction_scroll_pane.setPrefHeight(vbheight);
                    TransactionsTableController.this.resizevbox.layout();
                }
            });
            this.transactionEditFormVBox.prefHeightProperty().addListener((ChangeListener)new ChangeListener<Number>(){

                public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                    double height = TransactionsTableController.this.resizevbox.getHeight();
                    height -= TransactionsTableController.this.error_message.getHeight();
                    if ((height -= newValue.doubleValue()) < 300.0) {
                        height = 300.0;
                    }
                    TransactionsTableController.this.otherpane.setPrefHeight(height);
                    TransactionsTableController.this.otherpane.setMaxHeight(height);
                    TransactionsTableController.this.transaction_scroll_pane.setPrefHeight(newValue.doubleValue());
                    TransactionsTableController.this.resizevbox.layout();
                }
            });
            this.resizevbox.heightProperty().addListener((ChangeListener)new ChangeListener<Number>(){

                public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                    double height = TransactionsTableController.this.resizevbox.getHeight();
                    height -= TransactionsTableController.this.error_message.getHeight();
                    double vbheight = TransactionsTableController.this.transactionEditFormVBox.getHeight();
                    if ((height -= vbheight) < 300.0) {
                        height = 300.0;
                    }
                    TransactionsTableController.this.otherpane.setPrefHeight(height);
                    TransactionsTableController.this.otherpane.setMaxHeight(height);
                    TransactionsTableController.this.transaction_scroll_pane.setPrefHeight(vbheight);
                    TransactionsTableController.this.resizevbox.layout();
                }
            });
        }
    }

    @Override
    public void buildGlenixXBRL(Document resultDoc, Element resultElement) throws Exception {
        Element xbrlEl = resultDoc.createElementNS("http://www.glenix.com.au/", "gx:glenix");
        if (resultElement == null) {
            resultDoc.appendChild(xbrlEl);
        } else {
            resultElement.appendChild(xbrlEl);
        }
        super.buildGlenixXBRL(resultDoc, xbrlEl);
    }

    @Override
    public void loadGlenixXBRL(Document loadDoc, Element loadElement) throws Exception {
        if (loadElement.getNamespaceURI() != null && loadElement.getNamespaceURI().equals("http://www.glenix.com.au/") && loadElement.getLocalName() != null && loadElement.getLocalName().equals("glenix")) {
            NodeList nodeList = loadElement.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                Element el = (Element)node;
                super.loadGlenixXBRL(loadDoc, el);
            }
        }
    }

    public void setCounterpartyTransactionList(ObservableList<Transaction> counterpartyObservableList) {
        if (this.transactionEditFormVBox != null) {
            this.transactionEditFormVBox.setCounterpartyTransactionList(counterpartyObservableList);
        }
    }

    public void setProvisionList(ObservableList<Transaction> provisionObservableList) {
        if (this.transactionEditFormVBox != null) {
            this.transactionEditFormVBox.setProvisionList(provisionObservableList);
        }
    }

    public void setAccountList(ObservableList<Transaction> accountObservableList) {
        if (this.transactionEditFormVBox != null) {
            this.transactionEditFormVBox.setAccountList(accountObservableList);
        }
    }

    public void setBusinessTransactions(Business business) {
        this.business = business;
        if (business != null) {
            ArrayList<Transaction> tal = business.getTransactionArrayList();
            ObservableList tol = FXCollections.observableList(tal);
            this.setTransactionObservableList((ObservableList<Transaction>)tol);
        }
        this.setPageHeading();
    }

    protected void createFilteredItems() {
        this.filteredItems = new FilteredList(this.transactionObservableList, t -> this.checkTransactionType((Transaction)t));
        this.transactionTable.setItems(this.filteredItems);
        if (this.filterText != null) {
            this.filterText.addTextChangeListener((ChangeListener<String>)((ChangeListener)(obs, oldValue, newValue) -> this.updateFilter()));
        }
        if (this.filterFromDate != null) {
            this.filterFromDate.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(obs, oldValue, newValue) -> this.updateFilter()));
        }
        if (this.filterToDate != null) {
            this.filterToDate.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(obs, oldValue, newValue) -> this.updateFilter()));
        }
        this.updateTotalAmount();
    }

    protected void setTransactionObservableList(ObservableList<Transaction> transactionObservableList) {
        transactionObservableList.sort((Comparator)new Comparator<Transaction>(){

            @Override
            public int compare(Transaction t1, Transaction t2) {
                String t1date = t1.getTransactionDate();
                String t2date = t2.getTransactionDate();
                if (t1date == null || t1date.isEmpty()) {
                    if (t2date != null && !t2date.isEmpty()) {
                        return -1;
                    }
                } else {
                    if (t2date == null || t2date.isEmpty()) {
                        return 1;
                    }
                    int result = t1date.compareTo(t2date);
                    if (result != 0) {
                        return result;
                    }
                }
                String t1ci = t1.getCounterpartyIdentifier();
                String t2ci = t2.getCounterpartyIdentifier();
                if (t1ci == null || t1ci.isEmpty()) {
                    if (t2ci != null && !t2ci.isEmpty()) {
                        return -1;
                    }
                } else {
                    if (t2ci == null || t2ci.isEmpty()) {
                        return 1;
                    }
                    String t1cname = null;
                    String t2cname = null;
                    try {
                        Transaction t1ct = TransactionsTableController.this.xbrlFileController.getCounterpartyTransaction(t1ci);
                        if (t1ct != null) {
                            t1cname = t1ct.getCounterpartyLegalName();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    try {
                        Transaction t2ct = TransactionsTableController.this.xbrlFileController.getCounterpartyTransaction(t2ci);
                        if (t2ct != null) {
                            t2cname = t2ct.getCounterpartyLegalName();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (t1cname == null || t1cname.isEmpty()) {
                        if (t2cname != null && !t2cname.isEmpty()) {
                            return -1;
                        }
                    } else {
                        if (t2cname == null || t2cname.isEmpty()) {
                            return 1;
                        }
                        int result = t1cname.compareTo(t2cname);
                        if (result != 0) {
                            return result;
                        }
                    }
                }
                String t1comment = t1.getTransactionComment();
                String t2comment = t2.getTransactionComment();
                if (t1comment == null || t1comment.isEmpty()) {
                    if (t2comment != null && !t2comment.isEmpty()) {
                        return -1;
                    }
                } else {
                    if (t2comment == null || t2comment.isEmpty()) {
                        return 1;
                    }
                    int result = t1comment.compareTo(t2comment);
                    if (result != 0) {
                        return result;
                    }
                }
                return t1.toString().compareTo(t2.toString());
            }
        });
        this.transactionObservableList = transactionObservableList;
        this.createFilteredItems();
    }

    protected void updateFilter() {
        String filterTextValue = null;
        if (this.filterText != null) {
            filterTextValue = this.filterText.getText();
        }
        LocalDate fromDateValue = null;
        if (this.filterFromDate != null) {
            fromDateValue = this.filterFromDate.getLocalDate();
        }
        LocalDate toDateValue = null;
        if (this.filterToDate != null) {
            toDateValue = this.filterToDate.getLocalDate();
        }
        this.updateFilter(filterTextValue, fromDateValue, toDateValue);
    }

    protected boolean checkTransactionType(Transaction t) {
        return true;
    }

    protected void updateFilter(String newValue, LocalDate fromDate, LocalDate toDate) {
        if (this.filteredItems != null) {
            this.filteredItems.setPredicate(t -> {
                String formattedDate;
                if (!this.checkTransactionType((Transaction)t)) {
                    return false;
                }
                LocalDate localDate = t.getTransactionDateAsDate();
                if (fromDate != null || toDate != null) {
                    if (localDate == null) {
                        return false;
                    }
                    if (fromDate != null && localDate.isBefore(fromDate)) {
                        return false;
                    }
                    if (toDate != null && localDate.isAfter(toDate)) {
                        return false;
                    }
                }
                if (newValue == null || newValue.isEmpty()) {
                    return true;
                }
                String transactionComment = t.getTransactionComment();
                if (transactionComment != null && transactionComment.toLowerCase().contains(newValue.toLowerCase())) {
                    return true;
                }
                String cid = t.getCounterpartyIdentifier();
                if (cid != null && !cid.isEmpty()) {
                    try {
                        String cname;
                        Transaction ct = this.xbrlFileController.getCounterpartyTransaction(cid);
                        if (ct != null && (cname = ct.getCounterpartyLegalName()) != null && !cname.isEmpty() && cname.toLowerCase().contains(newValue.toLowerCase())) {
                            return true;
                        }
                    }
                    catch (Exception ct) {
                        // empty catch block
                    }
                }
                return localDate != null && (formattedDate = this.displayDateFormatter.format(localDate)) != null && !formattedDate.isEmpty() && formattedDate.toLowerCase().contains(newValue.toLowerCase());
            });
        }
        this.updateTotalAmount();
    }

    @FXML
    private void addTransaction() {
        try {
            this.xbrlFileController.gotoTransactionEdit(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    protected void loadTransaction(Transaction newTransaction) {
        block15: {
            if (newTransaction != null) {
                try {
                    String batchIdentifier = newTransaction.getBatchIdentifier();
                    if (batchIdentifier != null && !batchIdentifier.isEmpty()) {
                        this.error_message.setText("Error, the selected transaction is on a batch. Double click to go to edit.");
                        this.xbrlFileController.setStatusBarMessage("Error, the selected transaction is on a batch. Double click to go to edit.");
                        if (this.transactionEditFormVBox != null) {
                            this.transactionEditFormVBox.setTransactionElement(null);
                        }
                        this.transaction = null;
                        break block15;
                    }
                    String type = newTransaction.getTransactionType();
                    if (type != null && type.equals("pay_slip")) {
                        this.error_message.setText("Error, cannot edit pay slip on this page. Double click to go to the pay slip edit page.");
                        if (this.transactionEditFormVBox != null) {
                            this.transactionEditFormVBox.setTransactionElement(null);
                        }
                        this.transaction = null;
                    } else {
                        if (this.transactionEditFormVBox != null) {
                            this.transactionEditFormVBox.setTransactionElement(newTransaction);
                        }
                        this.transaction = newTransaction;
                    }
                    this.error_message.setText(null);
                    this.xbrlFileController.setStatusBarMessage(null);
                }
                catch (Exception e) {
                    this.transaction = null;
                    e.printStackTrace();
                    this.error_message.setText("Error, could not quick edit transaction.");
                    this.xbrlFileController.setStatusBarMessage("Error, could not quick edit transaction.");
                    try {
                        this.transactionEditFormVBox.setTransactionElement(null);
                    }
                    catch (Exception exception) {}
                }
            } else {
                this.transaction = null;
                this.error_message.setText(null);
                this.xbrlFileController.setStatusBarMessage(null);
                if (this.transactionEditFormVBox != null) {
                    try {
                        this.transactionEditFormVBox.setTransactionElement(null);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.error_message.setText(e.getMessage());
                        this.xbrlFileController.setStatusBarMessage(e.getMessage());
                    }
                }
            }
        }
        this.updateTotalAmount();
    }

    public void setPageHeading() {
        String worksheetdesc = this.getGlenixElementDescription();
        if (worksheetdesc != null && !worksheetdesc.isEmpty()) {
            String displayname = this.xbrlFileController.getBusinessLegalName();
            if (displayname != null && !displayname.isEmpty()) {
                this.page_heading.setText(worksheetdesc + " - " + displayname);
            } else {
                this.page_heading.setText(worksheetdesc);
            }
        }
    }

    public void setTransaction(Transaction transaction) {
        this.suspendselectchange = true;
        this.loadTransaction(transaction);
        if (this.filteredItems != null) {
            this.transactionTable.getSelectionModel().clearSelection();
            this.transactionTable.getSelectionModel().select((Object)transaction);
        }
        this.suspendselectchange = false;
        this.setPageHeading();
    }

    public void setTransactionDefaults() throws Exception {
        if (this.transaction == null) {
            return;
        }
        String tt = this.transaction.getTransactionType();
        if (tt == null) {
            this.transaction.setTransactionType("cash_payment");
        }
    }

    private boolean lodgedActivityStatementIsChanged(boolean statusChange) {
        if (this.transaction == null) {
            return false;
        }
        HashSet<String> ass = new HashSet<String>();
        boolean hasas = false;
        for (int i = 0; i < this.transaction.getTransactionLineCount(); ++i) {
            String status;
            ActivityStatement as;
            TransactionLine tl = this.transaction.getTransactionLine(i);
            String asNumber = tl.getActivityStatementNumber();
            if (asNumber == null || asNumber.isEmpty()) continue;
            hasas = true;
            GlenixTrnXBRL asTrn = null;
            try {
                asTrn = this.xbrlFileController.loadActivityStatement(asNumber);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (asTrn == null || (as = asTrn.getActivityStatement()) == null || (status = as.getSBRDocumentStatus()) == null || status.equals("created") || status.equals("list_complete") || status.equals("list_in_progress") || status.equals("prefill_complete") || status.equals("prefill_in_progress") || status.equals("prelodge_complete") || status.equals("prelodge_in_progress")) continue;
            if (statusChange) {
                return true;
            }
            ass.add(asNumber);
        }
        if (this.transactionEditFormVBox == null) {
            return hasas;
        }
        return this.transactionEditFormVBox.basChanged(ass);
    }

    private boolean transactionBatchIsLocked() {
        String bi;
        Transaction bt;
        Batch b;
        String trBi = null;
        if (this.transaction != null && (b = this.transaction.getBatch()) != null && (trBi = b.getBatchIdentifier()) != null && !trBi.isEmpty()) {
            String status;
            bt = null;
            try {
                bt = this.xbrlFileController.getBatchTransaction(trBi);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (bt != null && (status = bt.getBatchStatus()) != null && !status.equals("created")) {
                return true;
            }
        }
        if (this.transactionEditFormVBox != null && (bi = this.transactionEditFormVBox.getTransactionBatchIdentifier()) != null && !bi.isEmpty() && !bi.equals(trBi)) {
            bt = null;
            try {
                bt = this.xbrlFileController.getBatchTransaction(bi);
            }
            catch (Exception status) {
                // empty catch block
            }
            if (bt != null && (status = bt.getBatchStatus()) != null && !status.equals("created")) {
                return true;
            }
        }
        return false;
    }

    protected void saveTransaction() throws Exception {
        Double totalAmount;
        Document resultDoc = this.dBuilder.newDocument();
        this.transactionEditFormVBox.buildGlenixXBRLTransactionPart(resultDoc, null);
        this.transaction.loadDocumentElementOverwrite(resultDoc, resultDoc.getDocumentElement());
        this.setTransactionDefaults();
        this.transaction.removeMasterFileInformation();
        String tt = this.transaction.getTransactionType();
        if (tt == null || tt.isEmpty()) {
            throw new Exception("Error, no transaction type selected");
        }
        if (tt.equals("general_journal") && !(totalAmount = this.transaction.getTotalAmount()).equals(0.0)) {
            throw new Exception("Error, journal does not balance. Total should be zero");
        }
        this.xbrlFileController.saveTransaction(this.transaction);
    }

    protected void validateTransaction() throws Exception {
        Double totalAmount;
        String status;
        if (this.transactionEditFormVBox == null) {
            throw new Exception("Error, no transaction edit form found");
        }
        boolean statusChange = false;
        if (this.transaction != null && !(status = this.transaction.getTransactionStatus()).equals("posted")) {
            statusChange = true;
        }
        if (this.lodgedActivityStatementIsChanged(statusChange)) {
            this.transactionEditFormVBox.setTransactionElement(this.transaction);
            throw new Exception("Error, one of the modified lines is on a lodged Activity Statment.");
        }
        if (this.transactionBatchIsLocked()) {
            this.transactionEditFormVBox.setTransactionElement(this.transaction);
            throw new Exception("Error, you cannot modify the transaction as it is on an authorised or lodged Batch.");
        }
        LocalDate ld = this.transactionEditFormVBox.getTransactionLocalDate();
        if (ld == null) {
            throw new Exception("Error, a transaction date is blank or incorrect");
        }
        String counterpartyIdentifier = this.transactionEditFormVBox.getCounterpartyIdentifier();
        if (counterpartyIdentifier == null || counterpartyIdentifier.isEmpty()) {
            throw new Exception("Error, the transaction does not have a counterparty, select a counterparty");
        }
        if (!this.transactionEditFormVBox.allLinesHaveAccount()) {
            throw new Exception("Error, a transaction line is missing an account");
        }
        String transactionType = this.transactionEditFormVBox.getTransactionType();
        if (transactionType != null && !transactionType.isEmpty() && transactionType.equals("general_journal") && !(totalAmount = this.transactionEditFormVBox.getTotalAmount()).equals(0.0)) {
            throw new Exception("Error, journal does not balance. Total should be zero");
        }
    }

    protected void postTransactionE() throws Exception {
        this.validateTransaction();
        if (this.transaction == null) {
            this.transaction = this.xbrlFileController.addTransaction();
        }
        if (this.transaction == null) {
            throw new Exception("Error, transaction is null");
        }
        this.transaction.setTransactionStatus("posted");
        this.saveTransaction();
        this.error_message.setText("Saved");
        this.lastLocalDate = this.transactionEditFormVBox.getTransactionLocalDate();
    }

    @FXML
    protected void postTransaction() {
        try {
            this.suspendselectchange = true;
            this.postTransactionE();
            this.updateFilter();
            this.refreshTable();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
        this.suspendselectchange = false;
    }

    @FXML
    public void clearTransaction() {
        if (this.transactionEditFormVBox != null) {
            try {
                this.transactionEditFormVBox.setTransactionElement(null);
                this.transaction = null;
                if (this.lastLocalDate != null) {
                    this.transactionEditFormVBox.setTransactionLocalDate(this.lastLocalDate);
                }
                this.transactionEditFormVBox.requestFocus();
                this.error_message.setText("New transaction");
                this.xbrlFileController.setStatusBarMessage(null);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.error_message.setText(e.getMessage());
                this.xbrlFileController.setStatusBarMessage(e.getMessage());
            }
        }
    }

    @FXML
    public void postAndClearTransaction() {
        try {
            this.suspendselectchange = true;
            this.postTransactionE();
            this.clearTransaction();
            this.updateFilter();
            this.refreshTable();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
        this.suspendselectchange = false;
    }

    @FXML
    public void copyToNewTransaction() {
        try {
            this.suspendselectchange = true;
            this.transaction = null;
            this.transactionEditFormVBox.setActivityStatmentNumber(null);
            this.transactionEditFormVBox.setBatchTransactionElement(null);
            this.transactionEditFormVBox.requestFocus();
            this.error_message.setText("New transaction");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
        this.suspendselectchange = false;
    }

    @FXML
    public void cancelTransaction() {
        try {
            String status;
            this.suspendselectchange = true;
            boolean statusChange = false;
            if (this.transaction != null && !(status = this.transaction.getTransactionStatus()).equals("cancelled")) {
                statusChange = true;
            }
            if (this.lodgedActivityStatementIsChanged(statusChange)) {
                this.transactionEditFormVBox.setTransactionElement(this.transaction);
                this.error_message.setText("Error, one of the modified lines is on a lodged Activity Statment.");
                this.xbrlFileController.setStatusBarMessage("Error, one of the modified lines is on a lodged Activity Statment.");
                return;
            }
            if (this.transactionBatchIsLocked()) {
                this.transactionEditFormVBox.setTransactionElement(this.transaction);
                this.error_message.setText("Error, you cannot modify the transaction as it is on an authorised or lodged Batch.");
                this.xbrlFileController.setStatusBarMessage("Error, you cannot modify the transaction as it is on an authorised or lodged Batch.");
                return;
            }
            if (this.transaction == null) {
                throw new Exception("Error, transaction is null, no transaction to cancel");
            }
            this.transaction.setTransactionStatus("cancelled");
            this.saveTransaction();
            this.error_message.setText("Cancelled");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
        this.updateFilter();
        this.refreshTable();
        this.suspendselectchange = true;
    }

    protected Double addDouble(Double d1, Double d2) {
        if (d1 == null) {
            return d2;
        }
        if (d2 == null) {
            return d1;
        }
        return d1 + d2;
    }

    public void refreshTable() {
        this.transactionTable.refresh();
        if (this.transaction != null) {
            this.transactionTable.getSelectionModel().select((Object)this.transaction);
            int index = this.transactionTable.getSelectionModel().getSelectedIndex();
            this.transactionTable.getFocusModel().focus(index);
            this.transactionTable.scrollTo(index);
        }
    }

    protected void updateTotalAmount() {
        Double totalAmount = 0.0;
        Double totalProvisionAmount = 0.0;
        Double totalQuantity = 0.0;
        if (this.filteredItems != null) {
            for (Transaction t : this.filteredItems) {
                totalAmount = this.addDouble(totalAmount, t.getTotalAmount());
                totalProvisionAmount = this.addDouble(totalProvisionAmount, t.getTotalProvisionAmount());
                totalQuantity = this.addDouble(totalQuantity, t.getTotalQuantity());
            }
        }
        if (this.total_label != null) {
            this.total_label.setText("Total displayed amount: " + this.amountFormat.format(totalAmount) + ", total tax: " + this.amountFormat.format(totalProvisionAmount) + ", total quantity " + this.quantityFormat.format(totalQuantity));
        }
    }

    @FXML
    protected void addTransactionLine() {
        try {
            this.transactionEditFormVBox.addTransactionLine(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    protected void deleteSelectedTransactionLines() {
        block8: {
            try {
                if (this.transaction != null) {
                    HashSet<String> ass = new HashSet<String>();
                    for (int i = 0; i < this.transaction.getTransactionLineCount(); ++i) {
                        String status;
                        ActivityStatement as;
                        TransactionLine tl = this.transaction.getTransactionLine(i);
                        String asNumber = tl.getActivityStatementNumber();
                        if (asNumber == null || asNumber.isEmpty()) continue;
                        GlenixTrnXBRL asTrn = null;
                        try {
                            asTrn = this.xbrlFileController.loadActivityStatement(asNumber);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (asTrn == null || (as = asTrn.getActivityStatement()) == null || (status = as.getSBRDocumentStatus()) == null || status.equals("created") || status.equals("list_complete") || status.equals("list_in_progress") || status.equals("prefill_complete") || status.equals("prefill_in_progress") || status.equals("prelodge_complete") || status.equals("prelodge_in_progress")) continue;
                        ass.add(asNumber);
                    }
                    if (ass.size() == 0) {
                        this.transactionEditFormVBox.deleteSelectedTransactionLines(null);
                    } else {
                        this.transactionEditFormVBox.deleteSelectedTransactionLines(ass);
                    }
                    break block8;
                }
                this.transactionEditFormVBox.deleteSelectedTransactionLines(null);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.error_message.setText(e.getMessage());
                this.xbrlFileController.setStatusBarMessage(e.getMessage());
            }
        }
    }

    public void addDocumentLayoutImages(GlenixPDFWrapper gpw) throws Exception {
        Business b = this.xbrlFileController.getBusiness();
        DocumentLayout documentLayout = null;
        if (b != null && (documentLayout = b.getDocumentLayout()) != null) {
            int count = documentLayout.getLayoutImageCount();
            for (int i = 0; i < count; ++i) {
                InputStream is;
                LayoutImage li = documentLayout.getLayoutImage(i);
                String filename = li.getImageFileName();
                if (filename == null || filename.isEmpty() || (is = this.xbrlFileController.getFileDecrypt(filename = "images/" + filename)) == null) continue;
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                byte[] readBytes = new byte[1024];
                int readLen = 0;
                int totalRead = 0;
                while ((readLen = is.read(readBytes)) >= 0) {
                    buffer.write(readBytes, 0, readLen);
                    totalRead += readLen;
                }
                if (totalRead <= 0) continue;
                buffer.flush();
                gpw.addImage(buffer.toByteArray(), li.getImageFileName(), li.getImageLocation(), li.getImageWidthAsDouble(), li.getImageHeightAsDouble());
            }
        }
    }

    @Override
    public GlenixPDFWrapper buildPDF(boolean includeBlanks) throws Exception {
        LocalDate ld;
        String filterTextValue;
        GlenixPDFWrapper gpw = new GlenixPDFWrapper();
        gpw.addPDPageLandscape();
        gpw.setColumns(10);
        gpw.setColumnLeftPosAndWidthMM(0, 20.0, 266.0);
        gpw.setColumnLeftPosAndWidthMM(1, 20.0, 266.0);
        gpw.setColumnLeftPosAndWidthMM(2, 20.0, 24.0);
        gpw.setColumnLeftPosAndWidthMM(3, 44.0, 40.0);
        gpw.setColumnLeftPosAndWidthMM(4, 84.0, 50.0);
        gpw.setColumnLeftPosAndWidthMM(5, 134.0, 26.0);
        gpw.setColumnLeftPosAndWidthMM(6, 164.0, 40.0);
        gpw.setColumnLeftPosAndWidthMM(7, 204.0, 40.0);
        gpw.setColumnLeftPosAndWidthMM(8, 244.0, 20.0);
        gpw.setColumnLeftPosAndWidthMM(9, 264.0, 20.0);
        gpw.setColumnFont(0, gpw.muliBoldFont);
        gpw.setColumnFont(1, gpw.muliLightFont);
        gpw.setColumnFont(2, gpw.muliLightFont);
        gpw.setColumnFont(3, gpw.muliLightFont);
        gpw.setColumnFont(4, gpw.muliLightFont);
        gpw.setColumnFont(5, gpw.muliLightFont);
        gpw.setColumnFont(6, gpw.muliLightFont);
        gpw.setColumnFont(7, gpw.muliLightFont);
        gpw.setColumnFont(8, gpw.muliLightFont);
        gpw.setColumnFont(9, gpw.muliLightFont);
        Double fontSize = this.convertFontSize(this.page_heading.getFont().getSize());
        gpw.prepareString(0, this.page_heading.getText(), true, fontSize);
        gpw.drawStrings(10.0);
        fontSize = this.convertFontSize(new Double(this.xbrlFileController.getCurrentFontSize()));
        StringBuilder filterBuilder = new StringBuilder();
        String prefix = "";
        if (this.filterText != null && (filterTextValue = this.filterText.getGlenixElementValue()) != null && !filterTextValue.isEmpty()) {
            filterBuilder.append("Filter text: ");
            filterBuilder.append(filterTextValue);
            prefix = ", ";
        }
        if (this.filterFromDate != null && (ld = this.filterFromDate.getLocalDate()) != null) {
            filterBuilder.append(prefix);
            filterBuilder.append("From date: ");
            filterBuilder.append(this.displayDateFormatter.format(ld));
            prefix = ", ";
        }
        if (this.filterToDate != null && (ld = this.filterToDate.getLocalDate()) != null) {
            filterBuilder.append(prefix);
            filterBuilder.append("To date: ");
            filterBuilder.append(this.displayDateFormatter.format(ld));
            prefix = ", ";
        }
        if (filterBuilder.length() > 0) {
            gpw.prepareString(1, filterBuilder.toString(), true, fontSize);
            gpw.drawStrings(10.0);
        }
        Double totalAmount = 0.0;
        Double totalProvisionAmount = 0.0;
        Double totalQuantity = 0.0;
        this.drawPDFColumnHeadings(gpw);
        gpw.setAddPageCallback(this);
        for (Transaction t : this.filteredItems) {
            Double quantityDouble;
            String ai;
            Double amountDouble;
            String comment;
            String legalName;
            Transaction ct;
            String dateStr = null;
            if (this.displayDateFormatter != null) {
                dateStr = this.displayDateFormatter.format(t.getTransactionDateAsDate());
            }
            if (dateStr == null) {
                dateStr = t.getTransactionDate();
            }
            gpw.prepareString(2, dateStr, true, fontSize);
            String ci = t.getCounterpartyIdentifier();
            if (ci != null && !ci.isEmpty() && (ct = this.xbrlFileController.getCounterpartyTransaction(ci)) != null && (legalName = ct.getCounterpartyLegalName()) != null) {
                gpw.prepareString(3, legalName, true, fontSize);
            }
            if ((comment = t.getTransactionComment()) != null && !comment.isEmpty()) {
                gpw.prepareString(4, comment, true, fontSize);
            }
            if ((amountDouble = t.getTotalAmount()) != null) {
                totalAmount = totalAmount + amountDouble;
                gpw.prepareString(5, this.amountFormat.format(amountDouble), true, fontSize, "right");
            }
            if ((ai = t.getUniqueAccountIdentifier()) != null && !ai.isEmpty()) {
                String accountName;
                Transaction at = this.xbrlFileController.getAccountTransaction(ai);
                if (at != null && (accountName = at.getAccountName()) != null) {
                    gpw.prepareString(6, accountName, true, fontSize);
                }
            } else {
                gpw.prepareString(6, "split...", true, fontSize);
            }
            String pi = t.getUniqueProvisionIdentifier();
            if (pi != null && !pi.isEmpty()) {
                String provisionName;
                Transaction pt = this.xbrlFileController.getProvisionTransaction(ai);
                if (pt != null && (provisionName = pt.getProvisionName()) != null) {
                    gpw.prepareString(7, provisionName, true, fontSize);
                }
            } else {
                gpw.prepareString(7, "split...", true);
            }
            Double taxAmountDouble = t.getTotalProvisionAmount();
            if (taxAmountDouble != null) {
                totalProvisionAmount = totalProvisionAmount + taxAmountDouble;
                gpw.prepareString(8, this.amountFormat.format(taxAmountDouble), true, fontSize, "right");
            }
            if ((quantityDouble = t.getTotalQuantity()) != null) {
                totalQuantity = totalQuantity + quantityDouble;
                gpw.prepareString(9, this.quantityFormat.format(quantityDouble), true, fontSize, "right");
            }
            gpw.drawStrings(5.0);
        }
        gpw.setColumnFont(2, gpw.muliBoldFont);
        gpw.setColumnFont(5, gpw.muliBoldFont);
        gpw.setColumnFont(8, gpw.muliBoldFont);
        gpw.setColumnFont(9, gpw.muliBoldFont);
        gpw.prepareString(2, "Totals", true, fontSize);
        gpw.prepareString(5, this.amountFormat.format(totalAmount), true, fontSize, "right");
        gpw.prepareString(8, this.amountFormat.format(totalProvisionAmount), true, fontSize, "right");
        gpw.prepareString(9, this.quantityFormat.format(totalQuantity), true, fontSize, "right");
        gpw.drawStrings();
        gpw.addFooter();
        return gpw;
    }

    private void drawPDFColumnHeadings(GlenixPDFWrapper gpw) throws Exception {
        gpw.setColumnFont(2, gpw.muliBoldFont);
        gpw.setColumnFont(3, gpw.muliBoldFont);
        gpw.setColumnFont(4, gpw.muliBoldFont);
        gpw.setColumnFont(5, gpw.muliBoldFont);
        gpw.setColumnFont(6, gpw.muliBoldFont);
        gpw.setColumnFont(7, gpw.muliBoldFont);
        gpw.setColumnFont(8, gpw.muliBoldFont);
        gpw.setColumnFont(9, gpw.muliBoldFont);
        Double fontSize = this.convertFontSize(new Double(this.xbrlFileController.getCurrentFontSize()));
        gpw.prepareString(2, "Date", true, fontSize);
        gpw.prepareString(3, this.transactionCounterpartyColumn.getText(), true, fontSize);
        gpw.prepareString(4, "Transaction comment", true, fontSize);
        gpw.prepareString(5, "Amount", true, fontSize, "right");
        gpw.prepareString(6, "Account", true, fontSize);
        gpw.prepareString(7, "Tax code", true, fontSize);
        gpw.prepareString(8, "Tax", true, fontSize, "right");
        gpw.prepareString(9, "Quantity", true, fontSize, "right");
        gpw.drawStrings(5.0);
        gpw.setColumnFont(2, gpw.muliLightFont);
        gpw.setColumnFont(3, gpw.muliLightFont);
        gpw.setColumnFont(4, gpw.muliLightFont);
        gpw.setColumnFont(5, gpw.muliLightFont);
        gpw.setColumnFont(6, gpw.muliLightFont);
        gpw.setColumnFont(7, gpw.muliLightFont);
        gpw.setColumnFont(8, gpw.muliLightFont);
        gpw.setColumnFont(9, gpw.muliLightFont);
    }

    @Override
    public void newPDFPageAdded(GlenixPDFWrapper gpw) throws Exception {
        this.drawPDFColumnHeadings(gpw);
    }
}

