/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import au.com.glenix.ApplicationController;
import au.com.glenix.EventItemsVBox;
import au.com.glenix.TransactionTransactionLineTableController;
import au.com.glenix.trn.GlenixTrnXBRL;
import au.com.glenix.trn.Transaction;
import java.time.LocalDate;
import javafx.fxml.FXML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TransactionsTableASController
extends TransactionTransactionLineTableController {
    @FXML
    protected EventItemsVBox overalleventitemsvbox;
    @FXML
    protected EventItemsVBox businesseventitemsvbox;

    public TransactionsTableASController(ApplicationController xbrlFileController) {
        super(xbrlFileController);
    }

    @Override
    protected void updateFilter(String newValue) {
        if (this.filteredItems == null) {
            return;
        }
        this.filteredItems.setPredicate(ttl -> {
            String formattedDate;
            LocalDate localDate;
            String pid;
            String aid;
            if (!this.checkFilter((Transaction.TransactionTransactionLine)ttl)) {
                return false;
            }
            if (newValue == null || newValue.isEmpty()) {
                return true;
            }
            String transactionComment = ttl.getTransactionCommentLineComment();
            if (transactionComment != null && transactionComment.toLowerCase().contains(newValue.toLowerCase())) {
                return true;
            }
            String cid = ttl.getCounterpartyIdentifier();
            if (cid != null && !cid.isEmpty()) {
                try {
                    String cname;
                    Transaction ct = this.xbrlFileController.getCounterpartyTransaction(cid);
                    if (ct != null && (cname = ct.getCounterpartyLegalName()) != null && !cname.isEmpty() && cname.toLowerCase().contains(newValue.toLowerCase())) {
                        return true;
                    }
                }
                catch (Exception ct) {
                    // empty catch block
                }
            }
            if ((aid = ttl.getAccountIdentifier()) != null && !aid.isEmpty()) {
                try {
                    String aname;
                    Transaction at = this.xbrlFileController.getAccountTransaction(aid);
                    if (at != null && (aname = at.getAccountName()) != null && !aname.isEmpty() && aname.toLowerCase().contains(newValue.toLowerCase())) {
                        return true;
                    }
                }
                catch (Exception at) {
                    // empty catch block
                }
            }
            if ((pid = ttl.getProvisionIdentifier()) != null && !pid.isEmpty()) {
                try {
                    String pname;
                    Transaction pt = this.xbrlFileController.getProvisionTransaction(pid);
                    if (pt != null && (pname = pt.getCounterpartyLegalName()) != null && !pname.isEmpty() && pname.toLowerCase().contains(newValue.toLowerCase())) {
                        return true;
                    }
                }
                catch (Exception pt) {
                    // empty catch block
                }
            }
            if ((localDate = ttl.getTransactionDateAsDate()) != null && (formattedDate = this.displayDateFormatter.format(localDate)) != null && !formattedDate.isEmpty() && formattedDate.toLowerCase().contains(newValue.toLowerCase())) {
                return true;
            }
            String recDet = ttl.getReconciliationDetailsAndAmount();
            return recDet != null && !recDet.isEmpty() && recDet.toLowerCase().contains(newValue.toLowerCase());
        });
        this.updateTotalAmount();
    }

    @Override
    protected void setActivityStatement(GlenixTrnXBRL glenixTrnXBRLActivityStatement) {
        try {
            this.glenixTrnXBRLActivityStatement = glenixTrnXBRLActivityStatement;
            if (glenixTrnXBRLActivityStatement == null) {
                this.activityStatement = null;
                this.activityStatementNumber = null;
                this.overalleventitemsvbox.setEventItemsModel(null);
                this.businesseventitemsvbox.setEventItemsModel(null);
            } else {
                this.activityStatement = glenixTrnXBRLActivityStatement.getActivityStatement();
                if (this.activityStatement == null) {
                    this.activityStatementNumber = null;
                    this.overalleventitemsvbox.setEventItemsModel(null);
                    this.businesseventitemsvbox.setEventItemsModel(null);
                } else {
                    this.activityStatementNumber = this.activityStatement.getActivityStatementNumber();
                    this.overalleventitemsvbox.setEventItemsModel(this.activityStatement.getOverallEventItems());
                    this.businesseventitemsvbox.setEventItemsModel(this.activityStatement.getBusinessEventItems());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @Override
    public void buildGlenixXBRL(Document resultDoc, Element resultElement) throws Exception {
        Element xbrlEl = resultDoc.createElementNS("http://www.glenix.com.au/", "gx:glenix");
        if (resultElement == null) {
            resultDoc.appendChild(xbrlEl);
        } else {
            resultElement.appendChild(xbrlEl);
        }
        Element businessEl = resultDoc.createElementNS("http://www.glenix.com.au/", "gx:business");
        xbrlEl.appendChild(businessEl);
        Element transactionEl = resultDoc.createElementNS("http://www.glenix.com.au/", "gx:transaction");
        businessEl.appendChild(transactionEl);
        Element transactionLineEl = resultDoc.createElementNS("http://www.glenix.com.au/", "gx:transactionLine");
        transactionEl.appendChild(transactionLineEl);
        super.buildGlenixXBRL(resultDoc, transactionLineEl);
    }

    @Override
    public void loadGlenixXBRL(Document loadDoc, Element loadElement) throws Exception {
        if (loadElement.getNamespaceURI() != null && loadElement.getNamespaceURI().equals("http://www.glenix.com.au/") && loadElement.getLocalName() != null && loadElement.getLocalName().equals("glenix")) {
            NodeList nodeList = loadElement.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element businessElement;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || (businessElement = (Element)node).getNamespaceURI() == null || !businessElement.getNamespaceURI().equals("http://www.glenix.com.au/") || businessElement.getLocalName() == null || !businessElement.getLocalName().equals("business")) continue;
                NodeList nodeList2 = businessElement.getChildNodes();
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    Element transactionElement;
                    Node node2 = nodeList2.item(j);
                    if (node2.getNodeType() != 1 || (transactionElement = (Element)node2).getNamespaceURI() == null || !transactionElement.getNamespaceURI().equals("http://www.glenix.com.au/") || transactionElement.getLocalName() == null || !transactionElement.getLocalName().equals("transaction")) continue;
                    NodeList nodeList3 = transactionElement.getChildNodes();
                    for (int k = 0; k < nodeList3.getLength(); ++k) {
                        Element transactionLineElement;
                        Node node3 = nodeList3.item(k);
                        if (node3.getNodeType() != 1 || (transactionLineElement = (Element)node3).getNamespaceURI() == null || !transactionLineElement.getNamespaceURI().equals("http://www.glenix.com.au/") || transactionLineElement.getLocalName() == null || !transactionLineElement.getLocalName().equals("transactionLine")) continue;
                        NodeList nodeList4 = transactionLineElement.getChildNodes();
                        for (int m = 0; m < nodeList4.getLength(); ++m) {
                            Node node4 = nodeList4.item(m);
                            if (node4.getNodeType() != 1) continue;
                            Element asElement = (Element)node4;
                            super.loadGlenixXBRL(loadDoc, asElement);
                        }
                    }
                }
            }
        }
    }
}

