/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import au.com.glenix.ApplicationController;
import au.com.glenix.GlenixLabelBASAdditionalMonthsCombo;
import au.com.glenix.trn.Account;
import au.com.glenix.trn.ActivityStatement;
import au.com.glenix.trn.Business;
import au.com.glenix.trn.GSTObligation;
import au.com.glenix.trn.GlenixTrnXBRL;
import au.com.glenix.trn.PAYGWObligation;
import au.com.glenix.trn.Provision;
import au.com.glenix.trn.Transaction;
import au.com.glenix.widget.GlenixBranchController;
import au.com.glenix.widget.GlenixLabelText;
import au.com.glenix.widget.GlenixPDFWrapper;
import au.com.glenix.widget.GlenixPDFWrapperNewPageCallback;
import java.math.RoundingMode;
import java.net.URL;
import java.text.DecimalFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.ResourceBundle;
import java.util.Set;
import javafx.beans.value.ChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.input.MouseEvent;
import javafx.util.Callback;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TransactionTransactionLineTableController
extends GlenixBranchController
implements GlenixPDFWrapperNewPageCallback {
    protected DocumentBuilder dBuilder;
    protected GlenixTrnXBRL glenixTrnXBRL = null;
    @FXML
    protected GlenixLabelBASAdditionalMonthsCombo additionalMonths;
    @FXML
    protected Label error_message;
    @FXML
    protected Label page_heading;
    @FXML
    protected TableView transactionTransactionLineTable;
    @FXML
    protected TableColumn transactionCounterpartyColumn;
    @FXML
    protected TableColumn amountColumn;
    @FXML
    protected TableColumn accountColumn;
    @FXML
    protected TableColumn provisionColumn;
    @FXML
    protected TableColumn transactionCommentLineCommentColumn;
    @FXML
    protected TableColumn transactionDateColumn;
    @FXML
    protected TableColumn taxAmountColumn;
    @FXML
    protected TableColumn gstTaxableSalesColumn;
    @FXML
    protected TableColumn gstPayableColumn;
    @FXML
    protected TableColumn gstTaxablePurchasesColumn;
    @FXML
    protected TableColumn gstReceivableColumn;
    @FXML
    protected TableColumn salariesAndWagesColumn;
    @FXML
    protected TableColumn paygwPayableColumn;
    protected GlenixTrnXBRL provisionTrnXBRL;
    protected GlenixTrnXBRL glenixTrnXBRLActivityStatement;
    protected ActivityStatement activityStatement;
    protected String activityStatementNumber;
    protected ArrayList<Transaction.TransactionTransactionLine> transactionTransactionLineArrayList;
    @FXML
    protected GlenixLabelText filterText;
    protected ApplicationController xbrlFileController = null;
    protected ObservableList<Transaction.TransactionTransactionLine> transactionTransactionLineObservableList = null;
    protected FilteredList<Transaction.TransactionTransactionLine> filteredItems = null;
    protected String pattern = "dd MMM yyyy";
    protected DateTimeFormatter displayDateFormatter;
    @FXML
    protected Label total_label;
    protected DecimalFormat amountFormat;
    protected DecimalFormat quantityFormat;
    protected DecimalFormat wholeDollarFormat;
    protected LocalDate lastLocalDate = null;
    private String subSection = "sales";

    public TransactionTransactionLineTableController(ApplicationController xbrlFileController) {
        this.xbrlFileController = xbrlFileController;
        this.amountFormat = new DecimalFormat("$#,##0.00");
        this.amountFormat.setRoundingMode(RoundingMode.HALF_UP);
        this.quantityFormat = new DecimalFormat("#,##0.######");
        this.quantityFormat.setRoundingMode(RoundingMode.HALF_UP);
        this.wholeDollarFormat = new DecimalFormat("$#,##0");
        this.wholeDollarFormat.setRoundingMode(RoundingMode.HALF_UP);
    }

    protected void setupActionColumn() {
        this.transactionTransactionLineTable.setRowFactory(tv -> {
            TableRow<Transaction.TransactionTransactionLine> row = new TableRow<Transaction.TransactionTransactionLine>(){

                protected final void updateItem(Transaction.TransactionTransactionLine item, boolean empty) {
                    String asNumber;
                    super.updateItem((Object)item, empty);
                    boolean disable = false;
                    if (item != null && (asNumber = item.getActivityStatementNumber()) != null && !asNumber.equals(TransactionTransactionLineTableController.this.activityStatementNumber)) {
                        disable = true;
                    }
                    this.disableProperty().set(disable);
                }
            };
            row.setOnMouseClicked(arg_0 -> this.lambda$null$0((TableRow)row, arg_0));
            return row;
        });
    }

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setNamespaceAware(true);
            this.dBuilder = dbFactory.newDocumentBuilder();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
        }
        this.displayDateFormatter = DateTimeFormatter.ofPattern(this.pattern);
        this.setupActionColumn();
        if (this.transactionCounterpartyColumn != null) {
            this.transactionCounterpartyColumn.setCellFactory((Callback)new Callback<TableColumn<Transaction.TransactionTransactionLine, String>, TableCell<Transaction.TransactionTransactionLine, String>>(){

                public TableCell call(TableColumn<Transaction.TransactionTransactionLine, String> param) {
                    TableCell<Transaction.TransactionTransactionLine, String> cell = new TableCell<Transaction.TransactionTransactionLine, String>(){

                        public void updateItem(String item, boolean empty) {
                            super.updateItem((Object)item, empty);
                            this.setGraphic(null);
                            if (empty) {
                                this.setText(null);
                            } else {
                                Transaction.TransactionTransactionLine t = (Transaction.TransactionTransactionLine)this.getTableView().getItems().get(this.getIndex());
                                String id = t.getCounterpartyIdentifier();
                                boolean isset = false;
                                if (id != null) {
                                    try {
                                        Transaction ct = TransactionTransactionLineTableController.this.xbrlFileController.getCounterpartyTransaction(id);
                                        if (ct != null) {
                                            this.setText(ct.getCounterpartyLegalName());
                                            isset = true;
                                        }
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                                if (!isset) {
                                    this.setText(null);
                                }
                            }
                        }
                    };
                    return cell;
                }
            });
        }
        if (this.transactionDateColumn != null) {
            this.transactionDateColumn.setCellFactory((Callback)new Callback<TableColumn<Transaction.TransactionTransactionLine, LocalDate>, TableCell<Transaction.TransactionTransactionLine, LocalDate>>(){

                public TableCell call(TableColumn<Transaction.TransactionTransactionLine, LocalDate> param) {
                    TableCell<Transaction.TransactionTransactionLine, LocalDate> cell = new TableCell<Transaction.TransactionTransactionLine, LocalDate>(){

                        public void updateItem(LocalDate item, boolean empty) {
                            super.updateItem((Object)item, empty);
                            this.setGraphic(null);
                            if (empty) {
                                this.setText(null);
                            } else if (item == null) {
                                this.setText(null);
                            } else {
                                this.setText(TransactionTransactionLineTableController.this.displayDateFormatter.format(item));
                            }
                        }
                    };
                    return cell;
                }
            });
        }
        if (this.amountColumn != null) {
            this.amountColumn.setCellFactory((Callback)new Callback<TableColumn<Transaction.TransactionTransactionLine, Double>, TableCell<Transaction.TransactionTransactionLine, Double>>(){

                public TableCell call(TableColumn<Transaction.TransactionTransactionLine, Double> param) {
                    TableCell<Transaction.TransactionTransactionLine, Double> cell = new TableCell<Transaction.TransactionTransactionLine, Double>(){

                        public void updateItem(Double item, boolean empty) {
                            super.updateItem((Object)item, empty);
                            this.setGraphic(null);
                            if (empty || item == null) {
                                this.setText(null);
                            } else {
                                Transaction.TransactionTransactionLine t = (Transaction.TransactionTransactionLine)this.getTableView().getItems().get(this.getIndex());
                                String id = t.getProvisionIdentifier();
                                if (id == null) {
                                    this.setText(null);
                                } else {
                                    try {
                                        Transaction ct = TransactionTransactionLineTableController.this.xbrlFileController.getProvisionTransaction(id);
                                        if (ct != null) {
                                            this.setText(ct.getProvisionName());
                                            String basClass = ct.getProvisionGrossBASClassification();
                                            if (basClass == null || basClass.equals("GST_Taxable_Sales") || basClass.equals("Export_Sales") || basClass.equals("GST_Free_Sales") || basClass.equals("Input_Taxed_Sales") || basClass.equals("Sales_Adjustments") || basClass.equals("Capital_Purchases") || basClass.equals("Non_Capital_Purchases") || basClass.equals("Purchases_for_Input_Taxed_Sales") || basClass.equals("Purchases_for_Input_Taxed_Sales_Capital") || basClass.equals("GST_Free_Purchases") || basClass.equals("GST_Free_Purchases_Capital") || basClass.equals("Purchase_Adjustments") || basClass.equals("Salaries_and_Wages") || basClass.equals("PAYG_Withholding_Payable") || basClass.equals("GST_Paid_to_ATO") || basClass.equals("GST_Received_from_ATO") || basClass.equals("PAYG_Withheld_Paid_to_ATO") || basClass.equals("PAYG_Instalment_Accrued") || basClass.equals("PAYG_Instalment_Paid_to_ATO") || basClass.equals("Wine_Equalisation_Paid_to_ATO") || basClass.equals("Luxury_Car_Tax_Paid_to_ATO") || basClass.equals("Fuel_Tax_Credits_Refunded_from_ATO") || basClass.equals("GST_Deferred_Liability_On_Import_Duty")) {
                                                this.setText(null);
                                            } else {
                                                String transactionType = t.getTransactionType();
                                                if (transactionType.equals("sales_invoice") || transactionType.equals("sales_quote") || transactionType.equals("cash_received") || transactionType.equals("purchase_credit")) {
                                                    this.setText(TransactionTransactionLineTableController.this.amountFormat.format(-item.doubleValue()));
                                                } else {
                                                    this.setText(TransactionTransactionLineTableController.this.amountFormat.format(item));
                                                }
                                            }
                                        } else {
                                            this.setText(null);
                                        }
                                    }
                                    catch (Exception e) {
                                        this.setText(null);
                                    }
                                }
                            }
                        }
                    };
                    return cell;
                }
            });
        }
        if (this.taxAmountColumn != null) {
            this.taxAmountColumn.setCellFactory((Callback)new Callback<TableColumn<Transaction.TransactionTransactionLine, Double>, TableCell<Transaction.TransactionTransactionLine, Double>>(){

                public TableCell call(TableColumn<Transaction.TransactionTransactionLine, Double> param) {
                    TableCell<Transaction.TransactionTransactionLine, Double> cell = new TableCell<Transaction.TransactionTransactionLine, Double>(){

                        public void updateItem(Double item, boolean empty) {
                            super.updateItem((Object)item, empty);
                            this.setGraphic(null);
                            if (empty || item == null) {
                                this.setText(null);
                            } else {
                                Transaction.TransactionTransactionLine t = (Transaction.TransactionTransactionLine)this.getTableView().getItems().get(this.getIndex());
                                String id = t.getProvisionIdentifier();
                                if (id == null) {
                                    this.setText(null);
                                } else {
                                    try {
                                        Transaction ct = TransactionTransactionLineTableController.this.xbrlFileController.getProvisionTransaction(id);
                                        if (ct != null) {
                                            String basClass = ct.getProvisionGrossBASClassification();
                                            if (basClass == null || basClass.equals("GST_Taxable_Sales") || basClass.equals("Export_Sales") || basClass.equals("GST_Free_Sales") || basClass.equals("Input_Taxed_Sales") || basClass.equals("Sales_Adjustments") || basClass.equals("Capital_Purchases") || basClass.equals("Non_Capital_Purchases") || basClass.equals("Purchases_for_Input_Taxed_Sales") || basClass.equals("Purchases_for_Input_Taxed_Sales_Capital") || basClass.equals("GST_Free_Purchases") || basClass.equals("GST_Free_Purchases_Capital") || basClass.equals("Purchase_Adjustments") || basClass.equals("Salaries_and_Wages") || basClass.equals("PAYG_Withholding_Payable") || basClass.equals("GST_Paid_to_ATO") || basClass.equals("GST_Received_from_ATO") || basClass.equals("PAYG_Withheld_Paid_to_ATO") || basClass.equals("PAYG_Instalment_Accrued") || basClass.equals("PAYG_Instalment_Paid_to_ATO") || basClass.equals("Wine_Equalisation_Paid_to_ATO") || basClass.equals("Luxury_Car_Tax_Paid_to_ATO") || basClass.equals("Fuel_Tax_Credits_Refunded_from_ATO") || basClass.equals("GST_Deferred_Liability_On_Import_Duty")) {
                                                this.setText(null);
                                            } else {
                                                Double grossAmount = t.getAmount();
                                                String transactionType = t.getTransactionType();
                                                if (transactionType.equals("sales_invoice") || transactionType.equals("sales_quote") || transactionType.equals("cash_received") || transactionType.equals("purchase_credit")) {
                                                    grossAmount = -grossAmount.doubleValue();
                                                    item = -item.doubleValue();
                                                }
                                                if (basClass.equals("Wine_Equalisation_Tax_Claimable_Credits") || basClass.equals("Wine_Equalisation_Tax_Liability") || basClass.equals("Luxury_Car_Tax_Claimable_Credits") || basClass.equals("Luxury_Car_Tax_Liability") || basClass.equals("Fuel_Tax_Overclaimed_Credits") || basClass.equals("Fuel_Tax_Claimable_Credits")) {
                                                    item = grossAmount - item;
                                                }
                                                this.setText(TransactionTransactionLineTableController.this.amountFormat.format(item));
                                            }
                                        } else {
                                            this.setText(null);
                                        }
                                    }
                                    catch (Exception e) {
                                        this.setText(null);
                                    }
                                }
                            }
                        }
                    };
                    return cell;
                }
            });
        }
        if (this.accountColumn != null) {
            this.accountColumn.setCellFactory((Callback)new Callback<TableColumn<Transaction.TransactionTransactionLine, Account>, TableCell<Transaction.TransactionTransactionLine, Account>>(){

                public TableCell call(TableColumn<Transaction.TransactionTransactionLine, Account> param) {
                    TableCell<Transaction.TransactionTransactionLine, Account> cell = new TableCell<Transaction.TransactionTransactionLine, Account>(){

                        public void updateItem(Account item, boolean empty) {
                            super.updateItem((Object)item, empty);
                            this.setGraphic(null);
                            if (empty) {
                                this.setText(null);
                            } else {
                                Transaction.TransactionTransactionLine t = (Transaction.TransactionTransactionLine)this.getTableView().getItems().get(this.getIndex());
                                String id = t.getAccountIdentifier();
                                if (id == null) {
                                    this.setText(null);
                                } else {
                                    try {
                                        Transaction ct = TransactionTransactionLineTableController.this.xbrlFileController.getAccountTransaction(id);
                                        if (ct != null) {
                                            this.setText(ct.getAccountName());
                                        } else {
                                            this.setText(null);
                                        }
                                    }
                                    catch (Exception e) {
                                        this.setText(null);
                                    }
                                }
                            }
                        }
                    };
                    return cell;
                }
            });
        }
        if (this.provisionColumn != null) {
            this.provisionColumn.setCellFactory((Callback)new Callback<TableColumn<Transaction.TransactionTransactionLine, Provision>, TableCell<Transaction.TransactionTransactionLine, Provision>>(){

                public TableCell call(TableColumn<Transaction.TransactionTransactionLine, Provision> param) {
                    TableCell<Transaction.TransactionTransactionLine, Provision> cell = new TableCell<Transaction.TransactionTransactionLine, Provision>(){

                        public void updateItem(Provision item, boolean empty) {
                            super.updateItem((Object)item, empty);
                            this.setGraphic(null);
                            if (empty) {
                                this.setText(null);
                            } else {
                                Transaction.TransactionTransactionLine t = (Transaction.TransactionTransactionLine)this.getTableView().getItems().get(this.getIndex());
                                String id = t.getProvisionIdentifier();
                                if (id == null) {
                                    this.setText(null);
                                } else {
                                    try {
                                        Transaction ct = TransactionTransactionLineTableController.this.xbrlFileController.getProvisionTransaction(id);
                                        if (ct != null) {
                                            this.setText(ct.getProvisionName());
                                        } else {
                                            this.setText(null);
                                        }
                                    }
                                    catch (Exception e) {
                                        this.setText(null);
                                    }
                                }
                            }
                        }
                    };
                    return cell;
                }
            });
        }
        if (this.gstTaxableSalesColumn != null) {
            this.gstTaxableSalesColumn.setCellFactory((Callback)new Callback<TableColumn<Transaction.TransactionTransactionLine, String>, TableCell<Transaction.TransactionTransactionLine, String>>(){

                public TableCell call(TableColumn<Transaction.TransactionTransactionLine, String> param) {
                    TableCell<Transaction.TransactionTransactionLine, String> cell = new TableCell<Transaction.TransactionTransactionLine, String>(){

                        public void updateItem(String item, boolean empty) {
                            super.updateItem((Object)item, empty);
                            this.setGraphic(null);
                            if (empty || item == null) {
                                this.setText(null);
                            } else {
                                TableRow tr = this.getTableRow();
                                Transaction.TransactionTransactionLine ttl = (Transaction.TransactionTransactionLine)tr.getItem();
                                Double amount = TransactionTransactionLineTableController.this.getBASGrossSalesAmount(ttl, item);
                                if (amount == null) {
                                    this.setText(null);
                                } else {
                                    this.setText(TransactionTransactionLineTableController.this.amountFormat.format(amount));
                                }
                            }
                        }
                    };
                    return cell;
                }
            });
        }
        if (this.gstTaxablePurchasesColumn != null) {
            this.gstTaxablePurchasesColumn.setCellFactory((Callback)new Callback<TableColumn<Transaction.TransactionTransactionLine, String>, TableCell<Transaction.TransactionTransactionLine, String>>(){

                public TableCell call(TableColumn<Transaction.TransactionTransactionLine, String> param) {
                    TableCell<Transaction.TransactionTransactionLine, String> cell = new TableCell<Transaction.TransactionTransactionLine, String>(){

                        public void updateItem(String item, boolean empty) {
                            super.updateItem((Object)item, empty);
                            this.setGraphic(null);
                            if (empty || item == null) {
                                this.setText(null);
                            } else {
                                TableRow tr = this.getTableRow();
                                Transaction.TransactionTransactionLine t = (Transaction.TransactionTransactionLine)tr.getItem();
                                Double amount = TransactionTransactionLineTableController.this.getBASGrossPurchasesAmount(t, item);
                                if (amount == null) {
                                    this.setText(null);
                                } else {
                                    this.setText(TransactionTransactionLineTableController.this.amountFormat.format(amount));
                                }
                            }
                        }
                    };
                    return cell;
                }
            });
        }
        if (this.gstPayableColumn != null) {
            this.gstPayableColumn.setCellFactory((Callback)new Callback<TableColumn<Transaction.TransactionTransactionLine, String>, TableCell<Transaction.TransactionTransactionLine, String>>(){

                public TableCell call(TableColumn<Transaction.TransactionTransactionLine, String> param) {
                    TableCell<Transaction.TransactionTransactionLine, String> cell = new TableCell<Transaction.TransactionTransactionLine, String>(){

                        public void updateItem(String item, boolean empty) {
                            super.updateItem((Object)item, empty);
                            this.setGraphic(null);
                            if (empty || item == null) {
                                this.setText(null);
                            } else {
                                TableRow tr = this.getTableRow();
                                Transaction.TransactionTransactionLine t = (Transaction.TransactionTransactionLine)tr.getItem();
                                Double amount = TransactionTransactionLineTableController.this.getGstPayable(t, item);
                                if (amount == null) {
                                    this.setText(null);
                                } else {
                                    this.setText(TransactionTransactionLineTableController.this.amountFormat.format(amount));
                                }
                            }
                        }
                    };
                    return cell;
                }
            });
        }
        if (this.gstReceivableColumn != null) {
            this.gstReceivableColumn.setCellFactory((Callback)new Callback<TableColumn<Transaction.TransactionTransactionLine, String>, TableCell<Transaction.TransactionTransactionLine, String>>(){

                public TableCell call(TableColumn<Transaction.TransactionTransactionLine, String> param) {
                    TableCell<Transaction.TransactionTransactionLine, String> cell = new TableCell<Transaction.TransactionTransactionLine, String>(){

                        public void updateItem(String item, boolean empty) {
                            super.updateItem((Object)item, empty);
                            this.setGraphic(null);
                            if (empty || item == null) {
                                this.setText(null);
                            } else {
                                TableRow tr = this.getTableRow();
                                Transaction.TransactionTransactionLine t = (Transaction.TransactionTransactionLine)tr.getItem();
                                Double amount = TransactionTransactionLineTableController.this.getGstReceivable(t, item);
                                if (amount == null) {
                                    this.setText(null);
                                } else {
                                    this.setText(TransactionTransactionLineTableController.this.amountFormat.format(amount));
                                }
                            }
                        }
                    };
                    return cell;
                }
            });
        }
        if (this.salariesAndWagesColumn != null) {
            this.salariesAndWagesColumn.setCellFactory((Callback)new Callback<TableColumn<Transaction.TransactionTransactionLine, String>, TableCell<Transaction.TransactionTransactionLine, String>>(){

                public TableCell call(TableColumn<Transaction.TransactionTransactionLine, String> param) {
                    TableCell<Transaction.TransactionTransactionLine, String> cell = new TableCell<Transaction.TransactionTransactionLine, String>(){

                        public void updateItem(String item, boolean empty) {
                            super.updateItem((Object)item, empty);
                            this.setGraphic(null);
                            if (empty || item == null) {
                                this.setText(null);
                            } else {
                                TableRow tr = this.getTableRow();
                                Transaction.TransactionTransactionLine t = (Transaction.TransactionTransactionLine)tr.getItem();
                                Double amount = TransactionTransactionLineTableController.this.getSalariesAndWages(t, item);
                                if (amount == null) {
                                    this.setText(null);
                                } else {
                                    this.setText(TransactionTransactionLineTableController.this.amountFormat.format(amount));
                                }
                            }
                        }
                    };
                    return cell;
                }
            });
        }
        if (this.paygwPayableColumn != null) {
            this.paygwPayableColumn.setCellFactory((Callback)new Callback<TableColumn<Transaction.TransactionTransactionLine, String>, TableCell<Transaction.TransactionTransactionLine, String>>(){

                public TableCell call(TableColumn<Transaction.TransactionTransactionLine, String> param) {
                    TableCell<Transaction.TransactionTransactionLine, String> cell = new TableCell<Transaction.TransactionTransactionLine, String>(){

                        public void updateItem(String item, boolean empty) {
                            super.updateItem((Object)item, empty);
                            this.setGraphic(null);
                            if (empty || item == null) {
                                this.setText(null);
                            } else {
                                TableRow tr = this.getTableRow();
                                Transaction.TransactionTransactionLine t = (Transaction.TransactionTransactionLine)tr.getItem();
                                Double amount = TransactionTransactionLineTableController.this.getPaygWithholdingPayable(t, item);
                                if (amount == null) {
                                    this.setText(null);
                                } else {
                                    this.setText(TransactionTransactionLineTableController.this.amountFormat.format(amount));
                                }
                            }
                        }
                    };
                    return cell;
                }
            });
        }
        this.transactionTransactionLineTable.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
    }

    @Override
    public void buildGlenixXBRL(Document resultDoc, Element resultElement) throws Exception {
        Element xbrlEl = resultDoc.createElementNS("http://www.glenix.com.au/", "gx:glenix");
        if (resultElement == null) {
            resultDoc.appendChild(xbrlEl);
        } else {
            resultElement.appendChild(xbrlEl);
        }
        super.buildGlenixXBRL(resultDoc, xbrlEl);
    }

    @Override
    public void loadGlenixXBRL(Document loadDoc, Element loadElement) throws Exception {
        if (loadElement.getNamespaceURI() != null && loadElement.getNamespaceURI().equals("http://www.glenix.com.au/") && loadElement.getLocalName() != null && loadElement.getLocalName().equals("glenix")) {
            NodeList nodeList = loadElement.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                Element el = (Element)node;
                super.loadGlenixXBRL(loadDoc, el);
            }
        }
    }

    public void setCounterpartyTransactionList(ObservableList<Transaction> counterpartyObservableList) {
    }

    public void setProvisionList(ObservableList<Transaction> provisionObservableList) {
    }

    public void setAccountList(ObservableList<Transaction> accountObservableList) {
    }

    public void setBusinessTransactions(Business business) throws Exception {
        this.transactionTransactionLineArrayList = null;
        ArrayList<Transaction.TransactionTransactionLine> ttlArrayList = null;
        if (business != null && this.activityStatementNumber != null && !this.activityStatementNumber.isEmpty()) {
            ArrayList<String> asNumberList = new ArrayList<String>();
            String originalASNumber = this.activityStatementNumber;
            while (originalASNumber != null && !originalASNumber.isEmpty()) {
                ActivityStatement oas;
                asNumberList.add(originalASNumber);
                GlenixTrnXBRL oASXBRL = this.xbrlFileController.loadActivityStatement(originalASNumber);
                originalASNumber = null;
                if (oASXBRL == null || (oas = oASXBRL.getActivityStatement()) == null) continue;
                originalASNumber = oas.getOriginalActivityStatementNumber();
            }
            ttlArrayList = business.getASTransactionTransactionLineArrayList(asNumberList);
        }
        if (ttlArrayList == null || ttlArrayList.size() == 0) {
            this.generateTransactions();
        } else {
            this.setTransactionTransactionLineObservableList(ttlArrayList);
        }
    }

    protected void createFilteredItems() {
        this.filteredItems = new FilteredList(this.transactionTransactionLineObservableList, ttl -> this.checkFilter((Transaction.TransactionTransactionLine)ttl));
        this.transactionTransactionLineTable.setItems(this.filteredItems);
        this.filterText.addTextChangeListener((ChangeListener<String>)((ChangeListener)(obs, oldValue, newValue) -> this.updateFilter((String)newValue)));
        this.updateTotalAmount();
    }

    public void setTransactionTransactionLineObservableList(ArrayList<Transaction.TransactionTransactionLine> ttlArrayList) {
        this.transactionTransactionLineArrayList = ttlArrayList;
        ttlArrayList.sort(new Comparator<Transaction.TransactionTransactionLine>(){

            @Override
            public int compare(Transaction.TransactionTransactionLine ttl1, Transaction.TransactionTransactionLine ttl2) {
                Transaction t2;
                Transaction t1 = ttl1.getTransaction();
                if (t1 == (t2 = ttl2.getTransaction())) {
                    int tl1line = ttl1.getLineNumberAsInt();
                    int tl2line = ttl2.getLineNumberAsInt();
                    return tl1line - tl2line;
                }
                String t1date = t1.getTransactionDate();
                String t2date = t2.getTransactionDate();
                if (t1date == null || t1date.isEmpty()) {
                    if (t2date != null && !t2date.isEmpty()) {
                        return -1;
                    }
                } else {
                    if (t2date == null || t2date.isEmpty()) {
                        return 1;
                    }
                    int result = t1date.compareTo(t2date);
                    if (result != 0) {
                        return result;
                    }
                }
                String t1comment = t1.getTransactionComment();
                String t2comment = t2.getTransactionComment();
                if (t1comment == null || t1comment.isEmpty()) {
                    if (t2comment != null && !t2comment.isEmpty()) {
                        return -1;
                    }
                } else {
                    if (t2comment == null || t2comment.isEmpty()) {
                        return 1;
                    }
                    int result = t1comment.compareTo(t2comment);
                    if (result != 0) {
                        return result;
                    }
                }
                String t1aid = ttl1.getAccountIdentifier();
                String t2aid = ttl2.getAccountIdentifier();
                if (t1aid == null || t1aid.isEmpty()) {
                    if (t2aid != null && !t2aid.isEmpty()) {
                        return -1;
                    }
                } else {
                    if (t2aid == null || t2aid.isEmpty()) {
                        return 1;
                    }
                    int result = t1aid.compareTo(t2aid);
                    if (result != 0) {
                        return result;
                    }
                }
                String t1pid = ttl1.getProvisionIdentifier();
                String t2pid = ttl2.getProvisionIdentifier();
                if (t1pid == null || t1pid.isEmpty()) {
                    if (t2pid != null && !t2pid.isEmpty()) {
                        return -1;
                    }
                } else {
                    if (t2pid == null || t2pid.isEmpty()) {
                        return 1;
                    }
                    int result = t1pid.compareTo(t2pid);
                    if (result != 0) {
                        return result;
                    }
                }
                return ttl1.toString().compareTo(ttl2.toString());
            }
        });
        this.transactionTransactionLineObservableList = FXCollections.observableList(ttlArrayList);
        this.createFilteredItems();
        this.refreshTable();
    }

    protected void updateFilter() {
        if (this.filterText == null) {
            this.updateFilter(null);
        } else {
            this.updateFilter(this.filterText.getText());
        }
    }

    protected boolean checkFilter(Transaction.TransactionTransactionLine ttl) {
        String status = ttl.getTransactionStatus();
        return status == null || !status.equals("cancelled") && !status.equals("draft");
    }

    protected void updateFilter(String newValue) {
        if (this.filteredItems == null) {
            return;
        }
        this.filteredItems.setPredicate(ttl -> {
            String pid;
            String aid;
            if (!this.checkFilter((Transaction.TransactionTransactionLine)ttl)) {
                return false;
            }
            if (newValue == null || newValue.isEmpty()) {
                return true;
            }
            String transactionComment = ttl.getTransactionCommentLineComment();
            if (transactionComment != null && transactionComment.toLowerCase().contains(newValue.toLowerCase())) {
                return true;
            }
            String cid = ttl.getCounterpartyIdentifier();
            if (cid != null && !cid.isEmpty()) {
                try {
                    String cname;
                    Transaction ct = this.xbrlFileController.getCounterpartyTransaction(cid);
                    if (ct != null && (cname = ct.getCounterpartyLegalName()) != null && !cname.isEmpty() && cname.toLowerCase().contains(newValue.toLowerCase())) {
                        return true;
                    }
                }
                catch (Exception ct) {
                    // empty catch block
                }
            }
            if ((aid = ttl.getAccountIdentifier()) != null && !aid.isEmpty()) {
                try {
                    String aname;
                    Transaction at = this.xbrlFileController.getAccountTransaction(aid);
                    if (at != null && (aname = at.getAccountName()) != null && !aname.isEmpty() && aname.toLowerCase().contains(newValue.toLowerCase())) {
                        return true;
                    }
                }
                catch (Exception at) {
                    // empty catch block
                }
            }
            if ((pid = ttl.getProvisionIdentifier()) != null && !pid.isEmpty()) {
                try {
                    String pname;
                    Transaction pt = this.xbrlFileController.getProvisionTransaction(pid);
                    if (pt != null && (pname = pt.getCounterpartyLegalName()) != null && !pname.isEmpty() && pname.toLowerCase().contains(newValue.toLowerCase())) {
                        return true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return false;
        });
        this.updateTotalAmount();
    }

    public void setProvisionMasterfileCached(GlenixTrnXBRL provisionTrnXBRL) {
        this.provisionTrnXBRL = provisionTrnXBRL;
    }

    protected void setActivityStatement(GlenixTrnXBRL glenixTrnXBRLActivityStatement) {
        this.glenixTrnXBRLActivityStatement = glenixTrnXBRLActivityStatement;
        if (glenixTrnXBRLActivityStatement == null) {
            this.activityStatement = null;
            this.activityStatementNumber = null;
        } else {
            this.activityStatement = glenixTrnXBRLActivityStatement.getActivityStatement();
            this.activityStatementNumber = this.activityStatement == null ? null : this.activityStatement.getActivityStatementNumber();
        }
    }

    public void refreshTable() {
        this.transactionTransactionLineTable.refresh();
    }

    @FXML
    protected void gotoActivityStatementLodge() {
        String asNumber;
        ActivityStatement as = this.glenixTrnXBRLActivityStatement.getActivityStatement();
        if (as == null) {
            this.error_message.setText("Error, no activity statement selected");
        }
        if ((asNumber = as.getActivityStatementNumber()) == null || asNumber.isEmpty()) {
            this.error_message.setText("Error, no activity statement number found");
            return;
        }
        try {
            this.xbrlFileController.gotoActivityStatement(asNumber);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    protected void generateTransactions() {
        ActivityStatement as = this.glenixTrnXBRLActivityStatement.getActivityStatement();
        if (as == null) {
            this.error_message.setText("Error, no activity statement selected");
            return;
        }
        try {
            String asNumber = as.getActivityStatementNumber();
            if (asNumber == null || asNumber.isEmpty()) {
                throw new Exception("Error, no activity statement number found");
            }
            ArrayList<String> asNumberList = new ArrayList<String>();
            String originalASNumber = asNumber;
            while (originalASNumber != null && !originalASNumber.isEmpty()) {
                ActivityStatement oas;
                asNumberList.add(originalASNumber);
                GlenixTrnXBRL oASXBRL = this.xbrlFileController.loadActivityStatement(originalASNumber);
                originalASNumber = null;
                if (oASXBRL == null || (oas = oASXBRL.getActivityStatement()) == null) continue;
                originalASNumber = oas.getOriginalActivityStatementNumber();
            }
            LocalDate startDate = null;
            LocalDate endDate = null;
            LocalDate paySlipStartDate = null;
            LocalDate paySlipEndDate = null;
            ArrayList classifications = new ArrayList();
            Business b = this.provisionTrnXBRL.getBusiness();
            ArrayList<Transaction> pts = b.getTransactionArrayList();
            if (b != null && pts != null) {
                GSTObligation gsto = this.activityStatement.getGSTObligation();
                ArrayList<String> gsttaxes = new ArrayList<String>();
                ArrayList<String> gstclasses = new ArrayList<String>();
                gstclasses.add("GST_Taxable_Sales");
                gstclasses.add("Export_Sales");
                gstclasses.add("GST_Free_Sales");
                gstclasses.add("Input_Taxed_Sales");
                gstclasses.add("Sales_Adjustments");
                gstclasses.add("Capital_Purchases");
                gstclasses.add("Non_Capital_Purchases");
                gstclasses.add("Purchases_for_Input_Taxed_Sales");
                gstclasses.add("Purchases_for_Input_Taxed_Sales_Capital");
                gstclasses.add("GST_Free_Purchases");
                gstclasses.add("GST_Free_Purchases_Capital");
                gstclasses.add("Purchase_Adjustments");
                gstclasses.add("Wine_Equalisation_Tax_Claimable_Credits");
                gstclasses.add("Wine_Equalisation_Tax_Liability");
                gstclasses.add("Luxury_Car_Tax_Claimable_Credits");
                gstclasses.add("Luxury_Car_Tax_Liability");
                gstclasses.add("Fuel_Tax_Overclaimed_Credits");
                gstclasses.add("Fuel_Tax_Claimable_Credits");
                gstclasses.add("Fuel_Tax_Overclaimed_Credits_Tax_Amount");
                gstclasses.add("Fuel_Tax_Claimable_Credits_Tax_Amount");
                if (gsto != null) {
                    for (int i = 0; i < pts.size(); ++i) {
                        Transaction pt = pts.get(i);
                        if (pt == null || pt.getProvisionGrossBASClassification() == null || !gstclasses.contains(pt.getProvisionGrossBASClassification())) continue;
                        gsttaxes.add(pt.getProvisionIdentifier());
                    }
                    startDate = gsto.getStartDateAsDate();
                    endDate = gsto.getEndDateAsDate();
                    try {
                        Integer addm = Integer.parseInt(this.additionalMonths.getGlenixElementValue());
                        startDate = startDate.minusMonths(addm.intValue()).withDayOfMonth(1);
                    }
                    catch (Exception addm) {
                        // empty catch block
                    }
                }
                PAYGWObligation paygwo = this.activityStatement.getPAYGWObligation();
                ArrayList<String> paygwtaxes = new ArrayList<String>();
                ArrayList<String> paygwclasses = new ArrayList<String>();
                paygwclasses.add("Salaries_and_Wages");
                paygwclasses.add("PAYG_Withholding_Payable");
                paygwclasses.add("No_ABN_Withholding");
                paygwclasses.add("Other_PAYG_Withholding");
                if (paygwo != null) {
                    for (int i = 0; i < pts.size(); ++i) {
                        Transaction pt = pts.get(i);
                        if (pt == null || pt.getProvisionGrossBASClassification() == null || !paygwclasses.contains(pt.getProvisionGrossBASClassification())) continue;
                        paygwtaxes.add(pt.getProvisionIdentifier());
                    }
                    paySlipStartDate = paygwo.getStartDateAsDate();
                    paySlipEndDate = paygwo.getEndDateAsDate();
                }
                this.transactionTransactionLineArrayList = this.xbrlFileController.markActivityStatementTransactions(asNumber, asNumberList, startDate, endDate, gsttaxes, paySlipStartDate, paySlipEndDate, paygwtaxes);
                this.setTransactionTransactionLineObservableList(this.transactionTransactionLineArrayList);
            }
            this.xbrlFileController.saveTransactions((Set<Transaction>)null);
            this.transactionTransactionLineTable.refresh();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    public Double getProvisionGrossBASTotalAmount(Transaction.TransactionTransactionLine ttl, String transactionType, String provisionGrossBASClassification) {
        String grossBASClassification;
        Transaction provisionTransaction;
        String pi;
        if (ttl == null || transactionType == null || transactionType.isEmpty() || provisionGrossBASClassification == null || provisionGrossBASClassification.isEmpty()) {
            return null;
        }
        Double amount = ttl.getAmount();
        if (transactionType.equals("sales_invoice") || transactionType.equals("sales_quote") || transactionType.equals("cash_received") || transactionType.equals("purchase_credit")) {
            amount = -amount.doubleValue();
        }
        if ((pi = ttl.getProvisionIdentifier()) != null && !pi.isEmpty() && (provisionTransaction = this.provisionTrnXBRL.getProvisionTransaction(pi)) != null && (grossBASClassification = provisionTransaction.getProvisionGrossBASClassification()) != null && grossBASClassification.equals(provisionGrossBASClassification)) {
            return amount;
        }
        return null;
    }

    public Double getSalariesAndWages(Transaction.TransactionTransactionLine ttl, String transactionType) {
        return this.getProvisionGrossBASTotalAmount(ttl, transactionType, "Salaries_and_Wages");
    }

    public String getBASGrossClassification(String provisionIdentifier) {
        if (provisionIdentifier == null || provisionIdentifier.isEmpty()) {
            return null;
        }
        Transaction provisionTransaction = this.provisionTrnXBRL.getProvisionTransaction(provisionIdentifier);
        if (provisionTransaction == null) {
            return null;
        }
        return provisionTransaction.getProvisionGrossBASClassification();
    }

    public Double getBASGrossSalesAmount(Transaction.TransactionTransactionLine ttl, String transactionType) {
        String grossBASClassification;
        Transaction provisionTransaction;
        String pi;
        if (ttl == null || transactionType == null || transactionType.isEmpty()) {
            return null;
        }
        Double amount = ttl.getAmount();
        if (!(transactionType.equals("sales_invoice") || transactionType.equals("sales_quote") || transactionType.equals("cash_received") || transactionType.equals("purchase_credit"))) {
            amount = -amount.doubleValue();
        }
        if ((pi = ttl.getProvisionIdentifier()) != null && !pi.isEmpty() && (provisionTransaction = this.provisionTrnXBRL.getProvisionTransaction(pi)) != null && (grossBASClassification = provisionTransaction.getProvisionGrossBASClassification()) != null && (grossBASClassification.equals("GST_Taxable_Sales") || grossBASClassification.equals("Export_Sales") || grossBASClassification.equals("Input_Taxed_Sales") || grossBASClassification.equals("Sales_Adjustments") || grossBASClassification.equals("GST_Free_Sales") || grossBASClassification.equals("Wine_Equalisation_Tax_Liability"))) {
            return amount;
        }
        return null;
    }

    public Double getBASGrossPurchasesAmount(Transaction.TransactionTransactionLine ttl, String transactionType) {
        String grossBASClassification;
        Transaction provisionTransaction;
        String pi;
        if (ttl == null || transactionType == null || transactionType.isEmpty()) {
            return null;
        }
        Double amount = ttl.getAmount();
        if (transactionType.equals("sales_invoice") || transactionType.equals("sales_quote") || transactionType.equals("cash_received") || transactionType.equals("purchase_credit")) {
            amount = -amount.doubleValue();
        }
        if ((pi = ttl.getProvisionIdentifier()) != null && !pi.isEmpty() && (provisionTransaction = this.provisionTrnXBRL.getProvisionTransaction(pi)) != null && (grossBASClassification = provisionTransaction.getProvisionGrossBASClassification()) != null && (grossBASClassification.equals("Capital_Purchases") || grossBASClassification.equals("Non_Capital_Purchases") || grossBASClassification.equals("Purchases_for_Input_Taxed_Sales") || grossBASClassification.equals("Purchases_for_Input_Taxed_Sales_Capital") || grossBASClassification.equals("GST_Free_Purchases") || grossBASClassification.equals("GST_Free_Purchases_Capital") || grossBASClassification.equals("Purchase_Adjustments") || grossBASClassification.equals("Wine_Equalisation_Tax_Claimable_Credits"))) {
            return amount;
        }
        return null;
    }

    public Double getProvisionTaxBASTotalAmount(Transaction.TransactionTransactionLine ttl, String transactionType, String provisionGrossBASClassification) {
        String grossBASClassification;
        Transaction provisionTransaction;
        String pi;
        if (ttl == null || transactionType == null || transactionType.isEmpty() || provisionGrossBASClassification == null || provisionGrossBASClassification.isEmpty()) {
            return null;
        }
        Double provisionAmount = ttl.getProvisionAmount();
        if (transactionType.equals("sales_invoice") || transactionType.equals("sales_quote") || transactionType.equals("cash_received") || transactionType.equals("purchase_credit")) {
            provisionAmount = -provisionAmount.doubleValue();
        }
        if ((pi = ttl.getProvisionIdentifier()) != null && !pi.isEmpty() && (provisionTransaction = this.provisionTrnXBRL.getProvisionTransaction(pi)) != null && (grossBASClassification = provisionTransaction.getProvisionGrossBASClassification()) != null && grossBASClassification.equals(provisionGrossBASClassification)) {
            return provisionAmount;
        }
        return null;
    }

    public Double getGstPayable(Transaction.TransactionTransactionLine ttl, String transactionType) {
        Double result = this.getProvisionTaxBASTotalAmount(ttl, transactionType, "GST_Taxable_Sales");
        result = this.addDouble(result, this.getProvisionTaxBASTotalAmount(ttl, transactionType, "Sales_Adjustments"));
        result = this.addDouble(result, this.getProvisionTaxBASTotalAmount(ttl, transactionType, "Wine_Equalisation_Tax_Liability"));
        result = this.addDouble(result, this.getProvisionTaxBASTotalAmount(ttl, transactionType, "Luxury_Car_Tax_Liability"));
        if ((result = this.addDouble(result, this.getProvisionTaxBASTotalAmount(ttl, transactionType, "Fuel_Tax_Overclaimed_Credits"))) == null) {
            return null;
        }
        return -result.doubleValue();
    }

    public Double getGstReceivable(Transaction.TransactionTransactionLine ttl, String transactionType) {
        Double result = this.getProvisionTaxBASTotalAmount(ttl, transactionType, "Capital_Purchases");
        result = this.addDouble(result, this.getProvisionTaxBASTotalAmount(ttl, transactionType, "Non_Capital_Purchases"));
        result = this.addDouble(result, this.getProvisionTaxBASTotalAmount(ttl, transactionType, "Purchase_Adjustments"));
        result = this.addDouble(result, this.getProvisionTaxBASTotalAmount(ttl, transactionType, "Wine_Equalisation_Tax_Claimable_Credits"));
        result = this.addDouble(result, this.getProvisionTaxBASTotalAmount(ttl, transactionType, "Luxury_Car_Tax_Claimable_Credits"));
        result = this.addDouble(result, this.getProvisionTaxBASTotalAmount(ttl, transactionType, "Fuel_Tax_Claimable_Credits"));
        return result;
    }

    public Double getPaygWithholdingPayable(Transaction.TransactionTransactionLine ttl, String transactionType) {
        return this.getProvisionTaxBASTotalAmount(ttl, transactionType, "PAYG_Withholding_Payable");
    }

    private Double addDouble(Double one, Double two) {
        if (one == null) {
            return two;
        }
        if (two == null) {
            return one;
        }
        return one + two;
    }

    private Double subtractDouble(Double one, Double two) {
        if (one == null && two == null) {
            return null;
        }
        if (one == null && two != null) {
            return -two.doubleValue();
        }
        if (one != null && two == null) {
            return one;
        }
        return one - two;
    }

    private Double twoTotals(HashMap<String, Double> totalOne, HashMap<String, Double> totalTwo, String key) {
        return this.addDouble(totalOne.get(key), totalTwo.get(key));
    }

    protected void updateTotalAmount() {
        if (this.provisionTrnXBRL == null) {
            return;
        }
        if (this.transactionTransactionLineArrayList == null) {
            return;
        }
        HashMap<String, Double> totalGross = new HashMap<String, Double>();
        HashMap<String, Double> totalTax = new HashMap<String, Double>();
        for (Transaction.TransactionTransactionLine ttl : this.transactionTransactionLineArrayList) {
            String basGrossClassification;
            Transaction pmT;
            String pi;
            String transactionStatus = ttl.getTransactionStatus();
            if (transactionStatus == null || !transactionStatus.equals("posted")) continue;
            String transactionType = ttl.getTransactionType();
            Double amount = ttl.getAmount();
            Double provisionAmount = ttl.getProvisionAmount();
            if (transactionType.equals("sales_invoice") || transactionType.equals("sales_quote") || transactionType.equals("cash_received") || transactionType.equals("purchase_credit")) {
                amount = -amount.doubleValue();
                provisionAmount = -provisionAmount.doubleValue();
            }
            if ((pi = ttl.getProvisionIdentifier()) == null || pi.isEmpty() || (pmT = this.provisionTrnXBRL.getProvisionTransaction(pi)) == null || (basGrossClassification = pmT.getProvisionGrossBASClassification()) == null || basGrossClassification.isEmpty()) continue;
            Double curAmt = (Double)totalGross.get(basGrossClassification);
            if (curAmt == null) {
                curAmt = 0.0;
            }
            totalGross.put(basGrossClassification, curAmt + amount);
            curAmt = (Double)totalTax.get(basGrossClassification);
            if (curAmt == null) {
                curAmt = 0.0;
            }
            totalTax.put(basGrossClassification, curAmt - provisionAmount);
        }
        StringBuilder totalSB = new StringBuilder();
        try {
            ActivityStatement as = this.glenixTrnXBRLActivityStatement.getActivityStatement();
            if (as != null) {
                PAYGWObligation paygwo;
                GSTObligation gsto;
                String status = as.getSBRDocumentStatus();
                boolean doupdate = true;
                if (status != null && status.equals("lodge_complete")) {
                    doupdate = false;
                }
                if ((gsto = as.getGSTObligation()) != null) {
                    Double GST_Free_Purchases;
                    Double Purchases_for_Input_Taxed_Sales;
                    Double wetGrossPurchases;
                    Double GST_Free_Purchases_Capital;
                    Double Purchases_for_Input_Taxed_Sales_Capital;
                    Double GST_Taxable_Sales;
                    Double wetGrossSales;
                    Double Sales_Adjustments;
                    Double Input_Taxed_Sales;
                    Double GST_Free_Sales;
                    Double totalSales = 0.0;
                    Double totalSalesNoGST = null;
                    Double Export_Sales = (Double)totalGross.get("Export_Sales");
                    if (Export_Sales == null) {
                        if (doupdate) {
                            gsto.setGoodsAndServicesTaxExportSalesAmount(null);
                        }
                    } else {
                        if (doupdate) {
                            gsto.setGoodsAndServicesTaxExportSalesAmount("" + -Export_Sales.intValue());
                        }
                        totalSales = totalSales + Export_Sales;
                        totalSalesNoGST = Export_Sales;
                    }
                    if ((GST_Free_Sales = (Double)totalGross.get("GST_Free_Sales")) == null) {
                        if (doupdate) {
                            gsto.setGoodsAndServicesTaxExemptSalesAmount(null);
                        }
                    } else {
                        if (doupdate) {
                            gsto.setGoodsAndServicesTaxExemptSalesAmount("" + -GST_Free_Sales.intValue());
                        }
                        totalSales = totalSales + GST_Free_Sales;
                        totalSalesNoGST = totalSalesNoGST == null ? GST_Free_Sales : Double.valueOf(totalSalesNoGST + GST_Free_Sales);
                    }
                    if ((Input_Taxed_Sales = (Double)totalGross.get("Input_Taxed_Sales")) != null) {
                        totalSales = totalSales + Input_Taxed_Sales;
                        totalSalesNoGST = totalSalesNoGST == null ? Input_Taxed_Sales : Double.valueOf(totalSalesNoGST + Input_Taxed_Sales);
                    }
                    if ((Sales_Adjustments = (Double)totalGross.get("Sales_Adjustments")) == null) {
                        if (doupdate) {
                            gsto.setSalesAdjustments(null);
                        }
                    } else if (doupdate) {
                        gsto.setSalesAdjustments("" + -Sales_Adjustments.intValue());
                    }
                    if ((wetGrossSales = (Double)totalGross.get("Wine_Equalisation_Tax_Liability")) != null) {
                        totalSales = totalSales + wetGrossSales;
                    }
                    if ((GST_Taxable_Sales = (Double)totalGross.get("GST_Taxable_Sales")) != null) {
                        totalSales = totalSales + GST_Taxable_Sales;
                    }
                    if (doupdate) {
                        if (totalSalesNoGST == null) {
                            gsto.setTotalSalesWithNoGST(null);
                            gsto.setTotalSalesSubjectToGST("" + -totalSales.intValue());
                            if (Sales_Adjustments == null) {
                                gsto.setTotalSalesSubjectToGSTAfterAdjustments("" + -totalSales.intValue());
                            } else {
                                gsto.setTotalSalesSubjectToGSTAfterAdjustments("" + (-totalSales.intValue() - Sales_Adjustments.intValue()));
                            }
                        } else {
                            gsto.setTotalSalesWithNoGST("" + -totalSalesNoGST.intValue());
                            gsto.setTotalSalesSubjectToGST("" + (-totalSales.intValue() + totalSalesNoGST.intValue()));
                            if (Sales_Adjustments == null) {
                                gsto.setTotalSalesSubjectToGSTAfterAdjustments("" + (-totalSales.intValue() + totalSalesNoGST.intValue()));
                            } else {
                                gsto.setTotalSalesSubjectToGSTAfterAdjustments("" + (-totalSales.intValue() + totalSalesNoGST.intValue() - Sales_Adjustments.intValue()));
                            }
                        }
                        gsto.setIncomeSaleOfGoodsAndServicesWholeAmount("" + -totalSales.intValue());
                        gsto.setIncomeSaleOfGoodsAndServicesTaxIncludedIndicator("true");
                    }
                    Double totalPurchasesWithGST = 0.0;
                    Double totalCapitalPurchases = null;
                    Double Capital_Purchases = (Double)totalGross.get("Capital_Purchases");
                    if (Capital_Purchases != null) {
                        if (totalCapitalPurchases == null) {
                            totalCapitalPurchases = 0.0;
                        }
                        totalCapitalPurchases = totalCapitalPurchases + Capital_Purchases;
                        totalPurchasesWithGST = totalPurchasesWithGST + Capital_Purchases;
                    }
                    if ((Purchases_for_Input_Taxed_Sales_Capital = (Double)totalGross.get("Purchases_for_Input_Taxed_Sales_Capital")) != null) {
                        if (totalCapitalPurchases == null) {
                            totalCapitalPurchases = 0.0;
                        }
                        totalCapitalPurchases = totalCapitalPurchases + Purchases_for_Input_Taxed_Sales_Capital;
                    }
                    if ((GST_Free_Purchases_Capital = (Double)totalGross.get("GST_Free_Purchases_Capital")) != null) {
                        if (totalCapitalPurchases == null) {
                            totalCapitalPurchases = 0.0;
                        }
                        totalCapitalPurchases = totalCapitalPurchases + GST_Free_Purchases_Capital;
                    }
                    if (doupdate) {
                        if (totalCapitalPurchases == null) {
                            gsto.setExpenseCapitalAmount(null);
                        } else {
                            gsto.setExpenseCapitalAmount("" + totalCapitalPurchases.intValue());
                        }
                    }
                    Double totalNonCapitalPurchases = null;
                    Double Non_Capital_Purchases = (Double)totalGross.get("Non_Capital_Purchases");
                    if (Non_Capital_Purchases != null) {
                        if (totalNonCapitalPurchases == null) {
                            totalNonCapitalPurchases = 0.0;
                        }
                        totalNonCapitalPurchases = totalNonCapitalPurchases + Non_Capital_Purchases;
                        totalPurchasesWithGST = totalPurchasesWithGST + Non_Capital_Purchases;
                    }
                    if ((wetGrossPurchases = (Double)totalGross.get("Wine_Equalisation_Tax_Claimable_Credits")) != null) {
                        if (totalNonCapitalPurchases == null) {
                            totalNonCapitalPurchases = 0.0;
                        }
                        totalNonCapitalPurchases = totalNonCapitalPurchases + wetGrossPurchases;
                        totalPurchasesWithGST = totalPurchasesWithGST + wetGrossPurchases;
                    }
                    if ((Purchases_for_Input_Taxed_Sales = (Double)totalGross.get("Purchases_for_Input_Taxed_Sales")) == null) {
                        if (doupdate) {
                            gsto.setPurchasesForInputTaxedSales(null);
                        }
                    } else {
                        if (doupdate) {
                            gsto.setPurchasesForInputTaxedSales("" + Purchases_for_Input_Taxed_Sales.intValue());
                        }
                        if (totalNonCapitalPurchases == null) {
                            totalNonCapitalPurchases = 0.0;
                        }
                        totalNonCapitalPurchases = totalNonCapitalPurchases + Purchases_for_Input_Taxed_Sales;
                    }
                    if ((GST_Free_Purchases = (Double)totalGross.get("GST_Free_Purchases")) == null) {
                        if (doupdate) {
                            gsto.setGSTFreePurchases(null);
                            if (Purchases_for_Input_Taxed_Sales == null) {
                                gsto.setTotalPurchasesNoClaimableGST(null);
                            } else {
                                gsto.setTotalPurchasesNoClaimableGST("" + Purchases_for_Input_Taxed_Sales.intValue());
                            }
                        }
                    } else {
                        if (doupdate) {
                            gsto.setGSTFreePurchases("" + GST_Free_Purchases.intValue());
                            if (Purchases_for_Input_Taxed_Sales == null) {
                                gsto.setTotalPurchasesNoClaimableGST("" + GST_Free_Purchases.intValue());
                            } else {
                                gsto.setTotalPurchasesNoClaimableGST("" + (GST_Free_Purchases.intValue() + Purchases_for_Input_Taxed_Sales.intValue()));
                            }
                        }
                        if (totalNonCapitalPurchases == null) {
                            totalNonCapitalPurchases = 0.0;
                        }
                        totalNonCapitalPurchases = totalNonCapitalPurchases + GST_Free_Purchases;
                    }
                    if (doupdate) {
                        if (totalNonCapitalPurchases == null) {
                            gsto.setExpenseNonCapitalAmount(null);
                            if (totalCapitalPurchases == null) {
                                gsto.setTotalPurchases(null);
                            } else {
                                gsto.setTotalPurchases("" + totalCapitalPurchases.intValue());
                            }
                        } else {
                            gsto.setExpenseNonCapitalAmount("" + totalNonCapitalPurchases.intValue());
                            if (totalCapitalPurchases == null) {
                                gsto.setTotalPurchases("" + totalNonCapitalPurchases.intValue());
                            } else {
                                gsto.setTotalPurchases("" + (totalNonCapitalPurchases.intValue() + totalCapitalPurchases.intValue()));
                            }
                        }
                        if (totalNonCapitalPurchases == null && totalCapitalPurchases == null && totalPurchasesWithGST == 0.0) {
                            gsto.setTotalPurchasesWithGST(null);
                        } else {
                            gsto.setTotalPurchasesWithGST("" + totalPurchasesWithGST.intValue());
                        }
                    }
                    Double Purchase_Adjustments = (Double)totalGross.get("Purchase_Adjustments");
                    if (doupdate) {
                        if (Purchase_Adjustments == null) {
                            gsto.setPurchaseAdjustments(null);
                            if (totalNonCapitalPurchases == null && totalCapitalPurchases == null && totalPurchasesWithGST == 0.0) {
                                gsto.setTotalPurchasesWithGSTAfterAdjustments(null);
                            } else {
                                gsto.setTotalPurchasesWithGSTAfterAdjustments("" + totalPurchasesWithGST.intValue());
                            }
                        } else {
                            gsto.setPurchaseAdjustments("" + Purchase_Adjustments.intValue());
                            if (totalNonCapitalPurchases == null && totalCapitalPurchases == null && totalPurchasesWithGST == 0.0) {
                                gsto.setTotalPurchasesWithGSTAfterAdjustments("" + Purchase_Adjustments.intValue());
                            } else {
                                gsto.setTotalPurchasesWithGSTAfterAdjustments("" + (totalPurchasesWithGST.intValue() + Purchase_Adjustments.intValue()));
                            }
                        }
                    }
                    Double GST_Payable = (Double)totalTax.get("GST_Taxable_Sales");
                    GST_Payable = this.addDouble(GST_Payable, (Double)totalTax.get("Sales_Adjustments"));
                    GST_Payable = this.addDouble(GST_Payable, (Double)totalTax.get("Wine_Equalisation_Tax_Liability"));
                    GST_Payable = this.addDouble(GST_Payable, (Double)totalTax.get("Luxury_Car_Tax_Liability"));
                    GST_Payable = this.addDouble(GST_Payable, (Double)totalTax.get("Fuel_Tax_Overclaimed_Credits"));
                    if (doupdate) {
                        if (GST_Payable == null) {
                            gsto.setCalculationGoodsAndServicesTaxLiabilityAmount(null);
                            gsto.setGoodsAndServicesTaxPayableAmount(null);
                        } else {
                            gsto.setCalculationGoodsAndServicesTaxLiabilityAmount("" + GST_Payable.intValue());
                            gsto.setGoodsAndServicesTaxPayableAmount("" + GST_Payable.intValue());
                        }
                    }
                    Double GST_Receivable = (Double)totalTax.get("Capital_Purchases");
                    GST_Receivable = this.addDouble(GST_Receivable, (Double)totalTax.get("Non_Capital_Purchases"));
                    GST_Receivable = this.addDouble(GST_Receivable, (Double)totalTax.get("Purchase_Adjustments"));
                    GST_Receivable = this.addDouble(GST_Receivable, (Double)totalTax.get("Wine_Equalisation_Tax_Claimable_Credits"));
                    GST_Receivable = this.addDouble(GST_Receivable, (Double)totalTax.get("Luxury_Car_Tax_Claimable_Credits"));
                    GST_Receivable = this.addDouble(GST_Receivable, (Double)totalTax.get("Fuel_Tax_Claimable_Credits"));
                    if (doupdate) {
                        if (GST_Receivable == null) {
                            gsto.setGoodsAndServicesTaxClaimableCreditsAmount(null);
                        } else {
                            gsto.setGoodsAndServicesTaxClaimableCreditsAmount("" + -GST_Receivable.intValue());
                        }
                    }
                    Double Wine_Equalisation_Tax_Claimable_Credits = this.twoTotals(totalGross, totalTax, "Wine_Equalisation_Tax_Claimable_Credits");
                    if (doupdate) {
                        if (Wine_Equalisation_Tax_Claimable_Credits == null) {
                            gsto.setWineEqualisationTaxClaimableCreditsAmount(null);
                        } else {
                            gsto.setWineEqualisationTaxClaimableCreditsAmount("" + Wine_Equalisation_Tax_Claimable_Credits.intValue());
                        }
                    }
                    Double Wine_Equalisation_Tax_Liability = this.twoTotals(totalGross, totalTax, "Wine_Equalisation_Tax_Liability");
                    if (doupdate) {
                        if (Wine_Equalisation_Tax_Liability == null) {
                            gsto.setWineEqualisationTaxLiabilityAmount(null);
                        } else {
                            gsto.setWineEqualisationTaxLiabilityAmount("" + -Wine_Equalisation_Tax_Liability.intValue());
                        }
                    }
                    Double Luxury_Car_Tax_Claimable_Credits = this.twoTotals(totalGross, totalTax, "Luxury_Car_Tax_Claimable_Credits");
                    if (doupdate) {
                        if (Luxury_Car_Tax_Claimable_Credits == null) {
                            gsto.setLuxuryCarTaxClaimableCreditsAmount(null);
                        } else {
                            gsto.setLuxuryCarTaxClaimableCreditsAmount("" + Luxury_Car_Tax_Claimable_Credits.intValue());
                        }
                    }
                    Double Luxury_Car_Tax_Liability = this.twoTotals(totalGross, totalTax, "Luxury_Car_Tax_Liability");
                    if (doupdate) {
                        if (Luxury_Car_Tax_Liability == null) {
                            gsto.setLuxuryCarTaxLiabilityAmount(null);
                        } else {
                            gsto.setLuxuryCarTaxLiabilityAmount("" + -Luxury_Car_Tax_Liability.intValue());
                        }
                    }
                    Double Fuel_Tax_Claimable_Credits = this.twoTotals(totalGross, totalTax, "Fuel_Tax_Claimable_Credits");
                    Fuel_Tax_Claimable_Credits = this.subtractDouble(Fuel_Tax_Claimable_Credits, totalTax.get("Fuel_Tax_Claimable_Credits_Tax_Amount"));
                    if (doupdate) {
                        if (Fuel_Tax_Claimable_Credits == null) {
                            gsto.setFuelTaxClaimableCreditsAmount(null);
                        } else {
                            gsto.setFuelTaxClaimableCreditsAmount("" + Fuel_Tax_Claimable_Credits.intValue());
                        }
                    }
                    Double Fuel_Tax_Overclaimed_Credits = this.twoTotals(totalGross, totalTax, "Fuel_Tax_Overclaimed_Credits");
                    Fuel_Tax_Overclaimed_Credits = this.subtractDouble(Fuel_Tax_Overclaimed_Credits, totalTax.get("Fuel_Tax_Overclaimed_Credits_Tax_Amount"));
                    if (doupdate) {
                        if (Fuel_Tax_Overclaimed_Credits == null) {
                            gsto.setFuelTaxOverclaimedCreditsAmount(null);
                        } else {
                            gsto.setFuelTaxOverclaimedCreditsAmount("" + -Fuel_Tax_Overclaimed_Credits.intValue());
                        }
                    }
                    totalSB.append("BAS totals: ");
                    if (totalSales != null) {
                        totalSB.append("Sales ");
                        totalSB.append(this.wholeDollarFormat.format(-totalSales.doubleValue()) + " ");
                        if (GST_Payable != null) {
                            totalSB.append("(incl GST: ");
                            totalSB.append(this.wholeDollarFormat.format(GST_Payable));
                            totalSB.append(") ");
                        }
                    }
                    if (totalNonCapitalPurchases != null || totalCapitalPurchases != null) {
                        Double tmptotal = 0.0;
                        if (totalNonCapitalPurchases != null) {
                            tmptotal = tmptotal + totalNonCapitalPurchases;
                        }
                        if (totalCapitalPurchases != null) {
                            tmptotal = tmptotal + totalCapitalPurchases;
                        }
                        totalSB.append("Purchases ");
                        totalSB.append(this.wholeDollarFormat.format(tmptotal) + " ");
                        if (GST_Receivable != null) {
                            totalSB.append("(incl GST: ");
                            totalSB.append(this.wholeDollarFormat.format(-GST_Receivable.doubleValue()));
                            totalSB.append(") ");
                        }
                    }
                }
                if ((paygwo = as.getPAYGWObligation()) != null) {
                    Double No_ABN_Withholding;
                    Double PAYG_Withholding_Payable;
                    Double totalPAYGW = null;
                    Double Salaries_and_Wages = (Double)totalGross.get("Salaries_and_Wages");
                    if (Salaries_and_Wages != null && doupdate) {
                        paygwo.setRemunerationWagesAndSalariesPlusPaymentsOtherAmount("" + Salaries_and_Wages.intValue());
                    }
                    if ((PAYG_Withholding_Payable = (Double)totalTax.get("PAYG_Withholding_Payable")) != null) {
                        if (totalPAYGW == null) {
                            totalPAYGW = 0.0;
                        }
                        if (doupdate) {
                            paygwo.setW2ITPAYGWithholdingDetailsAmount("" + PAYG_Withholding_Payable.intValue());
                        }
                        totalPAYGW = totalPAYGW + PAYG_Withholding_Payable;
                    } else if (Salaries_and_Wages != null) {
                        if (totalPAYGW == null) {
                            totalPAYGW = 0.0;
                        }
                        if (doupdate) {
                            paygwo.setW2ITPAYGWithholdingDetailsAmount("0");
                        }
                    }
                    Double Other_PAYG_Withholding = (Double)totalTax.get("Other_PAYG_Withholding");
                    if (Other_PAYG_Withholding != null) {
                        if (doupdate) {
                            paygwo.setW3ITPAYGWithholdingDetailsAmount("" + Other_PAYG_Withholding.intValue());
                        }
                        if (totalPAYGW == null) {
                            totalPAYGW = 0.0;
                        }
                        totalPAYGW = totalPAYGW + Other_PAYG_Withholding;
                    }
                    if ((No_ABN_Withholding = (Double)totalTax.get("No_ABN_Withholding")) != null) {
                        if (doupdate) {
                            paygwo.setDNOABNITPAYGWithholdingDetailsAmount("" + No_ABN_Withholding.intValue());
                        }
                        if (totalPAYGW == null) {
                            totalPAYGW = 0.0;
                        }
                        totalPAYGW = totalPAYGW + No_ABN_Withholding;
                    }
                    if (doupdate) {
                        if (totalPAYGW == null) {
                            paygwo.setIncomeTaxPayAsYouGoWithholdingTotalAmount("0");
                        } else {
                            paygwo.setIncomeTaxPayAsYouGoWithholdingTotalAmount("" + totalPAYGW.intValue());
                        }
                    }
                    if (Salaries_and_Wages != null) {
                        totalSB.append("Salaries and wages ");
                        totalSB.append(this.wholeDollarFormat.format(Salaries_and_Wages) + " ");
                        if (totalPAYGW != null) {
                            totalSB.append("(total tax withheld: ");
                            totalSB.append(this.wholeDollarFormat.format(totalPAYGW));
                            totalSB.append(") ");
                        }
                    }
                }
            }
            this.total_label.setText(totalSB.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getLocalizedMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    private void removeSelectedTransaction() {
        ObservableList ol = this.transactionTransactionLineTable.getSelectionModel().getSelectedItems();
        try {
            for (Transaction.TransactionTransactionLine ttl : ol) {
                ttl.setActivityStatementNumber(null);
            }
            this.xbrlFileController.saveTransactions((Set<Transaction>)null);
            this.transactionTransactionLineObservableList.removeAll((Collection)ol);
            this.updateFilter();
            this.refreshTable();
            this.updateTotalAmount();
            this.transactionTransactionLineTable.getSelectionModel().clearSelection();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    private void buildPDFSubSection(String subSection, GlenixPDFWrapper gpw) throws Exception {
        this.subSection = subSection;
        Double fontSize = this.convertFontSize(new Double(this.xbrlFileController.getCurrentFontSize()));
        this.drawPDFColumnHeadings(gpw);
        Double totalAmount = 0.0;
        Double totalProvisionAmount = 0.0;
        for (Transaction.TransactionTransactionLine ttl : this.filteredItems) {
            String comment;
            String provisionName;
            Transaction pt;
            String pi;
            String accountName;
            Transaction at;
            String ai;
            String legalName;
            Transaction ct;
            Double taxAmount;
            Double amount;
            String tt;
            if (subSection.equals("sales")) {
                tt = ttl.getTransactionType();
                amount = this.getBASGrossSalesAmount(ttl, tt);
                taxAmount = this.getGstPayable(ttl, tt);
                if (amount == null && taxAmount == null) continue;
                if (amount != null) {
                    totalAmount = totalAmount + amount;
                    gpw.prepareString(4, this.amountFormat.format(amount), true, fontSize, "right");
                }
                if (taxAmount != null) {
                    totalProvisionAmount = totalProvisionAmount + taxAmount;
                    gpw.prepareString(5, this.amountFormat.format(taxAmount), true, fontSize, "right");
                }
            } else if (subSection.equals("purchases")) {
                tt = ttl.getTransactionType();
                amount = this.getBASGrossPurchasesAmount(ttl, tt);
                taxAmount = this.getGstReceivable(ttl, tt);
                if (amount == null && taxAmount == null) continue;
                if (amount != null) {
                    totalAmount = totalAmount + amount;
                    gpw.prepareString(4, this.amountFormat.format(amount), true, fontSize, "right");
                }
                if (taxAmount != null) {
                    totalProvisionAmount = totalProvisionAmount + taxAmount;
                    gpw.prepareString(5, this.amountFormat.format(taxAmount), true, fontSize, "right");
                }
            } else if (subSection.equals("salaries")) {
                tt = ttl.getTransactionType();
                amount = this.getSalariesAndWages(ttl, tt);
                taxAmount = this.getPaygWithholdingPayable(ttl, tt);
                if (amount == null && taxAmount == null) continue;
                if (amount != null) {
                    totalAmount = totalAmount + amount;
                    gpw.prepareString(4, this.amountFormat.format(amount), true, fontSize, "right");
                }
                if (taxAmount != null) {
                    totalProvisionAmount = totalProvisionAmount + taxAmount;
                    gpw.prepareString(5, this.amountFormat.format(taxAmount), true, fontSize, "right");
                }
            } else if (subSection.equals("other")) {
                Double taxAmountDouble;
                tt = ttl.getTransactionType();
                Double a1 = this.getBASGrossSalesAmount(ttl, tt);
                Double t1 = this.getGstPayable(ttl, tt);
                Double a2 = this.getBASGrossPurchasesAmount(ttl, tt);
                Double t2 = this.getGstReceivable(ttl, tt);
                Double a3 = this.getSalariesAndWages(ttl, tt);
                Double t3 = this.getPaygWithholdingPayable(ttl, tt);
                if (a1 != null || t1 != null || a2 != null || t2 != null || a3 != null || t3 != null) continue;
                Double amountDouble = ttl.getAmount();
                if (amountDouble != null) {
                    totalAmount = totalAmount + amountDouble;
                    gpw.prepareString(4, this.amountFormat.format(amountDouble), true, fontSize, "right");
                }
                if ((taxAmountDouble = ttl.getProvisionAmount()) != null) {
                    totalProvisionAmount = totalProvisionAmount + taxAmountDouble;
                    gpw.prepareString(5, this.amountFormat.format(taxAmountDouble), true, fontSize, "right");
                }
            }
            gpw.prepareString(2, this.displayDateFormatter.format(ttl.getTransactionDateAsDate()), true, fontSize);
            String ci = ttl.getCounterpartyIdentifier();
            if (ci != null && !ci.isEmpty() && (ct = this.xbrlFileController.getCounterpartyTransaction(ci)) != null && (legalName = ct.getCounterpartyLegalName()) != null) {
                gpw.prepareString(3, legalName, true, fontSize);
            }
            if ((ai = ttl.getAccountIdentifier()) != null && !ai.isEmpty() && (at = this.xbrlFileController.getAccountTransaction(ai)) != null && (accountName = at.getAccountName()) != null) {
                gpw.prepareString(6, accountName, true, fontSize);
            }
            if ((pi = ttl.getProvisionIdentifier()) != null && !pi.isEmpty() && (pt = this.xbrlFileController.getProvisionTransaction(ai)) != null && (provisionName = pt.getProvisionName()) != null) {
                gpw.prepareString(7, provisionName, true, fontSize);
            }
            if ((comment = ttl.getTransactionComment()) != null && !comment.isEmpty()) {
                gpw.prepareString(8, comment, true, fontSize);
            }
            gpw.drawStrings(5.0);
        }
        gpw.setColumnFont(2, gpw.muliBoldFont);
        gpw.setColumnFont(4, gpw.muliBoldFont);
        gpw.setColumnFont(5, gpw.muliBoldFont);
        gpw.prepareString(2, "Totals", true, fontSize);
        gpw.prepareString(4, this.amountFormat.format(totalAmount), true, fontSize, "right");
        gpw.prepareString(5, this.amountFormat.format(totalProvisionAmount), true, fontSize, "right");
        gpw.setColumnFont(2, gpw.muliLightFont);
        gpw.setColumnFont(4, gpw.muliLightFont);
        gpw.setColumnFont(5, gpw.muliLightFont);
        gpw.drawStrings(10.0);
    }

    @Override
    public GlenixPDFWrapper buildPDF(boolean includeBlanks) throws Exception {
        String filterTextValue;
        GlenixPDFWrapper gpw = new GlenixPDFWrapper();
        gpw.addPDPageLandscape();
        gpw.setColumns(9);
        gpw.setColumnLeftPosAndWidthMM(0, 20.0, 266.0);
        gpw.setColumnLeftPosAndWidthMM(1, 20.0, 266.0);
        gpw.setColumnLeftPosAndWidthMM(2, 20.0, 24.0);
        gpw.setColumnLeftPosAndWidthMM(3, 44.0, 40.0);
        gpw.setColumnLeftPosAndWidthMM(4, 84.0, 28.0);
        gpw.setColumnLeftPosAndWidthMM(5, 112.0, 26.0);
        gpw.setColumnLeftPosAndWidthMM(6, 142.0, 40.0);
        gpw.setColumnLeftPosAndWidthMM(7, 184.0, 40.0);
        gpw.setColumnLeftPosAndWidthMM(8, 226.0, 40.0);
        gpw.setColumnFont(0, gpw.muliBoldFont);
        gpw.setColumnFont(1, gpw.muliLightFont);
        gpw.setColumnFont(2, gpw.muliLightFont);
        gpw.setColumnFont(3, gpw.muliLightFont);
        gpw.setColumnFont(4, gpw.muliLightFont);
        gpw.setColumnFont(5, gpw.muliLightFont);
        gpw.setColumnFont(6, gpw.muliLightFont);
        gpw.setColumnFont(7, gpw.muliLightFont);
        gpw.setColumnFont(8, gpw.muliLightFont);
        Double fontSize = this.convertFontSize(this.page_heading.getFont().getSize());
        gpw.prepareString(0, this.page_heading.getText(), true, fontSize);
        gpw.drawStrings(10.0);
        fontSize = this.convertFontSize(new Double(this.xbrlFileController.getCurrentFontSize()));
        StringBuilder filterBuilder = new StringBuilder();
        String prefix = "";
        if (this.filterText != null && (filterTextValue = this.filterText.getGlenixElementValue()) != null && !filterTextValue.isEmpty()) {
            filterBuilder.append("Filter text: ");
            filterBuilder.append(filterTextValue);
            prefix = ", ";
        }
        if (filterBuilder.length() > 0) {
            gpw.prepareString(1, filterBuilder.toString(), true, fontSize);
            gpw.drawStrings(10.0);
        }
        gpw.setAddPageCallback(this);
        gpw.prepareString(0, "Sales and GST payable", true, fontSize);
        gpw.drawStrings(5.0);
        this.buildPDFSubSection("sales", gpw);
        gpw.prepareString(0, "Purchases and GST receivable", true, fontSize);
        gpw.drawStrings(5.0);
        this.buildPDFSubSection("purchases", gpw);
        gpw.prepareString(0, "Payroll and PAYG tax withholding payable", true, fontSize);
        gpw.drawStrings(5.0);
        this.buildPDFSubSection("salaries", gpw);
        gpw.prepareString(0, "Other", true, fontSize);
        gpw.drawStrings(5.0);
        this.buildPDFSubSection("other", gpw);
        gpw.addFooter();
        return gpw;
    }

    private void drawPDFColumnHeadings(GlenixPDFWrapper gpw) throws Exception {
        gpw.setColumnFont(2, gpw.muliBoldFont);
        gpw.setColumnFont(3, gpw.muliBoldFont);
        gpw.setColumnFont(4, gpw.muliBoldFont);
        gpw.setColumnFont(5, gpw.muliBoldFont);
        gpw.setColumnFont(6, gpw.muliBoldFont);
        gpw.setColumnFont(7, gpw.muliBoldFont);
        gpw.setColumnFont(8, gpw.muliBoldFont);
        Double fontSize = this.convertFontSize(new Double(this.xbrlFileController.getCurrentFontSize()));
        gpw.prepareString(2, this.transactionDateColumn.getText(), true, fontSize);
        gpw.prepareString(3, this.transactionCounterpartyColumn.getText(), true, fontSize);
        if (this.subSection.equals("sales")) {
            gpw.prepareString(4, this.gstTaxableSalesColumn.getText(), true, fontSize);
            gpw.prepareString(5, this.gstPayableColumn.getText(), true, fontSize);
        } else if (this.subSection.equals("purchases")) {
            gpw.prepareString(4, this.gstTaxablePurchasesColumn.getText(), true, fontSize);
            gpw.prepareString(5, this.gstReceivableColumn.getText(), true, fontSize);
        } else if (this.subSection.equals("payroll")) {
            gpw.prepareString(4, this.salariesAndWagesColumn.getText(), true, fontSize);
            gpw.prepareString(5, this.paygwPayableColumn.getText(), true, fontSize);
        } else if (this.subSection.equals("other")) {
            gpw.prepareString(4, "Gross", true, fontSize);
            gpw.prepareString(5, "Tax", true, fontSize);
        }
        gpw.prepareString(6, this.accountColumn.getText(), true, fontSize);
        gpw.prepareString(7, this.provisionColumn.getText(), true, fontSize);
        gpw.prepareString(8, this.transactionCommentLineCommentColumn.getText(), true, fontSize);
        gpw.drawStrings(5.0);
        gpw.setColumnFont(2, gpw.muliLightFont);
        gpw.setColumnFont(3, gpw.muliLightFont);
        gpw.setColumnFont(4, gpw.muliLightFont);
        gpw.setColumnFont(5, gpw.muliLightFont);
        gpw.setColumnFont(6, gpw.muliLightFont);
        gpw.setColumnFont(7, gpw.muliLightFont);
        gpw.setColumnFont(8, gpw.muliLightFont);
    }

    @Override
    public void newPDFPageAdded(GlenixPDFWrapper gpw) throws Exception {
        this.drawPDFColumnHeadings(gpw);
    }

    private /* synthetic */ void lambda$null$0(TableRow row, MouseEvent event) {
        block24: {
            String tt;
            Transaction t;
            Transaction.TransactionTransactionLine reportItem;
            if (event.getClickCount() == 2 && !row.isEmpty() && (reportItem = (Transaction.TransactionTransactionLine)row.getItem()) != null && (t = reportItem.getTransaction()) != null && (tt = t.getTransactionType()) != null) {
                String batchIdentifier;
                if (tt.equals("sales_invoice") || tt.equals("sales_credit") || tt.equals("sales_quote")) {
                    try {
                        String batchIdentifier2 = t.getBatchIdentifier();
                        if (batchIdentifier2 != null && !batchIdentifier2.isEmpty()) {
                            this.xbrlFileController.gotoBatchTransactionEdit(t, batchIdentifier2);
                            break block24;
                        }
                        this.xbrlFileController.gotoSalesTransactionsE(t);
                    }
                    catch (Exception e) {
                        this.error_message.setText(e.getMessage());
                        this.xbrlFileController.setStatusBarMessage(e.getMessage());
                        e.printStackTrace();
                    }
                } else if (tt.equals("cash_received")) {
                    try {
                        String batchIdentifier3 = t.getBatchIdentifier();
                        if (batchIdentifier3 != null && !batchIdentifier3.isEmpty()) {
                            this.xbrlFileController.gotoBatchTransactionEdit(t, batchIdentifier3);
                            break block24;
                        }
                        this.xbrlFileController.gotoReceiveMoneyE(t, 0, null, null, null);
                    }
                    catch (Exception e) {
                        this.error_message.setText(e.getMessage());
                        this.xbrlFileController.setStatusBarMessage(e.getMessage());
                        e.printStackTrace();
                    }
                } else if (tt.equals("purchase_invoice") || tt.equals("purchase_credit") || tt.equals("purchase_quote")) {
                    try {
                        String batchIdentifier4 = t.getBatchIdentifier();
                        if (batchIdentifier4 != null && !batchIdentifier4.isEmpty()) {
                            this.xbrlFileController.gotoBatchTransactionEdit(t, batchIdentifier4);
                            break block24;
                        }
                        this.xbrlFileController.gotoOtherPurchasesTransactionsE(t);
                    }
                    catch (Exception e) {
                        this.error_message.setText(e.getMessage());
                        this.xbrlFileController.setStatusBarMessage(e.getMessage());
                        e.printStackTrace();
                    }
                } else if (tt.equals("cash_payment")) {
                    try {
                        String batchIdentifier5 = t.getBatchIdentifier();
                        if (batchIdentifier5 != null && !batchIdentifier5.isEmpty()) {
                            this.xbrlFileController.gotoBatchTransactionEdit(t, batchIdentifier5);
                            break block24;
                        }
                        this.xbrlFileController.gotoPayMoneyE(t, 0, null, null, null);
                    }
                    catch (Exception e) {
                        this.error_message.setText(e.getMessage());
                        this.xbrlFileController.setStatusBarMessage(e.getMessage());
                        e.printStackTrace();
                    }
                } else if (tt.equals("pay_slip") && (batchIdentifier = t.getBatchIdentifier()) != null && !batchIdentifier.isEmpty()) {
                    try {
                        this.xbrlFileController.gotoBatchPaySlipEdit(t, batchIdentifier);
                    }
                    catch (Exception e) {
                        this.error_message.setText(e.getMessage());
                        this.xbrlFileController.setStatusBarMessage(e.getMessage());
                        e.printStackTrace();
                    }
                }
            }
        }
    }
}

