/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import au.com.glenix.TransactionLineEditShortController;
import au.com.glenix.trn.TransactionLine;
import au.com.glenix.widget.GlenixLabelEightDecimalNumberVertical;
import au.com.glenix.widget.GlenixLabelTwoDecimalNumberVertical;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;

public class TransactionLineEditShortFuelTaxCreditController
extends TransactionLineEditShortController {
    @FXML
    private GlenixLabelTwoDecimalNumberVertical provisionAmount;
    @FXML
    private GlenixLabelEightDecimalNumberVertical rate;
    @FXML
    private GlenixLabelEightDecimalNumberVertical provisionQuantity;
    protected DecimalFormat amountFormat = new DecimalFormat("0.00");
    protected DecimalFormat quantityFormat = new DecimalFormat("0.00000000");

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        super.initialize(url, rb);
        if (this.provisionAmount != null) {
            this.provisionAmount.setSingleChangeListener(new ChangeListener<String>(){

                public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                    if (TransactionLineEditShortFuelTaxCreditController.this.doupdate) {
                        TransactionLineEditShortFuelTaxCreditController.this.calculateQuantityFromAmountRate();
                    }
                }
            });
        }
        if (this.rate != null) {
            this.rate.setSingleChangeListener(new ChangeListener<String>(){

                public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                    if (TransactionLineEditShortFuelTaxCreditController.this.doupdate) {
                        TransactionLineEditShortFuelTaxCreditController.this.calculateAmountFromQuantityRate();
                    }
                }
            });
        }
        if (this.provisionQuantity != null) {
            this.provisionQuantity.setSingleChangeListener(new ChangeListener<String>(){

                public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                    if (TransactionLineEditShortFuelTaxCreditController.this.doupdate) {
                        TransactionLineEditShortFuelTaxCreditController.this.calculateAmountFromQuantityRate();
                    }
                }
            });
        }
    }

    protected void setRatesVisibility(Number width) {
    }

    public void calculateAmountFromQuantityRate() {
        Double arate = this.rate.getDouble();
        Double aqty = this.provisionQuantity.getDouble();
        if (arate != null && aqty != null) {
            Double calc = arate * aqty;
            this.provisionAmount.setGlenixElementValue(this.amountFormat.format(calc));
        }
    }

    public void calculateQuantityFromAmountRate() {
        Double arate = this.rate.getDouble();
        Double amt = this.provisionAmount.getDouble();
        if (arate != null && amt != null && arate != 0.0) {
            Double calc = amt / arate;
            this.provisionQuantity.setGlenixElementValue(this.quantityFormat.format(calc));
        }
    }

    @Override
    public void setTransactionLine(TransactionLine aTransactionLine) {
        super.setTransactionLine(aTransactionLine);
        this.doupdate = false;
        if (aTransactionLine == null) {
            this.provisionAmount.setGlenixElementValue(null);
            this.provisionQuantity.setGlenixElementValue(null);
            this.rate.setGlenixElementValue(null);
        } else {
            this.provisionAmount.setGlenixElementValue(aTransactionLine.getProvisionAmountString());
            this.provisionQuantity.setGlenixElementValue(aTransactionLine.getProvisionQuantityString());
            Double amt = aTransactionLine.getAmountAsDouble();
            Double qty = aTransactionLine.getProvisionQuantityAsDouble();
            if (amt != null && qty != null && qty != 0.0) {
                Double calc = amt / qty;
                this.rate.setGlenixElementValue(this.quantityFormat.format(calc));
            }
        }
        this.doupdate = true;
    }

    public void setRate(Double arate) {
        if (arate == null) {
            this.rate.setGlenixElementValue(null);
        }
        this.rate.setGlenixElementValue(this.quantityFormat.format(arate));
    }
}

