/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import au.com.glenix.GlenixLabelApportionmentMethodComboVertical;
import au.com.glenix.TransactionLineEditShortController;
import au.com.glenix.trn.TransactionLine;
import au.com.glenix.widget.GlenixLabelTwoDecimalNumberVertical;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.util.Pair;

public class TransactionLineEditShortApportionedController
extends TransactionLineEditShortController {
    @FXML
    private GlenixLabelTwoDecimalNumberVertical fullAmount;
    @FXML
    private GlenixLabelApportionmentMethodComboVertical apportionmentMethod;
    protected Double apportionmentRate = 0.0;
    protected DecimalFormat numberFormat = new DecimalFormat("0.00");

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        super.initialize(url, rb);
        this.getPane().widthProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                TransactionLineEditShortApportionedController.this.setRatesVisibility(newValue);
            }
        });
        this.setRatesVisibility(this.getPane().getWidth());
        if (this.fullAmount != null) {
            this.fullAmount.setSingleChangeListener(new ChangeListener<String>(){

                public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                    if (TransactionLineEditShortApportionedController.this.doupdate) {
                        TransactionLineEditShortApportionedController.this.calculateAmountFromFullAmount();
                    }
                }
            });
        }
        if (this.apportionmentMethod != null) {
            this.apportionmentMethod.setSingleChangeListener(new ChangeListener<Pair<String, String>>(){

                public void changed(ObservableValue<? extends Pair<String, String>> observable, Pair<String, String> oldValue, Pair<String, String> newValue) {
                    if (TransactionLineEditShortApportionedController.this.doupdate) {
                        TransactionLineEditShortApportionedController.this.calculateAmountFromFullAmount();
                    }
                }
            });
        }
    }

    public void setApportionmentRate(Double rate) {
        this.apportionmentRate = rate;
    }

    @Override
    public void calculateRateQuantityFromAmount() {
        super.calculateRateQuantityFromAmount();
        this.calculateFullAmountFromAmount();
    }

    public void calculateAmountFromFullAmount() {
        Double fa = this.fullAmount.getDouble();
        if (fa != null) {
            String appm = this.apportionmentMethod.getGlenixElementValue();
            if (appm != null && appm.equals("direct")) {
                this.amount.setGlenixElementValue(fa.toString());
            } else if (appm != null && appm.equals("apportioned")) {
                Double calc = fa * this.apportionmentRate;
                this.amount.setGlenixElementValue(this.numberFormat.format(calc));
            }
        }
    }

    public void calculateFullAmountFromAmount() {
        Double a = this.amount.getDouble();
        if (a != null) {
            String appm = this.apportionmentMethod.getGlenixElementValue();
            if (appm != null && appm.equals("direct")) {
                this.fullAmount.setGlenixElementValue(a.toString());
            } else if (appm != null && appm.equals("apportion")) {
                Double calc = a / this.apportionmentRate;
                this.fullAmount.setGlenixElementValue(this.numberFormat.format(calc));
            }
        }
    }

    protected void setRatesVisibility(Number width) {
        if (width == null || width.intValue() < 600) {
            this.startEndDateTime.setManaged(false);
            this.startEndDateTime.setVisible(false);
            this.quantityRateHBox.setManaged(false);
            this.quantityRateHBox.setVisible(false);
            this.lineComment.setPrefWidth(500.0);
        } else if (width == null || width.intValue() < 800) {
            this.startEndDateTime.setManaged(false);
            this.startEndDateTime.setVisible(false);
            this.quantityRateHBox.setManaged(false);
            this.quantityRateHBox.setVisible(false);
            this.lineComment.setPrefWidth(width.intValue() - 500);
        } else if (width.intValue() < 1300) {
            this.startEndDateTime.setManaged(false);
            this.startEndDateTime.setVisible(false);
            this.quantityRateHBox.setManaged(true);
            this.quantityRateHBox.setVisible(true);
            this.lineComment.setPrefWidth(width.intValue() - 720);
        } else {
            this.startEndDateTime.setManaged(true);
            this.startEndDateTime.setVisible(true);
            this.quantityRateHBox.setManaged(true);
            this.quantityRateHBox.setVisible(true);
            this.lineComment.setPrefWidth(width.intValue() - 1110);
        }
    }

    @Override
    public void setTransactionLine(TransactionLine aTransactionLine) {
        super.setTransactionLine(aTransactionLine);
        this.doupdate = false;
        if (aTransactionLine == null) {
            this.fullAmount.setGlenixElementValue(null);
            this.apportionmentMethod.setGlenixElementValue(null);
        } else {
            this.fullAmount.setGlenixElementValue(aTransactionLine.getFullAmountString());
            this.apportionmentMethod.setGlenixElementValue(aTransactionLine.getApportionmentMethodString());
        }
        this.doupdate = true;
    }

    public boolean hasApportionment() {
        String ai = this.apportionmentMethod.getGlenixElementValue();
        if (ai == null || ai.isEmpty()) {
            return false;
        }
        String fa = this.fullAmount.getGlenixElementValue();
        if (fa == null || fa.isEmpty()) {
            return false;
        }
        String a = this.amount.getGlenixElementValue();
        return a != null && !a.isEmpty();
    }
}

