/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import au.com.glenix.GlenixLabelAccountComboVertical;
import au.com.glenix.GlenixLabelProvisionComboVertical;
import au.com.glenix.GlenixStartEndDateTimeHorizontal;
import au.com.glenix.trn.Account;
import au.com.glenix.trn.ImportData;
import au.com.glenix.trn.Provision;
import au.com.glenix.trn.Transaction;
import au.com.glenix.trn.TransactionLine;
import au.com.glenix.widget.GlenixBranchController;
import au.com.glenix.widget.GlenixController;
import au.com.glenix.widget.GlenixLabelEightDecimalNumberVertical;
import au.com.glenix.widget.GlenixLabelEightDecimalPositiveNumberVertical;
import au.com.glenix.widget.GlenixLabelLabelVertical;
import au.com.glenix.widget.GlenixLabelTextAreaVertical;
import au.com.glenix.widget.GlenixLabelTwoDecimalNumberVertical;
import java.math.RoundingMode;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ResourceBundle;
import java.util.Set;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.HBox;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TransactionLineEditController
extends GlenixBranchController {
    protected DocumentBuilderFactory dbFactory;
    protected DocumentBuilder dBuilder;
    @FXML
    protected CheckBox select;
    @FXML
    protected FlowPane transactionfp;
    @FXML
    protected Label error_message;
    @FXML
    protected GlenixLabelProvisionComboVertical provision;
    @FXML
    protected GlenixLabelAccountComboVertical account;
    @FXML
    protected HBox quantityRateHBox;
    @FXML
    protected GlenixLabelEightDecimalPositiveNumberVertical transactionLineRate;
    @FXML
    protected GlenixLabelEightDecimalNumberVertical quantity;
    @FXML
    protected GlenixLabelTwoDecimalNumberVertical amount;
    @FXML
    protected GlenixLabelTwoDecimalNumberVertical provisionAmount;
    @FXML
    protected GlenixStartEndDateTimeHorizontal startEndDateTime;
    @FXML
    protected GlenixLabelTextAreaVertical lineComment;
    @FXML
    protected GlenixLabelLabelVertical invoiceComment;
    @FXML
    protected HBox amountsection;
    protected Double lastTransactionLineRate = null;
    protected TransactionLine transactionLine = null;
    protected ImportData importData = null;
    private String activityStatementNumber = null;
    private ChangeListener<TransactionLine> changeListener = null;
    private String lastFocus = "rate";
    private String secondLastFocus = "quantity";
    private boolean updateinprogress = false;
    private Double normalRate = null;
    protected boolean doupdate = true;

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        try {
            this.dbFactory = DocumentBuilderFactory.newInstance();
            this.dbFactory.setNamespaceAware(true);
            this.dBuilder = this.dbFactory.newDocumentBuilder();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.amount != null) {
            this.amount.setSingleChangeListener(new ChangeListener<String>(){

                public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                    if (TransactionLineEditController.this.doupdate) {
                        TransactionLineEditController.this.calculateRateQuantityFromAmount();
                        TransactionLineEditController.this.calculateProvisionAmount();
                        TransactionLineEditController.this.updateListener();
                    }
                }
            });
        }
        if (this.transactionLineRate != null) {
            this.transactionLineRate.setSingleChangeListener(new ChangeListener<String>(){

                public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                    if (TransactionLineEditController.this.doupdate) {
                        TransactionLineEditController.this.calculateAmountQuantityFromRate();
                    }
                }
            });
        }
        if (this.quantity != null) {
            this.quantity.setSingleChangeListener(new ChangeListener<String>(){

                public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                    if (TransactionLineEditController.this.doupdate) {
                        TransactionLineEditController.this.calculateAmountRateFromQuantity();
                        TransactionLineEditController.this.updateListener();
                    }
                }
            });
        }
        if (this.provision != null) {
            this.provision.addValueChangeListener((ChangeListener)new ChangeListener<Transaction>(){

                public void changed(ObservableValue<? extends Transaction> observable, Transaction oldValue, Transaction newValue) {
                    if (TransactionLineEditController.this.doupdate) {
                        TransactionLineEditController.this.calculateProvisionAmount();
                        TransactionLineEditController.this.updateListener();
                    }
                }
            });
        }
        if (this.provisionAmount != null) {
            this.provisionAmount.setSingleChangeListener(new ChangeListener<String>(){

                public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                    if (TransactionLineEditController.this.doupdate) {
                        TransactionLineEditController.this.updateListener();
                    }
                }
            });
        }
        if (this.account != null) {
            this.account.addValueChangeListener((ChangeListener)new ChangeListener<Transaction>(){

                public void changed(ObservableValue<? extends Transaction> observable, Transaction oldValue, Transaction newValue) {
                    if (TransactionLineEditController.this.doupdate) {
                        TransactionLineEditController.this.setDefaultProvision(newValue);
                        TransactionLineEditController.this.setRateFromAccount(newValue);
                        TransactionLineEditController.this.updateListener();
                    }
                }
            });
        }
        if (this.startEndDateTime != null) {
            this.startEndDateTime.setSingleChangeListener(new ChangeListener<Integer>(){

                public void changed(ObservableValue<? extends Integer> observable, Integer oldValue, Integer newValue) {
                    if (newValue != null && TransactionLineEditController.this.doupdate) {
                        Double hoursValue = (double)Math.round((double)newValue.intValue() * 1.0E8 / 3600.0) / 1.0E8;
                        TransactionLineEditController.this.quantity.setGlenixElementValue(hoursValue.toString());
                        TransactionLineEditController.this.updateListener();
                    }
                }
            });
        }
        if (this.startEndDateTime != null) {
            this.startEndDateTime.setManaged(true);
            this.startEndDateTime.setVisible(true);
        }
        if (this.quantityRateHBox != null) {
            this.quantityRateHBox.setManaged(true);
            this.quantityRateHBox.setVisible(true);
        }
    }

    private void updateFocusOrder() {
        if (this.amount != null && this.amount.glenixTextIsFocused() && !this.lastFocus.equals("amount")) {
            this.secondLastFocus = this.lastFocus;
            this.lastFocus = "amount";
        } else if (this.transactionLineRate != null && this.transactionLineRate.glenixTextIsFocused() && !this.lastFocus.equals("rate")) {
            this.secondLastFocus = this.lastFocus;
            this.lastFocus = "rate";
        } else if (this.quantity != null && this.quantity.glenixTextIsFocused() && !this.lastFocus.equals("quantity")) {
            this.secondLastFocus = this.lastFocus;
            this.lastFocus = "quantity";
        }
    }

    public void calculateRateQuantityFromAmount() {
        if (this.updateinprogress) {
            return;
        }
        if (this.amount == null || this.transactionLineRate == null || this.quantity == null) {
            return;
        }
        this.updateinprogress = true;
        this.updateFocusOrder();
        String amountString = this.amount.getText();
        Double amountDouble = 0.0;
        if (amountString != null) {
            try {
                amountDouble = Double.parseDouble(amountString);
            }
            catch (Exception e) {
                amountDouble = 0.0;
            }
        }
        String quantityString = this.quantity.getText();
        Double quantityDouble = 0.0;
        if (quantityString != null) {
            try {
                quantityDouble = Double.parseDouble(quantityString);
            }
            catch (Exception e) {
                quantityDouble = 0.0;
            }
        }
        Double rateDouble = this.lastTransactionLineRate;
        String rateString = this.transactionLineRate.getText();
        if (rateDouble == null) {
            rateDouble = 0.0;
            if (rateString != null) {
                try {
                    this.lastTransactionLineRate = rateDouble = Double.valueOf(Double.parseDouble(rateString));
                }
                catch (Exception e) {
                    rateDouble = 0.0;
                }
            }
        }
        DecimalFormat df = new DecimalFormat("#.########");
        df.setRoundingMode(RoundingMode.HALF_UP);
        if (this.lastFocus.equals("quantity") || this.lastFocus.equals("amount") && this.secondLastFocus.equals("quantity")) {
            if (!(quantityString == null || quantityString.equals("") || quantityDouble.equals(0) || this.transactionLineRate.glenixTextIsFocused())) {
                rateDouble = amountDouble / quantityDouble;
                rateString = df.format(rateDouble);
                this.transactionLineRate.setText(rateString);
                this.lastTransactionLineRate = rateDouble;
            } else if (!(rateString == null || rateString.isEmpty() || rateDouble.equals(0) || this.quantity.glenixTextIsFocused())) {
                quantityDouble = (double)Math.round(1.0E8 * (amountDouble / rateDouble)) / 1.0E8;
                quantityString = df.format(quantityDouble);
                this.quantity.setText(quantityString);
                rateDouble = amountDouble / quantityDouble;
                rateString = df.format(rateDouble);
                this.transactionLineRate.setText(rateString);
                this.lastFocus = "amount";
                this.secondLastFocus = "rate";
            }
        } else if (!(rateString == null || rateString.isEmpty() || rateDouble.equals(0) || this.quantity.glenixTextIsFocused())) {
            quantityDouble = (double)Math.round(1.0E8 * (amountDouble / rateDouble)) / 1.0E8;
            quantityString = df.format(quantityDouble);
            this.quantity.setText(quantityString);
            rateDouble = amountDouble / quantityDouble;
            rateString = df.format(rateDouble);
            this.transactionLineRate.setText(rateString);
        } else if (!(quantityString == null || quantityString.equals("") || quantityDouble.equals(0) || this.transactionLineRate.glenixTextIsFocused())) {
            rateDouble = amountDouble / quantityDouble;
            rateString = df.format(rateDouble);
            this.transactionLineRate.setText(rateString);
            this.lastTransactionLineRate = rateDouble;
            this.lastFocus = "amount";
            this.secondLastFocus = "quantity";
        }
        this.updateinprogress = false;
    }

    public void calculateAmountQuantityFromRate() {
        if (this.updateinprogress) {
            return;
        }
        if (this.amount == null || this.transactionLineRate == null || this.quantity == null) {
            return;
        }
        this.updateinprogress = true;
        this.updateFocusOrder();
        String amountString = this.amount.getText();
        Double amountDouble = 0.0;
        if (amountString != null) {
            try {
                amountDouble = Double.parseDouble(amountString);
            }
            catch (Exception e) {
                amountDouble = 0.0;
            }
        }
        String quantityString = this.quantity.getText();
        Double quantityDouble = 0.0;
        if (quantityString != null) {
            try {
                quantityDouble = Double.parseDouble(quantityString);
            }
            catch (Exception e) {
                quantityDouble = 0.0;
            }
        }
        String rateString = this.transactionLineRate.getText();
        Double rateDouble = 0.0;
        if (rateString != null) {
            try {
                this.lastTransactionLineRate = rateDouble = Double.valueOf(Double.parseDouble(rateString));
            }
            catch (Exception e) {
                rateDouble = 0.0;
            }
        }
        if (this.lastFocus.equals("quantity") || this.lastFocus.equals("rate") && this.secondLastFocus.equals("quantity")) {
            if (!(quantityString == null || quantityString.equals("") || quantityDouble.equals(0) || this.amount.glenixTextIsFocused())) {
                DecimalFormat df = new DecimalFormat("#.##");
                df.setRoundingMode(RoundingMode.HALF_UP);
                amountDouble = rateDouble * quantityDouble;
                amountString = df.format(amountDouble);
                this.amount.setText(amountString);
            } else if (!(amountString == null || amountString.equals("") || amountDouble.equals(0) || this.quantity.glenixTextIsFocused())) {
                DecimalFormat df = new DecimalFormat("#.########");
                df.setRoundingMode(RoundingMode.HALF_UP);
                quantityDouble = amountDouble / rateDouble;
                quantityString = df.format(quantityDouble);
                this.quantity.setText(quantityString);
                this.lastFocus = "rate";
                this.secondLastFocus = "amount";
            }
        } else if (!(amountString == null || amountString.equals("") || amountDouble.equals(0) || this.quantity.glenixTextIsFocused())) {
            DecimalFormat df = new DecimalFormat("#.########");
            df.setRoundingMode(RoundingMode.HALF_UP);
            quantityDouble = amountDouble / rateDouble;
            quantityString = df.format(quantityDouble);
            this.quantity.setText(quantityString);
        } else if (!(quantityString == null || quantityString.equals("") || quantityDouble.equals(0) || this.amount.glenixTextIsFocused())) {
            DecimalFormat df = new DecimalFormat("#.##");
            df.setRoundingMode(RoundingMode.HALF_UP);
            amountDouble = rateDouble * quantityDouble;
            amountString = df.format(amountDouble);
            this.amount.setText(amountString);
            this.lastFocus = "rate";
            this.secondLastFocus = "quantity";
        }
        this.updateinprogress = false;
    }

    public void calculateAmountRateFromQuantity() {
        if (this.updateinprogress) {
            return;
        }
        if (this.amount == null || this.transactionLineRate == null || this.quantity == null) {
            return;
        }
        this.updateinprogress = true;
        this.updateFocusOrder();
        String amountString = this.amount.getText();
        Double amountDouble = 0.0;
        if (amountString != null) {
            try {
                amountDouble = Double.parseDouble(amountString);
            }
            catch (Exception e) {
                amountDouble = 0.0;
            }
        }
        String quantityString = this.quantity.getText();
        Double quantityDouble = 0.0;
        if (quantityString != null) {
            try {
                quantityDouble = Double.parseDouble(quantityString);
            }
            catch (Exception e) {
                quantityDouble = 0.0;
            }
        }
        Double rateDouble = this.lastTransactionLineRate;
        String rateString = this.transactionLineRate.getText();
        if (rateDouble == null) {
            rateDouble = 0.0;
            if (rateString != null) {
                try {
                    this.lastTransactionLineRate = rateDouble = Double.valueOf(Double.parseDouble(rateString));
                }
                catch (Exception e) {
                    rateDouble = 0.0;
                }
            }
        }
        if (this.lastFocus.equals("rate") || this.lastFocus.equals("quantity") && this.secondLastFocus.equals("rate")) {
            if (!(rateString == null || rateString.isEmpty() || rateDouble.equals(0) || this.amount.glenixTextIsFocused())) {
                DecimalFormat df = new DecimalFormat("#.##");
                df.setRoundingMode(RoundingMode.HALF_UP);
                amountDouble = (double)Math.round(quantityDouble * rateDouble * 100.0) / 100.0;
                amountString = df.format(amountDouble);
                this.amount.setText(amountString);
                df = new DecimalFormat("#.########");
                df.setRoundingMode(RoundingMode.HALF_UP);
                rateDouble = amountDouble / quantityDouble;
                rateString = df.format(rateDouble);
                this.transactionLineRate.setText(rateString);
            } else if (!(amountString == null || amountString.equals("") || amountDouble.equals(0) || this.transactionLineRate.glenixTextIsFocused())) {
                DecimalFormat df = new DecimalFormat("#.########");
                df.setRoundingMode(RoundingMode.HALF_UP);
                rateDouble = amountDouble / quantityDouble;
                rateString = df.format(rateDouble);
                this.transactionLineRate.setText(rateString);
                this.lastTransactionLineRate = rateDouble;
                this.lastFocus = "quantity";
                this.secondLastFocus = "amount";
            }
        } else if (!(amountString == null || amountString.equals("") || amountDouble.equals(0) || this.transactionLineRate.glenixTextIsFocused())) {
            DecimalFormat df = new DecimalFormat("#.########");
            df.setRoundingMode(RoundingMode.HALF_UP);
            rateDouble = amountDouble / quantityDouble;
            rateString = df.format(rateDouble);
            this.transactionLineRate.setText(rateString);
            this.lastTransactionLineRate = rateDouble;
        } else if (!(rateString == null || rateString.isEmpty() || rateDouble.equals(0) || this.amount.glenixTextIsFocused())) {
            DecimalFormat df = new DecimalFormat("#.##");
            df.setRoundingMode(RoundingMode.HALF_UP);
            amountDouble = (double)Math.round(quantityDouble * rateDouble * 100.0) / 100.0;
            amountString = df.format(amountDouble);
            this.amount.setText(amountString);
            df = new DecimalFormat("#.########");
            df.setRoundingMode(RoundingMode.HALF_UP);
            rateDouble = amountDouble / quantityDouble;
            rateString = df.format(rateDouble);
            this.transactionLineRate.setText(rateString);
            this.lastFocus = "quantity";
            this.secondLastFocus = "rate";
        }
        this.startEndDateTimeSetQuantity(quantityDouble);
        this.updateinprogress = false;
    }

    protected void startEndDateTimeSetQuantity(Double quantityDouble) {
        this.startEndDateTime.setQuantity(quantityDouble);
    }

    public void calculateProvisionAmount() {
        if (this.provisionAmount == null) {
            return;
        }
        if (this.amount == null) {
            return;
        }
        Transaction transactionProvision = this.provision.getSelectedProvisionTransaction();
        if (transactionProvision == null) {
            return;
        }
        String percentageString = transactionProvision.getProvisionPercentage();
        Double percentageDouble = 0.0;
        if (percentageString != null) {
            try {
                percentageDouble = Double.parseDouble(percentageString);
            }
            catch (Exception e) {
                percentageDouble = 0.0;
            }
        }
        String amountString = this.amount.getText();
        Double amountDouble = 0.0;
        if (amountString != null) {
            try {
                amountDouble = Double.parseDouble(amountString);
            }
            catch (Exception e) {
                amountDouble = 0.0;
            }
        }
        DecimalFormat df = new DecimalFormat("#.##");
        df.setRoundingMode(RoundingMode.HALF_UP);
        Double provisionAmountDouble = amountDouble * percentageDouble / 100.0;
        String provisionAmountString = df.format(provisionAmountDouble);
        this.provisionAmount.setText(provisionAmountString);
    }

    public void setDefaultProvision(Transaction accountTransaction) {
        if (accountTransaction == null) {
            return;
        }
        String provisionIdentifierString = accountTransaction.getAccountDefaultProvisionIdentifier();
        if (provisionIdentifierString == null) {
            return;
        }
        this.provision.setComboId(provisionIdentifierString);
    }

    public void setNormalRate(Double normalRate, boolean doThisUpdate) {
        this.normalRate = normalRate;
        if (this.doupdate && doThisUpdate) {
            Transaction t = this.account.getSelectedAccountTransaction();
            this.setRateFromAccount(t);
        }
    }

    public void setRateFromAccount(Transaction accountTransaction) {
        if (!this.doupdate || accountTransaction == null) {
            return;
        }
        String rateString = accountTransaction.getAccountRate();
        Double rate = null;
        Double multiplier = null;
        try {
            String multiplierString;
            if (rateString != null && !rateString.isEmpty()) {
                rate = Double.parseDouble(rateString);
            } else if (this.normalRate != null && (multiplierString = accountTransaction.getAccountNormalRateMultiplier()) != null && !multiplierString.isEmpty()) {
                multiplier = Double.parseDouble(multiplierString);
                rate = this.normalRate * multiplier;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (rate != null) {
            this.transactionLineRate.setGlenixElementValue(rate.toString());
            this.lastTransactionLineRate = null;
        }
    }

    public void setProvisionTransactionList(ObservableList<Transaction> provisionObservableList) {
        this.provision.setItems(provisionObservableList);
    }

    public void setAccountTransactionList(ObservableList<Transaction> accountObservableList) {
        this.account.setItems(accountObservableList);
    }

    public Double getAmount() {
        if (this.amount == null) {
            return null;
        }
        String amountString = this.amount.getGlenixElementValue();
        if (amountString != null) {
            try {
                return Double.parseDouble(amountString);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public Double getQuantity() {
        if (this.quantity == null) {
            return null;
        }
        String quantityString = this.quantity.getGlenixElementValue();
        if (quantityString != null) {
            try {
                return Double.parseDouble(quantityString);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public void setQuantity(Double value) throws Exception {
        if (this.quantity == null) {
            throw new Exception("Error, no quantity box to set value");
        }
        value = (double)Math.round(value * 1.0E8) / 1.0E8;
        this.quantity.setGlenixElementValue(value.toString());
    }

    public Double getProvisionAmount() {
        if (this.provisionAmount == null) {
            return null;
        }
        String provisionAmountString = this.provisionAmount.getGlenixElementValue();
        if (provisionAmountString != null) {
            try {
                return Double.parseDouble(provisionAmountString);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public Transaction getProvisionTransaction() {
        if (this.provision == null) {
            return null;
        }
        return this.provision.getSelectedProvisionTransaction();
    }

    public Transaction getAccountTransaction() {
        if (this.account == null) {
            return null;
        }
        return this.account.getSelectedAccountTransaction();
    }

    public String getAccountIdentifier() {
        Transaction at = this.getAccountTransaction();
        if (at == null) {
            return null;
        }
        return at.getAccountIdentifier();
    }

    public void setAccountIdentifier(String value) throws Exception {
        if (this.account == null) {
            throw new Exception("Error, cannot set account identifier, no account box");
        }
        this.account.setGlenixElementValue(value);
    }

    @Override
    public GlenixController getGlenixControllerByNameNS(String namespace, String name) {
        if (name != null) {
            if (name.equals("startDateTime")) {
                return super.getGlenixControllerByNameNS(namespace, "startEndDateTime");
            }
            if (name.equals("endDateTime")) {
                return super.getGlenixControllerByNameNS(namespace, "startEndDateTime");
            }
            if (name.equals("breakTime")) {
                return super.getGlenixControllerByNameNS(namespace, "startEndDateTime");
            }
        }
        return super.getGlenixControllerByNameNS(namespace, name);
    }

    public void setActivityStatementNumber(String asNumber) throws Exception {
        if (this.transactionLine == null) {
            this.transactionLine = new TransactionLine();
        }
        this.transactionLine.setActivityStatementNumber(asNumber);
    }

    public String getActivityStatementNumber() {
        if (this.transactionLine == null) {
            return null;
        }
        return this.transactionLine.getActivityStatementNumber();
    }

    public void setImportData(ImportData importData) throws Exception {
        if (importData == null) {
            if (this.transactionLine == null) {
                return;
            }
            this.transactionLine.setImportData((Document)null);
            return;
        }
        if (this.transactionLine == null) {
            this.transactionLine = new TransactionLine();
        }
        this.transactionLine.setImportData(importData.buildDocument());
    }

    public void setTransactionLine(TransactionLine aTransactionLine) {
        boolean changeback = false;
        if (this.doupdate) {
            this.doupdate = false;
            changeback = true;
        }
        this.transactionLine = aTransactionLine;
        if (aTransactionLine == null) {
            this.amount.setGlenixElementValue(null);
            if (this.account != null) {
                this.account.setGlenixElementValue(null);
            }
            if (this.provision != null) {
                this.provision.setGlenixElementValue(null);
            }
            if (this.provisionAmount != null) {
                this.provisionAmount.setGlenixElementValue(null);
            }
            if (this.quantity != null) {
                this.quantity.setGlenixElementValue(null);
            }
            this.transactionLineRate.setGlenixElementValue(null);
            this.lastTransactionLineRate = null;
            if (this.lineComment != null) {
                this.lineComment.setGlenixElementValue(null);
            }
            if (this.invoiceComment != null) {
                this.invoiceComment.setGlenixElementValue(null);
            }
        } else {
            this.amount.setGlenixElementValue(aTransactionLine.getAmountString());
            if (this.account != null) {
                Account a = aTransactionLine.getAccount();
                if (a == null) {
                    this.account.setGlenixElementValue(null);
                } else {
                    this.account.setGlenixElementValue(a.getAccountIdentifier());
                }
            }
            if (this.provision != null) {
                Provision p = aTransactionLine.getProvision();
                if (p == null) {
                    this.provision.setGlenixElementValue(null);
                } else {
                    this.provision.setGlenixElementValue(p.getProvisionIdentifier());
                }
            }
            if (this.provisionAmount != null) {
                this.provisionAmount.setGlenixElementValue(aTransactionLine.getProvisionAmountString());
            }
            if (this.quantity != null) {
                this.quantity.setGlenixElementValue(aTransactionLine.getQuantityString());
            }
            this.calculateRateQuantityFromAmount();
            if (this.lineComment != null) {
                this.lineComment.setGlenixElementValue(aTransactionLine.getLineCommentString());
            }
            if (this.invoiceComment != null) {
                String firstpart = aTransactionLine.getInvoiceCommentString();
                if (firstpart != null && !firstpart.isEmpty() && firstpart.length() > 100) {
                    firstpart = firstpart.substring(0, 97) + "...";
                }
                this.invoiceComment.setGlenixElementValue(firstpart);
            }
        }
        if (changeback) {
            this.doupdate = true;
        }
    }

    protected void updateListener() {
        if (this.changeListener != null) {
            ReadOnlyObjectWrapper observableValue = new ReadOnlyObjectWrapper((Object)this.transactionLine);
            this.changeListener.changed((ObservableValue)observableValue, null, (Object)this.transactionLine);
        }
    }

    public void setSingleChangeListener(ChangeListener<TransactionLine> changeListener) {
        this.changeListener = changeListener;
    }

    public boolean getSelectValue() {
        if (this.select == null) {
            return false;
        }
        return this.select.isSelected();
    }

    @Override
    public void clearGlenixXBRL() {
        super.clearGlenixXBRL();
        this.activityStatementNumber = null;
        this.importData = null;
    }

    @Override
    public void loadGlenixXBRL(Document loadDoc, Element loadElement) throws Exception {
        throw new Exception("Error, doc load into transaction line not supported use setTransactionLine");
    }

    @Override
    public void buildGlenixXBRL(Document resultDoc, Element resultElement) throws Exception {
        if (this.transactionLine != null) {
            Document doc = this.dBuilder.newDocument();
            super.buildGlenixXBRL(doc, null);
            this.transactionLine.loadDocumentElement(doc, doc.getDocumentElement());
            this.transactionLine.appendToElement(resultDoc, resultElement);
            return;
        }
        super.buildGlenixXBRL(resultDoc, resultElement);
    }

    public boolean basChanged(Set lodgedActivityStatements) {
        if (this.transactionLine == null) {
            return false;
        }
        String asNumber = this.transactionLine.getActivityStatementNumber();
        if (asNumber == null || asNumber.isEmpty() || !lodgedActivityStatements.contains(asNumber)) {
            return false;
        }
        String provisionIdentifier = this.provision.getGlenixElementValue();
        String trProvisionIdentifier = this.transactionLine.getProvisionIdentifier();
        if (provisionIdentifier != null && trProvisionIdentifier != null && !trProvisionIdentifier.equals(provisionIdentifier)) {
            return true;
        }
        if (provisionIdentifier == null && trProvisionIdentifier != null || provisionIdentifier != null && trProvisionIdentifier == null) {
            return true;
        }
        if (this.amount != null) {
            Double amountD = this.amount.getDouble();
            Double trAmount = this.transactionLine.getAmountAsDouble();
            if (amountD != null && trAmount != null && !trAmount.equals(amountD)) {
                return true;
            }
            if (amountD == null && trAmount != null || amountD != null && trAmount == null) {
                return true;
            }
        }
        if (this.provisionAmount != null) {
            Double taxAmount = this.provisionAmount.getDouble();
            Double trTaxAmount = this.transactionLine.getProvisionAmountAsDouble();
            if (taxAmount != null && trTaxAmount != null && !trTaxAmount.equals(taxAmount)) {
                return true;
            }
            if (taxAmount == null && trTaxAmount != null || taxAmount != null && trTaxAmount == null) {
                return true;
            }
        }
        return false;
    }

    public boolean validateAccount() {
        String ai = this.account.getGlenixElementValue();
        return ai != null && !ai.isEmpty();
    }

    public String getReconciliationNumber() {
        if (this.transactionLine == null) {
            return null;
        }
        return this.transactionLine.getReconciliationNumber();
    }

    public void clearReconciliationNumber() throws Exception {
        if (this.transactionLine == null) {
            return;
        }
        this.transactionLine.setReconciliationNumber(null);
    }

    public void clearProvisionReconciliationNumber() throws Exception {
        if (this.transactionLine == null) {
            return;
        }
        this.transactionLine.setProvisionReconciliationNumber(null);
    }
}

