/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import au.com.glenix.GlenixLabelCounterpartyComboVertical;
import au.com.glenix.GlenixLabelTransactionTypeCombo;
import au.com.glenix.TransactionLineEditVBox;
import au.com.glenix.trn.Transaction;
import au.com.glenix.trn.TransactionLine;
import au.com.glenix.widget.GlenixBranchController;
import au.com.glenix.widget.GlenixLabelDateVertical;
import au.com.glenix.widget.GlenixLabelTextAreaVertical;
import java.math.RoundingMode;
import java.net.URL;
import java.text.DecimalFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.VBox;
import javafx.util.Pair;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TransactionEditFormController
extends GlenixBranchController {
    protected DocumentBuilder dBuilder;
    @FXML
    protected GlenixLabelCounterpartyComboVertical counterpartyComboBox;
    @FXML
    protected GlenixLabelDateVertical transactionDate;
    @FXML
    protected GlenixLabelTextAreaVertical transactionComment;
    @FXML
    protected VBox transactionlinevboxes;
    protected Transaction transaction = null;
    protected Transaction batchTransaction = null;
    protected ObservableList<Transaction> provisionObservableList;
    protected ObservableList<Transaction> accountObservableList;
    protected String defaultTransactionType = null;
    @FXML
    protected Label totalamountlabel;
    @FXML
    protected GlenixLabelTransactionTypeCombo transactionTypeCombo;
    protected Double totalAmount = 0.0;
    protected Double totalProvisionAmount = 0.0;
    protected Double totalQuantity = 0.0;
    protected DecimalFormat amountFormat = new DecimalFormat("$#,##0.00");
    protected DecimalFormat quantityFormat;

    public TransactionEditFormController() {
        this.amountFormat.setRoundingMode(RoundingMode.HALF_UP);
        this.quantityFormat = new DecimalFormat("#,##0.######");
        this.quantityFormat.setRoundingMode(RoundingMode.HALF_UP);
    }

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setNamespaceAware(true);
            this.dBuilder = dbFactory.newDocumentBuilder();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.transactionDate.setOnKeyPressed(ke -> {
            if (ke.getCode().equals((Object)KeyCode.CONTROL) && !this.transactionDate.isShowing()) {
                this.transactionDate.show();
            }
        });
    }

    public void setTransactionTypeVisibleOptions(ArrayList<Pair<String, String>> options, boolean visible, String defaultValue) {
        String currentValue;
        this.transactionTypeCombo.setVisible(visible);
        this.transactionTypeCombo.setManaged(visible);
        if (options != null) {
            this.transactionTypeCombo.setItems(options);
        }
        if (defaultValue != null && !defaultValue.isEmpty() && ((currentValue = this.transactionTypeCombo.getGlenixElementValue()) == null || currentValue.isEmpty())) {
            this.transactionTypeCombo.setGlenixElementValue(defaultValue);
            this.defaultTransactionType = defaultValue;
        }
    }

    public void setCounterpartyTransactionList(ObservableList<Transaction> counterpartyObservableList) {
        this.counterpartyComboBox.setItems(counterpartyObservableList);
    }

    public void addCounterpartyComboChangeListener(ChangeListener<Transaction> changeListener) {
        this.counterpartyComboBox.addValueChangeListener(changeListener);
    }

    public void setProvisionList(ObservableList<Transaction> provisionObservableList) {
        this.provisionObservableList = provisionObservableList;
    }

    public void setAccountList(ObservableList<Transaction> accountObservableList) {
        this.accountObservableList = accountObservableList;
    }

    public TransactionLineEditVBox addTransactionLine(TransactionLine transactionLine) throws Exception {
        TransactionLineEditVBox tlv = new TransactionLineEditVBox();
        this.transactionlinevboxes.getChildren().add((Object)tlv);
        tlv.setAccountTransactionList(this.accountObservableList);
        tlv.setProvisionTransactionList(this.provisionObservableList);
        if (transactionLine != null) {
            tlv.setTransactionLine(transactionLine);
        }
        tlv.setSingleChangeListener(new ChangeListener<TransactionLine>(){

            public void changed(ObservableValue<? extends TransactionLine> observable, TransactionLine oldValue, TransactionLine newValue) {
                TransactionEditFormController.this.calculateTotals();
            }
        });
        return tlv;
    }

    public void deleteSelectedTransactionLines(Set lodgedActivityStatements) throws Exception {
        boolean changed = false;
        ArrayList<Node> removeList = new ArrayList<Node>();
        ObservableList oln = this.transactionlinevboxes.getChildren();
        for (Node n : oln) {
            TransactionLineEditVBox el;
            if (!(n instanceof TransactionLineEditVBox) || !(el = (TransactionLineEditVBox)n).getSelectValue()) continue;
            String asNumber = el.getActivityStatementNumber();
            if (asNumber != null && !asNumber.isEmpty() && lodgedActivityStatements.contains(asNumber)) {
                throw new Exception("Error, cannot delete a transaction line as it is on a lodged activity statement");
            }
            removeList.add(n);
            changed = true;
        }
        if (changed) {
            this.transactionlinevboxes.getChildren().removeAll(removeList);
            this.calculateTotals();
        }
    }

    public void setTransactionElement(Transaction transaction) throws Exception {
        this.setTransactionElement(transaction, true);
    }

    public void setTransactionElement(Transaction transaction, boolean blanklineifnull) throws Exception {
        this.clearTransaction();
        this.transaction = transaction;
        if (transaction == null) {
            this.transactionlinevboxes.getChildren().clear();
            if (blanklineifnull) {
                this.addTransactionLine(null);
            }
            if (this.defaultTransactionType != null && !this.defaultTransactionType.isEmpty()) {
                this.transactionTypeCombo.setGlenixElementValue(this.defaultTransactionType);
            }
        } else {
            String tt = transaction.getTransactionType();
            if ((tt == null || tt.isEmpty()) && this.defaultTransactionType != null && !this.defaultTransactionType.isEmpty()) {
                this.transactionTypeCombo.setGlenixElementValue(this.defaultTransactionType);
            } else {
                this.transactionTypeCombo.setGlenixElementValue(tt);
            }
            this.transactionDate.setGlenixElementValue(transaction.getTransactionDate());
            this.transactionComment.setGlenixElementValue(transaction.getTransactionComment());
            this.counterpartyComboBox.setGlenixElementValue(transaction.getCounterpartyIdentifier());
            this.transactionlinevboxes.getChildren().clear();
            int count = transaction.getTransactionLineCount();
            for (int i = 0; i < count; ++i) {
                TransactionLine tl = transaction.getTransactionLine(i);
                this.addTransactionLine(tl);
            }
        }
        this.calculateTotals();
        this.updateTotalLabel();
    }

    public void setTransactionElementPostBatch(Transaction transaction) {
    }

    public void setActivityStatementNumber(String asNumber) throws Exception {
        for (Node n : this.transactionlinevboxes.getChildren()) {
            if (!(n instanceof TransactionLineEditVBox)) continue;
            ((TransactionLineEditVBox)n).setActivityStatementNumber(asNumber);
        }
    }

    public void setBatchTransactionElement(Transaction batchTransaction) {
        this.batchTransaction = batchTransaction;
    }

    public void buildGlenixXBRLTransactionPart(Document resultDoc, Element element) throws Exception {
        super.buildGlenixXBRL(resultDoc, element);
    }

    protected void clearTransaction() {
        this.clearGlenixXBRL();
    }

    public void setTransactionType(String transactionType) {
        this.transactionTypeCombo.setGlenixElementValue(transactionType);
    }

    public void setTransactionLocalDate(LocalDate localDate) {
        this.transactionDate.setLocalDate(localDate);
    }

    public LocalDate getTransactionLocalDate() {
        return this.transactionDate.getLocalDate();
    }

    public String getTransactionDateString() {
        return this.transactionDate.getGlenixElementValue();
    }

    public String getTransactionType() {
        return this.transactionTypeCombo.getGlenixElementValue();
    }

    public String getTransactionBatchIdentifier() {
        if (this.batchTransaction == null) {
            return null;
        }
        return this.batchTransaction.getBatchIdentifier();
    }

    public String getCounterpartyIdentifier() {
        return this.counterpartyComboBox.getGlenixElementValue();
    }

    public void requestFocus() {
        this.transactionDate.requestFocus();
    }

    protected Double addDouble(Double d1, Double d2) {
        if (d2 == null) {
            return d1;
        }
        if (d1 == null) {
            return d2;
        }
        return d1 + d2;
    }

    public void updateTotalLabel() {
        this.totalamountlabel.setText("Total amount = " + this.amountFormat.format(this.totalAmount) + " (tax amount = " + this.amountFormat.format(this.totalProvisionAmount) + ", total quantity = " + this.quantityFormat.format(this.totalQuantity) + ")");
    }

    public void calculateTotals() {
        this.totalAmount = 0.0;
        this.totalQuantity = 0.0;
        this.totalProvisionAmount = 0.0;
        for (Node n : this.transactionlinevboxes.getChildren()) {
            if (!(n instanceof TransactionLineEditVBox)) continue;
            TransactionLineEditVBox tlv = (TransactionLineEditVBox)n;
            this.totalAmount = this.addDouble(this.totalAmount, tlv.getAmount());
            this.totalProvisionAmount = this.addDouble(this.totalProvisionAmount, tlv.getProvisionAmount());
            this.totalQuantity = this.addDouble(this.totalQuantity, tlv.getQuantity());
        }
        this.updateTotalLabel();
    }

    public Double getTotalAmount() {
        return this.totalAmount;
    }

    public boolean basChanged(Set lodgedActivityStatements) {
        for (Node n : this.transactionlinevboxes.getChildren()) {
            if (!(n instanceof TransactionLineEditVBox) || !((TransactionLineEditVBox)n).basChanged(lodgedActivityStatements)) continue;
            return true;
        }
        return false;
    }

    public boolean allLinesHaveAccount() {
        for (Node n : this.transactionlinevboxes.getChildren()) {
            if (!(n instanceof TransactionLineEditVBox) || ((TransactionLineEditVBox)n).hasAccount()) continue;
            return false;
        }
        return true;
    }

    public Set<String> getReconciliationNumberSet() {
        HashSet<String> result = new HashSet<String>();
        for (Node n : this.transactionlinevboxes.getChildren()) {
            String rn;
            if (!(n instanceof TransactionLineEditVBox) || (rn = ((TransactionLineEditVBox)n).getReconciliationNumber()) == null || rn.isEmpty()) continue;
            result.add(rn);
        }
        return result;
    }

    public void clearReconciliationNumbers() throws Exception {
        for (Node n : this.transactionlinevboxes.getChildren()) {
            if (!(n instanceof TransactionLineEditVBox)) continue;
            ((TransactionLineEditVBox)n).clearReconciliationNumber();
        }
    }

    public void clearProvisionReconciliationNumbers() throws Exception {
        for (Node n : this.transactionlinevboxes.getChildren()) {
            if (!(n instanceof TransactionLineEditVBox)) continue;
            ((TransactionLineEditVBox)n).clearProvisionReconciliationNumber();
        }
    }

    public void clearAllReconciliationNumbers() throws Exception {
        for (Node n : this.transactionlinevboxes.getChildren()) {
            if (!(n instanceof TransactionLineEditVBox)) continue;
            ((TransactionLineEditVBox)n).clearReconciliationNumber();
            ((TransactionLineEditVBox)n).clearProvisionReconciliationNumber();
        }
        if (this.transaction != null) {
            this.transaction.setTransactionReconciliationNumber(null);
        }
    }

    public void clearTransactionReconciliationNumber() throws Exception {
        this.transaction.setTransactionReconciliationNumber(null);
    }
}

