/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import au.com.glenix.ApplicationController;
import au.com.glenix.GlenixLabelCounterpartyComboVertical;
import au.com.glenix.TransactionEditFormVBox;
import au.com.glenix.trn.ActivityStatement;
import au.com.glenix.trn.Batch;
import au.com.glenix.trn.GlenixTrnXBRL;
import au.com.glenix.trn.OutgoingMailServer;
import au.com.glenix.trn.Profile;
import au.com.glenix.trn.Transaction;
import au.com.glenix.trn.TransactionLine;
import au.com.glenix.widget.GlenixBranchController;
import java.io.File;
import java.net.URL;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.HashSet;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.UUID;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TransactionEditController
extends GlenixBranchController {
    protected DocumentBuilder dBuilder;
    @FXML
    protected Label page_heading;
    @FXML
    protected Label error_message;
    @FXML
    protected TransactionEditFormVBox transactionEditFormVBox;
    protected Transaction transaction = null;
    protected Transaction batchTransaction = null;
    protected ApplicationController xbrlFileController;
    protected String pattern = "dd MMM yyyy";
    protected DateTimeFormatter displayDateFormatter;
    protected GlenixLabelCounterpartyComboVertical counterpartyComboBox;

    public TransactionEditController(ApplicationController xbrlFileController) {
        this.xbrlFileController = xbrlFileController;
        this.displayDateFormatter = DateTimeFormatter.ofPattern(this.pattern);
    }

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setNamespaceAware(true);
            this.dBuilder = dbFactory.newDocumentBuilder();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
        }
    }

    public void setCounterpartyTransactionList(ObservableList<Transaction> counterpartyObservableList) {
        this.transactionEditFormVBox.setCounterpartyTransactionList(counterpartyObservableList);
    }

    public void setProvisionList(ObservableList<Transaction> provisionObservableList) {
        this.transactionEditFormVBox.setProvisionList(provisionObservableList);
    }

    public void setAccountList(ObservableList<Transaction> accountObservableList) {
        this.transactionEditFormVBox.setAccountList(accountObservableList);
    }

    @Override
    public void buildGlenixXBRL(Document resultDoc, Element resultElement) throws Exception {
        Element xbrlEl = resultDoc.createElementNS("http://www.glenix.com.au/", "gx:glenix");
        if (resultElement == null) {
            resultDoc.appendChild(xbrlEl);
        } else {
            resultElement.appendChild(xbrlEl);
        }
        Element businessEl = resultDoc.createElementNS("http://www.glenix.com.au/", "gx:business");
        xbrlEl.appendChild(businessEl);
        super.buildGlenixXBRL(resultDoc, businessEl);
    }

    @Override
    public void loadGlenixXBRL(Document loadDoc, Element loadElement) throws Exception {
        if (loadElement.getNamespaceURI() != null && loadElement.getNamespaceURI().equals("http://www.glenix.com.au/") && loadElement.getLocalName() != null && loadElement.getLocalName().equals("glenix")) {
            NodeList nodeList = loadElement.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                Element businessElement = (Element)node;
                super.loadGlenixXBRL(loadDoc, businessElement);
            }
        }
    }

    public void setTransactionElement(Transaction transaction) {
        try {
            this.transaction = transaction;
            this.transactionEditFormVBox.setTransactionElement(transaction);
            this.error_message.setText("Existing transaction");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    public void setTransactionElementPostBatch(Transaction transaction) {
    }

    public void setBatchTransactionElement(Transaction batchTransaction) {
        this.transactionEditFormVBox.setBatchTransactionElement(batchTransaction);
        this.batchTransaction = batchTransaction;
        if (batchTransaction == null) {
            this.page_heading.setText("Transaction edit");
        } else {
            LocalDate ld;
            String batchComment = batchTransaction.getBatchComment();
            if (batchComment == null || batchComment.isEmpty()) {
                batchComment = "batch";
            }
            if ((ld = batchTransaction.getBatchPaymentDateAsDate()) != null) {
                this.page_heading.setText("Transaction edit - " + batchComment + " (payment on " + ld.format(this.displayDateFormatter) + ")");
            } else {
                this.page_heading.setText("Transaction edit - " + batchComment);
            }
        }
    }

    @FXML
    protected void addTransactionLine() {
        try {
            this.transactionEditFormVBox.addTransactionLine(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    public void copyToNewTransaction() {
        try {
            this.transaction = null;
            this.transactionEditFormVBox.setActivityStatmentNumber(null);
            this.transactionEditFormVBox.requestFocus();
            this.error_message.setText("New transaction");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    public void setTransactionDefaults() throws Exception {
        if (this.transaction == null) {
            return;
        }
        String tt = this.transaction.getTransactionType();
        if (tt == null) {
            this.transaction.setTransactionType("cash_payment");
        }
        if (this.batchTransaction == null) {
            this.transaction.removeBatch();
        } else {
            String batchIdentifier = this.batchTransaction.getBatchIdentifier();
            if (batchIdentifier != null && !batchIdentifier.isEmpty()) {
                this.transaction.setBatchIdentifier(batchIdentifier);
            } else {
                this.transaction.removeBatch();
            }
        }
    }

    private boolean lodgedActivityStatementIsChanged(boolean statusChange) {
        if (this.transaction == null) {
            return false;
        }
        HashSet<String> ass = new HashSet<String>();
        for (int i = 0; i < this.transaction.getTransactionLineCount(); ++i) {
            String status;
            ActivityStatement as;
            TransactionLine tl = this.transaction.getTransactionLine(i);
            String asNumber = tl.getActivityStatementNumber();
            if (asNumber == null || asNumber.isEmpty()) continue;
            GlenixTrnXBRL asTrn = null;
            try {
                asTrn = this.xbrlFileController.loadActivityStatement(asNumber);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (asTrn == null || (as = asTrn.getActivityStatement()) == null || (status = as.getSBRDocumentStatus()) == null || status.equals("created") || status.equals("list_complete") || status.equals("list_in_progress") || status.equals("prefill_complete") || status.equals("prefill_in_progress") || status.equals("prelodge_complete") || status.equals("prelodge_in_progress")) continue;
            if (statusChange) {
                return true;
            }
            ass.add(asNumber);
        }
        return this.transactionEditFormVBox.basChanged(ass);
    }

    private boolean transactionBatchIsLocked() {
        String bi;
        Transaction bt;
        Batch b;
        String trBi = null;
        if (this.transaction != null && (b = this.transaction.getBatch()) != null && (trBi = b.getBatchIdentifier()) != null && !trBi.isEmpty()) {
            String status;
            bt = null;
            try {
                bt = this.xbrlFileController.getBatchTransaction(trBi);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (bt != null && (status = bt.getBatchStatus()) != null && !status.equals("created")) {
                return true;
            }
        }
        if (this.transactionEditFormVBox != null && (bi = this.transactionEditFormVBox.getTransactionBatchIdentifier()) != null && !bi.isEmpty() && !bi.equals(trBi)) {
            bt = null;
            try {
                bt = this.xbrlFileController.getBatchTransaction(bi);
            }
            catch (Exception status) {
                // empty catch block
            }
            if (bt != null && (status = bt.getBatchStatus()) != null && !status.equals("created")) {
                return true;
            }
        }
        return false;
    }

    protected void saveTransaction() throws Exception {
        if (this.transactionEditFormVBox != null) {
            Document resultDoc = this.dBuilder.newDocument();
            this.transactionEditFormVBox.buildGlenixXBRLTransactionPart(resultDoc, null);
            this.transaction.loadDocumentElementOverwrite(resultDoc, resultDoc.getDocumentElement());
        }
        this.setTransactionDefaults();
        this.xbrlFileController.saveTransaction(this.transaction);
    }

    @FXML
    private void postTransaction() {
        try {
            String status;
            boolean statusChange = false;
            if (!(this.transaction == null || (status = this.transaction.getTransactionStatus()) != null && status.equals("posted"))) {
                statusChange = true;
            }
            if (this.lodgedActivityStatementIsChanged(statusChange)) {
                this.transactionEditFormVBox.setTransactionElement(this.transaction);
                this.error_message.setText("Error, one of the modified lines is on a lodged Activity Statment.");
                this.xbrlFileController.setStatusBarMessage("Error, one of the modified lines is on a lodged Activity Statment.");
                return;
            }
            if (this.transactionBatchIsLocked()) {
                this.transactionEditFormVBox.setTransactionElement(this.transaction);
                this.error_message.setText("Error, you cannot modify the transaction as it is on an authorised or lodged Batch.");
                this.xbrlFileController.setStatusBarMessage("Error, you cannot modify the transaction as it is on an authorised or lodged Batch.");
                return;
            }
            if (this.transaction == null) {
                this.transaction = this.xbrlFileController.addTransaction();
            }
            if (this.transaction == null) {
                throw new Exception("Error, transaction is null");
            }
            this.transaction.setTransactionStatus("posted");
            if (this.batchTransaction == null) {
                this.transaction.removeBatch();
            } else {
                String batchIdentifier = this.batchTransaction.getBatchIdentifier();
                if (batchIdentifier != null && !batchIdentifier.isEmpty()) {
                    this.transaction.setBatchIdentifier(batchIdentifier);
                } else {
                    this.transaction.removeBatch();
                }
            }
            this.saveTransaction();
            this.error_message.setText("Saved");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    public void clearTransaction() {
        this.clearGlenixXBRL();
        this.setTransactionElement(null);
        this.error_message.setText("New transaction");
    }

    @FXML
    private void gotoTransactionList() {
        if (this.batchTransaction != null) {
            this.xbrlFileController.gotoBatchTransactions(this.batchTransaction);
            return;
        }
        this.xbrlFileController.gotoTransactions();
    }

    public void setTransactionLocalDate(LocalDate localDate) {
        this.transactionEditFormVBox.setTransactionLocalDate(localDate);
    }

    @FXML
    public void cancelTransaction() {
        try {
            String status;
            boolean statusChange = false;
            if (this.transaction != null && !(status = this.transaction.getTransactionStatus()).equals("cancelled")) {
                statusChange = true;
            }
            if (this.lodgedActivityStatementIsChanged(statusChange)) {
                this.transactionEditFormVBox.setTransactionElement(this.transaction);
                this.error_message.setText("Error, one of the modified lines is on a lodged Activity Statment.");
                this.xbrlFileController.setStatusBarMessage("Error, one of the modified lines is on a lodged Activity Statment.");
                return;
            }
            if (this.transactionBatchIsLocked()) {
                this.transactionEditFormVBox.setTransactionElement(this.transaction);
                this.error_message.setText("Error, you cannot modify the transaction as it is on an authorised or lodged Batch.");
                this.xbrlFileController.setStatusBarMessage("Error, you cannot modify the transaction as it is on an authorised or lodged Batch.");
                return;
            }
            if (this.transaction == null) {
                throw new Exception("Error, transaction is null, no transaction to cancel");
            }
            this.transaction.setTransactionStatus("cancelled");
            this.saveTransaction();
            this.error_message.setText("Cancelled");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    protected void deleteSelectedTransactionLines() {
        block8: {
            try {
                if (this.transaction != null) {
                    HashSet<String> ass = new HashSet<String>();
                    for (int i = 0; i < this.transaction.getTransactionLineCount(); ++i) {
                        String status;
                        ActivityStatement as;
                        TransactionLine tl = this.transaction.getTransactionLine(i);
                        String asNumber = tl.getActivityStatementNumber();
                        if (asNumber == null || asNumber.isEmpty()) continue;
                        GlenixTrnXBRL asTrn = null;
                        try {
                            asTrn = this.xbrlFileController.loadActivityStatement(asNumber);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (asTrn == null || (as = asTrn.getActivityStatement()) == null || (status = as.getSBRDocumentStatus()) == null || status.equals("created") || status.equals("list_complete") || status.equals("list_in_progress") || status.equals("prefill_complete") || status.equals("prefill_in_progress") || status.equals("prelodge_complete") || status.equals("prelodge_in_progress")) continue;
                        ass.add(asNumber);
                    }
                    if (ass.size() == 0) {
                        this.transactionEditFormVBox.deleteSelectedTransactionLines(null);
                    } else {
                        this.transactionEditFormVBox.deleteSelectedTransactionLines(ass);
                    }
                    break block8;
                }
                this.transactionEditFormVBox.deleteSelectedTransactionLines(null);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.error_message.setText(e.getMessage());
                this.xbrlFileController.setStatusBarMessage(e.getMessage());
            }
        }
    }

    protected String getPDFDocName() {
        String docname = "Document";
        String tt = this.transaction.getTransactionType();
        if (tt != null && !tt.isEmpty()) {
            if (tt.equals("pay_slip")) {
                docname = "Pay_slip";
            } else if (tt.equals("sales_invoice")) {
                docname = "Tax_invoice";
            } else if (tt.equals("sales_credit")) {
                docname = "Adjustment_note";
            } else if (tt.equals("sales_quote")) {
                docname = "Quote";
            } else if (tt.equals("purchase_invoice")) {
                docname = "Purchase_order";
            } else if (tt.equals("purchase_credit")) {
                docname = "Purchase_credit_note";
            } else if (tt.equals("purchase_quote")) {
                docname = "Purchase_order";
            } else if (tt.equals("cash_received")) {
                docname = "Cash_receipt";
            } else if (tt.equals("cash_payment")) {
                docname = "Remittance_advice";
            }
        }
        return docname;
    }

    protected File buildTempPDFFile() throws Exception {
        String tmpdir = System.getProperty("java.io.tmpdir");
        UUID uuid = UUID.randomUUID();
        String randomUUIDString = uuid.toString();
        String docname = this.getPDFDocName();
        File file = tmpdir != null && !tmpdir.isEmpty() ? new File(tmpdir + "/" + docname + "_" + randomUUIDString + ".pdf") : new File(docname + "_" + randomUUIDString + ".pdf");
        this.xbrlFileController.buildPDFSalesInvoice(file, this.transaction);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendEmail(String to, String from, String subject, String message_html) {
        File file = null;
        try {
            if (this.transaction == null) {
                throw new Exception("Error, the transaction is not yet saved.");
            }
            Profile p = this.xbrlFileController.getOutgoingMailServer();
            if (p == null) {
                throw new Exception("Error, outgoing mail server is not set up");
            }
            OutgoingMailServer outgoingMailServer = p.getOutgoingMailServer();
            if (outgoingMailServer == null) {
                throw new Exception("Error, outgoing mail server is not set up");
            }
            String host = outgoingMailServer.getOutgoingMailServerName();
            if (host == null || host.isEmpty()) {
                throw new Exception("Error, outgoing mail server host is not set up");
            }
            String port = outgoingMailServer.getOutgoingMailServerPort();
            if (port == null || port.isEmpty()) {
                throw new Exception("Error, outgoing mail server host is not set up");
            }
            final String username = outgoingMailServer.getOutgoingMailUsername();
            final String password = outgoingMailServer.getOutgoingMailPassword();
            Properties properties = new Properties();
            properties.put("mail.smtp.allow8bitmime", "true");
            properties.put("mail.smtp.timeout", "60000");
            properties.put("mail.smtp.connectiontimeout", "60000");
            properties.put("mail.smtp.port", port);
            properties.put("mail.smtp.socketFactory.port", port);
            properties.put("mail.smtp.from", from);
            properties.put("mail.smtp.starttls.enable", "true");
            properties.put("mail.smtp.EnableSSL.enable", "true");
            properties.setProperty("mail.smtp.host", host);
            if (username != null && !username.isEmpty()) {
                properties.put("mail.smtp.auth", "true");
                properties.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
                properties.setProperty("mail.user", username);
            }
            if (password != null && !password.isEmpty()) {
                properties.setProperty("mail.password", password);
            }
            Session session = Session.getInstance(properties, new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(username, password);
                }
            });
            MimeMessage message = new MimeMessage(session);
            message.setFrom(new InternetAddress(from));
            message.addRecipient(Message.RecipientType.TO, new InternetAddress(to));
            message.setSubject(subject);
            MimeBodyPart messageBodyPart = new MimeBodyPart();
            messageBodyPart.setContent(message_html, "text/html");
            MimeMultipart multipart = new MimeMultipart();
            ((Multipart)multipart).addBodyPart(messageBodyPart);
            messageBodyPart = new MimeBodyPart();
            file = this.buildTempPDFFile();
            FileDataSource source = new FileDataSource(file);
            String docname = this.getPDFDocName();
            messageBodyPart.setDataHandler(new DataHandler((DataSource)source));
            messageBodyPart.setFileName(docname + ".pdf");
            ((Multipart)multipart).addBodyPart(messageBodyPart);
            message.setContent(multipart);
            Transport transport = session.getTransport();
            transport.connect();
            transport.sendMessage(message, message.getAllRecipients());
            transport.close();
            this.error_message.setText(docname + " has been emailed.");
            this.xbrlFileController.setStatusBarMessage(docname + " has been emailed.");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
        finally {
            if (file != null) {
                file.delete();
            }
        }
    }
}

