/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import au.com.glenix.ApplicationController;
import au.com.glenix.GlenixSBRAttachment;
import au.com.glenix.tr2018.GlenixLabelCountryLabel;
import au.com.glenix.trn.Business;
import au.com.glenix.trn.BusinessMasterFile;
import au.com.glenix.trn.ElectronicContact;
import au.com.glenix.trn.GlenixResult;
import au.com.glenix.trn.GlenixTrnXBRL;
import au.com.glenix.trn.Profile;
import au.com.glenix.trn.TFND0004AddressDetailsBusiness;
import au.com.glenix.widget.GlenixBranchController;
import au.com.glenix.widget.GlenixLabelDateLabel;
import au.com.glenix.widget.GlenixLabelLabel;
import java.net.URL;
import java.security.MessageDigest;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TaxServicesOrderFormController
extends GlenixBranchController {
    @FXML
    private Label error_message;
    @FXML
    private Label warning_message;
    private ApplicationController xbrlFileController = null;
    private Profile profile = null;
    private GlenixTrnXBRL business = null;
    private DocumentBuilder dBuilder;
    @FXML
    private GlenixLabelLabel businessABN;
    @FXML
    private GlenixLabelLabel businessLegalName;
    @FXML
    private GlenixLabelLabel businessTradingName;
    @FXML
    private GlenixLabelLabel Line1T;
    @FXML
    private GlenixLabelLabel Line2T;
    @FXML
    private GlenixLabelLabel LocalityNameT;
    @FXML
    private GlenixLabelLabel StateOrTerritoryC;
    @FXML
    private GlenixLabelLabel PostcodeT;
    @FXML
    private GlenixLabelCountryLabel CountryC;
    @FXML
    private GlenixLabelLabel Line1T_POS;
    @FXML
    private GlenixLabelLabel Line2T_POS;
    @FXML
    private GlenixLabelLabel LocalityNameT_POS;
    @FXML
    private GlenixLabelLabel StateOrTerritoryC_POS;
    @FXML
    private GlenixLabelLabel PostcodeT_POS;
    @FXML
    private GlenixLabelCountryLabel CountryC_POS;
    @FXML
    private GlenixLabelLabel businessPersonUnstructuredNameFullNameT;
    @FXML
    private GlenixLabelLabel businessTelephoneAreaC;
    @FXML
    private GlenixLabelLabel businessTelephoneMinimalN;
    @FXML
    private GlenixLabelLabel businessElectronicMailAddressT;
    @FXML
    private GlenixLabelDateLabel ledgerStartDate;
    @FXML
    private GlenixLabelDateLabel ledgerEndDate;

    public TaxServicesOrderFormController(ApplicationController xbrlFileController) {
        this.xbrlFileController = xbrlFileController;
    }

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setNamespaceAware(true);
            this.dBuilder = dbFactory.newDocumentBuilder();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    public void setModel(Profile profileXBRL) throws Exception {
        Document doc;
        this.profile = profileXBRL;
        if (this.profile != null && (doc = this.profile.buildDocument()) != null) {
            this.loadGlenixXBRL(doc, doc.getDocumentElement());
        }
    }

    public void setBusiness(GlenixTrnXBRL businessMasterFile) throws Exception {
        this.business = businessMasterFile;
        Business b = null;
        if (this.business != null) {
            b = this.business.getBusiness();
        }
        if (b == null) {
            this.businessABN.setGlenixElementValue(null);
            this.businessLegalName.setGlenixElementValue(null);
            this.businessTradingName.setGlenixElementValue(null);
            this.Line1T.setGlenixElementValue(null);
            this.Line2T.setGlenixElementValue(null);
            this.LocalityNameT.setGlenixElementValue(null);
            this.PostcodeT.setGlenixElementValue(null);
            this.StateOrTerritoryC.setGlenixElementValue(null);
            this.CountryC.setGlenixElementValue(null);
            this.Line1T_POS.setGlenixElementValue(null);
            this.Line2T_POS.setGlenixElementValue(null);
            this.LocalityNameT_POS.setGlenixElementValue(null);
            this.PostcodeT_POS.setGlenixElementValue(null);
            this.StateOrTerritoryC_POS.setGlenixElementValue(null);
            this.CountryC_POS.setGlenixElementValue(null);
            this.businessPersonUnstructuredNameFullNameT.setGlenixElementValue(null);
            this.businessTelephoneAreaC.setGlenixElementValue(null);
            this.businessTelephoneMinimalN.setGlenixElementValue(null);
            this.businessElectronicMailAddressT.setGlenixElementValue(null);
            this.ledgerStartDate.setGlenixElementValue(null);
            this.ledgerEndDate.setGlenixElementValue(null);
        } else {
            this.businessABN.setGlenixElementValue(b.getBusinessABN());
            this.businessLegalName.setGlenixElementValue(b.getBusinessLegalName());
            this.businessTradingName.setGlenixElementValue(b.getBusinessTradingName());
            BusinessMasterFile bmf = b.getBusinessMasterFile();
            if (bmf != null) {
                this.ledgerStartDate.setGlenixElementValue(bmf.getLedgerStartDate());
                this.ledgerEndDate.setGlenixElementValue(bmf.getLedgerEndDate());
                TFND0004AddressDetailsBusiness addr = bmf.getBusinessBusinessAddress();
                if (addr != null) {
                    this.Line1T.setGlenixElementValue(addr.getLine1T());
                    this.Line2T.setGlenixElementValue(addr.getLine2T());
                    this.LocalityNameT.setGlenixElementValue(addr.getLocalityNameT());
                    this.PostcodeT.setGlenixElementValue(addr.getPostcodeT());
                    this.StateOrTerritoryC.setGlenixElementValue(addr.getStateOrTerritoryC());
                    this.CountryC.setGlenixElementValue(addr.getCountryC());
                } else {
                    this.Line1T.setGlenixElementValue(null);
                    this.Line2T.setGlenixElementValue(null);
                    this.LocalityNameT.setGlenixElementValue(null);
                    this.PostcodeT.setGlenixElementValue(null);
                    this.StateOrTerritoryC.setGlenixElementValue(null);
                    this.CountryC.setGlenixElementValue(null);
                }
                addr = bmf.getBusinessPostalAddress();
                if (addr != null) {
                    this.Line1T_POS.setGlenixElementValue(addr.getLine1T());
                    this.Line2T_POS.setGlenixElementValue(addr.getLine2T());
                    this.LocalityNameT_POS.setGlenixElementValue(addr.getLocalityNameT());
                    this.PostcodeT_POS.setGlenixElementValue(addr.getPostcodeT());
                    this.StateOrTerritoryC_POS.setGlenixElementValue(addr.getStateOrTerritoryC());
                    this.CountryC_POS.setGlenixElementValue(addr.getCountryC());
                } else {
                    this.Line1T_POS.setGlenixElementValue(null);
                    this.Line2T_POS.setGlenixElementValue(null);
                    this.LocalityNameT_POS.setGlenixElementValue(null);
                    this.PostcodeT_POS.setGlenixElementValue(null);
                    this.StateOrTerritoryC_POS.setGlenixElementValue(null);
                    this.CountryC_POS.setGlenixElementValue(null);
                }
                ElectronicContact ec = bmf.getBusinessElectronicContact();
                if (ec != null) {
                    this.businessPersonUnstructuredNameFullNameT.setGlenixElementValue(ec.getPersonUnstructuredNameFullNameT());
                    this.businessTelephoneAreaC.setGlenixElementValue(ec.getTelephoneAreaC());
                    this.businessTelephoneMinimalN.setGlenixElementValue(ec.getTelephoneMinimalN());
                    this.businessElectronicMailAddressT.setGlenixElementValue(ec.getElectronicMailAddressT());
                } else {
                    this.businessPersonUnstructuredNameFullNameT.setGlenixElementValue(null);
                    this.businessTelephoneAreaC.setGlenixElementValue(null);
                    this.businessTelephoneMinimalN.setGlenixElementValue(null);
                    this.businessElectronicMailAddressT.setGlenixElementValue(null);
                }
            }
        }
    }

    @FXML
    public void placeOrder() {
        try {
            this.placeOrder(this.profile);
        }
        catch (Exception e) {
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
            e.printStackTrace();
        }
    }

    @Override
    public void buildGlenixXBRL(Document resultDoc, Element resultElement) throws Exception {
        Element el = resultDoc.createElementNS("http://www.glenix.com.au/", "gx:glenix");
        el.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:gx", "http://www.glenix.com.au/");
        if (resultElement == null) {
            resultDoc.appendChild(el);
        } else {
            resultElement.appendChild(el);
        }
        Element profileEl = resultDoc.createElementNS("http://www.glenix.com.au/", "gx:profile");
        el.appendChild(profileEl);
        try {
            String pkStr = this.xbrlFileController.getPublicKeyDer();
            Element pkiEl = resultDoc.createElementNS("http://www.glenix.com.au/", "gx:publicKey");
            pkiEl.setTextContent(pkStr);
            Element keyPairEl = resultDoc.createElementNS("http://www.glenix.com.au/", "gx:keyPair");
            profileEl.appendChild(keyPairEl);
            keyPairEl.appendChild(pkiEl);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.buildGlenixXBRLSub(this.getPane(), resultDoc, profileEl);
    }

    protected String getOrderService() {
        return "ORDERBUSINESS";
    }

    protected String getOrderSuccessMessage() {
        return "Thankyou for your order form we will be in touch soon";
    }

    public void placeOrder(Profile profile) {
        final ApplicationController xbrlFileController = this.xbrlFileController;
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Platform.runLater(() -> {
                        xbrlFileController.setStatusBarMessage("Begin place order...");
                        TaxServicesOrderFormController.this.warning_message.setText(null);
                        TaxServicesOrderFormController.this.warning_message.setVisible(false);
                        TaxServicesOrderFormController.this.warning_message.setManaged(false);
                    });
                    Document attachdoc = TaxServicesOrderFormController.this.dBuilder.newDocument();
                    TaxServicesOrderFormController.this.buildGlenixXBRL(attachdoc, null);
                    MessageDigest md = xbrlFileController.calculateSHA1Digest(attachdoc.getDocumentElement());
                    GlenixSBRAttachment gatt = new GlenixSBRAttachment(attachdoc, "Attachment01", md);
                    String service = TaxServicesOrderFormController.this.getOrderService();
                    GlenixResult glenixResult = xbrlFileController.sendDocumentToFASResult("http://www.freeaccountingsoftware.com.au/soap/register_profile", service, gatt);
                    Platform.runLater(() -> xbrlFileController.setStatusBarMessage("Interpreting response from FAS..."));
                    String resultCode = null;
                    if (glenixResult != null) {
                        resultCode = glenixResult.getResultCode();
                    }
                    if (resultCode == null) {
                        throw new Exception("Error, unable to place order");
                    }
                    if (!resultCode.equals("OK")) {
                        if (resultCode.equals("WARNVERSION")) {
                            Platform.runLater(() -> {
                                TaxServicesOrderFormController.this.warning_message.setText("Warning: There is a new version of this software available please go to www.freeaccountingsoftware.com.au to download the latest version.");
                                TaxServicesOrderFormController.this.warning_message.setVisible(true);
                                TaxServicesOrderFormController.this.warning_message.setManaged(true);
                            });
                        } else if (resultCode.equals("WARNING")) {
                            Platform.runLater(() -> {
                                TaxServicesOrderFormController.this.warning_message.setText("Warning: " + glenixResult.getResultDescription());
                                TaxServicesOrderFormController.this.warning_message.setVisible(true);
                                TaxServicesOrderFormController.this.warning_message.setManaged(true);
                            });
                        } else {
                            if (resultCode.equals("ERRORVERSION")) {
                                throw new Exception("Error, the version of the software you are using is out of date. You need to upgrade first please go to www.freeaccountingsoftware.com.au to download the latest version.");
                            }
                            if (resultCode.equals("ERROR")) {
                                throw new Exception("Error, unable to check version or license information, error code " + resultCode + ", description " + glenixResult.getResultDescription());
                            }
                            throw new Exception("Error, error code " + resultCode + ", description " + glenixResult.getResultDescription());
                        }
                    }
                    Platform.runLater(() -> {
                        try {
                            TaxServicesOrderFormController.this.error_message.setText("Thankyou for your order form we will be in touch soon.");
                            xbrlFileController.setStatusBarMessage("Thankyou for your order form we will be in touch soon.");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            TaxServicesOrderFormController.this.error_message.setText(e.getMessage());
                            xbrlFileController.setStatusBarMessage(e.getMessage());
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Platform.runLater(() -> {
                        e.printStackTrace();
                        TaxServicesOrderFormController.this.error_message.setText(e.getMessage());
                        xbrlFileController.setStatusBarMessage(e.getMessage());
                    });
                }
            }
        }).start();
    }
}

