/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import au.com.glenix.ApplicationController;
import au.com.glenix.EventItemsVBox;
import au.com.glenix.GlenixLabelAUSKeyCombo;
import au.com.glenix.GlenixLabelDocumentStatusCombo;
import au.com.glenix.GlenixLabelDocumentTypeCombo;
import au.com.glenix.GlenixSBRAttachment;
import au.com.glenix.GlenixSBRAttachmentGzip;
import au.com.glenix.GlenixSBRResponse;
import au.com.glenix.SearchListener;
import au.com.glenix.tr2018.GlenixSchedule;
import au.com.glenix.tr2018.TaxReturnCGLS0006VBox;
import au.com.glenix.tr2018.TaxReturnCGNFT0002VBox;
import au.com.glenix.tr2018.TaxReturnCGTS0006VBox;
import au.com.glenix.tr2018.TaxReturnCTR0009VBox;
import au.com.glenix.tr2018.TaxReturnDIDS0002VBox;
import au.com.glenix.tr2018.TaxReturnDIS0003VBox;
import au.com.glenix.tr2018.TaxReturnFTER0002VBox;
import au.com.glenix.tr2018.TaxReturnIDS0006VBox;
import au.com.glenix.tr2018.TaxReturnIEE0003VBox;
import au.com.glenix.tr2018.TaxReturnIITR0005VBox;
import au.com.glenix.tr2018.TaxReturnLS0006VBox;
import au.com.glenix.tr2018.TaxReturnNRFI0002VBox;
import au.com.glenix.tr2018.TaxReturnPSS0002VBox;
import au.com.glenix.tr2018.TaxReturnPTR0007VBox;
import au.com.glenix.tr2018.TaxReturnRDTIS0003VBox;
import au.com.glenix.tr2018.TaxReturnRS0002VBox;
import au.com.glenix.tr2018.TaxReturnSMSF0008VBox;
import au.com.glenix.tr2018.TaxReturnTRT0007VBox;
import au.com.glenix.tr2018.TaxReturnWRE0003VBox;
import au.com.glenix.tr2019.TaxReturnCTR0010VBox;
import au.com.glenix.tr2019.TaxReturnDDCTNS0001VBox;
import au.com.glenix.tr2019.TaxReturnIDS0007VBox;
import au.com.glenix.tr2019.TaxReturnIITR0006VBox;
import au.com.glenix.tr2019.TaxReturnRPTTAXPOS0001VBox;
import au.com.glenix.tr2019.TaxReturnSMSF0009VBox;
import au.com.glenix.trn.BusinessMasterFile;
import au.com.glenix.trn.CGLS0006;
import au.com.glenix.trn.CGNFT0002;
import au.com.glenix.trn.CGTS0006;
import au.com.glenix.trn.CTR0009;
import au.com.glenix.trn.CTR0010;
import au.com.glenix.trn.DDCTNS0001;
import au.com.glenix.trn.DIDS0002;
import au.com.glenix.trn.DIS0003;
import au.com.glenix.trn.EventItems;
import au.com.glenix.trn.FTER0002;
import au.com.glenix.trn.GlenixElement;
import au.com.glenix.trn.GlenixResult;
import au.com.glenix.trn.IDS0006;
import au.com.glenix.trn.IDS0007;
import au.com.glenix.trn.IEE0003;
import au.com.glenix.trn.IITR0005;
import au.com.glenix.trn.IITR0006;
import au.com.glenix.trn.LS0006;
import au.com.glenix.trn.NRFI0002;
import au.com.glenix.trn.PSS0002;
import au.com.glenix.trn.PTR0007;
import au.com.glenix.trn.Profile;
import au.com.glenix.trn.RDTIS0003;
import au.com.glenix.trn.RPTTAXPOS0001;
import au.com.glenix.trn.RS0002;
import au.com.glenix.trn.SMSF0008;
import au.com.glenix.trn.SMSF0009;
import au.com.glenix.trn.TRT0007;
import au.com.glenix.trn.TaxReturn;
import au.com.glenix.trn.WRE0003;
import au.com.glenix.widget.ErrorDisplay;
import au.com.glenix.widget.GlenixBranchController;
import au.com.glenix.widget.GlenixController;
import au.com.glenix.widget.GlenixLabelDate;
import au.com.glenix.widget.GlenixLabelDateTimeLabel;
import au.com.glenix.widget.GlenixLabelLabel;
import au.com.glenix.widget.GlenixLabelPassword;
import au.com.glenix.widget.GlenixLabelText;
import java.net.URL;
import java.security.MessageDigest;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import java.util.UUID;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.VBox;
import javafx.util.Pair;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TaxReturnTaxReturnController
extends GlenixBranchController
implements ErrorDisplay,
SearchListener {
    private DocumentBuilder dBuilder;
    private TaxReturn taxReturn;
    private GlenixSchedule schedulePane;
    private GlenixElement scheduleElement;
    @FXML
    private VBox schedulePlaceholder;
    @FXML
    private Label error_message;
    @FXML
    private Label warning_message;
    @FXML
    private Label page_heading;
    @FXML
    private EventItemsVBox overalleventitemsvbox;
    @FXML
    private EventItemsVBox businesseventitemsvbox;
    @FXML
    private GlenixLabelLabel taxReturnNumber;
    @FXML
    private GlenixLabelDocumentTypeCombo taxReturnType;
    @FXML
    private GlenixLabelDocumentStatusCombo taxReturnStatus;
    @FXML
    private GlenixLabelDateTimeLabel taxReturnDateTime;
    @FXML
    private GlenixLabelText year;
    @FXML
    private GlenixLabelDate startDate;
    @FXML
    private GlenixLabelDate endDate;
    private ApplicationController xbrlFileController;
    @FXML
    private GlenixLabelAUSKeyCombo ausKeyCombo;
    @FXML
    private GlenixLabelPassword password;
    @FXML
    private Button prelodgeButton;
    @FXML
    private Button lodgeButton;
    @FXML
    private VBox auskeyvbox;
    private ViewUpdater viewUpdater = null;
    private TaxReturnCGNFT0002VBox taxReturnCGNFT0002VBox = null;
    private TaxReturnCTR0009VBox taxReturnCTR0009VBox = null;
    private TaxReturnCTR0010VBox taxReturnCTR0010VBox = null;
    private TaxReturnIITR0005VBox taxReturnIITR0005VBox = null;
    private TaxReturnIITR0006VBox taxReturnIITR0006VBox = null;
    private TaxReturnPTR0007VBox taxReturnPTR0007VBox = null;
    private TaxReturnTRT0007VBox taxReturnTRT0007VBox = null;
    private TaxReturnSMSF0008VBox taxReturnSMSF0008VBox = null;
    private TaxReturnSMSF0009VBox taxReturnSMSF0009VBox = null;
    private TaxReturnRS0002VBox taxReturnRS0002VBox = null;
    private TaxReturnCGTS0006VBox taxReturnCGTS0006VBox = null;
    private TaxReturnDIDS0002VBox taxReturnDIDS0002VBox = null;
    private TaxReturnNRFI0002VBox taxReturnNRFI0002VBox = null;
    private TaxReturnPSS0002VBox taxReturnPSS0002VBox = null;
    private TaxReturnWRE0003VBox taxReturnWRE0003VBox = null;
    private TaxReturnIDS0006VBox taxReturnIDS0006VBox = null;
    private TaxReturnIDS0007VBox taxReturnIDS0007VBox = null;
    private TaxReturnCGLS0006VBox taxReturnCGLS0006VBox = null;
    private TaxReturnDIS0003VBox taxReturnDIS0003VBox = null;
    private TaxReturnLS0006VBox taxReturnLS0006VBox = null;
    private TaxReturnRDTIS0003VBox taxReturnRDTIS0003VBox = null;
    private TaxReturnIEE0003VBox taxReturnIEE0003VBox = null;
    private TaxReturnFTER0002VBox taxReturnFTER0002VBox = null;
    private TaxReturnDDCTNS0001VBox taxReturnDDCTNS0001VBox = null;
    private TaxReturnRPTTAXPOS0001VBox taxReturnRPTTAXPOS0001VBox = null;
    private Profile profileXBRL;

    public TaxReturnTaxReturnController(ApplicationController xbrlFileController) {
        this.xbrlFileController = xbrlFileController;
    }

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setNamespaceAware(true);
            this.dBuilder = dbFactory.newDocumentBuilder();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
        this.taxReturnType.setSingleComboChangeListener(new ChangeListener<Pair<String, String>>(){

            public void changed(ObservableValue<? extends Pair<String, String>> observable, Pair<String, String> oldValue, Pair<String, String> newValue) {
                TaxReturnTaxReturnController.this.updateSchedule();
            }
        });
        this.taxReturnStatus.setSingleComboChangeListener(new ChangeListener<Pair<String, String>>(){

            public void changed(ObservableValue<? extends Pair<String, String>> observable, Pair<String, String> oldValue, Pair<String, String> newValue) {
                TaxReturnTaxReturnController.this.updateSchedule();
            }
        });
        this.year.setSingleChangeListener(new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                TaxReturnTaxReturnController.this.updateSchedule();
            }
        });
        this.startDate.setSingleDateChangeListener(new ChangeListener<LocalDate>(){

            public void changed(ObservableValue<? extends LocalDate> observable, LocalDate oldValue, LocalDate newValue) {
                TaxReturnTaxReturnController.this.updateSchedule();
            }
        });
        this.endDate.setSingleDateChangeListener(new ChangeListener<LocalDate>(){

            public void changed(ObservableValue<? extends LocalDate> observable, LocalDate oldValue, LocalDate newValue) {
                TaxReturnTaxReturnController.this.updateSchedule();
            }
        });
        this.overalleventitemsvbox.setSearchListener(this);
        this.businesseventitemsvbox.setSearchListener(this);
    }

    public void updateSchedule() {
        if (this.schedulePane == null) {
            return;
        }
        this.schedulePane.setTaxReturnDetails(this.taxReturnType.getGlenixElementValue(), this.taxReturnStatus.getGlenixElementValue(), this.year.getGlenixElementValue(), this.startDate.getLocalDate(), this.endDate.getLocalDate());
        String desc = this.schedulePane.getGlenixElementDescription();
        if (desc != null && !desc.isEmpty()) {
            this.page_heading.setText(desc);
        } else {
            this.page_heading.setText("Tax Return");
        }
    }

    public void setModel(TaxReturn taxReturn, GlenixElement ge) throws Exception {
        throw new Exception("Error, schedule element must be a known tax return schedule");
    }

    private void disableLodge(boolean disable) {
        this.prelodgeButton.disableProperty().set(disable);
        this.lodgeButton.disableProperty().set(disable);
        if (disable) {
            this.auskeyvbox.setManaged(false);
            this.auskeyvbox.setVisible(false);
        } else {
            this.auskeyvbox.setManaged(true);
            this.auskeyvbox.setVisible(true);
        }
    }

    private void setTaxReturn(TaxReturn taxReturn) {
        this.taxReturn = taxReturn;
        this.taxReturnNumber.setGlenixElementValue(taxReturn.getTaxReturnNumber());
        this.taxReturnType.setGlenixElementValue(taxReturn.getTaxReturnType());
        String status = taxReturn.getTaxReturnStatus();
        this.taxReturnStatus.setGlenixElementValue(status);
        String ausKeyId = taxReturn.getTaxReturnCertAlias();
        this.ausKeyCombo.setGlenixElementValue(ausKeyId);
        this.taxReturnDateTime.setGlenixElementValue(taxReturn.getTaxReturnDateTime());
        if (status != null && status.equals("lodge_complete")) {
            this.lodgeButton.disableProperty().set(true);
        } else {
            this.lodgeButton.disableProperty().set(false);
        }
        String yearStr = taxReturn.getYear();
        if (yearStr == null || yearStr.isEmpty()) {
            this.year.setGlenixElementValue(taxReturn.getDefaultYear());
        } else {
            this.year.setGlenixElementValue(yearStr);
        }
        String startStr = taxReturn.getStartDate();
        if (startStr == null || startStr.isEmpty()) {
            this.startDate.setGlenixElementValue(taxReturn.getDefaultStartDate());
        } else {
            this.startDate.setGlenixElementValue(startStr);
        }
        String endStr = taxReturn.getEndDate();
        if (endStr == null || endStr.isEmpty()) {
            this.endDate.setGlenixElementValue(taxReturn.getEndDate());
        } else {
            this.endDate.setGlenixElementValue(endStr);
        }
    }

    public void setModelCGNFT0002(TaxReturn taxReturn, CGNFT0002 cgnft0002) throws Exception {
        this.schedulePane = null;
        this.loadGlenixDefaults();
        this.setTaxReturn(taxReturn);
        if (cgnft0002 == null) {
            cgnft0002 = taxReturn.addCGNFT0002();
        }
        this.viewUpdater = new ViewUpdater(taxReturn, cgnft0002){

            @Override
            public void updateView() throws Exception {
                TaxReturnTaxReturnController.this.setModelCGNFT0002(this.taxReturn, (CGNFT0002)this.schedule);
            }
        };
        this.scheduleElement = cgnft0002;
        this.schedulePlaceholder.getChildren().clear();
        if (this.taxReturnCGNFT0002VBox == null) {
            this.taxReturnCGNFT0002VBox = new TaxReturnCGNFT0002VBox(this);
        }
        this.taxReturnCGNFT0002VBox.setModel(cgnft0002);
        this.schedulePlaceholder.getChildren().add((Object)this.taxReturnCGNFT0002VBox);
        this.schedulePane = this.taxReturnCGNFT0002VBox;
        this.updateSchedule();
        this.businesseventitemsvbox.setEventItemsModel(null);
        this.overalleventitemsvbox.setEventItemsModel(null);
        if (cgnft0002 != null) {
            EventItems eventItems = cgnft0002.getBusinessEventItems();
            if (eventItems != null) {
                this.businesseventitemsvbox.setEventItemsModel(eventItems);
            }
            if ((eventItems = cgnft0002.getOverallEventItems()) != null) {
                this.overalleventitemsvbox.setEventItemsModel(eventItems);
            }
        }
        if ("cgnft0002".equals(taxReturn.getTaxReturnType())) {
            this.disableLodge(false);
        } else {
            this.disableLodge(true);
        }
    }

    public void setModelCTR0009(TaxReturn taxReturn, CTR0009 schedule) throws Exception {
        this.schedulePane = null;
        this.loadGlenixDefaults();
        this.setTaxReturn(taxReturn);
        if (schedule == null) {
            schedule = taxReturn.addCTR0009();
        }
        this.viewUpdater = new ViewUpdater(taxReturn, schedule){

            @Override
            public void updateView() throws Exception {
                TaxReturnTaxReturnController.this.setModelCTR0009(this.taxReturn, (CTR0009)this.schedule);
            }
        };
        this.scheduleElement = schedule;
        this.schedulePlaceholder.getChildren().clear();
        if (this.taxReturnCTR0009VBox == null) {
            this.taxReturnCTR0009VBox = new TaxReturnCTR0009VBox(this);
        }
        this.taxReturnCTR0009VBox.setModel(schedule);
        this.schedulePlaceholder.getChildren().add((Object)this.taxReturnCTR0009VBox);
        this.schedulePane = this.taxReturnCTR0009VBox;
        this.updateSchedule();
        this.businesseventitemsvbox.setEventItemsModel(null);
        this.overalleventitemsvbox.setEventItemsModel(null);
        if (schedule != null) {
            EventItems eventItems = schedule.getBusinessEventItems();
            if (eventItems != null) {
                this.businesseventitemsvbox.setEventItemsModel(eventItems);
            }
            if ((eventItems = schedule.getOverallEventItems()) != null) {
                this.overalleventitemsvbox.setEventItemsModel(eventItems);
            }
        }
        this.disableLodge(false);
    }

    public void setModelCTR0010(TaxReturn taxReturn, CTR0010 schedule) throws Exception {
        this.schedulePane = null;
        this.loadGlenixDefaults();
        this.setTaxReturn(taxReturn);
        if (schedule == null) {
            schedule = taxReturn.addCTR0010();
        }
        this.viewUpdater = new ViewUpdater(taxReturn, schedule){

            @Override
            public void updateView() throws Exception {
                TaxReturnTaxReturnController.this.setModelCTR0010(this.taxReturn, (CTR0010)this.schedule);
            }
        };
        this.scheduleElement = schedule;
        this.schedulePlaceholder.getChildren().clear();
        if (this.taxReturnCTR0010VBox == null) {
            this.taxReturnCTR0010VBox = new TaxReturnCTR0010VBox(this);
        }
        this.taxReturnCTR0010VBox.setModel(schedule);
        this.schedulePlaceholder.getChildren().add((Object)this.taxReturnCTR0010VBox);
        this.schedulePane = this.taxReturnCTR0010VBox;
        this.updateSchedule();
        this.businesseventitemsvbox.setEventItemsModel(null);
        this.overalleventitemsvbox.setEventItemsModel(null);
        if (schedule != null) {
            EventItems eventItems = schedule.getBusinessEventItems();
            if (eventItems != null) {
                this.businesseventitemsvbox.setEventItemsModel(eventItems);
            }
            if ((eventItems = schedule.getOverallEventItems()) != null) {
                this.overalleventitemsvbox.setEventItemsModel(eventItems);
            }
        }
        this.disableLodge(false);
    }

    public void setModelIITR0005(TaxReturn taxReturn, IITR0005 schedule) throws Exception {
        this.schedulePane = null;
        this.loadGlenixDefaults();
        this.setTaxReturn(taxReturn);
        if (schedule == null) {
            schedule = taxReturn.addIITR0005();
        }
        this.viewUpdater = new ViewUpdater(taxReturn, schedule){

            @Override
            public void updateView() throws Exception {
                TaxReturnTaxReturnController.this.setModelIITR0005(this.taxReturn, (IITR0005)this.schedule);
            }
        };
        this.scheduleElement = schedule;
        this.schedulePlaceholder.getChildren().clear();
        if (this.taxReturnIITR0005VBox == null) {
            this.taxReturnIITR0005VBox = new TaxReturnIITR0005VBox(this);
        }
        this.taxReturnIITR0005VBox.setModel(schedule);
        this.schedulePlaceholder.getChildren().add((Object)this.taxReturnIITR0005VBox);
        this.schedulePane = this.taxReturnIITR0005VBox;
        this.updateSchedule();
        this.businesseventitemsvbox.setEventItemsModel(null);
        this.overalleventitemsvbox.setEventItemsModel(null);
        if (schedule != null) {
            EventItems eventItems = schedule.getBusinessEventItems();
            if (eventItems != null) {
                this.businesseventitemsvbox.setEventItemsModel(eventItems);
            }
            if ((eventItems = schedule.getOverallEventItems()) != null) {
                this.overalleventitemsvbox.setEventItemsModel(eventItems);
            }
        }
        this.disableLodge(false);
    }

    public void setModelIITR0006(TaxReturn taxReturn, IITR0006 schedule) throws Exception {
        this.schedulePane = null;
        this.loadGlenixDefaults();
        this.setTaxReturn(taxReturn);
        if (schedule == null) {
            schedule = taxReturn.addIITR0006();
        }
        this.viewUpdater = new ViewUpdater(taxReturn, schedule){

            @Override
            public void updateView() throws Exception {
                TaxReturnTaxReturnController.this.setModelIITR0006(this.taxReturn, (IITR0006)this.schedule);
            }
        };
        this.scheduleElement = schedule;
        this.schedulePlaceholder.getChildren().clear();
        if (this.taxReturnIITR0006VBox == null) {
            this.taxReturnIITR0006VBox = new TaxReturnIITR0006VBox(this);
        }
        this.taxReturnIITR0006VBox.setModel(schedule);
        if (taxReturn.getTaxReturnStatus() != null && !taxReturn.getTaxReturnStatus().equals("lodge_complete")) {
            DDCTNS0001 ddctns0001 = taxReturn.getDDCTNS0001();
            this.taxReturnIITR0006VBox.setModelDDCTNS0001(ddctns0001);
        }
        this.schedulePlaceholder.getChildren().add((Object)this.taxReturnIITR0006VBox);
        this.schedulePane = this.taxReturnIITR0006VBox;
        this.updateSchedule();
        this.businesseventitemsvbox.setEventItemsModel(null);
        this.overalleventitemsvbox.setEventItemsModel(null);
        if (schedule != null) {
            EventItems eventItems = schedule.getBusinessEventItems();
            if (eventItems != null) {
                this.businesseventitemsvbox.setEventItemsModel(eventItems);
            }
            if ((eventItems = schedule.getOverallEventItems()) != null) {
                this.overalleventitemsvbox.setEventItemsModel(eventItems);
            }
        }
        this.disableLodge(false);
    }

    public void setModelPTR0007(TaxReturn taxReturn, PTR0007 schedule) throws Exception {
        this.schedulePane = null;
        this.loadGlenixDefaults();
        this.setTaxReturn(taxReturn);
        if (schedule == null) {
            schedule = taxReturn.addPTR0007();
        }
        this.viewUpdater = new ViewUpdater(taxReturn, schedule){

            @Override
            public void updateView() throws Exception {
                TaxReturnTaxReturnController.this.setModelPTR0007(this.taxReturn, (PTR0007)this.schedule);
            }
        };
        this.scheduleElement = schedule;
        this.schedulePlaceholder.getChildren().clear();
        if (this.taxReturnPTR0007VBox == null) {
            this.taxReturnPTR0007VBox = new TaxReturnPTR0007VBox(this);
        }
        this.taxReturnPTR0007VBox.setModel(schedule);
        this.schedulePlaceholder.getChildren().add((Object)this.taxReturnPTR0007VBox);
        this.schedulePane = this.taxReturnPTR0007VBox;
        this.updateSchedule();
        this.businesseventitemsvbox.setEventItemsModel(null);
        this.overalleventitemsvbox.setEventItemsModel(null);
        if (schedule != null) {
            EventItems eventItems = schedule.getBusinessEventItems();
            if (eventItems != null) {
                this.businesseventitemsvbox.setEventItemsModel(eventItems);
            }
            if ((eventItems = schedule.getOverallEventItems()) != null) {
                this.overalleventitemsvbox.setEventItemsModel(eventItems);
            }
        }
        this.disableLodge(false);
    }

    public void setModelTRT0007(TaxReturn taxReturn, TRT0007 schedule) throws Exception {
        this.schedulePane = null;
        this.loadGlenixDefaults();
        this.setTaxReturn(taxReturn);
        if (schedule == null) {
            schedule = taxReturn.addTRT0007();
        }
        this.viewUpdater = new ViewUpdater(taxReturn, schedule){

            @Override
            public void updateView() throws Exception {
                TaxReturnTaxReturnController.this.setModelTRT0007(this.taxReturn, (TRT0007)this.schedule);
            }
        };
        this.scheduleElement = schedule;
        this.schedulePlaceholder.getChildren().clear();
        if (this.taxReturnTRT0007VBox == null) {
            this.taxReturnTRT0007VBox = new TaxReturnTRT0007VBox(this);
        }
        this.taxReturnTRT0007VBox.setModel(schedule);
        this.schedulePlaceholder.getChildren().add((Object)this.taxReturnTRT0007VBox);
        this.schedulePane = this.taxReturnTRT0007VBox;
        this.updateSchedule();
        this.businesseventitemsvbox.setEventItemsModel(null);
        this.overalleventitemsvbox.setEventItemsModel(null);
        if (schedule != null) {
            EventItems eventItems = schedule.getBusinessEventItems();
            if (eventItems != null) {
                this.businesseventitemsvbox.setEventItemsModel(eventItems);
            }
            if ((eventItems = schedule.getOverallEventItems()) != null) {
                this.overalleventitemsvbox.setEventItemsModel(eventItems);
            }
        }
        this.disableLodge(false);
    }

    public void setModelSMSF0008(TaxReturn taxReturn, SMSF0008 schedule) throws Exception {
        this.schedulePane = null;
        this.loadGlenixDefaults();
        this.setTaxReturn(taxReturn);
        if (schedule == null) {
            schedule = taxReturn.addSMSF0008();
        }
        this.viewUpdater = new ViewUpdater(taxReturn, schedule){

            @Override
            public void updateView() throws Exception {
                TaxReturnTaxReturnController.this.setModelSMSF0008(this.taxReturn, (SMSF0008)this.schedule);
            }
        };
        this.scheduleElement = schedule;
        this.schedulePlaceholder.getChildren().clear();
        if (this.taxReturnSMSF0008VBox == null) {
            this.taxReturnSMSF0008VBox = new TaxReturnSMSF0008VBox(this);
        }
        this.taxReturnSMSF0008VBox.setModel(schedule);
        this.schedulePlaceholder.getChildren().add((Object)this.taxReturnSMSF0008VBox);
        this.schedulePane = this.taxReturnSMSF0008VBox;
        this.updateSchedule();
        this.businesseventitemsvbox.setEventItemsModel(null);
        this.overalleventitemsvbox.setEventItemsModel(null);
        if (schedule != null) {
            EventItems eventItems = schedule.getBusinessEventItems();
            if (eventItems != null) {
                this.businesseventitemsvbox.setEventItemsModel(eventItems);
            }
            if ((eventItems = schedule.getOverallEventItems()) != null) {
                this.overalleventitemsvbox.setEventItemsModel(eventItems);
            }
        }
        this.disableLodge(false);
    }

    public void setModelSMSF0009(TaxReturn taxReturn, SMSF0009 schedule) throws Exception {
        this.schedulePane = null;
        this.loadGlenixDefaults();
        this.setTaxReturn(taxReturn);
        if (schedule == null) {
            schedule = taxReturn.addSMSF0009();
        }
        this.viewUpdater = new ViewUpdater(taxReturn, schedule){

            @Override
            public void updateView() throws Exception {
                TaxReturnTaxReturnController.this.setModelSMSF0009(this.taxReturn, (SMSF0009)this.schedule);
            }
        };
        this.scheduleElement = schedule;
        this.schedulePlaceholder.getChildren().clear();
        if (this.taxReturnSMSF0009VBox == null) {
            this.taxReturnSMSF0009VBox = new TaxReturnSMSF0009VBox(this);
        }
        this.taxReturnSMSF0009VBox.setModel(schedule);
        this.schedulePlaceholder.getChildren().add((Object)this.taxReturnSMSF0009VBox);
        this.schedulePane = this.taxReturnSMSF0009VBox;
        this.updateSchedule();
        this.businesseventitemsvbox.setEventItemsModel(null);
        this.overalleventitemsvbox.setEventItemsModel(null);
        if (schedule != null) {
            EventItems eventItems = schedule.getBusinessEventItems();
            if (eventItems != null) {
                this.businesseventitemsvbox.setEventItemsModel(eventItems);
            }
            if ((eventItems = schedule.getOverallEventItems()) != null) {
                this.overalleventitemsvbox.setEventItemsModel(eventItems);
            }
        }
        this.disableLodge(false);
    }

    public void setModelRS0002(TaxReturn taxReturn, RS0002 schedule) throws Exception {
        EventItems eventItems;
        this.schedulePane = null;
        this.loadGlenixDefaults();
        this.setTaxReturn(taxReturn);
        if (schedule == null) {
            schedule = taxReturn.addRS0002();
        }
        this.viewUpdater = new ViewUpdater(taxReturn, schedule){

            @Override
            public void updateView() throws Exception {
                TaxReturnTaxReturnController.this.setModelRS0002(this.taxReturn, (RS0002)this.schedule);
            }
        };
        this.scheduleElement = schedule;
        this.schedulePlaceholder.getChildren().clear();
        if (this.taxReturnRS0002VBox == null) {
            this.taxReturnRS0002VBox = new TaxReturnRS0002VBox(this);
        }
        this.taxReturnRS0002VBox.setModel(schedule);
        this.schedulePlaceholder.getChildren().add((Object)this.taxReturnRS0002VBox);
        this.schedulePane = this.taxReturnRS0002VBox;
        this.updateSchedule();
        this.businesseventitemsvbox.setEventItemsModel(null);
        this.overalleventitemsvbox.setEventItemsModel(null);
        if (schedule != null && (eventItems = schedule.getBusinessEventItems()) != null) {
            this.businesseventitemsvbox.setEventItemsModel(eventItems);
        }
        this.disableLodge(true);
    }

    public void setModelCGTS0006(TaxReturn taxReturn, CGTS0006 schedule) throws Exception {
        EventItems eventItems;
        this.schedulePane = null;
        this.loadGlenixDefaults();
        this.setTaxReturn(taxReturn);
        if (schedule == null) {
            schedule = taxReturn.addCGTS0006();
        }
        this.viewUpdater = new ViewUpdater(taxReturn, schedule){

            @Override
            public void updateView() throws Exception {
                TaxReturnTaxReturnController.this.setModelCGTS0006(this.taxReturn, (CGTS0006)this.schedule);
            }
        };
        this.scheduleElement = schedule;
        this.schedulePlaceholder.getChildren().clear();
        if (this.taxReturnCGTS0006VBox == null) {
            this.taxReturnCGTS0006VBox = new TaxReturnCGTS0006VBox(this);
        }
        this.taxReturnCGTS0006VBox.setModel(schedule);
        this.schedulePlaceholder.getChildren().add((Object)this.taxReturnCGTS0006VBox);
        this.schedulePane = this.taxReturnCGTS0006VBox;
        this.updateSchedule();
        this.businesseventitemsvbox.setEventItemsModel(null);
        this.overalleventitemsvbox.setEventItemsModel(null);
        if (schedule != null && (eventItems = schedule.getBusinessEventItems()) != null) {
            this.businesseventitemsvbox.setEventItemsModel(eventItems);
        }
        this.disableLodge(true);
    }

    public void setModelDIDS0002(TaxReturn taxReturn, DIDS0002 schedule) throws Exception {
        EventItems eventItems;
        this.schedulePane = null;
        this.loadGlenixDefaults();
        this.setTaxReturn(taxReturn);
        if (schedule == null) {
            schedule = taxReturn.addDIDS0002();
        }
        this.viewUpdater = new ViewUpdater(taxReturn, schedule){

            @Override
            public void updateView() throws Exception {
                TaxReturnTaxReturnController.this.setModelDIDS0002(this.taxReturn, (DIDS0002)this.schedule);
            }
        };
        this.scheduleElement = schedule;
        this.schedulePlaceholder.getChildren().clear();
        if (this.taxReturnDIDS0002VBox == null) {
            this.taxReturnDIDS0002VBox = new TaxReturnDIDS0002VBox(this);
        }
        this.taxReturnDIDS0002VBox.setModel(schedule);
        this.schedulePlaceholder.getChildren().add((Object)this.taxReturnDIDS0002VBox);
        this.schedulePane = this.taxReturnDIDS0002VBox;
        this.updateSchedule();
        this.businesseventitemsvbox.setEventItemsModel(null);
        this.overalleventitemsvbox.setEventItemsModel(null);
        if (schedule != null && (eventItems = schedule.getBusinessEventItems()) != null) {
            this.businesseventitemsvbox.setEventItemsModel(eventItems);
        }
        this.disableLodge(true);
    }

    public void setModelNRFI0002(TaxReturn taxReturn, NRFI0002 schedule) throws Exception {
        EventItems eventItems;
        this.schedulePane = null;
        this.loadGlenixDefaults();
        this.setTaxReturn(taxReturn);
        if (schedule == null) {
            schedule = taxReturn.addNRFI0002();
        }
        this.viewUpdater = new ViewUpdater(taxReturn, schedule){

            @Override
            public void updateView() throws Exception {
                TaxReturnTaxReturnController.this.setModelNRFI0002(this.taxReturn, (NRFI0002)this.schedule);
            }
        };
        this.scheduleElement = schedule;
        this.schedulePlaceholder.getChildren().clear();
        if (this.taxReturnNRFI0002VBox == null) {
            this.taxReturnNRFI0002VBox = new TaxReturnNRFI0002VBox(this);
        }
        this.taxReturnNRFI0002VBox.setModel(schedule);
        this.schedulePlaceholder.getChildren().add((Object)this.taxReturnNRFI0002VBox);
        this.schedulePane = this.taxReturnNRFI0002VBox;
        this.updateSchedule();
        this.businesseventitemsvbox.setEventItemsModel(null);
        this.overalleventitemsvbox.setEventItemsModel(null);
        if (schedule != null && (eventItems = schedule.getBusinessEventItems()) != null) {
            this.businesseventitemsvbox.setEventItemsModel(eventItems);
        }
        this.disableLodge(true);
    }

    public void setModelPSS0002(TaxReturn taxReturn, PSS0002 schedule) throws Exception {
        EventItems eventItems;
        this.schedulePane = null;
        this.loadGlenixDefaults();
        this.setTaxReturn(taxReturn);
        if (schedule == null) {
            schedule = taxReturn.addPSS0002();
        }
        this.viewUpdater = new ViewUpdater(taxReturn, schedule){

            @Override
            public void updateView() throws Exception {
                TaxReturnTaxReturnController.this.setModelPSS0002(this.taxReturn, (PSS0002)this.schedule);
            }
        };
        this.scheduleElement = schedule;
        this.schedulePlaceholder.getChildren().clear();
        if (this.taxReturnPSS0002VBox == null) {
            this.taxReturnPSS0002VBox = new TaxReturnPSS0002VBox(this);
        }
        this.taxReturnPSS0002VBox.setModel(schedule);
        this.schedulePlaceholder.getChildren().add((Object)this.taxReturnPSS0002VBox);
        this.schedulePane = this.taxReturnPSS0002VBox;
        this.updateSchedule();
        this.businesseventitemsvbox.setEventItemsModel(null);
        this.overalleventitemsvbox.setEventItemsModel(null);
        if (schedule != null && (eventItems = schedule.getBusinessEventItems()) != null) {
            this.businesseventitemsvbox.setEventItemsModel(eventItems);
        }
        this.disableLodge(true);
    }

    public void setModelWRE0003(TaxReturn taxReturn, WRE0003 schedule) throws Exception {
        EventItems eventItems;
        this.schedulePane = null;
        this.loadGlenixDefaults();
        this.setTaxReturn(taxReturn);
        if (schedule == null) {
            schedule = taxReturn.addWRE0003();
        }
        this.viewUpdater = new ViewUpdater(taxReturn, schedule){

            @Override
            public void updateView() throws Exception {
                TaxReturnTaxReturnController.this.setModelWRE0003(this.taxReturn, (WRE0003)this.schedule);
            }
        };
        this.scheduleElement = schedule;
        this.schedulePlaceholder.getChildren().clear();
        if (this.taxReturnWRE0003VBox == null) {
            this.taxReturnWRE0003VBox = new TaxReturnWRE0003VBox(this);
        }
        this.taxReturnWRE0003VBox.setModel(schedule);
        this.schedulePlaceholder.getChildren().add((Object)this.taxReturnWRE0003VBox);
        this.schedulePane = this.taxReturnWRE0003VBox;
        this.updateSchedule();
        this.businesseventitemsvbox.setEventItemsModel(null);
        this.overalleventitemsvbox.setEventItemsModel(null);
        if (schedule != null && (eventItems = schedule.getBusinessEventItems()) != null) {
            this.businesseventitemsvbox.setEventItemsModel(eventItems);
        }
        this.disableLodge(true);
    }

    public void setModelIDS0006(TaxReturn taxReturn, IDS0006 schedule) throws Exception {
        EventItems eventItems;
        this.schedulePane = null;
        this.loadGlenixDefaults();
        this.setTaxReturn(taxReturn);
        if (schedule == null) {
            schedule = taxReturn.addIDS0006();
        }
        this.viewUpdater = new ViewUpdater(taxReturn, schedule){

            @Override
            public void updateView() throws Exception {
                TaxReturnTaxReturnController.this.setModelIDS0006(this.taxReturn, (IDS0006)this.schedule);
            }
        };
        this.scheduleElement = schedule;
        this.schedulePlaceholder.getChildren().clear();
        if (this.taxReturnIDS0006VBox == null) {
            this.taxReturnIDS0006VBox = new TaxReturnIDS0006VBox(this);
        }
        this.taxReturnIDS0006VBox.setModel(schedule);
        this.schedulePlaceholder.getChildren().add((Object)this.taxReturnIDS0006VBox);
        this.schedulePane = this.taxReturnIDS0006VBox;
        this.updateSchedule();
        this.businesseventitemsvbox.setEventItemsModel(null);
        this.overalleventitemsvbox.setEventItemsModel(null);
        if (schedule != null && (eventItems = schedule.getBusinessEventItems()) != null) {
            this.businesseventitemsvbox.setEventItemsModel(eventItems);
        }
        this.disableLodge(true);
    }

    public void setModelIDS0007(TaxReturn taxReturn, IDS0007 schedule) throws Exception {
        EventItems eventItems;
        this.schedulePane = null;
        this.loadGlenixDefaults();
        this.setTaxReturn(taxReturn);
        if (schedule == null) {
            schedule = taxReturn.addIDS0007();
        }
        this.viewUpdater = new ViewUpdater(taxReturn, schedule){

            @Override
            public void updateView() throws Exception {
                TaxReturnTaxReturnController.this.setModelIDS0007(this.taxReturn, (IDS0007)this.schedule);
            }
        };
        this.scheduleElement = schedule;
        this.schedulePlaceholder.getChildren().clear();
        if (this.taxReturnIDS0007VBox == null) {
            this.taxReturnIDS0007VBox = new TaxReturnIDS0007VBox(this);
        }
        this.taxReturnIDS0007VBox.setModel(schedule);
        this.schedulePlaceholder.getChildren().add((Object)this.taxReturnIDS0007VBox);
        this.schedulePane = this.taxReturnIDS0007VBox;
        this.updateSchedule();
        this.businesseventitemsvbox.setEventItemsModel(null);
        this.overalleventitemsvbox.setEventItemsModel(null);
        if (schedule != null && (eventItems = schedule.getBusinessEventItems()) != null) {
            this.businesseventitemsvbox.setEventItemsModel(eventItems);
        }
        this.disableLodge(true);
    }

    public void setModelCGLS0006(TaxReturn taxReturn, CGLS0006 schedule) throws Exception {
        EventItems eventItems;
        this.schedulePane = null;
        this.loadGlenixDefaults();
        this.setTaxReturn(taxReturn);
        if (schedule == null) {
            schedule = taxReturn.addCGLS0006();
        }
        this.viewUpdater = new ViewUpdater(taxReturn, schedule){

            @Override
            public void updateView() throws Exception {
                TaxReturnTaxReturnController.this.setModelCGLS0006(this.taxReturn, (CGLS0006)this.schedule);
            }
        };
        this.scheduleElement = schedule;
        this.schedulePlaceholder.getChildren().clear();
        if (this.taxReturnCGLS0006VBox == null) {
            this.taxReturnCGLS0006VBox = new TaxReturnCGLS0006VBox(this);
        }
        this.taxReturnCGLS0006VBox.setModel(schedule);
        this.schedulePlaceholder.getChildren().add((Object)this.taxReturnCGLS0006VBox);
        this.schedulePane = this.taxReturnCGLS0006VBox;
        this.updateSchedule();
        this.businesseventitemsvbox.setEventItemsModel(null);
        this.overalleventitemsvbox.setEventItemsModel(null);
        if (schedule != null && (eventItems = schedule.getBusinessEventItems()) != null) {
            this.businesseventitemsvbox.setEventItemsModel(eventItems);
        }
        this.disableLodge(true);
    }

    public void setModelDIS0003(TaxReturn taxReturn, DIS0003 schedule) throws Exception {
        this.schedulePane = null;
        this.loadGlenixDefaults();
        this.setTaxReturn(taxReturn);
        if (schedule == null) {
            schedule = taxReturn.addDIS0003();
        }
        this.viewUpdater = new ViewUpdater(taxReturn, schedule){

            @Override
            public void updateView() throws Exception {
                TaxReturnTaxReturnController.this.setModelDIS0003(this.taxReturn, (DIS0003)this.schedule);
            }
        };
        this.scheduleElement = schedule;
        this.schedulePlaceholder.getChildren().clear();
        if (this.taxReturnDIS0003VBox == null) {
            this.taxReturnDIS0003VBox = new TaxReturnDIS0003VBox(this);
        }
        this.taxReturnDIS0003VBox.setModel(schedule);
        this.schedulePlaceholder.getChildren().add((Object)this.taxReturnDIS0003VBox);
        this.schedulePane = this.taxReturnDIS0003VBox;
        this.updateSchedule();
        this.businesseventitemsvbox.setEventItemsModel(null);
        this.overalleventitemsvbox.setEventItemsModel(null);
        if (schedule != null) {
            EventItems eventItems = schedule.getBusinessEventItems();
            if (eventItems != null) {
                this.businesseventitemsvbox.setEventItemsModel(eventItems);
            }
            if ((eventItems = schedule.getOverallEventItems()) != null) {
                this.overalleventitemsvbox.setEventItemsModel(eventItems);
            }
        }
        if ("dis0003".equals(taxReturn.getTaxReturnType())) {
            this.disableLodge(false);
        } else {
            this.disableLodge(true);
        }
    }

    public void setModelLS0006(TaxReturn taxReturn, LS0006 schedule) throws Exception {
        EventItems eventItems;
        this.schedulePane = null;
        this.loadGlenixDefaults();
        this.setTaxReturn(taxReturn);
        if (schedule == null) {
            schedule = taxReturn.addLS0006();
        }
        this.viewUpdater = new ViewUpdater(taxReturn, schedule){

            @Override
            public void updateView() throws Exception {
                TaxReturnTaxReturnController.this.setModelLS0006(this.taxReturn, (LS0006)this.schedule);
            }
        };
        this.scheduleElement = schedule;
        this.schedulePlaceholder.getChildren().clear();
        if (this.taxReturnLS0006VBox == null) {
            this.taxReturnLS0006VBox = new TaxReturnLS0006VBox(this);
        }
        this.taxReturnLS0006VBox.setModel(schedule);
        this.schedulePlaceholder.getChildren().add((Object)this.taxReturnLS0006VBox);
        this.schedulePane = this.taxReturnLS0006VBox;
        this.updateSchedule();
        this.businesseventitemsvbox.setEventItemsModel(null);
        this.overalleventitemsvbox.setEventItemsModel(null);
        if (schedule != null && (eventItems = schedule.getBusinessEventItems()) != null) {
            this.businesseventitemsvbox.setEventItemsModel(eventItems);
        }
        this.disableLodge(true);
    }

    public void setModelRDTIS0003(TaxReturn taxReturn, RDTIS0003 schedule) throws Exception {
        EventItems eventItems;
        this.schedulePane = null;
        this.loadGlenixDefaults();
        this.setTaxReturn(taxReturn);
        if (schedule == null) {
            schedule = taxReturn.addRDTIS0003();
        }
        this.viewUpdater = new ViewUpdater(taxReturn, schedule){

            @Override
            public void updateView() throws Exception {
                TaxReturnTaxReturnController.this.setModelRDTIS0003(this.taxReturn, (RDTIS0003)this.schedule);
            }
        };
        this.scheduleElement = schedule;
        this.schedulePlaceholder.getChildren().clear();
        if (this.taxReturnRDTIS0003VBox == null) {
            this.taxReturnRDTIS0003VBox = new TaxReturnRDTIS0003VBox(this);
        }
        this.taxReturnRDTIS0003VBox.setModel(schedule);
        this.schedulePlaceholder.getChildren().add((Object)this.taxReturnRDTIS0003VBox);
        this.schedulePane = this.taxReturnRDTIS0003VBox;
        this.updateSchedule();
        this.businesseventitemsvbox.setEventItemsModel(null);
        this.overalleventitemsvbox.setEventItemsModel(null);
        if (schedule != null && (eventItems = schedule.getBusinessEventItems()) != null) {
            this.businesseventitemsvbox.setEventItemsModel(eventItems);
        }
        this.disableLodge(true);
    }

    public void setModelIEE0003(TaxReturn taxReturn, IEE0003 schedule) throws Exception {
        EventItems eventItems;
        this.schedulePane = null;
        this.loadGlenixDefaults();
        this.setTaxReturn(taxReturn);
        if (schedule == null) {
            schedule = taxReturn.addIEE0003();
        }
        this.viewUpdater = new ViewUpdater(taxReturn, schedule){

            @Override
            public void updateView() throws Exception {
                TaxReturnTaxReturnController.this.setModelIEE0003(this.taxReturn, (IEE0003)this.schedule);
            }
        };
        this.scheduleElement = schedule;
        this.schedulePlaceholder.getChildren().clear();
        if (this.taxReturnIEE0003VBox == null) {
            this.taxReturnIEE0003VBox = new TaxReturnIEE0003VBox(this);
        }
        this.taxReturnIEE0003VBox.setModel(schedule);
        this.schedulePlaceholder.getChildren().add((Object)this.taxReturnIEE0003VBox);
        this.schedulePane = this.taxReturnIEE0003VBox;
        this.updateSchedule();
        this.businesseventitemsvbox.setEventItemsModel(null);
        this.overalleventitemsvbox.setEventItemsModel(null);
        if (schedule != null && (eventItems = schedule.getBusinessEventItems()) != null) {
            this.businesseventitemsvbox.setEventItemsModel(eventItems);
        }
        if ("iee0003".equals(taxReturn.getTaxReturnType())) {
            this.disableLodge(false);
        } else {
            this.disableLodge(true);
        }
    }

    public void setModelFTER0002(TaxReturn taxReturn, FTER0002 fter0002) throws Exception {
        this.schedulePane = null;
        this.loadGlenixDefaults();
        this.setTaxReturn(taxReturn);
        if (fter0002 == null) {
            fter0002 = taxReturn.addFTER0002();
        }
        this.viewUpdater = new ViewUpdater(taxReturn, fter0002){

            @Override
            public void updateView() throws Exception {
                TaxReturnTaxReturnController.this.setModelFTER0002(this.taxReturn, (FTER0002)this.schedule);
            }
        };
        this.scheduleElement = fter0002;
        this.schedulePlaceholder.getChildren().clear();
        if (this.taxReturnFTER0002VBox == null) {
            this.taxReturnFTER0002VBox = new TaxReturnFTER0002VBox(this);
        }
        this.taxReturnFTER0002VBox.setModel(fter0002);
        this.schedulePlaceholder.getChildren().add((Object)this.taxReturnFTER0002VBox);
        this.schedulePane = this.taxReturnFTER0002VBox;
        this.updateSchedule();
        this.businesseventitemsvbox.setEventItemsModel(null);
        this.overalleventitemsvbox.setEventItemsModel(null);
        if (fter0002 != null) {
            EventItems eventItems = fter0002.getBusinessEventItems();
            if (eventItems != null) {
                this.businesseventitemsvbox.setEventItemsModel(eventItems);
            }
            if ((eventItems = fter0002.getOverallEventItems()) != null) {
                this.overalleventitemsvbox.setEventItemsModel(eventItems);
            }
        }
        if ("fter0002".equals(taxReturn.getTaxReturnType())) {
            this.disableLodge(false);
        } else {
            this.disableLodge(true);
        }
    }

    public void setModelDDCTNS0001(TaxReturn taxReturn, DDCTNS0001 schedule) throws Exception {
        EventItems eventItems;
        this.schedulePane = null;
        this.loadGlenixDefaults();
        this.setTaxReturn(taxReturn);
        if (schedule == null) {
            schedule = taxReturn.addDDCTNS0001();
        }
        this.viewUpdater = new ViewUpdater(taxReturn, schedule){

            @Override
            public void updateView() throws Exception {
                TaxReturnTaxReturnController.this.setModelDDCTNS0001(this.taxReturn, (DDCTNS0001)this.schedule);
            }
        };
        this.scheduleElement = schedule;
        this.schedulePlaceholder.getChildren().clear();
        if (this.taxReturnDDCTNS0001VBox == null) {
            this.taxReturnDDCTNS0001VBox = new TaxReturnDDCTNS0001VBox(this);
        }
        this.taxReturnDDCTNS0001VBox.setModel(schedule);
        this.schedulePlaceholder.getChildren().add((Object)this.taxReturnDDCTNS0001VBox);
        this.schedulePane = this.taxReturnDDCTNS0001VBox;
        this.updateSchedule();
        this.businesseventitemsvbox.setEventItemsModel(null);
        this.overalleventitemsvbox.setEventItemsModel(null);
        if (schedule != null && (eventItems = schedule.getBusinessEventItems()) != null) {
            this.businesseventitemsvbox.setEventItemsModel(eventItems);
        }
        this.disableLodge(true);
    }

    public void setModelRPTTAXPOS0001(TaxReturn taxReturn, RPTTAXPOS0001 schedule) throws Exception {
        EventItems eventItems;
        this.schedulePane = null;
        this.loadGlenixDefaults();
        this.setTaxReturn(taxReturn);
        if (schedule == null) {
            schedule = taxReturn.addRPTTAXPOS0001();
        }
        this.viewUpdater = new ViewUpdater(taxReturn, schedule){

            @Override
            public void updateView() throws Exception {
                TaxReturnTaxReturnController.this.setModelRPTTAXPOS0001(this.taxReturn, (RPTTAXPOS0001)this.schedule);
            }
        };
        this.scheduleElement = schedule;
        this.schedulePlaceholder.getChildren().clear();
        if (this.taxReturnRPTTAXPOS0001VBox == null) {
            this.taxReturnRPTTAXPOS0001VBox = new TaxReturnRPTTAXPOS0001VBox(this);
        }
        this.taxReturnRPTTAXPOS0001VBox.setModel(schedule);
        this.schedulePlaceholder.getChildren().add((Object)this.taxReturnRPTTAXPOS0001VBox);
        this.schedulePane = this.taxReturnRPTTAXPOS0001VBox;
        this.updateSchedule();
        this.businesseventitemsvbox.setEventItemsModel(null);
        this.overalleventitemsvbox.setEventItemsModel(null);
        if (schedule != null && (eventItems = schedule.getBusinessEventItems()) != null) {
            this.businesseventitemsvbox.setEventItemsModel(eventItems);
        }
        this.disableLodge(true);
    }

    @Override
    public void buildGlenixXBRL(Document resultDoc, Element resultElement) throws Exception {
        Element xbrlEl = resultDoc.createElementNS("http://www.glenix.com.au/", "gx:glenix");
        if (resultElement == null) {
            resultDoc.appendChild(xbrlEl);
        } else {
            resultElement.appendChild(xbrlEl);
        }
        Element businessEl = resultDoc.createElementNS("http://www.glenix.com.au/", "gx:business");
        xbrlEl.appendChild(businessEl);
        super.buildGlenixXBRL(resultDoc, businessEl);
    }

    @Override
    public void loadGlenixXBRL(Document loadDoc, Element loadElement) throws Exception {
        if (loadElement.getNamespaceURI() != null && loadElement.getNamespaceURI().equals("http://www.glenix.com.au/") && loadElement.getLocalName() != null && loadElement.getLocalName().equals("glenix")) {
            NodeList nodeList = loadElement.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element businessElement;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || (businessElement = (Element)node).getNamespaceURI() == null || !businessElement.getNamespaceURI().equals("http://www.glenix.com.au/") || businessElement.getLocalName() == null || !businessElement.getLocalName().equals("business")) continue;
                NodeList nodeList2 = businessElement.getChildNodes();
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    Node node2 = nodeList2.item(j);
                    if (node2.getNodeType() != 1) continue;
                    Element el = (Element)node2;
                    super.loadGlenixXBRL(loadDoc, el);
                }
            }
        }
    }

    private void taxReturnSaveModel() throws Exception {
        this.xbrlFileController.saveTaxReturn();
    }

    private void saveTaxReturnE() throws Exception {
        String status = this.taxReturn.getTaxReturnStatus();
        if (status != null && status.equals("lodge_complete")) {
            throw new Exception("Error, the Tax return is lodged you cannot modify it.");
        }
        this.taxReturn.setTaxReturnStatus("created");
        ZoneId zoneIdUTC = ZoneId.of("UTC");
        ZonedDateTime now = ZonedDateTime.now(zoneIdUTC);
        String dateTime = DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(now);
        this.taxReturnDateTime.setGlenixElementValue(dateTime);
        this.taxReturn.setTaxReturnDateTime(dateTime);
        this.taxReturn.setStartDate(this.startDate.getGlenixElementValue());
        this.taxReturn.setEndDate(this.endDate.getGlenixElementValue());
        String yearStr = this.year.getGlenixElementValue();
        this.taxReturn.setYear(yearStr);
        this.taxReturn.setTaxReturnCertAlias(this.ausKeyCombo.getGlenixElementValue());
        Document doc = this.dBuilder.newDocument();
        GlenixController scheduleController = this.schedulePane.getGlenixController();
        if (scheduleController == null) {
            throw new Exception("Error, cannot save tax return as controller is null");
        }
        scheduleController.buildGlenixXBRL(doc, null);
        this.scheduleElement.loadDocumentElementOverwrite(doc, doc.getDocumentElement());
        this.taxReturnSaveModel();
    }

    @FXML
    public void saveTaxReturn() {
        try {
            this.saveTaxReturnE();
            this.error_message.setText("Saved");
            this.xbrlFileController.setStatusBarMessage("Saved");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    private void deleteThisScheduleE() throws Exception {
        String status = this.taxReturn.getTaxReturnStatus();
        if (status != null && status.equals("lodge_complete")) {
            throw new Exception("Error, the Tax return is lodged you cannot modify it.");
        }
        this.taxReturn.deleteSchedule(this.scheduleElement);
        this.taxReturn.setTaxReturnStatus("created");
        this.xbrlFileController.saveTaxReturn();
    }

    @FXML
    private void deleteThisSchedule() {
        if (this.taxReturn != null) {
            try {
                this.deleteThisScheduleE();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.error_message.setText(e.getLocalizedMessage());
                this.xbrlFileController.setStatusBarMessage(e.getMessage());
            }
        }
        this.xbrlFileController.gotoTaxReturnList();
    }

    @FXML
    private void backToList() {
        this.xbrlFileController.gotoTaxReturnList();
    }

    public void setBusinessDetails(BusinessMasterFile businessMasterFile) {
        String status = this.taxReturnStatus.getGlenixElementValue();
        if (status == null || !status.equals("lodge_complete")) {
            this.schedulePane.setBusinessDetails(businessMasterFile);
        }
    }

    public void setProfileDetails(Profile profileXBRL) {
        this.profileXBRL = profileXBRL;
        String status = this.taxReturnStatus.getGlenixElementValue();
        if (status == null || !status.equals("lodge_complete")) {
            this.schedulePane.setProfileDetails(profileXBRL);
        }
    }

    public void prelodgeLodgeTaxReturn(String action, String initialMessage) {
        if (this.taxReturn == null) {
            this.xbrlFileController.setStatusBarMessage("Error, tax return is null, save first.");
            this.error_message.setText("Error, tax return is null, save first.");
            return;
        }
        this.lodgeButton.disableProperty().set(true);
        this.prelodgeButton.disableProperty().set(true);
        String status = null;
        status = this.taxReturn.getTaxReturnStatus();
        if (status != null && status.equals("lodge_complete")) {
            this.error_message.setText("Error, the document has been lodged you cannot relodge it");
            this.xbrlFileController.setStatusBarMessage("Error, the document has been lodged you cannot relodge it");
            this.lodgeButton.disableProperty().set(false);
            this.prelodgeButton.disableProperty().set(false);
            return;
        }
        if (status != null && (status.equals("prelodge_in_progress") || status.equals("lodge_in_progress"))) {
            this.error_message.setText("Error, lodge or prelodge is in progress please wait");
            this.xbrlFileController.setStatusBarMessage("Error, lodge or prelodge is in progress please wait");
            this.lodgeButton.disableProperty().set(false);
            this.prelodgeButton.disableProperty().set(false);
            return;
        }
        this.error_message.setText(null);
        this.xbrlFileController.setStatusBarMessage(initialMessage);
        this.taxReturn.removeEventMessages();
        try {
            if (action != null && action.equals("lodge")) {
                this.taxReturn.setTaxReturnStatus("lodge_in_progress");
                this.taxReturnStatus.setGlenixElementValue("lodge_in_progress");
            } else {
                this.taxReturn.setTaxReturnStatus("prelodge_in_progress");
                this.taxReturnStatus.setGlenixElementValue("prelodge_in_progress");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
            this.lodgeButton.disableProperty().set(false);
            this.prelodgeButton.disableProperty().set(false);
            return;
        }
        try {
            this.saveTaxReturnE();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
            this.lodgeButton.disableProperty().set(false);
            this.prelodgeButton.disableProperty().set(false);
            return;
        }
        try {
            String credentialId = this.ausKeyCombo.getGlenixElementValue();
            String password = this.password.getText();
            this.password.setText(null);
            GlenixElement ge = this.scheduleElement;
            this.lodge(this.taxReturn, this.scheduleElement, action, credentialId, password);
            if (this.viewUpdater != null && ge == this.scheduleElement) {
                this.viewUpdater.updateView();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
            this.lodgeButton.disableProperty().set(false);
            this.prelodgeButton.disableProperty().set(false);
            try {
                this.taxReturn.setTaxReturnStatus("created");
                this.saveTaxReturnE();
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
    }

    @FXML
    public void prelodgeTaxReturn() {
        this.prelodgeLodgeTaxReturn("prelodge", "Begin prelodge validation...");
    }

    @FXML
    public void lodgeTaxReturn() {
        this.prelodgeLodgeTaxReturn("lodge", "Begin tax return lodge...");
    }

    protected String generateMessageIdentifier() {
        UUID uuid = UUID.randomUUID();
        return uuid.toString() + "@freeaccountingsoftware.com.au";
    }

    private void lodge(final TaxReturn taxReturn, final GlenixElement scheduleElement, final String action, final String credentialId, final String password) {
        final ApplicationController xbrlFileController = this.xbrlFileController;
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    String maxError;
                    EventItems ei;
                    RPTTAXPOS0001 rpttaxpos0001;
                    IDS0007 ids0007;
                    IDS0006 ids0006;
                    RDTIS0003 rdtis0003;
                    LS0006 ls0006;
                    MessageProcessor mp;
                    MessageDigest md;
                    MessageProcessor mp2;
                    MessageDigest md2;
                    PSS0002 pss0002;
                    CGTS0006 cgts0006;
                    MessageProcessor mp3;
                    MessageDigest md3;
                    GlenixSBRAttachment gatt;
                    int i;
                    MessageProcessor mp4;
                    String year;
                    MessageProcessor mp5;
                    MessageDigest md4;
                    GlenixSBRAttachment gatt2;
                    Platform.runLater(() -> {
                        xbrlFileController.setStatusBarMessage("Begin tax return " + action + "...");
                        TaxReturnTaxReturnController.this.warning_message.setText(null);
                        TaxReturnTaxReturnController.this.warning_message.setVisible(false);
                        TaxReturnTaxReturnController.this.warning_message.setManaged(false);
                    });
                    xbrlFileController.loadAUSKeyCredential(credentialId);
                    xbrlFileController.unprotectAUSKeyCredentialPrivateKey(password);
                    xbrlFileController.extractAUSKeyCredentialX509Certificate();
                    String service = null;
                    String actionCode = null;
                    String tan = null;
                    String agentABN = null;
                    String abn = null;
                    String tfn = null;
                    String defaultPartID = "default";
                    Platform.runLater(() -> xbrlFileController.setStatusBarMessage("Building tax return document..."));
                    HashMap<String, MessageProcessor> messageProcessors = new HashMap<String, MessageProcessor>();
                    MessageProcessor overallMessageProcessor = null;
                    boolean zipattachments = true;
                    int count = 0;
                    boolean hasBase = false;
                    ArrayList<GlenixSBRAttachment> gattl = new ArrayList<GlenixSBRAttachment>();
                    Document attachdoc = taxReturn.buildIITR0005Document();
                    if (attachdoc != null) {
                        ++count;
                        gatt2 = null;
                        if (zipattachments) {
                            gatt2 = new GlenixSBRAttachmentGzip(attachdoc, "Attachment" + count);
                        } else {
                            md4 = xbrlFileController.calculateSHA1Digest(attachdoc.getDocumentElement());
                            gatt2 = new GlenixSBRAttachment(attachdoc, "Attachment" + count, md4);
                        }
                        gatt2.setDocumentName("IITR");
                        gatt2.setDocumentType("BASE");
                        gatt2.setPartID("iitr0005");
                        gatt2.setFilename("iitr0005");
                        gattl.add(gatt2);
                        service = "http://sbr.gov.au/ato/iitr/2018";
                        actionCode = "Validate.005.00";
                        if (action != null && action.equals("lodge")) {
                            actionCode = "Submit.005.00";
                        }
                        tfn = taxReturn.getIITR0005IdentifiersTaxFileNumberIdentifier();
                        tan = taxReturn.getIITR0005AgentIdentifiersTaxAgentNumberIdentifier();
                        agentABN = taxReturn.getIITR0005AgentIdentifiersAustralianBusinessNumberIdentifier();
                        overallMessageProcessor = new MessageProcessor((GlenixElement)taxReturn){

                            @Override
                            public void processMessage(Document doc, Element root) throws Exception {
                                ((TaxReturn)this.glenixElement).loadSBRIITR0005OverallEventItemsDocument(doc, root);
                            }

                            @Override
                            public EventItems getEventItems() {
                                return ((TaxReturn)this.glenixElement).getIITR0005OverallEventItems();
                            }
                        };
                        mp5 = new MessageProcessor((GlenixElement)taxReturn){

                            @Override
                            public void processMessage(Document doc, Element root) throws Exception {
                                ((TaxReturn)this.glenixElement).loadSBRIITR0005BusinessEventItemsDocument(doc, root);
                            }

                            @Override
                            public EventItems getEventItems() {
                                return ((TaxReturn)this.glenixElement).getIITR0005BusinessEventItems();
                            }
                        };
                        messageProcessors.put("iitr0005", mp5);
                        defaultPartID = "iitr0005";
                        hasBase = true;
                    }
                    if ((attachdoc = taxReturn.buildIITR0006Document()) != null) {
                        ++count;
                        gatt2 = null;
                        if (zipattachments) {
                            gatt2 = new GlenixSBRAttachmentGzip(attachdoc, "Attachment" + count);
                        } else {
                            md4 = xbrlFileController.calculateSHA1Digest(attachdoc.getDocumentElement());
                            gatt2 = new GlenixSBRAttachment(attachdoc, "Attachment" + count, md4);
                        }
                        gatt2.setDocumentName("IITR");
                        gatt2.setDocumentType("BASE");
                        gatt2.setPartID("iitr0006");
                        gatt2.setFilename("iitr0006");
                        gattl.add(gatt2);
                        service = "http://sbr.gov.au/ato/iitr/2019";
                        actionCode = "Validate.006.00";
                        if (action != null && action.equals("lodge")) {
                            actionCode = "Submit.006.00";
                        }
                        tfn = taxReturn.getIITR0006IdentifiersTaxFileNumberIdentifier();
                        tan = taxReturn.getIITR0006AgentIdentifiersTaxAgentNumberIdentifier();
                        agentABN = taxReturn.getIITR0006AgentIdentifiersAustralianBusinessNumberIdentifier();
                        overallMessageProcessor = new MessageProcessor((GlenixElement)taxReturn){

                            @Override
                            public void processMessage(Document doc, Element root) throws Exception {
                                ((TaxReturn)this.glenixElement).loadSBRIITR0006OverallEventItemsDocument(doc, root);
                            }

                            @Override
                            public EventItems getEventItems() {
                                return ((TaxReturn)this.glenixElement).getIITR0006OverallEventItems();
                            }
                        };
                        mp5 = new MessageProcessor((GlenixElement)taxReturn){

                            @Override
                            public void processMessage(Document doc, Element root) throws Exception {
                                ((TaxReturn)this.glenixElement).loadSBRIITR0006BusinessEventItemsDocument(doc, root);
                            }

                            @Override
                            public EventItems getEventItems() {
                                return ((TaxReturn)this.glenixElement).getIITR0006BusinessEventItems();
                            }
                        };
                        messageProcessors.put("iitr0006", mp5);
                        defaultPartID = "iitr0006";
                        hasBase = true;
                    }
                    if ((attachdoc = taxReturn.buildCTR0009Document()) != null) {
                        ++count;
                        gatt2 = null;
                        if (zipattachments) {
                            gatt2 = new GlenixSBRAttachmentGzip(attachdoc, "Attachment" + count);
                        } else {
                            md4 = xbrlFileController.calculateSHA1Digest(attachdoc.getDocumentElement());
                            gatt2 = new GlenixSBRAttachment(attachdoc, "Attachment" + count, md4);
                        }
                        gatt2.setDocumentName("CTR");
                        gatt2.setDocumentType("BASE");
                        gatt2.setPartID("ctr0009");
                        gatt2.setFilename("ctr0009");
                        gattl.add(gatt2);
                        service = "http://sbr.gov.au/ato/ctr/2018";
                        actionCode = "Validate.009.00";
                        if (action != null && action.equals("lodge")) {
                            actionCode = "Submit.009.00";
                        }
                        tfn = taxReturn.getCTR0009IdentifiersTaxFileNumberIdentifier();
                        abn = taxReturn.getCTR0009IdentifiersAustralianBusinessNumberIdentifier();
                        tan = taxReturn.getCTR0009AgentIdentifiersTaxAgentNumberIdentifier();
                        agentABN = taxReturn.getCTR0009AgentIdentifiersAustralianBusinessNumberIdentifier();
                        overallMessageProcessor = new MessageProcessor((GlenixElement)taxReturn){

                            @Override
                            public void processMessage(Document doc, Element root) throws Exception {
                                ((TaxReturn)this.glenixElement).loadSBRCTR0009OverallEventItemsDocument(doc, root);
                            }

                            @Override
                            public EventItems getEventItems() {
                                return ((TaxReturn)this.glenixElement).getCTR0009OverallEventItems();
                            }
                        };
                        mp5 = new MessageProcessor((GlenixElement)taxReturn){

                            @Override
                            public void processMessage(Document doc, Element root) throws Exception {
                                ((TaxReturn)this.glenixElement).loadSBRCTR0009BusinessEventItemsDocument(doc, root);
                            }

                            @Override
                            public EventItems getEventItems() {
                                return ((TaxReturn)this.glenixElement).getCTR0009BusinessEventItems();
                            }
                        };
                        messageProcessors.put("ctr0009", mp5);
                        defaultPartID = "ctr0009";
                        hasBase = true;
                    }
                    if ((attachdoc = taxReturn.buildCTR0010Document()) != null) {
                        ++count;
                        gatt2 = null;
                        if (zipattachments) {
                            gatt2 = new GlenixSBRAttachmentGzip(attachdoc, "Attachment" + count);
                        } else {
                            md4 = xbrlFileController.calculateSHA1Digest(attachdoc.getDocumentElement());
                            gatt2 = new GlenixSBRAttachment(attachdoc, "Attachment" + count, md4);
                        }
                        gatt2.setDocumentName("CTR");
                        gatt2.setDocumentType("BASE");
                        gatt2.setPartID("ctr0010");
                        gatt2.setFilename("ctr0010");
                        gattl.add(gatt2);
                        service = "http://sbr.gov.au/ato/ctr/2019";
                        actionCode = "Validate.010.00";
                        if (action != null && action.equals("lodge")) {
                            actionCode = "Submit.010.00";
                        }
                        tfn = taxReturn.getCTR0010IdentifiersTaxFileNumberIdentifier();
                        abn = taxReturn.getCTR0010IdentifiersAustralianBusinessNumberIdentifier();
                        tan = taxReturn.getCTR0010AgentIdentifiersTaxAgentNumberIdentifier();
                        agentABN = taxReturn.getCTR0010AgentIdentifiersAustralianBusinessNumberIdentifier();
                        overallMessageProcessor = new MessageProcessor((GlenixElement)taxReturn){

                            @Override
                            public void processMessage(Document doc, Element root) throws Exception {
                                ((TaxReturn)this.glenixElement).loadSBRCTR0010OverallEventItemsDocument(doc, root);
                            }

                            @Override
                            public EventItems getEventItems() {
                                return ((TaxReturn)this.glenixElement).getCTR0010OverallEventItems();
                            }
                        };
                        mp5 = new MessageProcessor((GlenixElement)taxReturn){

                            @Override
                            public void processMessage(Document doc, Element root) throws Exception {
                                ((TaxReturn)this.glenixElement).loadSBRCTR0010BusinessEventItemsDocument(doc, root);
                            }

                            @Override
                            public EventItems getEventItems() {
                                return ((TaxReturn)this.glenixElement).getCTR0010BusinessEventItems();
                            }
                        };
                        messageProcessors.put("ctr0010", mp5);
                        defaultPartID = "ctr0010";
                        hasBase = true;
                    }
                    if ((attachdoc = taxReturn.buildPTR0007Document()) != null) {
                        ++count;
                        gatt2 = null;
                        if (zipattachments) {
                            gatt2 = new GlenixSBRAttachmentGzip(attachdoc, "Attachment" + count);
                        } else {
                            md4 = xbrlFileController.calculateSHA1Digest(attachdoc.getDocumentElement());
                            gatt2 = new GlenixSBRAttachment(attachdoc, "Attachment" + count, md4);
                        }
                        gatt2.setDocumentName("PTR");
                        gatt2.setDocumentType("BASE");
                        gatt2.setPartID("ptr0007");
                        gatt2.setFilename("ptr0007");
                        gattl.add(gatt2);
                        year = taxReturn.getYear();
                        service = year.equals("2019") ? "http://sbr.gov.au/ato/ptr/2019" : "http://sbr.gov.au/ato/ptr/2018";
                        actionCode = "Validate.007.00";
                        if (action != null && action.equals("lodge")) {
                            actionCode = "Submit.007.00";
                        }
                        tfn = taxReturn.getPTR0007IdentifiersTaxFileNumberIdentifier();
                        abn = taxReturn.getPTR0007IdentifiersAustralianBusinessNumberIdentifier();
                        tan = taxReturn.getPTR0007AgentIdentifiersTaxAgentNumberIdentifier();
                        agentABN = taxReturn.getPTR0007AgentIdentifiersAustralianBusinessNumberIdentifier();
                        overallMessageProcessor = new MessageProcessor((GlenixElement)taxReturn){

                            @Override
                            public void processMessage(Document doc, Element root) throws Exception {
                                ((TaxReturn)this.glenixElement).loadSBRPTR0007OverallEventItemsDocument(doc, root);
                            }

                            @Override
                            public EventItems getEventItems() {
                                return ((TaxReturn)this.glenixElement).getPTR0007OverallEventItems();
                            }
                        };
                        mp4 = new MessageProcessor((GlenixElement)taxReturn){

                            @Override
                            public void processMessage(Document doc, Element root) throws Exception {
                                ((TaxReturn)this.glenixElement).loadSBRPTR0007BusinessEventItemsDocument(doc, root);
                            }

                            @Override
                            public EventItems getEventItems() {
                                return ((TaxReturn)this.glenixElement).getPTR0007BusinessEventItems();
                            }
                        };
                        messageProcessors.put("ptr0007", mp4);
                        defaultPartID = "ptr0007";
                        hasBase = true;
                    }
                    if ((attachdoc = taxReturn.buildTRT0007Document()) != null) {
                        ++count;
                        gatt2 = null;
                        if (zipattachments) {
                            gatt2 = new GlenixSBRAttachmentGzip(attachdoc, "Attachment" + count);
                        } else {
                            md4 = xbrlFileController.calculateSHA1Digest(attachdoc.getDocumentElement());
                            gatt2 = new GlenixSBRAttachment(attachdoc, "Attachment" + count, md4);
                        }
                        gatt2.setDocumentName("TRT");
                        gatt2.setDocumentType("BASE");
                        gatt2.setPartID("trt0007");
                        gatt2.setFilename("trt0007");
                        gattl.add(gatt2);
                        year = taxReturn.getYear();
                        service = year.equals("2019") ? "http://sbr.gov.au/ato/trt/2019" : "http://sbr.gov.au/ato/trt/2018";
                        actionCode = "Validate.007.00";
                        if (action != null && action.equals("lodge")) {
                            actionCode = "Submit.007.00";
                        }
                        tfn = taxReturn.getTRT0007IdentifiersTaxFileNumberIdentifier();
                        abn = taxReturn.getTRT0007IdentifiersAustralianBusinessNumberIdentifier();
                        tan = taxReturn.getTRT0007AgentIdentifiersTaxAgentNumberIdentifier();
                        agentABN = taxReturn.getTRT0007AgentIdentifiersAustralianBusinessNumberIdentifier();
                        overallMessageProcessor = new MessageProcessor((GlenixElement)taxReturn){

                            @Override
                            public void processMessage(Document doc, Element root) throws Exception {
                                ((TaxReturn)this.glenixElement).loadSBRTRT0007OverallEventItemsDocument(doc, root);
                            }

                            @Override
                            public EventItems getEventItems() {
                                return ((TaxReturn)this.glenixElement).getTRT0007OverallEventItems();
                            }
                        };
                        mp4 = new MessageProcessor((GlenixElement)taxReturn){

                            @Override
                            public void processMessage(Document doc, Element root) throws Exception {
                                ((TaxReturn)this.glenixElement).loadSBRTRT0007BusinessEventItemsDocument(doc, root);
                            }

                            @Override
                            public EventItems getEventItems() {
                                return ((TaxReturn)this.glenixElement).getTRT0007BusinessEventItems();
                            }
                        };
                        messageProcessors.put("trt0007", mp4);
                        defaultPartID = "trt0007";
                        hasBase = true;
                    }
                    if ((attachdoc = taxReturn.buildSMSF0008Document()) != null) {
                        ++count;
                        gatt2 = null;
                        if (zipattachments) {
                            gatt2 = new GlenixSBRAttachmentGzip(attachdoc, "Attachment" + count);
                        } else {
                            md4 = xbrlFileController.calculateSHA1Digest(attachdoc.getDocumentElement());
                            gatt2 = new GlenixSBRAttachment(attachdoc, "Attachment" + count, md4);
                        }
                        gatt2.setDocumentName("SMSFAR");
                        gatt2.setDocumentType("BASE");
                        gatt2.setPartID("smsf0008");
                        gatt2.setFilename("smsf0008");
                        gattl.add(gatt2);
                        service = "http://sbr.gov.au/ato/smsfar/2018";
                        actionCode = "Validate.008.00";
                        if (action != null && action.equals("lodge")) {
                            actionCode = "Submit.008.00";
                        }
                        tfn = taxReturn.getSMSF0008IdentifiersTaxFileNumberIdentifier();
                        abn = taxReturn.getSMSF0008IdentifiersAustralianBusinessNumberIdentifier();
                        tan = taxReturn.getSMSF0008AgentIdentifiersTaxAgentNumberIdentifier();
                        agentABN = taxReturn.getSMSF0008AgentIdentifiersAustralianBusinessNumberIdentifier();
                        overallMessageProcessor = new MessageProcessor((GlenixElement)taxReturn){

                            @Override
                            public void processMessage(Document doc, Element root) throws Exception {
                                ((TaxReturn)this.glenixElement).loadSBRSMSF0008OverallEventItemsDocument(doc, root);
                            }

                            @Override
                            public EventItems getEventItems() {
                                return ((TaxReturn)this.glenixElement).getSMSF0008OverallEventItems();
                            }
                        };
                        mp5 = new MessageProcessor((GlenixElement)taxReturn){

                            @Override
                            public void processMessage(Document doc, Element root) throws Exception {
                                ((TaxReturn)this.glenixElement).loadSBRSMSF0008BusinessEventItemsDocument(doc, root);
                            }

                            @Override
                            public EventItems getEventItems() {
                                return ((TaxReturn)this.glenixElement).getSMSF0008BusinessEventItems();
                            }
                        };
                        messageProcessors.put("smsf0008", mp5);
                        defaultPartID = "smsf0008";
                        hasBase = true;
                    }
                    if ((attachdoc = taxReturn.buildSMSF0009Document()) != null) {
                        ++count;
                        gatt2 = null;
                        if (zipattachments) {
                            gatt2 = new GlenixSBRAttachmentGzip(attachdoc, "Attachment" + count);
                        } else {
                            md4 = xbrlFileController.calculateSHA1Digest(attachdoc.getDocumentElement());
                            gatt2 = new GlenixSBRAttachment(attachdoc, "Attachment" + count, md4);
                        }
                        gatt2.setDocumentName("SMSFAR");
                        gatt2.setDocumentType("BASE");
                        gatt2.setPartID("smsf0009");
                        gatt2.setFilename("smsf0009");
                        gattl.add(gatt2);
                        service = "http://sbr.gov.au/ato/smsfar/2019";
                        actionCode = "Validate.009.00";
                        if (action != null && action.equals("lodge")) {
                            actionCode = "Submit.009.00";
                        }
                        tfn = taxReturn.getSMSF0009IdentifiersTaxFileNumberIdentifier();
                        abn = taxReturn.getSMSF0009IdentifiersAustralianBusinessNumberIdentifier();
                        tan = taxReturn.getSMSF0009AgentIdentifiersTaxAgentNumberIdentifier();
                        agentABN = taxReturn.getSMSF0009AgentIdentifiersAustralianBusinessNumberIdentifier();
                        overallMessageProcessor = new MessageProcessor((GlenixElement)taxReturn){

                            @Override
                            public void processMessage(Document doc, Element root) throws Exception {
                                ((TaxReturn)this.glenixElement).loadSBRSMSF0009OverallEventItemsDocument(doc, root);
                            }

                            @Override
                            public EventItems getEventItems() {
                                return ((TaxReturn)this.glenixElement).getSMSF0009OverallEventItems();
                            }
                        };
                        mp5 = new MessageProcessor((GlenixElement)taxReturn){

                            @Override
                            public void processMessage(Document doc, Element root) throws Exception {
                                ((TaxReturn)this.glenixElement).loadSBRSMSF0009BusinessEventItemsDocument(doc, root);
                            }

                            @Override
                            public EventItems getEventItems() {
                                return ((TaxReturn)this.glenixElement).getSMSF0009BusinessEventItems();
                            }
                        };
                        messageProcessors.put("smsf0009", mp5);
                        defaultPartID = "smsf0009";
                        hasBase = true;
                    }
                    if ((attachdoc = taxReturn.buildCGNFT0002Document()) != null) {
                        ++count;
                        gatt2 = null;
                        if (zipattachments) {
                            gatt2 = new GlenixSBRAttachmentGzip(attachdoc, "Attachment" + count);
                        } else {
                            md4 = xbrlFileController.calculateSHA1Digest(attachdoc.getDocumentElement());
                            gatt2 = new GlenixSBRAttachment(attachdoc, "Attachment" + count, md4);
                        }
                        gatt2.setDocumentName("CGNFT");
                        if (hasBase) {
                            gatt2.setDocumentType("SCHEDULE");
                        } else {
                            gatt2.setDocumentType("BASE");
                            service = "http://sbr.gov.au/ato/cgnft/2018";
                            actionCode = "Validate.002.00";
                            if (action != null && action.equals("lodge")) {
                                actionCode = "Submit.002.00";
                            }
                            tfn = taxReturn.getCGNFT0002IdentifiersTaxFileNumberIdentifier();
                            abn = taxReturn.getCGNFT0002IdentifiersAustralianBusinessNumberIdentifier();
                            tan = taxReturn.getCGNFT0002AgentIdentifiersTaxAgentNumberIdentifier();
                            agentABN = taxReturn.getCGNFT0002AgentIdentifiersAustralianBusinessNumberIdentifier();
                            overallMessageProcessor = new MessageProcessor((GlenixElement)taxReturn){

                                @Override
                                public void processMessage(Document doc, Element root) throws Exception {
                                    ((TaxReturn)this.glenixElement).loadSBRCGNFT0002OverallEventItemsDocument(doc, root);
                                }

                                @Override
                                public EventItems getEventItems() {
                                    return ((TaxReturn)this.glenixElement).getCGNFT0002OverallEventItems();
                                }
                            };
                            defaultPartID = "cgnft0002";
                        }
                        gatt2.setPartID("cgnft0002");
                        gatt2.setFilename("cgnft0002");
                        gattl.add(gatt2);
                        mp5 = new MessageProcessor((GlenixElement)taxReturn){

                            @Override
                            public void processMessage(Document doc, Element root) throws Exception {
                                ((TaxReturn)this.glenixElement).loadSBRCGNFT0002BusinessEventItemsDocument(doc, root);
                            }

                            @Override
                            public EventItems getEventItems() {
                                return ((TaxReturn)this.glenixElement).getCGNFT0002BusinessEventItems();
                            }
                        };
                        messageProcessors.put("cgnft0002", mp5);
                        hasBase = true;
                    }
                    if ((attachdoc = taxReturn.buildDIS0003Document(hasBase)) != null) {
                        ++count;
                        gatt2 = null;
                        if (zipattachments) {
                            gatt2 = new GlenixSBRAttachmentGzip(attachdoc, "Attachment" + count);
                        } else {
                            md4 = xbrlFileController.calculateSHA1Digest(attachdoc.getDocumentElement());
                            gatt2 = new GlenixSBRAttachment(attachdoc, "Attachment" + count, md4);
                        }
                        gatt2.setDocumentName("DIS");
                        if (hasBase) {
                            gatt2.setDocumentType("SCHEDULE");
                        } else {
                            gatt2.setDocumentType("BASE");
                            service = "http://sbr.gov.au/ato/dis/2018";
                            actionCode = "Validate.003.00";
                            if (action != null && action.equals("lodge")) {
                                actionCode = "Submit.003.00";
                            }
                            tfn = taxReturn.getDIS0003IdentifiersTaxFileNumberIdentifier();
                            abn = taxReturn.getDIS0003IdentifiersAustralianBusinessNumberIdentifier();
                            tan = taxReturn.getDIS0003AgentIdentifiersTaxAgentNumberIdentifier();
                            agentABN = taxReturn.getDIS0003AgentIdentifiersAustralianBusinessNumberIdentifier();
                            overallMessageProcessor = new MessageProcessor((GlenixElement)taxReturn){

                                @Override
                                public void processMessage(Document doc, Element root) throws Exception {
                                    ((TaxReturn)this.glenixElement).loadSBRDIS0003OverallEventItemsDocument(doc, root);
                                }

                                @Override
                                public EventItems getEventItems() {
                                    return ((TaxReturn)this.glenixElement).getDIS0003OverallEventItems();
                                }
                            };
                            defaultPartID = "dis0003";
                        }
                        gatt2.setPartID("dis0003");
                        gatt2.setFilename("dis0003");
                        gattl.add(gatt2);
                        mp5 = new MessageProcessor((GlenixElement)taxReturn){

                            @Override
                            public void processMessage(Document doc, Element root) throws Exception {
                                ((TaxReturn)this.glenixElement).loadSBRDIS0003BusinessEventItemsDocument(doc, root);
                            }

                            @Override
                            public EventItems getEventItems() {
                                return ((TaxReturn)this.glenixElement).getDIS0003BusinessEventItems();
                            }
                        };
                        messageProcessors.put("dis0003", mp5);
                        hasBase = true;
                    }
                    for (i = 0; i < taxReturn.getIEE0003Count(); ++i) {
                        ++count;
                        IEE0003 iee0003 = taxReturn.getIEE0003(i);
                        Document ieeattachdoc = iee0003.buildIEE0003Document(taxReturn.getStartDate(), taxReturn.getEndDate(), hasBase);
                        gatt = null;
                        if (zipattachments) {
                            gatt = new GlenixSBRAttachmentGzip(ieeattachdoc, "Attachment" + count);
                        } else {
                            md3 = xbrlFileController.calculateSHA1Digest(ieeattachdoc.getDocumentElement());
                            gatt = new GlenixSBRAttachment(ieeattachdoc, "Attachment" + count, md3);
                        }
                        gatt.setDocumentName("IEE");
                        if (hasBase) {
                            gatt.setDocumentType("SCHEDULE");
                        } else {
                            gatt.setDocumentType("BASE");
                            service = "http://sbr.gov.au/ato/iee/2018";
                            actionCode = "Validate.003.00";
                            if (action != null && action.equals("lodge")) {
                                actionCode = "Submit.003.00";
                            }
                            tfn = iee0003.getIdentifiersTaxFileNumberIdentifier();
                            abn = iee0003.getIdentifiersAustralianBusinessNumberIdentifier();
                            tan = iee0003.getAgentIdentifiersTaxAgentNumberIdentifier();
                            agentABN = iee0003.getAgentIdentifiersAustralianBusinessNumberIdentifier();
                            overallMessageProcessor = new MessageProcessor((GlenixElement)iee0003){

                                @Override
                                public void processMessage(Document doc, Element root) throws Exception {
                                    ((IEE0003)this.glenixElement).loadSBROverallEventItemsDocument(doc, root);
                                }

                                @Override
                                public EventItems getEventItems() {
                                    return ((IEE0003)this.glenixElement).getOverallEventItems();
                                }
                            };
                            defaultPartID = "iee0003_" + i;
                        }
                        gatt.setPartID("iee0003_" + i);
                        gatt.setFilename("iee0003_" + i);
                        gattl.add(gatt);
                        mp3 = new MessageProcessor((GlenixElement)iee0003){

                            @Override
                            public void processMessage(Document doc, Element root) throws Exception {
                                ((IEE0003)this.glenixElement).loadSBRBusinessEventItemsDocument(doc, root);
                            }

                            @Override
                            public EventItems getEventItems() {
                                return ((IEE0003)this.glenixElement).getBusinessEventItems();
                            }
                        };
                        messageProcessors.put("iee0003_" + i, mp3);
                        hasBase = true;
                    }
                    for (i = 0; i < taxReturn.getFTER0002Count(); ++i) {
                        ++count;
                        FTER0002 fter0002 = taxReturn.getFTER0002(i);
                        Document fterattachdoc = fter0002.buildFTER0002Document(taxReturn.getStartDate(), taxReturn.getEndDate(), hasBase);
                        gatt = null;
                        if (zipattachments) {
                            gatt = new GlenixSBRAttachmentGzip(fterattachdoc, "Attachment" + count);
                        } else {
                            md3 = xbrlFileController.calculateSHA1Digest(fterattachdoc.getDocumentElement());
                            gatt = new GlenixSBRAttachment(fterattachdoc, "Attachment" + count, md3);
                        }
                        gatt.setDocumentName("FTER");
                        if (hasBase) {
                            gatt.setDocumentType("SCHEDULE");
                        } else {
                            gatt.setDocumentType("BASE");
                            service = "http://sbr.gov.au/ato/fter/2018";
                            actionCode = "Validate.002.00";
                            if (action != null && action.equals("lodge")) {
                                actionCode = "Submit.002.00";
                            }
                            tfn = fter0002.getIdentifiersTaxFileNumberIdentifier();
                            abn = fter0002.getIdentifiersAustralianBusinessNumberIdentifier();
                            tan = fter0002.getAgentIdentifiersTaxAgentNumberIdentifier();
                            agentABN = fter0002.getAgentIdentifiersAustralianBusinessNumberIdentifier();
                            overallMessageProcessor = new MessageProcessor((GlenixElement)fter0002){

                                @Override
                                public void processMessage(Document doc, Element root) throws Exception {
                                    ((FTER0002)this.glenixElement).loadSBROverallEventItemsDocument(doc, root);
                                }

                                @Override
                                public EventItems getEventItems() {
                                    return ((FTER0002)this.glenixElement).getOverallEventItems();
                                }
                            };
                            defaultPartID = "fter0002_" + i;
                        }
                        gatt.setPartID("fter0002_" + i);
                        gatt.setFilename("fter0002_" + i);
                        gattl.add(gatt);
                        mp3 = new MessageProcessor((GlenixElement)fter0002){

                            @Override
                            public void processMessage(Document doc, Element root) throws Exception {
                                ((FTER0002)this.glenixElement).loadSBRBusinessEventItemsDocument(doc, root);
                            }

                            @Override
                            public EventItems getEventItems() {
                                return ((FTER0002)this.glenixElement).getBusinessEventItems();
                            }
                        };
                        messageProcessors.put("fter0002_" + i, mp3);
                        hasBase = true;
                    }
                    for (i = 0; i < taxReturn.getRS0002Count(); ++i) {
                        ++count;
                        RS0002 rs0002 = taxReturn.getRS0002(i);
                        Document rsattachdoc = rs0002.buildRS0002Document(taxReturn.getStartDate(), taxReturn.getEndDate());
                        GlenixSBRAttachment rsgatt = null;
                        if (zipattachments) {
                            rsgatt = new GlenixSBRAttachmentGzip(rsattachdoc, "Attachment" + count);
                        } else {
                            md3 = xbrlFileController.calculateSHA1Digest(rsattachdoc.getDocumentElement());
                            rsgatt = new GlenixSBRAttachment(rsattachdoc, "Attachment" + count, md3);
                        }
                        rsgatt.setDocumentName("RS");
                        rsgatt.setDocumentType("SCHEDULE");
                        rsgatt.setPartID("rs0002_" + i);
                        rsgatt.setFilename("rs0002_" + i);
                        gattl.add(rsgatt);
                        mp3 = new MessageProcessor((GlenixElement)rs0002){

                            @Override
                            public void processMessage(Document doc, Element root) throws Exception {
                                ((RS0002)this.glenixElement).loadSBRBusinessEventItemsDocument(doc, root);
                            }

                            @Override
                            public EventItems getEventItems() {
                                return ((RS0002)this.glenixElement).getBusinessEventItems();
                            }
                        };
                        messageProcessors.put("rs0002_" + i, mp3);
                    }
                    DDCTNS0001 ddctns0001 = taxReturn.getDDCTNS0001();
                    if (ddctns0001 != null) {
                        ++count;
                        Document cgtsattachdoc = ddctns0001.buildDDCTNS0001Document(taxReturn.getStartDate(), taxReturn.getEndDate());
                        GlenixSBRAttachment ddctnsgatt = null;
                        if (zipattachments) {
                            ddctnsgatt = new GlenixSBRAttachmentGzip(cgtsattachdoc, "Attachment" + count);
                        } else {
                            MessageDigest md5 = xbrlFileController.calculateSHA1Digest(cgtsattachdoc.getDocumentElement());
                            ddctnsgatt = new GlenixSBRAttachment(cgtsattachdoc, "Attachment" + count, md5);
                        }
                        ddctnsgatt.setDocumentName("DDCTNS");
                        ddctnsgatt.setDocumentType("SCHEDULE");
                        ddctnsgatt.setPartID("ddctns0001");
                        ddctnsgatt.setFilename("ddctns0001");
                        gattl.add(ddctnsgatt);
                        MessageProcessor mp6 = new MessageProcessor((GlenixElement)ddctns0001){

                            @Override
                            public void processMessage(Document doc, Element root) throws Exception {
                                ((DDCTNS0001)this.glenixElement).loadSBRBusinessEventItemsDocument(doc, root);
                            }

                            @Override
                            public EventItems getEventItems() {
                                return ((DDCTNS0001)this.glenixElement).getBusinessEventItems();
                            }
                        };
                        messageProcessors.put("ddctns0001", mp6);
                    }
                    if ((cgts0006 = taxReturn.getCGTS0006()) != null) {
                        ++count;
                        Document cgtsattachdoc = cgts0006.buildCGTS0006Document(taxReturn.getStartDate(), taxReturn.getEndDate());
                        GlenixSBRAttachment cgtsgatt = null;
                        if (zipattachments) {
                            cgtsgatt = new GlenixSBRAttachmentGzip(cgtsattachdoc, "Attachment" + count);
                        } else {
                            md3 = xbrlFileController.calculateSHA1Digest(cgtsattachdoc.getDocumentElement());
                            cgtsgatt = new GlenixSBRAttachment(cgtsattachdoc, "Attachment" + count, md3);
                        }
                        cgtsgatt.setDocumentName("CGTS");
                        cgtsgatt.setDocumentType("SCHEDULE");
                        cgtsgatt.setPartID("cgts0006");
                        cgtsgatt.setFilename("cgts0006");
                        gattl.add(cgtsgatt);
                        mp3 = new MessageProcessor((GlenixElement)cgts0006){

                            @Override
                            public void processMessage(Document doc, Element root) throws Exception {
                                ((CGTS0006)this.glenixElement).loadSBRBusinessEventItemsDocument(doc, root);
                            }

                            @Override
                            public EventItems getEventItems() {
                                return ((CGTS0006)this.glenixElement).getBusinessEventItems();
                            }
                        };
                        messageProcessors.put("cgts0006", mp3);
                    }
                    if ((pss0002 = taxReturn.getPSS0002()) != null) {
                        ++count;
                        Document pssattachdoc = pss0002.buildPSS0002Document(taxReturn.getStartDate(), taxReturn.getEndDate());
                        GlenixSBRAttachment pssgatt = null;
                        if (zipattachments) {
                            pssgatt = new GlenixSBRAttachmentGzip(pssattachdoc, "Attachment" + count);
                        } else {
                            MessageDigest md6 = xbrlFileController.calculateSHA1Digest(pssattachdoc.getDocumentElement());
                            pssgatt = new GlenixSBRAttachment(pssattachdoc, "Attachment" + count, md6);
                        }
                        pssgatt.setDocumentName("PSS");
                        pssgatt.setDocumentType("SCHEDULE");
                        pssgatt.setPartID("pss0002");
                        pssgatt.setFilename("pss0002");
                        gattl.add(pssgatt);
                        MessageProcessor mp7 = new MessageProcessor((GlenixElement)pss0002){

                            @Override
                            public void processMessage(Document doc, Element root) throws Exception {
                                ((PSS0002)this.glenixElement).loadSBRBusinessEventItemsDocument(doc, root);
                            }

                            @Override
                            public EventItems getEventItems() {
                                return ((PSS0002)this.glenixElement).getBusinessEventItems();
                            }
                        };
                        messageProcessors.put("pss0002", mp7);
                    }
                    for (int i2 = 0; i2 < taxReturn.getDIDS0002Count(); ++i2) {
                        ++count;
                        DIDS0002 dids0002 = taxReturn.getDIDS0002(i2);
                        Document didsattachdoc = dids0002.buildDIDS0002Document(taxReturn.getStartDate(), taxReturn.getEndDate());
                        GlenixSBRAttachment didsgatt = null;
                        if (zipattachments) {
                            didsgatt = new GlenixSBRAttachmentGzip(didsattachdoc, "Attachment" + count);
                        } else {
                            md2 = xbrlFileController.calculateSHA1Digest(didsattachdoc.getDocumentElement());
                            didsgatt = new GlenixSBRAttachment(didsattachdoc, "Attachment" + count, md2);
                        }
                        didsgatt.setDocumentName("DIDS");
                        didsgatt.setDocumentType("SCHEDULE");
                        didsgatt.setPartID("dids0002");
                        didsgatt.setFilename("dids0002");
                        gattl.add(didsgatt);
                        mp2 = new MessageProcessor((GlenixElement)dids0002){

                            @Override
                            public void processMessage(Document doc, Element root) throws Exception {
                                ((DIDS0002)this.glenixElement).loadSBRBusinessEventItemsDocument(doc, root);
                            }

                            @Override
                            public EventItems getEventItems() {
                                return ((DIDS0002)this.glenixElement).getBusinessEventItems();
                            }
                        };
                        messageProcessors.put("dids0002", mp2);
                    }
                    WRE0003 wre0003 = taxReturn.getWRE0003();
                    if (wre0003 != null) {
                        ++count;
                        Document wreattachdoc = wre0003.buildWRE0003Document(taxReturn.getStartDate(), taxReturn.getEndDate());
                        GlenixSBRAttachment wregatt = null;
                        if (zipattachments) {
                            wregatt = new GlenixSBRAttachmentGzip(wreattachdoc, "Attachment" + count);
                        } else {
                            MessageDigest md7 = xbrlFileController.calculateSHA1Digest(wreattachdoc.getDocumentElement());
                            wregatt = new GlenixSBRAttachment(wreattachdoc, "Attachment" + count, md7);
                        }
                        wregatt.setDocumentName("WRE");
                        wregatt.setDocumentType("SCHEDULE");
                        wregatt.setPartID("wre0003");
                        wregatt.setFilename("wre0003");
                        gattl.add(wregatt);
                        MessageProcessor mp8 = new MessageProcessor((GlenixElement)wre0003){

                            @Override
                            public void processMessage(Document doc, Element root) throws Exception {
                                ((WRE0003)this.glenixElement).loadSBRBusinessEventItemsDocument(doc, root);
                            }

                            @Override
                            public EventItems getEventItems() {
                                return ((WRE0003)this.glenixElement).getBusinessEventItems();
                            }
                        };
                        messageProcessors.put("wre0003", mp8);
                    }
                    for (int i3 = 0; i3 < taxReturn.getNRFI0002Count(); ++i3) {
                        ++count;
                        NRFI0002 nrfi0002 = taxReturn.getNRFI0002(i3);
                        Document nrfiattachdoc = nrfi0002.buildNRFI0002Document(taxReturn.getStartDate(), taxReturn.getEndDate());
                        GlenixSBRAttachment nrfigatt = null;
                        if (zipattachments) {
                            nrfigatt = new GlenixSBRAttachmentGzip(nrfiattachdoc, "Attachment" + count);
                        } else {
                            md = xbrlFileController.calculateSHA1Digest(nrfiattachdoc.getDocumentElement());
                            nrfigatt = new GlenixSBRAttachment(nrfiattachdoc, "Attachment" + count, md);
                        }
                        nrfigatt.setDocumentName("NRFI");
                        nrfigatt.setDocumentType("SCHEDULE");
                        nrfigatt.setPartID("nrfi0002_" + i3);
                        nrfigatt.setFilename("nrfi0002_" + i3);
                        gattl.add(nrfigatt);
                        mp = new MessageProcessor((GlenixElement)nrfi0002){

                            @Override
                            public void processMessage(Document doc, Element root) throws Exception {
                                ((NRFI0002)this.glenixElement).loadSBRBusinessEventItemsDocument(doc, root);
                            }

                            @Override
                            public EventItems getEventItems() {
                                return ((NRFI0002)this.glenixElement).getBusinessEventItems();
                            }
                        };
                        messageProcessors.put("nrfi0002_" + i3, mp);
                    }
                    CGLS0006 cgls0006 = taxReturn.getCGLS0006();
                    if (cgls0006 != null) {
                        ++count;
                        Document cglsattachdoc = cgls0006.buildCGLS0006Document(taxReturn.getStartDate(), taxReturn.getEndDate());
                        GlenixSBRAttachment cglsgatt = null;
                        if (zipattachments) {
                            cglsgatt = new GlenixSBRAttachmentGzip(cglsattachdoc, "Attachment" + count);
                        } else {
                            md2 = xbrlFileController.calculateSHA1Digest(cglsattachdoc.getDocumentElement());
                            cglsgatt = new GlenixSBRAttachment(cglsattachdoc, "Attachment" + count, md2);
                        }
                        cglsgatt.setDocumentName("CGLS");
                        cglsgatt.setDocumentType("SCHEDULE");
                        cglsgatt.setPartID("cgls0006");
                        cglsgatt.setFilename("cgls0006");
                        gattl.add(cglsgatt);
                        mp2 = new MessageProcessor((GlenixElement)cgls0006){

                            @Override
                            public void processMessage(Document doc, Element root) throws Exception {
                                ((CGLS0006)this.glenixElement).loadSBRBusinessEventItemsDocument(doc, root);
                            }

                            @Override
                            public EventItems getEventItems() {
                                return ((CGLS0006)this.glenixElement).getBusinessEventItems();
                            }
                        };
                        messageProcessors.put("cgls0006", mp2);
                    }
                    if ((ls0006 = taxReturn.getLS0006()) != null) {
                        ++count;
                        Document lsattachdoc = ls0006.buildLS0006Document(taxReturn.getStartDate(), taxReturn.getEndDate());
                        GlenixSBRAttachment lsgatt = null;
                        if (zipattachments) {
                            lsgatt = new GlenixSBRAttachmentGzip(lsattachdoc, "Attachment" + count);
                        } else {
                            md = xbrlFileController.calculateSHA1Digest(lsattachdoc.getDocumentElement());
                            lsgatt = new GlenixSBRAttachment(lsattachdoc, "Attachment" + count, md);
                        }
                        lsgatt.setDocumentName("LS");
                        lsgatt.setDocumentType("SCHEDULE");
                        lsgatt.setPartID("ls0006");
                        lsgatt.setFilename("ls0006");
                        gattl.add(lsgatt);
                        mp = new MessageProcessor((GlenixElement)ls0006){

                            @Override
                            public void processMessage(Document doc, Element root) throws Exception {
                                ((LS0006)this.glenixElement).loadSBRBusinessEventItemsDocument(doc, root);
                            }

                            @Override
                            public EventItems getEventItems() {
                                return ((LS0006)this.glenixElement).getBusinessEventItems();
                            }
                        };
                        messageProcessors.put("ls0006", mp);
                    }
                    if ((rdtis0003 = taxReturn.getRDTIS0003()) != null) {
                        ++count;
                        Document rdtisattachdoc = rdtis0003.buildRDTIS0003Document(taxReturn.getStartDate(), taxReturn.getEndDate());
                        GlenixSBRAttachment rdtisgatt = null;
                        if (zipattachments) {
                            rdtisgatt = new GlenixSBRAttachmentGzip(rdtisattachdoc, "Attachment" + count);
                        } else {
                            MessageDigest md8 = xbrlFileController.calculateSHA1Digest(rdtisattachdoc.getDocumentElement());
                            rdtisgatt = new GlenixSBRAttachment(rdtisattachdoc, "Attachment" + count, md8);
                        }
                        rdtisgatt.setDocumentName("RDTIS");
                        rdtisgatt.setDocumentType("SCHEDULE");
                        rdtisgatt.setPartID("rdtis0003");
                        rdtisgatt.setFilename("rdtis0003");
                        gattl.add(rdtisgatt);
                        MessageProcessor mp9 = new MessageProcessor((GlenixElement)rdtis0003){

                            @Override
                            public void processMessage(Document doc, Element root) throws Exception {
                                ((RDTIS0003)this.glenixElement).loadSBRBusinessEventItemsDocument(doc, root);
                            }

                            @Override
                            public EventItems getEventItems() {
                                return ((RDTIS0003)this.glenixElement).getBusinessEventItems();
                            }
                        };
                        messageProcessors.put("rdtis0003", mp9);
                    }
                    if ((ids0006 = taxReturn.getIDS0006()) != null) {
                        ++count;
                        Document idsattachdoc = ids0006.buildIDS0006Document(taxReturn.getStartDate(), taxReturn.getEndDate());
                        GlenixSBRAttachment idsgatt = null;
                        if (zipattachments) {
                            idsgatt = new GlenixSBRAttachmentGzip(idsattachdoc, "Attachment" + count);
                        } else {
                            MessageDigest md9 = xbrlFileController.calculateSHA1Digest(idsattachdoc.getDocumentElement());
                            idsgatt = new GlenixSBRAttachment(idsattachdoc, "Attachment" + count, md9);
                        }
                        idsgatt.setDocumentName("IDS");
                        idsgatt.setDocumentType("SCHEDULE");
                        idsgatt.setPartID("ids0006");
                        idsgatt.setFilename("ids0006");
                        gattl.add(idsgatt);
                        MessageProcessor mp10 = new MessageProcessor((GlenixElement)ids0006){

                            @Override
                            public void processMessage(Document doc, Element root) throws Exception {
                                ((IDS0006)this.glenixElement).loadSBRBusinessEventItemsDocument(doc, root);
                            }

                            @Override
                            public EventItems getEventItems() {
                                return ((IDS0006)this.glenixElement).getBusinessEventItems();
                            }
                        };
                        messageProcessors.put("ids0006", mp10);
                    }
                    if ((ids0007 = taxReturn.getIDS0007()) != null) {
                        ++count;
                        Document idsattachdoc = ids0007.buildIDS0007Document(taxReturn.getStartDate(), taxReturn.getEndDate());
                        GlenixSBRAttachment idsgatt = null;
                        if (zipattachments) {
                            idsgatt = new GlenixSBRAttachmentGzip(idsattachdoc, "Attachment" + count);
                        } else {
                            MessageDigest md10 = xbrlFileController.calculateSHA1Digest(idsattachdoc.getDocumentElement());
                            idsgatt = new GlenixSBRAttachment(idsattachdoc, "Attachment" + count, md10);
                        }
                        idsgatt.setDocumentName("IDS");
                        idsgatt.setDocumentType("SCHEDULE");
                        idsgatt.setPartID("ids0007");
                        idsgatt.setFilename("ids0007");
                        gattl.add(idsgatt);
                        MessageProcessor mp11 = new MessageProcessor((GlenixElement)ids0007){

                            @Override
                            public void processMessage(Document doc, Element root) throws Exception {
                                ((IDS0007)this.glenixElement).loadSBRBusinessEventItemsDocument(doc, root);
                            }

                            @Override
                            public EventItems getEventItems() {
                                return ((IDS0007)this.glenixElement).getBusinessEventItems();
                            }
                        };
                        messageProcessors.put("ids0007", mp11);
                    }
                    if ((rpttaxpos0001 = taxReturn.getRPTTAXPOS0001()) != null) {
                        ++count;
                        Document rpttaxposattachdoc = rpttaxpos0001.buildRPTTAXPOS0001Document(taxReturn.getStartDate(), taxReturn.getEndDate());
                        GlenixSBRAttachment rpttaxposgatt = null;
                        if (zipattachments) {
                            rpttaxposgatt = new GlenixSBRAttachmentGzip(rpttaxposattachdoc, "Attachment" + count);
                        } else {
                            MessageDigest md11 = xbrlFileController.calculateSHA1Digest(rpttaxposattachdoc.getDocumentElement());
                            rpttaxposgatt = new GlenixSBRAttachment(rpttaxposattachdoc, "Attachment" + count, md11);
                        }
                        rpttaxposgatt.setDocumentName("RPTTAXPOS");
                        rpttaxposgatt.setDocumentType("SCHEDULE");
                        rpttaxposgatt.setPartID("rpttaxpos0001");
                        rpttaxposgatt.setFilename("rpttaxpos0001");
                        gattl.add(rpttaxposgatt);
                        MessageProcessor mp12 = new MessageProcessor((GlenixElement)rpttaxpos0001){

                            @Override
                            public void processMessage(Document doc, Element root) throws Exception {
                                ((RPTTAXPOS0001)this.glenixElement).loadSBRBusinessEventItemsDocument(doc, root);
                            }

                            @Override
                            public EventItems getEventItems() {
                                return ((RPTTAXPOS0001)this.glenixElement).getBusinessEventItems();
                            }
                        };
                        messageProcessors.put("rpttaxpos0001", mp12);
                    }
                    taxReturn.setTaxReturnDateTime();
                    String timestamp = taxReturn.getTaxReturnDateTime();
                    taxReturn.generateTaxReturnMessageIdentifier();
                    String messageId = taxReturn.getTaxReturnMessageIdentifier();
                    String usageMessageID = TaxReturnTaxReturnController.this.generateMessageIdentifier();
                    GlenixResult glenixResult = xbrlFileController.doUsageCheck(tan, agentABN, abn, null, service, actionCode, usageMessageID, messageId, timestamp, -1);
                    String resultCode = null;
                    if (glenixResult != null) {
                        resultCode = glenixResult.getResultCode();
                    }
                    if (resultCode == null) {
                        throw new Exception("Error, unable to check version or license information, cannot lodge");
                    }
                    if (!resultCode.equals("OK")) {
                        if (resultCode.equals("WARNVERSION")) {
                            Platform.runLater(() -> {
                                TaxReturnTaxReturnController.this.warning_message.setText("Warning: There is a new version available please go to www.freeaccountingsoftware.com.au to download the latest version.");
                                TaxReturnTaxReturnController.this.warning_message.setVisible(true);
                                TaxReturnTaxReturnController.this.warning_message.setManaged(true);
                            });
                        } else if (resultCode.equals("WARNLICENSE")) {
                            Platform.runLater(() -> {
                                TaxReturnTaxReturnController.this.warning_message.setText("Warning: " + glenixResult.getResultDescription());
                                TaxReturnTaxReturnController.this.warning_message.setVisible(true);
                                TaxReturnTaxReturnController.this.warning_message.setManaged(true);
                            });
                        } else if (resultCode.equals("WARNING")) {
                            Platform.runLater(() -> {
                                TaxReturnTaxReturnController.this.warning_message.setText("Warning: " + glenixResult.getResultDescription());
                                TaxReturnTaxReturnController.this.warning_message.setVisible(true);
                                TaxReturnTaxReturnController.this.warning_message.setManaged(true);
                            });
                        } else {
                            if (resultCode.equals("ERRORLICENSE")) {
                                throw new Exception("Error, you do not have the required license to perform this lodgement. You may need to contact Free Accounting Software on 1300 113 733.");
                            }
                            if (resultCode.equals("ERRORVERSION")) {
                                throw new Exception("Error, the version of the software you are using is out of date. You need to upgrade first please go to www.freeaccountingsoftware.com.au to download the latest version.");
                            }
                            if (resultCode.equals("ERROR")) {
                                throw new Exception(glenixResult.getResultDescription());
                            }
                            throw new Exception(glenixResult.getResultDescription());
                        }
                    }
                    Platform.runLater(() -> xbrlFileController.setStatusBarMessage("Signing tax return document..."));
                    Node encryptedDataNode = xbrlFileController.buildAndSendSTSDocument();
                    Platform.runLater(() -> xbrlFileController.setStatusBarMessage("Sending tax return to ATO..."));
                    String identifier = taxReturn.getTaxReturnNumber();
                    String logFileName = "TaxReturn_" + identifier + "_prelodge.log";
                    if (action != null && action.equals("lodge")) {
                        logFileName = "TaxReturn_" + identifier + "_lodge.log";
                    }
                    GlenixSBRResponse glenixSBRResponse = xbrlFileController.buildAndSendLodgeDocument(encryptedDataNode, tan, agentABN, abn, null, tfn, service, actionCode, messageId, timestamp, gattl, logFileName);
                    Platform.runLater(() -> xbrlFileController.setStatusBarMessage("Interpreting response from ATO..."));
                    glenixSBRResponse.parseResponse();
                    glenixSBRResponse.resetPartIterator();
                    while (glenixSBRResponse.hasNextPart()) {
                        MessageProcessor mp13;
                        String href = glenixSBRResponse.nextPartHref();
                        if (href == null) continue;
                        String filename = glenixSBRResponse.getPartProperty(href, "filename");
                        String partID = glenixSBRResponse.getPartProperty(href, "PartID");
                        if (href.equals("cid:AttachmentEventSummaryBlock") || filename != null && filename.equals("OverallEventMessage")) {
                            if (overallMessageProcessor == null) continue;
                            Document doc = glenixSBRResponse.getDocumentByHref(href);
                            overallMessageProcessor.processMessage(doc, doc.getDocumentElement());
                            continue;
                        }
                        if (partID == null || partID.isEmpty()) {
                            partID = defaultPartID;
                        }
                        if ((mp13 = (MessageProcessor)messageProcessors.get(partID)) == null) {
                            mp13 = (MessageProcessor)messageProcessors.get(defaultPartID);
                        }
                        if (mp13 == null) continue;
                        Document doc = glenixSBRResponse.getDocumentByHref(href);
                        mp13.processMessage(doc, doc.getDocumentElement());
                    }
                    boolean ok = false;
                    if (overallMessageProcessor != null && (ei = overallMessageProcessor.getEventItems()) != null && (maxError = ei.getMaximumSeverityCode()) != null && (maxError.equals("Information") || maxError.equals("Warning"))) {
                        Platform.runLater(() -> {
                            if (action != null && action.equals("lodge")) {
                                xbrlFileController.setStatusBarMessage("Tax return or schedule lodge complete.");
                            } else {
                                xbrlFileController.setStatusBarMessage("Tax return or schedule prelodge validate complete.");
                            }
                        });
                        ok = true;
                    }
                    String ts = glenixSBRResponse.getTimestamp();
                    taxReturn.setLodgmentReceiptDatetime(ts);
                    String atoMI = glenixSBRResponse.getMessageId();
                    taxReturn.setATOMessageIdentifier(atoMI);
                    if (ok) {
                        if (action != null && action.equals("lodge")) {
                            taxReturn.setTaxReturnStatus("lodge_complete");
                        } else {
                            taxReturn.setTaxReturnStatus("prelodge_complete");
                            Platform.runLater(() -> {
                                TaxReturnTaxReturnController.this.lodgeButton.disableProperty().set(false);
                                TaxReturnTaxReturnController.this.prelodgeButton.disableProperty().set(false);
                            });
                        }
                    } else {
                        Platform.runLater(() -> {
                            xbrlFileController.setStatusBarMessage("An error has occurred please check the messages.");
                            TaxReturnTaxReturnController.this.lodgeButton.disableProperty().set(false);
                            TaxReturnTaxReturnController.this.prelodgeButton.disableProperty().set(false);
                        });
                        taxReturn.setTaxReturnStatus("created");
                    }
                    Platform.runLater(() -> {
                        try {
                            xbrlFileController.saveTaxReturn();
                            if (TaxReturnTaxReturnController.this.viewUpdater != null && TaxReturnTaxReturnController.this.taxReturn == taxReturn && TaxReturnTaxReturnController.this.scheduleElement == scheduleElement) {
                                TaxReturnTaxReturnController.this.viewUpdater.updateView();
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            TaxReturnTaxReturnController.this.error_message.setText(e.getMessage());
                            xbrlFileController.setStatusBarMessage(e.getMessage());
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Platform.runLater(() -> {
                        TaxReturnTaxReturnController.this.error_message.setText(e.getMessage());
                        xbrlFileController.setStatusBarMessage(e.getMessage());
                        try {
                            taxReturn.setTaxReturnStatus("created");
                            TaxReturnTaxReturnController.this.saveTaxReturnE();
                        }
                        catch (Exception ee) {
                            ee.printStackTrace();
                        }
                        TaxReturnTaxReturnController.this.lodgeButton.disableProperty().set(false);
                        TaxReturnTaxReturnController.this.prelodgeButton.disableProperty().set(false);
                    });
                }
                finally {
                    xbrlFileController.reprotectAUSKeyCredentialPrivateKey();
                }
            }
        }).start();
    }

    public void loadGlenixDefaults() {
        try {
            List<GlenixElement> al = this.xbrlFileController.getAUSKeyCredentialList();
            ObservableList ol = FXCollections.observableArrayList(al);
            this.ausKeyCombo.setItems((ObservableList<GlenixElement>)ol);
        }
        catch (Exception e) {
            this.error_message.setText("Error, unable to load AUS key");
            this.xbrlFileController.setStatusBarMessage("Error, unable to load AUS key");
        }
    }

    @Override
    public void displayError(String errorMessage) {
        this.error_message.setText(errorMessage);
        this.xbrlFileController.setStatusBarMessage(errorMessage);
    }

    @Override
    public void doSearch(String searchText) {
        this.xbrlFileController.setSearchText(searchText);
        this.xbrlFileController.searchForText();
    }

    private class MessageProcessor {
        GlenixElement glenixElement;

        public MessageProcessor(GlenixElement glenixElement) {
            this.glenixElement = glenixElement;
        }

        public void processMessage(Document doc, Element root) throws Exception {
            throw new Exception("Process message override this method");
        }

        public EventItems getEventItems() throws Exception {
            System.out.println("Process message override this event items method");
            return null;
        }
    }

    private class ViewUpdater {
        TaxReturn taxReturn;
        GlenixElement schedule;

        public ViewUpdater(TaxReturn taxReturn, GlenixElement schedule) {
            this.taxReturn = taxReturn;
            this.schedule = schedule;
        }

        public void updateView() throws Exception {
            System.out.println("Update view override this method");
        }
    }
}

