/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import au.com.glenix.ApplicationController;
import au.com.glenix.trn.Business;
import au.com.glenix.trn.CGLS0006;
import au.com.glenix.trn.CGNFT0002;
import au.com.glenix.trn.CGTS0006;
import au.com.glenix.trn.CTR0009;
import au.com.glenix.trn.CTR0010;
import au.com.glenix.trn.DDCTNS0001;
import au.com.glenix.trn.DIDS0002;
import au.com.glenix.trn.DIS0003;
import au.com.glenix.trn.FTER0002;
import au.com.glenix.trn.GlenixTrnXBRL;
import au.com.glenix.trn.IDS0006;
import au.com.glenix.trn.IDS0007;
import au.com.glenix.trn.IEE0003;
import au.com.glenix.trn.IITR0005;
import au.com.glenix.trn.IITR0006;
import au.com.glenix.trn.LS0006;
import au.com.glenix.trn.NRFI0002;
import au.com.glenix.trn.PSS0002;
import au.com.glenix.trn.PTR0007;
import au.com.glenix.trn.RDTIS0003;
import au.com.glenix.trn.RPTTAXPOS0001;
import au.com.glenix.trn.RS0002;
import au.com.glenix.trn.SMSF0008;
import au.com.glenix.trn.SMSF0009;
import au.com.glenix.trn.TRT0007;
import au.com.glenix.trn.TaxReturn;
import au.com.glenix.trn.WRE0003;
import au.com.glenix.widget.GlenixBranchController;
import au.com.glenix.widget.GlenixPDFWrapper;
import au.com.glenix.widget.GlenixPDFWrapperNewPageCallback;
import java.net.URL;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TaxReturnListController
extends GlenixBranchController
implements GlenixPDFWrapperNewPageCallback {
    private DocumentBuilder dBuilder;
    private GlenixTrnXBRL glenixTrnXBRL = null;
    private Business business = null;
    @FXML
    private Label error_message;
    @FXML
    private Label page_heading;
    @FXML
    private TableView<ScheduleItem> taxReturnTable;
    @FXML
    private TableColumn yearColumn;
    @FXML
    private TableColumn taxReturnNumberColumn;
    @FXML
    private TableColumn taxReturnTypeColumn;
    @FXML
    private TableColumn descriptionColumn;
    @FXML
    private TableColumn taxReturnStatusColumn;
    private ApplicationController xbrlFileController = null;
    private ObservableList<ScheduleItem> taxReturnObservableList = null;

    public TaxReturnListController(ApplicationController xbrlFileController) {
        this.xbrlFileController = xbrlFileController;
    }

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setNamespaceAware(true);
            this.dBuilder = dbFactory.newDocumentBuilder();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
        }
        this.taxReturnTable.setRowFactory(tv -> {
            TableRow row = new TableRow();
            row.setOnMouseClicked(event -> {
                block34: {
                    if (event.getClickCount() == 2 && !row.isEmpty()) {
                        ScheduleItem scheduleItem = (ScheduleItem)row.getItem();
                        if (scheduleItem != null) {
                            String scheduleType = scheduleItem.getScheduleType();
                            if (scheduleType != null) {
                                try {
                                    if (scheduleType.equals("ctr0009")) {
                                        this.xbrlFileController.gotoTaxReturnCTR0009(scheduleItem.getTaxReturn(), scheduleItem.getCTR0009());
                                        break block34;
                                    }
                                    if (scheduleType.equals("ctr0010")) {
                                        this.xbrlFileController.gotoTaxReturnCTR0010(scheduleItem.getTaxReturn(), scheduleItem.getCTR0010());
                                        break block34;
                                    }
                                    if (scheduleType.equals("iitr0005")) {
                                        this.xbrlFileController.gotoTaxReturnIITR0005(scheduleItem.getTaxReturn(), scheduleItem.getIITR0005());
                                        break block34;
                                    }
                                    if (scheduleType.equals("ptr0007_2019")) {
                                        this.xbrlFileController.gotoTaxReturnPTR0007(scheduleItem.getTaxReturn(), scheduleItem.getPTR0007());
                                        break block34;
                                    }
                                    if (scheduleType.equals("ptr0007")) {
                                        this.xbrlFileController.gotoTaxReturnPTR0007(scheduleItem.getTaxReturn(), scheduleItem.getPTR0007());
                                        break block34;
                                    }
                                    if (scheduleType.equals("trt0007_2019")) {
                                        this.xbrlFileController.gotoTaxReturnTRT0007(scheduleItem.getTaxReturn(), scheduleItem.getTRT0007());
                                        break block34;
                                    }
                                    if (scheduleType.equals("trt0007")) {
                                        this.xbrlFileController.gotoTaxReturnTRT0007(scheduleItem.getTaxReturn(), scheduleItem.getTRT0007());
                                        break block34;
                                    }
                                    if (scheduleType.equals("smsf0008")) {
                                        this.xbrlFileController.gotoTaxReturnSMSF0008(scheduleItem.getTaxReturn(), scheduleItem.getSMSF0008());
                                        break block34;
                                    }
                                    if (scheduleType.equals("smsf0009")) {
                                        this.xbrlFileController.gotoTaxReturnSMSF0009(scheduleItem.getTaxReturn(), scheduleItem.getSMSF0009());
                                        break block34;
                                    }
                                    if (scheduleType.equals("iitr0006")) {
                                        this.xbrlFileController.gotoTaxReturnIITR0006(scheduleItem.getTaxReturn(), scheduleItem.getIITR0006());
                                        break block34;
                                    }
                                    if (scheduleType.equals("rs0002")) {
                                        this.xbrlFileController.gotoTaxReturnRS0002(scheduleItem.getTaxReturn(), scheduleItem.getRS0002());
                                        break block34;
                                    }
                                    if (scheduleType.equals("cgts0006")) {
                                        this.xbrlFileController.gotoTaxReturnCGTS0006(scheduleItem.getTaxReturn(), scheduleItem.getCGTS0006());
                                        break block34;
                                    }
                                    if (scheduleType.equals("dids0002")) {
                                        this.xbrlFileController.gotoTaxReturnDIDS0002(scheduleItem.getTaxReturn(), scheduleItem.getDIDS0002());
                                        break block34;
                                    }
                                    if (scheduleType.equals("nrfi0002")) {
                                        this.xbrlFileController.gotoTaxReturnNRFI0002(scheduleItem.getTaxReturn(), scheduleItem.getNRFI0002());
                                        break block34;
                                    }
                                    if (scheduleType.equals("pss0002")) {
                                        this.xbrlFileController.gotoTaxReturnPSS0002(scheduleItem.getTaxReturn(), scheduleItem.getPSS0002());
                                        break block34;
                                    }
                                    if (scheduleType.equals("wre0003")) {
                                        this.xbrlFileController.gotoTaxReturnWRE0003(scheduleItem.getTaxReturn(), scheduleItem.getWRE0003());
                                        break block34;
                                    }
                                    if (scheduleType.equals("ids0006")) {
                                        this.xbrlFileController.gotoTaxReturnIDS0006(scheduleItem.getTaxReturn(), scheduleItem.getIDS0006());
                                        break block34;
                                    }
                                    if (scheduleType.equals("ids0007")) {
                                        this.xbrlFileController.gotoTaxReturnIDS0007(scheduleItem.getTaxReturn(), scheduleItem.getIDS0007());
                                        break block34;
                                    }
                                    if (scheduleType.equals("cgls0006")) {
                                        this.xbrlFileController.gotoTaxReturnCGLS0006(scheduleItem.getTaxReturn(), scheduleItem.getCGLS0006());
                                        break block34;
                                    }
                                    if (scheduleType.equals("dis0003")) {
                                        this.xbrlFileController.gotoTaxReturnDIS0003(scheduleItem.getTaxReturn(), scheduleItem.getDIS0003());
                                        break block34;
                                    }
                                    if (scheduleType.equals("ls0006")) {
                                        this.xbrlFileController.gotoTaxReturnLS0006(scheduleItem.getTaxReturn(), scheduleItem.getLS0006());
                                        break block34;
                                    }
                                    if (scheduleType.equals("rdtis0003")) {
                                        this.xbrlFileController.gotoTaxReturnRDTIS0003(scheduleItem.getTaxReturn(), scheduleItem.getRDTIS0003());
                                        break block34;
                                    }
                                    if (scheduleType.equals("cgnft0002")) {
                                        this.xbrlFileController.gotoTaxReturnCGNFT0002(scheduleItem.getTaxReturn(), scheduleItem.getCGNFT0002());
                                        break block34;
                                    }
                                    if (scheduleType.equals("iee0003")) {
                                        this.xbrlFileController.gotoTaxReturnIEE0003(scheduleItem.getTaxReturn(), scheduleItem.getIEE0003());
                                        break block34;
                                    }
                                    if (scheduleType.equals("fter0002")) {
                                        this.xbrlFileController.gotoTaxReturnFTER0002(scheduleItem.getTaxReturn(), scheduleItem.getFTER0002());
                                        break block34;
                                    }
                                    if (scheduleType.equals("ddctns0001")) {
                                        this.xbrlFileController.gotoTaxReturnDDCTNS0001(scheduleItem.getTaxReturn(), scheduleItem.getDDCTNS0001());
                                        break block34;
                                    }
                                    if (scheduleType.equals("rpttaxpos0001")) {
                                        this.xbrlFileController.gotoTaxReturnRPTTAXPOS0001(scheduleItem.getTaxReturn(), scheduleItem.getRPTTAXPOS0001());
                                        break block34;
                                    }
                                    this.error_message.setText("Error, could not go to tax return page. Unknown tax return type.");
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                    this.error_message.setText("Error, could not go to tax return page.");
                                }
                            } else {
                                this.error_message.setText("Error, could not get tax return.");
                            }
                        } else {
                            this.error_message.setText("Error, could not get tax return.");
                        }
                    }
                }
            });
            return row;
        });
    }

    @Override
    public void buildGlenixXBRL(Document resultDoc, Element resultElement) throws Exception {
        Element xbrlEl = resultDoc.createElementNS("http://www.glenix.com.au/", "gx:glenix");
        if (resultElement == null) {
            resultDoc.appendChild(xbrlEl);
        } else {
            resultElement.appendChild(xbrlEl);
        }
        Element businessEl = resultDoc.createElementNS("http://www.glenix.com.au/", "gx:business");
        xbrlEl.appendChild(businessEl);
        super.buildGlenixXBRL(resultDoc, businessEl);
    }

    @Override
    public void loadGlenixXBRL(Document loadDoc, Element loadElement) throws Exception {
        if (loadElement.getNamespaceURI() != null && loadElement.getNamespaceURI().equals("http://www.glenix.com.au/") && loadElement.getLocalName() != null && loadElement.getLocalName().equals("glenix")) {
            NodeList nodeList = loadElement.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element businessElement;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || (businessElement = (Element)node).getNamespaceURI() == null || !businessElement.getNamespaceURI().equals("http://www.glenix.com.au/") || businessElement.getLocalName() == null || !businessElement.getLocalName().equals("business")) continue;
                NodeList nodeList2 = businessElement.getChildNodes();
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    Node node2 = nodeList2.item(j);
                    if (node2.getNodeType() != 1) continue;
                    Element el = (Element)node2;
                    super.loadGlenixXBRL(loadDoc, el);
                }
            }
        }
    }

    public void setModel(GlenixTrnXBRL glenixTrnXBRL) throws Exception {
        this.glenixTrnXBRL = glenixTrnXBRL;
        if (glenixTrnXBRL != null) {
            ArrayList<TaxReturn> taxReturnList;
            Document doc = glenixTrnXBRL.buildDocument();
            this.loadGlenixXBRL(doc, doc.getDocumentElement());
            this.business = glenixTrnXBRL.getBusiness();
            if (this.business != null && (taxReturnList = this.business.getTaxReturnArrayList()) != null) {
                ArrayList<ScheduleItem> schedules = new ArrayList<ScheduleItem>();
                for (int i = 0; i < taxReturnList.size(); ++i) {
                    int ii;
                    TaxReturn tr = taxReturnList.get(i);
                    String type = tr.getTaxReturnType();
                    if (type == null) continue;
                    ScheduleItem si = new ScheduleItem(tr, type);
                    if (type.equals("ctr0009")) {
                        si.setCTR0009(tr.getCTR0009());
                    } else if (type.equals("ctr0010")) {
                        si.setCTR0010(tr.getCTR0010());
                    } else if (type.equals("iitr0005")) {
                        si.setIITR0005(tr.getIITR0005());
                    } else if (type.equals("iitr0006")) {
                        si.setIITR0006(tr.getIITR0006());
                    } else if (type.equals("ptr0007_2019")) {
                        si.setPTR0007(tr.getPTR0007());
                    } else if (type.equals("ptr0007")) {
                        si.setPTR0007(tr.getPTR0007());
                    } else if (type.equals("trt0007_2019")) {
                        si.setTRT0007(tr.getTRT0007());
                    } else if (type.equals("trt0007")) {
                        si.setTRT0007(tr.getTRT0007());
                    } else if (type.equals("smsf0008")) {
                        si.setSMSF0008(tr.getSMSF0008());
                    } else if (type.equals("smsf0009")) {
                        si.setSMSF0009(tr.getSMSF0009());
                    } else if (type.equals("cgnft0002")) {
                        si.setCGNFT0002(tr.getCGNFT0002());
                    } else if (type.equals("dis0003")) {
                        si.setDIS0003(tr.getDIS0003());
                    } else if (type.equals("iee0003")) {
                        si.setIEE0003(tr.getIEE0003(0));
                    } else if (type.equals("fter0002")) {
                        si.setFTER0002(tr.getFTER0002(0));
                    }
                    si.setYear(tr.getYear());
                    schedules.add(si);
                    if (type.equals("iitr0006")) {
                        si = new ScheduleItem(tr, "ddctns0001");
                        si.setDDCTNS0001(tr.getDDCTNS0001());
                        schedules.add(si);
                    }
                    for (ii = 0; ii < tr.getRS0002Count(); ++ii) {
                        si = new ScheduleItem(tr, "rs0002");
                        si.setRS0002(tr.getRS0002(ii));
                        schedules.add(si);
                    }
                    if (type.equals("iitr0005") || type.equals("iitr0006") || type.equals("trt0007") || type.equals("trt0007_2019") || type.equals("ptr0007_2019") || type.equals("ptr0007")) {
                        si = new ScheduleItem(tr, "rs0002");
                        schedules.add(si);
                    }
                    if (type.equals("iitr0005") || type.equals("iitr0006") || type.equals("trt0007") || type.equals("trt0007_2019") || type.equals("smsf0008") || type.equals("smsf0009") || type.equals("ctr0009") || type.equals("ctr0010")) {
                        si = new ScheduleItem(tr, "cgts0006");
                        si.setCGTS0006(tr.getCGTS0006());
                        schedules.add(si);
                    }
                    for (ii = 0; ii < tr.getDIDS0002Count(); ++ii) {
                        si = new ScheduleItem(tr, "dids0002");
                        si.setDIDS0002(tr.getDIDS0002(ii));
                        schedules.add(si);
                    }
                    if (type.equals("iitr0005")) {
                        si = new ScheduleItem(tr, "dids0002");
                        schedules.add(si);
                    }
                    for (ii = 0; ii < tr.getNRFI0002Count(); ++ii) {
                        si = new ScheduleItem(tr, "nrfi0002");
                        si.setNRFI0002(tr.getNRFI0002(ii));
                        schedules.add(si);
                    }
                    if (type.equals("iitr0005") || type.equals("iitr0006")) {
                        si = new ScheduleItem(tr, "nrfi0002");
                        schedules.add(si);
                    }
                    if (type.equals("iitr0005") || type.equals("iitr0006") || type.equals("trt0007_2019") || type.equals("trt0007") || type.equals("smsf0008") || type.equals("smsf0009") || type.equals("ctr0009") || type.equals("ctr0010") || type.equals("ptr0007_2019") || type.equals("ptr0007")) {
                        si = new ScheduleItem(tr, "pss0002");
                        si.setPSS0002(tr.getPSS0002());
                        schedules.add(si);
                    }
                    if (type.equals("iitr0005") || type.equals("iitr0006")) {
                        si = new ScheduleItem(tr, "wre0003");
                        si.setWRE0003(tr.getWRE0003());
                        schedules.add(si);
                    }
                    if (type.equals("ptr0007_2019") || type.equals("ptr0007") || type.equals("trt0007_2019") || type.equals("trt0007") || type.equals("ctr0009")) {
                        si = new ScheduleItem(tr, "ids0006");
                        si.setIDS0006(tr.getIDS0006());
                        schedules.add(si);
                    }
                    if (type.equals("ptr0007_2019") || type.equals("trt0007_2019") || type.equals("ptr0008") || type.equals("trt0008") || type.equals("ctr0010")) {
                        si = new ScheduleItem(tr, "ids0007");
                        si.setIDS0007(tr.getIDS0007());
                        schedules.add(si);
                    }
                    if (type.equals("ctr0009") || type.equals("ctr0010")) {
                        si = new ScheduleItem(tr, "cgls0006");
                        si.setCGLS0006(tr.getCGLS0006());
                        schedules.add(si);
                    }
                    if (type.equals("ctr0009") || type.equals("ctr0010")) {
                        si = new ScheduleItem(tr, "dis0003");
                        si.setDIS0003(tr.getDIS0003());
                        schedules.add(si);
                    }
                    if (type.equals("trt0007") || type.equals("trt0007_2019") || type.equals("smsf0008") || type.equals("smsf0009") || type.equals("ctr0009") || type.equals("ctr0010")) {
                        si = new ScheduleItem(tr, "ls0006");
                        si.setLS0006(tr.getLS0006());
                        schedules.add(si);
                    }
                    if (type.equals("ctr0009") || type.equals("ctr0010")) {
                        si = new ScheduleItem(tr, "rdtis0003");
                        si.setRDTIS0003(tr.getRDTIS0003());
                        schedules.add(si);
                    }
                    if (type.equals("ctr0009") || type.equals("ctr0010")) {
                        si = new ScheduleItem(tr, "cgnft0002");
                        si.setCGNFT0002(tr.getCGNFT0002());
                        schedules.add(si);
                    }
                    if (type.equals("trt0007_2019") || type.equals("trt0007") || type.equals("smsf0008") || type.equals("smsf0009") || type.equals("ctr0009") || type.equals("ctr0010") || type.equals("ptr0007_2019") || type.equals("ptr0007")) {
                        for (ii = 0; ii < tr.getIEE0003Count(); ++ii) {
                            si = new ScheduleItem(tr, "iee0003");
                            si.setIEE0003(tr.getIEE0003(ii));
                            schedules.add(si);
                        }
                        si = new ScheduleItem(tr, "iee0003");
                        schedules.add(si);
                    }
                    if (type.equals("trt0007_2019") || type.equals("trt0007") || type.equals("smsf0008") || type.equals("smsf0009")) {
                        for (ii = 0; ii < tr.getFTER0002Count(); ++ii) {
                            si = new ScheduleItem(tr, "fter0002");
                            si.setFTER0002(tr.getFTER0002(ii));
                            schedules.add(si);
                        }
                        si = new ScheduleItem(tr, "fter0002");
                        schedules.add(si);
                    }
                    if (!type.equals("ctr0010")) continue;
                    si = new ScheduleItem(tr, "rpttaxpos0001");
                    si.setRPTTAXPOS0001(tr.getRPTTAXPOS0001());
                    schedules.add(si);
                }
                this.taxReturnObservableList = FXCollections.observableList(schedules);
                this.taxReturnTable.setItems(this.taxReturnObservableList);
                this.taxReturnTable.refresh();
            }
        }
    }

    private void saveTaxReturnList() throws Exception {
        this.xbrlFileController.saveTaxReturn();
    }

    @FXML
    private void cloneTaxReturn() {
        ScheduleItem si = (ScheduleItem)this.taxReturnTable.getSelectionModel().getSelectedItem();
        if (si == null) {
            this.error_message.setText("Error, no tax return is selected");
            this.xbrlFileController.setStatusBarMessage("Error, no tax return is selected");
            return;
        }
        TaxReturn origTR = si.getTaxReturn();
        if (origTR == null) {
            this.error_message.setText("Error, could not find selected tax return");
            this.xbrlFileController.setStatusBarMessage("Error, could not find selected tax return");
            return;
        }
        try {
            TaxReturn newTR = this.business.addBlankTaxReturn();
            String docnumber = newTR.getTaxReturnNumber();
            Document doc = this.dBuilder.newDocument();
            origTR.appendToElement(doc);
            newTR.loadDocumentElement(doc, doc.getDocumentElement());
            newTR.setTaxReturnStatus("created");
            newTR.setTaxReturnNumber(docnumber);
            this.setModel(this.glenixTrnXBRL);
            this.saveTaxReturnList();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    private void addTaxReturnCTR0009() {
        if (this.business == null) {
            this.error_message.setText("Error, need to load file before creating tax return.");
            this.xbrlFileController.setStatusBarMessage("Error, need to load file before creating tax return.");
        }
        try {
            TaxReturn tr = this.business.addBlankTaxReturn();
            tr.setTaxReturnType("ctr0009");
            tr.setYear("2018");
            tr.setStartDate("2017-07-01");
            tr.setEndDate("2018-06-30");
            this.setModel(this.glenixTrnXBRL);
            this.saveTaxReturnList();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    private void addTaxReturnCTR0010() {
        if (this.business == null) {
            this.error_message.setText("Error, need to load file before creating tax return.");
            this.xbrlFileController.setStatusBarMessage("Error, need to load file before creating tax return.");
        }
        try {
            TaxReturn tr = this.business.addBlankTaxReturn();
            tr.setTaxReturnType("ctr0010");
            tr.setYear("2019");
            tr.setStartDate("2018-07-01");
            tr.setEndDate("2019-06-30");
            this.setModel(this.glenixTrnXBRL);
            this.saveTaxReturnList();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    private void addTaxReturnIITR0005() {
        if (this.business == null) {
            this.error_message.setText("Error, need to load file before creating tax return.");
            this.xbrlFileController.setStatusBarMessage("Error, need to load file before creating tax return.");
        }
        try {
            TaxReturn tr = this.business.addBlankTaxReturn();
            tr.setTaxReturnType("iitr0005");
            tr.setYear("2018");
            tr.setStartDate("2017-07-01");
            tr.setEndDate("2018-06-30");
            this.setModel(this.glenixTrnXBRL);
            this.saveTaxReturnList();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    private void addTaxReturnIITR0006() {
        if (this.business == null) {
            this.error_message.setText("Error, need to load file before creating tax return.");
            this.xbrlFileController.setStatusBarMessage("Error, need to load file before creating tax return.");
        }
        try {
            TaxReturn tr = this.business.addBlankTaxReturn();
            tr.setTaxReturnType("iitr0006");
            tr.setYear("2019");
            tr.setStartDate("2018-07-01");
            tr.setEndDate("2019-06-30");
            this.setModel(this.glenixTrnXBRL);
            this.saveTaxReturnList();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    private void addTaxReturnPTR0007() {
        if (this.business == null) {
            this.error_message.setText("Error, need to load file before creating tax return.");
            this.xbrlFileController.setStatusBarMessage("Error, need to load file before creating tax return.");
        }
        try {
            TaxReturn tr = this.business.addBlankTaxReturn();
            tr.setTaxReturnType("ptr0007");
            tr.setYear("2018");
            tr.setStartDate("2017-07-01");
            tr.setEndDate("2018-06-30");
            this.setModel(this.glenixTrnXBRL);
            this.saveTaxReturnList();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    private void addTaxReturnPTR0007_2019() {
        if (this.business == null) {
            this.error_message.setText("Error, need to load file before creating tax return.");
            this.xbrlFileController.setStatusBarMessage("Error, need to load file before creating tax return.");
        }
        try {
            TaxReturn tr = this.business.addBlankTaxReturn();
            tr.setTaxReturnType("ptr0007_2019");
            tr.setYear("2019");
            tr.setStartDate("2018-07-01");
            tr.setEndDate("2019-06-30");
            this.setModel(this.glenixTrnXBRL);
            this.saveTaxReturnList();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    private void addTaxReturnTRT0007() {
        if (this.business == null) {
            this.error_message.setText("Error, need to load file before creating tax return.");
            this.xbrlFileController.setStatusBarMessage("Error, need to load file before creating tax return.");
        }
        try {
            TaxReturn tr = this.business.addBlankTaxReturn();
            tr.setTaxReturnType("trt0007");
            tr.setYear("2018");
            tr.setStartDate("2017-07-01");
            tr.setEndDate("2018-06-30");
            this.setModel(this.glenixTrnXBRL);
            this.saveTaxReturnList();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    private void addTaxReturnTRT0007_2019() {
        if (this.business == null) {
            this.error_message.setText("Error, need to load file before creating tax return.");
            this.xbrlFileController.setStatusBarMessage("Error, need to load file before creating tax return.");
        }
        try {
            TaxReturn tr = this.business.addBlankTaxReturn();
            tr.setTaxReturnType("trt0007_2019");
            tr.setYear("2019");
            tr.setStartDate("2018-07-01");
            tr.setEndDate("2019-06-30");
            this.setModel(this.glenixTrnXBRL);
            this.saveTaxReturnList();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    private void addTaxReturnSMSF0008() {
        if (this.business == null) {
            this.error_message.setText("Error, need to load file before creating tax return.");
            this.xbrlFileController.setStatusBarMessage("Error, need to load file before creating tax return.");
        }
        try {
            TaxReturn tr = this.business.addBlankTaxReturn();
            tr.setTaxReturnType("smsf0008");
            tr.setYear("2018");
            tr.setStartDate("2017-07-01");
            tr.setEndDate("2018-06-30");
            this.setModel(this.glenixTrnXBRL);
            this.saveTaxReturnList();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    private void addTaxReturnSMSF0009() {
        if (this.business == null) {
            this.error_message.setText("Error, need to load file before creating tax return.");
            this.xbrlFileController.setStatusBarMessage("Error, need to load file before creating tax return.");
        }
        try {
            TaxReturn tr = this.business.addBlankTaxReturn();
            tr.setTaxReturnType("smsf0009");
            tr.setYear("2019");
            tr.setStartDate("2018-07-01");
            tr.setEndDate("2019-06-30");
            this.setModel(this.glenixTrnXBRL);
            this.saveTaxReturnList();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    private void addTaxReturnDIS0003() {
        if (this.business == null) {
            this.error_message.setText("Error, need to load file before creating tax return.");
            this.xbrlFileController.setStatusBarMessage("Error, need to load file before creating tax return.");
        }
        try {
            TaxReturn tr = this.business.addBlankTaxReturn();
            tr.setTaxReturnType("dis0003");
            tr.setYear("2019");
            tr.setStartDate("2018-07-01");
            tr.setEndDate("2019-06-30");
            this.setModel(this.glenixTrnXBRL);
            this.saveTaxReturnList();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    private void addTaxReturnCGNFT0002() {
        if (this.business == null) {
            this.error_message.setText("Error, need to load file before creating tax return.");
            this.xbrlFileController.setStatusBarMessage("Error, need to load file before creating tax return.");
        }
        try {
            TaxReturn tr = this.business.addBlankTaxReturn();
            tr.setTaxReturnType("cgnft0002");
            tr.setYear("2019");
            tr.setStartDate("2018-07-01");
            tr.setEndDate("2019-06-30");
            this.setModel(this.glenixTrnXBRL);
            this.saveTaxReturnList();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    private void addTaxReturnIEE0003() {
        if (this.business == null) {
            this.error_message.setText("Error, need to load file before creating document.");
            this.xbrlFileController.setStatusBarMessage("Error, need to load file before creating document.");
        }
        try {
            TaxReturn tr = this.business.addBlankTaxReturn();
            tr.setTaxReturnType("iee0003");
            tr.setYear("2019");
            tr.setStartDate("2018-07-01");
            tr.setEndDate("2019-06-30");
            this.setModel(this.glenixTrnXBRL);
            this.saveTaxReturnList();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    private void addTaxReturnFTER0002() {
        if (this.business == null) {
            this.error_message.setText("Error, need to load file before creating document.");
            this.xbrlFileController.setStatusBarMessage("Error, need to load file before creating document.");
        }
        try {
            TaxReturn tr = this.business.addBlankTaxReturn();
            tr.setTaxReturnType("fter0002");
            tr.setYear("2019");
            tr.setStartDate("2018-07-01");
            tr.setEndDate("2019-06-30");
            this.setModel(this.glenixTrnXBRL);
            this.saveTaxReturnList();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    private void deleteSelectedTaxReturn() {
        if (this.business == null) {
            this.error_message.setText("Error, need to load file before deleting tax return.");
            this.xbrlFileController.setStatusBarMessage("Error, need to load file before deleting tax return.");
        }
        try {
            ScheduleItem si = (ScheduleItem)this.taxReturnTable.getSelectionModel().getSelectedItem();
            if (si != null) {
                TaxReturn tr = si.getTaxReturn();
                this.business.deleteTaxReturn(tr);
                this.setModel(this.glenixTrnXBRL);
                this.saveTaxReturnList();
                this.error_message.setText("Deleted");
                this.xbrlFileController.setStatusBarMessage("Deleted");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @Override
    public GlenixPDFWrapper buildPDF(boolean includeBlanks) throws Exception {
        GlenixPDFWrapper gpw = new GlenixPDFWrapper();
        gpw.addPDPage();
        gpw.setColumns(7);
        gpw.setColumnLeftPosAndWidthMM(0, 20.0, 180.0);
        gpw.setColumnLeftPosAndWidthMM(1, 20.0, 180.0);
        gpw.setColumnLeftPosAndWidthMM(2, 20.0, 16.0);
        gpw.setColumnLeftPosAndWidthMM(3, 40.0, 16.0);
        gpw.setColumnLeftPosAndWidthMM(4, 60.0, 50.0);
        gpw.setColumnLeftPosAndWidthMM(5, 110.0, 70.0);
        gpw.setColumnLeftPosAndWidthMM(6, 180.0, 20.0);
        gpw.setColumnFont(0, gpw.muliBoldFont);
        gpw.setColumnFont(1, gpw.muliLightFont);
        gpw.setColumnFont(2, gpw.muliLightFont);
        gpw.setColumnFont(3, gpw.muliLightFont);
        gpw.setColumnFont(4, gpw.muliLightFont);
        gpw.setColumnFont(5, gpw.muliLightFont);
        gpw.setColumnFont(6, gpw.muliLightFont);
        Double fontSize = this.convertFontSize(this.page_heading.getFont().getSize());
        gpw.prepareString(0, this.page_heading.getText(), true, fontSize);
        gpw.drawStrings(10.0);
        fontSize = this.convertFontSize(new Double(this.xbrlFileController.getCurrentFontSize()));
        this.drawPDFColumnHeadings(gpw);
        gpw.setAddPageCallback(this);
        for (ScheduleItem s : this.taxReturnObservableList) {
            gpw.prepareString(2, s.getYear(), true, fontSize);
            gpw.prepareString(3, s.getTaxReturnNumber(), true, fontSize);
            gpw.prepareString(4, s.getTaxReturnType(), true, fontSize);
            gpw.prepareString(5, s.getDescription(), true, fontSize);
            gpw.prepareString(6, s.getTaxReturnStatus(), true, fontSize);
            gpw.drawStrings(5.0);
        }
        gpw.addFooter();
        return gpw;
    }

    private void drawPDFColumnHeadings(GlenixPDFWrapper gpw) throws Exception {
        gpw.setColumnFont(2, gpw.muliBoldFont);
        gpw.setColumnFont(3, gpw.muliBoldFont);
        gpw.setColumnFont(4, gpw.muliBoldFont);
        gpw.setColumnFont(5, gpw.muliBoldFont);
        gpw.setColumnFont(6, gpw.muliBoldFont);
        Double fontSize = this.convertFontSize(new Double(this.xbrlFileController.getCurrentFontSize()));
        gpw.prepareString(2, this.yearColumn.getText(), true, fontSize);
        gpw.prepareString(3, this.taxReturnNumberColumn.getText(), true, fontSize);
        gpw.prepareString(4, this.taxReturnTypeColumn.getText(), true, fontSize);
        gpw.prepareString(5, this.descriptionColumn.getText(), true, fontSize);
        gpw.prepareString(6, this.taxReturnStatusColumn.getText(), true, fontSize);
        gpw.drawStrings(5.0);
        gpw.setColumnFont(2, gpw.muliLightFont);
        gpw.setColumnFont(3, gpw.muliLightFont);
        gpw.setColumnFont(4, gpw.muliLightFont);
        gpw.setColumnFont(5, gpw.muliLightFont);
        gpw.setColumnFont(6, gpw.muliLightFont);
    }

    @Override
    public void newPDFPageAdded(GlenixPDFWrapper gpw) throws Exception {
        this.drawPDFColumnHeadings(gpw);
    }

    public class ScheduleItem {
        TaxReturn taxReturn;
        CTR0009 ctr0009;
        CTR0010 ctr0010;
        PTR0007 ptr0007;
        TRT0007 trt0007;
        SMSF0008 smsf0008;
        SMSF0009 smsf0009;
        IITR0005 iitr0005;
        IITR0006 iitr0006;
        RS0002 rs0002;
        CGTS0006 cgts0006;
        DIDS0002 dids0002;
        NRFI0002 nrfi0002;
        PSS0002 pss0002;
        WRE0003 wre0003;
        IDS0006 ids0006;
        IDS0007 ids0007;
        CGLS0006 cgls0006;
        DIS0003 dis0003;
        LS0006 ls0006;
        RDTIS0003 rdtis0003;
        CGNFT0002 cgnft0002;
        IEE0003 iee0003;
        FTER0002 fter0002;
        DDCTNS0001 ddctns0001;
        RPTTAXPOS0001 rpttaxpos0001;
        String type;
        String year;

        public ScheduleItem(TaxReturn taxReturn, String type) {
            this.taxReturn = taxReturn;
            this.type = type;
        }

        public void setYear(String year) {
            this.year = year;
        }

        public TaxReturn getTaxReturn() {
            return this.taxReturn;
        }

        public String getTaxReturnType() {
            String trtype = this.taxReturn.getTaxReturnType();
            if (trtype == null) {
                return "null";
            }
            if (trtype.equals("ctr0009")) {
                return "Company tax return 2018";
            }
            if (trtype.equals("ctr0010")) {
                return "Company tax return 2019";
            }
            if (trtype.equals("iitr0005")) {
                return "Individual tax return 2018";
            }
            if (trtype.equals("iitr0006")) {
                return "Individual tax return 2019";
            }
            if (trtype.equals("ptr0007_2019")) {
                return "Partnership tax return 2019";
            }
            if (trtype.equals("ptr0007") && this.year != null && this.year.equals("2019")) {
                return "Partnership tax return 2019";
            }
            if (trtype.equals("ptr0007")) {
                return "Partnership tax return 2018";
            }
            if (trtype.equals("trt0007_2019")) {
                return "Trust tax return 2019";
            }
            if (trtype.equals("trt0007") && this.year != null && this.year.equals("2019")) {
                return "Trust tax return 2019";
            }
            if (trtype.equals("trt0007")) {
                return "Trust tax return 2018";
            }
            if (trtype.equals("smsf0008")) {
                return "Self-managed superannuation fund annual return 2018";
            }
            if (trtype.equals("smsf0009")) {
                return "Self-managed superannuation fund annual return 2019";
            }
            if (trtype.equals("dis0003")) {
                return "Dividend and interest schedule";
            }
            if (trtype.equals("cgnft0002")) {
                return "Consolidated group notification";
            }
            if (trtype.equals("iee0003")) {
                return "Interposed entity election or revocation";
            }
            if (trtype.equals("fter0002")) {
                return "Family trust election";
            }
            return trtype;
        }

        public String getScheduleType() {
            return this.type;
        }

        public String getDescription() {
            if (this.type == null) {
                return "null";
            }
            if (this.type.equals("ctr0009")) {
                return "Company tax return 2018";
            }
            if (this.type.equals("ctr0010")) {
                return "Company tax return 2019";
            }
            if (this.type.equals("iitr0005")) {
                return "Individual tax return 2018";
            }
            if (this.type.equals("iitr0006")) {
                return "Individual tax return 2019";
            }
            if (this.type.equals("ptr0007_2019")) {
                return "Partnership tax return 2019";
            }
            if (this.type.equals("ptr0007") && this.year != null && this.year.equals("2019")) {
                return "Partnership tax return 2019";
            }
            if (this.type.equals("ptr0007")) {
                return "Partnership tax return 2018";
            }
            if (this.type.equals("trt0007_2019")) {
                return "Trust tax return 2019";
            }
            if (this.type.equals("trt0007") && this.year != null && this.year.equals("2019")) {
                return "Trust tax return 2019";
            }
            if (this.type.equals("trt0007")) {
                return "Trust tax return 2018";
            }
            if (this.type.equals("smsf0008")) {
                return "Self-managed superannuation fund annual return 2018";
            }
            if (this.type.equals("smsf0009")) {
                return "Self-managed superannuation fund annual return 2019";
            }
            if (this.type.equals("rs0002")) {
                return "Rental property schedule";
            }
            if (this.type.equals("cgts0006")) {
                return "Capital gains tax schedule";
            }
            if (this.type.equals("dids0002")) {
                return "Dividends and interest deductions schedule";
            }
            if (this.type.equals("nrfi0002")) {
                return "Non-resident foreign income schedule";
            }
            if (this.type.equals("pss0002")) {
                return "PAYG payment summary schedule";
            }
            if (this.type.equals("wre0003")) {
                return "Work related expenses schedule";
            }
            if (this.type.equals("ids0006")) {
                return "International dealings schedule";
            }
            if (this.type.equals("ids0007")) {
                return "International dealings schedule";
            }
            if (this.type.equals("cgls0006")) {
                return "Consolidated groups losses schedule";
            }
            if (this.type.equals("dis0003")) {
                return "Dividend and interest schedule";
            }
            if (this.type.equals("ls0006")) {
                return "Losses schedule";
            }
            if (this.type.equals("rdtis0003")) {
                return "Research and development tax incentive schedule";
            }
            if (this.type.equals("cgnft0002")) {
                return "Consolidated group notification";
            }
            if (this.type.equals("iee0003")) {
                return "Interposed entity election or revocation";
            }
            if (this.type.equals("fter0002")) {
                return "Family trust election";
            }
            if (this.type.equals("ddctns0001")) {
                return "Deductions schedule";
            }
            if (this.type.equals("rpttaxpos0001")) {
                return "Reportable tax position schedule";
            }
            return this.type;
        }

        public void setCTR0009(CTR0009 ctr0009) {
            this.ctr0009 = ctr0009;
        }

        public CTR0009 getCTR0009() {
            return this.ctr0009;
        }

        public void setCTR0010(CTR0010 ctr0010) {
            this.ctr0010 = ctr0010;
        }

        public CTR0010 getCTR0010() {
            return this.ctr0010;
        }

        public void setIITR0005(IITR0005 iitr0005) {
            this.iitr0005 = iitr0005;
        }

        public IITR0005 getIITR0005() {
            return this.iitr0005;
        }

        public void setIITR0006(IITR0006 iitr0006) {
            this.iitr0006 = iitr0006;
        }

        public IITR0006 getIITR0006() {
            return this.iitr0006;
        }

        public void setPTR0007(PTR0007 ptr0007) {
            this.ptr0007 = ptr0007;
        }

        public PTR0007 getPTR0007() {
            return this.ptr0007;
        }

        public void setTRT0007(TRT0007 trt0007) {
            this.trt0007 = trt0007;
        }

        public TRT0007 getTRT0007() {
            return this.trt0007;
        }

        public void setSMSF0008(SMSF0008 smsf0008) {
            this.smsf0008 = smsf0008;
        }

        public SMSF0008 getSMSF0008() {
            return this.smsf0008;
        }

        public void setSMSF0009(SMSF0009 smsf0009) {
            this.smsf0009 = smsf0009;
        }

        public SMSF0009 getSMSF0009() {
            return this.smsf0009;
        }

        public void setRS0002(RS0002 rs0002) {
            this.rs0002 = rs0002;
        }

        public RS0002 getRS0002() {
            return this.rs0002;
        }

        public void setCGTS0006(CGTS0006 cgts0006) {
            this.cgts0006 = cgts0006;
        }

        public CGTS0006 getCGTS0006() {
            return this.cgts0006;
        }

        public void setDIDS0002(DIDS0002 dids0002) {
            this.dids0002 = dids0002;
        }

        public DIDS0002 getDIDS0002() {
            return this.dids0002;
        }

        public void setNRFI0002(NRFI0002 nrfi0002) {
            this.nrfi0002 = nrfi0002;
        }

        public NRFI0002 getNRFI0002() {
            return this.nrfi0002;
        }

        public void setPSS0002(PSS0002 pss0002) {
            this.pss0002 = pss0002;
        }

        public PSS0002 getPSS0002() {
            return this.pss0002;
        }

        public void setWRE0003(WRE0003 wre0003) {
            this.wre0003 = wre0003;
        }

        public WRE0003 getWRE0003() {
            return this.wre0003;
        }

        public void setIDS0006(IDS0006 ids0006) {
            this.ids0006 = ids0006;
        }

        public IDS0006 getIDS0006() {
            return this.ids0006;
        }

        public void setIDS0007(IDS0007 ids0007) {
            this.ids0007 = ids0007;
        }

        public IDS0007 getIDS0007() {
            return this.ids0007;
        }

        public void setCGLS0006(CGLS0006 cgls0006) {
            this.cgls0006 = cgls0006;
        }

        public CGLS0006 getCGLS0006() {
            return this.cgls0006;
        }

        public void setDIS0003(DIS0003 dis0003) {
            this.dis0003 = dis0003;
        }

        public DIS0003 getDIS0003() {
            return this.dis0003;
        }

        public void setLS0006(LS0006 ls0006) {
            this.ls0006 = ls0006;
        }

        public LS0006 getLS0006() {
            return this.ls0006;
        }

        public void setRDTIS0003(RDTIS0003 rdtis0003) {
            this.rdtis0003 = rdtis0003;
        }

        public RDTIS0003 getRDTIS0003() {
            return this.rdtis0003;
        }

        public void setCGNFT0002(CGNFT0002 cgnft0002) {
            this.cgnft0002 = cgnft0002;
        }

        public CGNFT0002 getCGNFT0002() {
            return this.cgnft0002;
        }

        public void setIEE0003(IEE0003 iee0003) {
            this.iee0003 = iee0003;
        }

        public IEE0003 getIEE0003() {
            return this.iee0003;
        }

        public void setFTER0002(FTER0002 fter0002) {
            this.fter0002 = fter0002;
        }

        public FTER0002 getFTER0002() {
            return this.fter0002;
        }

        public void setDDCTNS0001(DDCTNS0001 ddctns0001) {
            this.ddctns0001 = ddctns0001;
        }

        public DDCTNS0001 getDDCTNS0001() {
            return this.ddctns0001;
        }

        public void setRPTTAXPOS0001(RPTTAXPOS0001 rpttaxpos0001) {
            this.rpttaxpos0001 = rpttaxpos0001;
        }

        public RPTTAXPOS0001 getRPTTAXPOS0001() {
            return this.rpttaxpos0001;
        }

        public String getYear() {
            return this.taxReturn.getYear();
        }

        public String getStartDate() {
            return this.taxReturn.getStartDate();
        }

        public String getEndDate() {
            return this.taxReturn.getEndDate();
        }

        public String getTaxReturnNumber() {
            return this.taxReturn.getTaxReturnNumber();
        }

        public String getTaxReturnStatus() {
            if (this.type.equals("rs0002") && this.rs0002 == null) {
                return "Blank";
            }
            if (this.type.equals("cgts0006") && this.cgts0006 == null) {
                return "Blank";
            }
            if (this.type.equals("dids0002") && this.dids0002 == null) {
                return "Blank";
            }
            if (this.type.equals("nrfi0002") && this.nrfi0002 == null) {
                return "Blank";
            }
            if (this.type.equals("pss0002") && this.pss0002 == null) {
                return "Blank";
            }
            if (this.type.equals("wre0003") && this.wre0003 == null) {
                return "Blank";
            }
            if (this.type.equals("ids0006") && this.ids0006 == null) {
                return "Blank";
            }
            if (this.type.equals("ids0007") && this.ids0007 == null) {
                return "Blank";
            }
            if (this.type.equals("cgls0006") && this.cgls0006 == null) {
                return "Blank";
            }
            if (this.type.equals("dis0003") && this.dis0003 == null) {
                return "Blank";
            }
            if (this.type.equals("ls0006") && this.ls0006 == null) {
                return "Blank";
            }
            if (this.type.equals("rdtis0003") && this.rdtis0003 == null) {
                return "Blank";
            }
            if (this.type.equals("cgnft0002") && this.cgnft0002 == null) {
                return "Blank";
            }
            if (this.type.equals("iee0003") && this.iee0003 == null) {
                return "Blank";
            }
            if (this.type.equals("fter0002") && this.fter0002 == null) {
                return "Blank";
            }
            if (this.type.equals("ddctns0001") && this.ddctns0001 == null) {
                return "Blank";
            }
            if (this.type.equals("rpttaxpos0001") && this.rpttaxpos0001 == null) {
                return "Blank";
            }
            String status = this.taxReturn.getTaxReturnStatus();
            if (status == null) {
                return "null";
            }
            if (status.equals("lodge_complete")) {
                return "Lodged";
            }
            if (status.equals("prelodge_complete")) {
                return "Validated";
            }
            if (status.equals("created")) {
                return "Created";
            }
            return status;
        }
    }
}

