/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import au.com.glenix.ApplicationController;
import au.com.glenix.Glenix;
import au.com.glenix.GlenixSBRAttachment;
import au.com.glenix.trn.GlenixResult;
import au.com.glenix.trn.Profile;
import au.com.glenix.widget.GlenixBranchController;
import au.com.glenix.widget.GlenixLabelLabel;
import java.net.URL;
import java.security.MessageDigest;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TaxAgentOrderFormController
extends GlenixBranchController {
    @FXML
    private GlenixLabelLabel firstName;
    @FXML
    private GlenixLabelLabel otherGivenNames;
    @FXML
    private GlenixLabelLabel lastName;
    @FXML
    private GlenixLabelLabel password;
    @FXML
    private GlenixLabelLabel registered_agent_number;
    @FXML
    private GlenixLabelLabel agent_ABN;
    @FXML
    private GlenixLabelLabel agent_ABN_branch_code;
    @FXML
    private Label error_message;
    @FXML
    private Label warning_message;
    private ApplicationController xbrlFileController = null;
    private Profile profile = null;
    private DocumentBuilder dBuilder;

    public TaxAgentOrderFormController(ApplicationController xbrlFileController) {
        this.xbrlFileController = xbrlFileController;
    }

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setNamespaceAware(true);
            this.dBuilder = dbFactory.newDocumentBuilder();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    public void setModel(Profile profileXBRL) throws Exception {
        Document doc;
        this.profile = profileXBRL;
        if (this.profile != null && (doc = this.profile.buildDocument()) != null) {
            this.loadGlenixXBRL(doc, doc.getDocumentElement());
        }
    }

    @FXML
    public void placeOrder() {
        try {
            this.placeOrder(this.profile);
        }
        catch (Exception e) {
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
            e.printStackTrace();
        }
    }

    @Override
    public void buildGlenixXBRL(Document resultDoc, Element resultElement) throws Exception {
        Element el = resultDoc.createElementNS("http://www.glenix.com.au/", "gx:glenix");
        el.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:gx", "http://www.glenix.com.au/");
        if (resultElement == null) {
            resultDoc.appendChild(el);
        } else {
            resultElement.appendChild(el);
        }
        Element profileEl = resultDoc.createElementNS("http://www.glenix.com.au/", "gx:profile");
        el.appendChild(profileEl);
        try {
            String pkStr = this.xbrlFileController.getPublicKeyDer();
            Element pkiEl = resultDoc.createElementNS("http://www.glenix.com.au/", "gx:publicKey");
            pkiEl.setTextContent(pkStr);
            Element keyPairEl = resultDoc.createElementNS("http://www.glenix.com.au/", "gx:keyPair");
            profileEl.appendChild(keyPairEl);
            keyPairEl.appendChild(pkiEl);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.buildGlenixXBRLSub(this.getPane(), resultDoc, profileEl);
    }

    public void placeOrder(Profile profile) {
        final ApplicationController xbrlFileController = this.xbrlFileController;
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Platform.runLater(() -> {
                        xbrlFileController.setStatusBarMessage("Begin place order...");
                        TaxAgentOrderFormController.this.warning_message.setText(null);
                        TaxAgentOrderFormController.this.warning_message.setVisible(false);
                        TaxAgentOrderFormController.this.warning_message.setManaged(false);
                    });
                    Document attachdoc = TaxAgentOrderFormController.this.dBuilder.newDocument();
                    TaxAgentOrderFormController.this.buildGlenixXBRL(attachdoc, null);
                    MessageDigest md = xbrlFileController.calculateSHA1Digest(attachdoc.getDocumentElement());
                    GlenixSBRAttachment gatt = new GlenixSBRAttachment(attachdoc, "Attachment01", md);
                    GlenixResult glenixResult = xbrlFileController.sendDocumentToFASResult(Glenix.soap_service_register_profile, "ORDERTAXAGENT", gatt);
                    Platform.runLater(() -> xbrlFileController.setStatusBarMessage("Interpreting response from FAS..."));
                    String resultCode = null;
                    if (glenixResult != null) {
                        resultCode = glenixResult.getResultCode();
                    }
                    if (resultCode == null) {
                        throw new Exception("Error, unable to place order");
                    }
                    if (!resultCode.equals("OK")) {
                        if (resultCode.equals("WARNVERSION")) {
                            Platform.runLater(() -> {
                                TaxAgentOrderFormController.this.warning_message.setText("Warning: There is a new version of this software available please go to www.freeaccountingsoftware.com.au to download the latest version.");
                                TaxAgentOrderFormController.this.warning_message.setVisible(true);
                                TaxAgentOrderFormController.this.warning_message.setManaged(true);
                            });
                        } else if (resultCode.equals("WARNLICENSE")) {
                            Platform.runLater(() -> {
                                TaxAgentOrderFormController.this.warning_message.setText("Warning: " + glenixResult.getResultDescription());
                                TaxAgentOrderFormController.this.warning_message.setVisible(true);
                                TaxAgentOrderFormController.this.warning_message.setManaged(true);
                            });
                        } else if (resultCode.equals("WARNING")) {
                            Platform.runLater(() -> {
                                TaxAgentOrderFormController.this.warning_message.setText("Warning: " + glenixResult.getResultDescription());
                                TaxAgentOrderFormController.this.warning_message.setVisible(true);
                                TaxAgentOrderFormController.this.warning_message.setManaged(true);
                            });
                        } else {
                            if (resultCode.equals("ERRORLICENSE")) {
                                throw new Exception("Error, you do not have the required license to perform this action. You may need to contact Free Accounting Software on 1300 113 733.");
                            }
                            if (resultCode.equals("ERRORVERSION")) {
                                throw new Exception("Error, the version of the software you are using is out of date. You need to upgrade first please go to www.freeaccountingsoftware.com.au to download the latest version.");
                            }
                            if (resultCode.equals("ERROR")) {
                                throw new Exception("Error, error code " + resultCode + ", description " + glenixResult.getResultDescription());
                            }
                            throw new Exception("Error, error code " + resultCode + ", description " + glenixResult.getResultDescription());
                        }
                    }
                    Platform.runLater(() -> {
                        try {
                            TaxAgentOrderFormController.this.error_message.setText("Order accepted, you may now lodge tax returns.");
                            xbrlFileController.setStatusBarMessage("Order accepted, you may now lodge tax returns.");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            TaxAgentOrderFormController.this.error_message.setText(e.getMessage());
                            xbrlFileController.setStatusBarMessage(e.getMessage());
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Platform.runLater(() -> {
                        e.printStackTrace();
                        TaxAgentOrderFormController.this.error_message.setText(e.getMessage());
                        xbrlFileController.setStatusBarMessage(e.getMessage());
                    });
                }
            }
        }).start();
    }
}

