/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import au.com.glenix.ApplicationController;
import au.com.glenix.Glenix;
import au.com.glenix.GlenixSBRAttachment;
import au.com.glenix.trn.GlenixResult;
import au.com.glenix.trn.Profile;
import au.com.glenix.widget.GlenixBranchController;
import au.com.glenix.widget.GlenixLabelLabel;
import au.com.glenix.widget.GlenixLabelText;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javax.swing.SwingUtilities;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;

public class SupportOrderFormController
extends GlenixBranchController {
    @FXML
    private GlenixLabelLabel firstName;
    @FXML
    private GlenixLabelLabel otherGivenNames;
    @FXML
    private GlenixLabelLabel lastName;
    @FXML
    private GlenixLabelText TelephoneAreaC;
    @FXML
    private GlenixLabelText TelephoneMinimalN;
    @FXML
    private GlenixLabelText ElectronicMailAddressT;
    @FXML
    private Label error_message;
    @FXML
    private Label warning_message;
    private ApplicationController applicationController = null;
    private Profile profile = null;
    private DocumentBuilder dBuilder;

    public SupportOrderFormController(ApplicationController applicationController) {
        this.applicationController = applicationController;
    }

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setNamespaceAware(true);
            this.dBuilder = dbFactory.newDocumentBuilder();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.applicationController.setStatusBarMessage(e.getMessage());
        }
    }

    public void setModel(Profile profileXBRL) throws Exception {
        Document doc;
        this.profile = profileXBRL;
        if (this.profile != null && (doc = this.profile.buildDocument()) != null) {
            this.loadGlenixXBRL(doc, doc.getDocumentElement());
        }
    }

    @FXML
    public void requestSupport() {
        try {
            this.profile.setFirstName(this.firstName.getGlenixElementValue());
            this.profile.setOtherGivenNames(this.otherGivenNames.getGlenixElementValue());
            this.profile.setLastName(this.lastName.getGlenixElementValue());
            this.profile.setTelephoneAreaC(this.TelephoneAreaC.getGlenixElementValue());
            this.profile.setTelephoneMinimalN(this.TelephoneMinimalN.getGlenixElementValue());
            this.profile.setElectronicMailAddressT(this.ElectronicMailAddressT.getGlenixElementValue());
            this.requestSupport(this.profile);
        }
        catch (Exception e) {
            this.error_message.setText(e.getMessage());
            this.applicationController.setStatusBarMessage(e.getMessage());
            e.printStackTrace();
        }
    }

    @FXML
    public void openLogFile() {
        try {
            File installPath = this.applicationController.locateInstallDirectory();
            if (installPath != null) {
                final File logfile = new File(installPath.getAbsolutePath() + "/FAS3Desktop_log.txt");
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Desktop.getDesktop().open(logfile);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void requestSupport(final Profile profile) {
        final ApplicationController applicationController = this.applicationController;
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Platform.runLater(() -> {
                        applicationController.setStatusBarMessage("Begin request support...");
                        SupportOrderFormController.this.warning_message.setText(null);
                        SupportOrderFormController.this.warning_message.setVisible(false);
                        SupportOrderFormController.this.warning_message.setManaged(false);
                    });
                    ArrayList<GlenixSBRAttachment> gattl = new ArrayList<GlenixSBRAttachment>();
                    Document attachdoc = profile.buildSignableDocument();
                    MessageDigest md = applicationController.calculateSHA1Digest(attachdoc.getDocumentElement());
                    GlenixSBRAttachment gatt = new GlenixSBRAttachment(attachdoc, "Attachment01", md);
                    gattl.add(gatt);
                    System.out.println("TODO put the log file into the file");
                    byte[] myBusinessFasFileBytes = applicationController.getMyBusinessFasFileBytes();
                    System.out.println("Bytes len = " + myBusinessFasFileBytes.length);
                    MessageDigest md2 = applicationController.calculateSHA1DigestBytes(myBusinessFasFileBytes);
                    GlenixSBRAttachment gatt2 = new GlenixSBRAttachment(myBusinessFasFileBytes, "Attachment02", md2);
                    gatt2.setMimeType("application/gzip");
                    gatt2.setCompressionType("application/gzip");
                    gattl.add(gatt2);
                    GlenixResult glenixResult = applicationController.sendDocumentToFASResult(Glenix.soap_service_register_profile, "REQUESTSUPPORT", gattl);
                    Platform.runLater(() -> applicationController.setStatusBarMessage("Interpreting response from FAS..."));
                    String resultCode = null;
                    if (glenixResult != null) {
                        resultCode = glenixResult.getResultCode();
                    }
                    if (resultCode == null) {
                        throw new Exception("Error, unable to place order");
                    }
                    if (!resultCode.equals("OK")) {
                        if (resultCode.equals("WARNVERSION")) {
                            Platform.runLater(() -> {
                                SupportOrderFormController.this.warning_message.setText("Warning: There is a new version of this software available please go to www.freeaccountingsoftware.com.au to download the latest version.");
                                SupportOrderFormController.this.warning_message.setVisible(true);
                                SupportOrderFormController.this.warning_message.setManaged(true);
                            });
                        } else if (resultCode.equals("WARNLICENSE")) {
                            Platform.runLater(() -> {
                                SupportOrderFormController.this.warning_message.setText("Warning: " + glenixResult.getResultDescription());
                                SupportOrderFormController.this.warning_message.setVisible(true);
                                SupportOrderFormController.this.warning_message.setManaged(true);
                            });
                        } else if (resultCode.equals("WARNING")) {
                            Platform.runLater(() -> {
                                SupportOrderFormController.this.warning_message.setText("Warning: " + glenixResult.getResultDescription());
                                SupportOrderFormController.this.warning_message.setVisible(true);
                                SupportOrderFormController.this.warning_message.setManaged(true);
                            });
                        } else {
                            if (resultCode.equals("ERRORLICENSE")) {
                                throw new Exception("Error, you do not have the required license to perform this action. You may need to contact Free Accounting Software on 1300 113 733.");
                            }
                            if (resultCode.equals("ERRORVERSION")) {
                                throw new Exception("Error, the version of the software you are using is out of date. You need to upgrade first please go to www.freeaccountingsoftware.com.au to download the latest version.");
                            }
                            if (resultCode.equals("ERROR")) {
                                throw new Exception("Error, unable to request support, error code " + resultCode + ", description " + glenixResult.getResultDescription());
                            }
                            throw new Exception("Error, unable to request support, error code " + resultCode + ", description " + glenixResult.getResultDescription());
                        }
                    }
                    Platform.runLater(() -> {
                        try {
                            SupportOrderFormController.this.error_message.setText("Support request received.");
                            applicationController.setStatusBarMessage("Support request received.");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            SupportOrderFormController.this.error_message.setText(e.getMessage());
                            applicationController.setStatusBarMessage(e.getMessage());
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Platform.runLater(() -> {
                        e.printStackTrace();
                        SupportOrderFormController.this.error_message.setText(e.getMessage());
                        applicationController.setStatusBarMessage(e.getMessage());
                    });
                }
            }
        }).start();
    }
}

