/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import au.com.glenix.ApplicationController;
import au.com.glenix.trn.Counterparty;
import au.com.glenix.trn.Transaction;
import au.com.glenix.widget.GlenixBranchController;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.collections.transformation.FilteredList;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;

public class SuperProductDetailsEditController
extends GlenixBranchController {
    @FXML
    private Label page_heading;
    @FXML
    private Label error_message;
    private ApplicationController xbrlFileController = null;
    private Counterparty counterparty = null;
    private FilteredList<Transaction> filteredItems;
    private DocumentBuilder dBuilder;

    public SuperProductDetailsEditController(ApplicationController xbrlFileController) {
        this.xbrlFileController = xbrlFileController;
    }

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setNamespaceAware(true);
            this.dBuilder = dbFactory.newDocumentBuilder();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    public void setCounterpartyElement(Counterparty counterparty) {
        this.clearGlenixXBRL();
        this.error_message.setText(null);
        this.xbrlFileController.setStatusBarMessage(null);
        this.counterparty = counterparty;
        if (counterparty == null) {
            this.page_heading.setText("Superannuation fund product details");
        } else {
            this.page_heading.setText("Superannuation fund product details - " + counterparty.getCounterpartyLegalName());
            try {
                Document cdoc = this.dBuilder.newDocument();
                counterparty.appendToElement(cdoc);
                this.loadGlenixXBRL(cdoc, cdoc.getDocumentElement());
            }
            catch (Exception e) {
                e.printStackTrace();
                this.error_message.setText(e.getMessage());
                this.xbrlFileController.setStatusBarMessage(e.getMessage());
            }
        }
    }

    @FXML
    private void gotoCounterpartyList() {
        this.xbrlFileController.gotoCounterpartyList();
    }

    @FXML
    private void gotoCounterpartyEdit() {
        try {
            if (this.counterparty == null) {
                throw new Exception("Error, you have not selected a counterparty.");
            }
            this.xbrlFileController.gotoCounterpartyEdit(this.counterparty);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    private void saveSuperProduct() {
        try {
            Document resultDoc = this.dBuilder.newDocument();
            super.buildGlenixXBRL(resultDoc, null);
            if (this.counterparty == null) {
                throw new Exception("Error, need to create counterparty before editing super details.");
            }
            this.counterparty.loadDocumentElement(resultDoc, resultDoc.getDocumentElement());
            this.xbrlFileController.saveCounterparty(this.counterparty);
            this.error_message.setText("Saved");
        }
        catch (Exception e) {
            this.error_message.setText(e.getMessage());
            e.printStackTrace();
        }
    }

    @FXML
    private void deleteSuperProduct() {
        try {
            if (this.counterparty == null) {
                throw new Exception("Error, need to create super product before deleting it.");
            }
            this.counterparty.deleteSuperProductDetails();
            this.xbrlFileController.saveCounterpartyList();
            this.gotoCounterpartyEdit();
        }
        catch (Exception e) {
            this.error_message.setText(e.getMessage());
            e.printStackTrace();
        }
    }
}

