/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import au.com.glenix.EventItemsVBox;
import au.com.glenix.GlenixLabelPaymentBasisCombo;
import au.com.glenix.GlenixLabelTFNExemptionCodeCombo;
import au.com.glenix.GlenixLabelTerminationCodeCombo;
import au.com.glenix.tr2018.GlenixLabelCountryCombo;
import au.com.glenix.tr2018.GlenixLabelCountryLabel;
import au.com.glenix.tr2018.GlenixLabelResidencyTaxStatusCombo;
import au.com.glenix.tr2018.GlenixLabelStateCombo;
import au.com.glenix.trn.AgentDetails;
import au.com.glenix.trn.BusinessMasterFile;
import au.com.glenix.trn.ElectronicContact;
import au.com.glenix.trn.EventItems;
import au.com.glenix.trn.Profile;
import au.com.glenix.trn.ProfileElectronicContact;
import au.com.glenix.trn.SBRDocumentTFND0004;
import au.com.glenix.trn.TFND0004AddressDetailsBusiness;
import au.com.glenix.widget.GlenixBranchController;
import au.com.glenix.widget.GlenixLabelBlankYesNoCombo;
import au.com.glenix.widget.GlenixLabelCheckbox;
import au.com.glenix.widget.GlenixLabelDate;
import au.com.glenix.widget.GlenixLabelDateTimeLabel;
import au.com.glenix.widget.GlenixLabelLabel;
import au.com.glenix.widget.GlenixLabelTFN;
import au.com.glenix.widget.GlenixLabelText;
import au.com.glenix.widget.GlenixVBox;
import java.net.URL;
import java.time.format.DateTimeFormatter;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SBRDocumentTFND0004Controller
extends GlenixBranchController {
    protected DocumentBuilder dBuilder;
    @FXML
    protected Label error_message;
    @FXML
    private GlenixLabelTFN TaxFileNumberId;
    @FXML
    private GlenixLabelTFNExemptionCodeCombo IdentificationExemptionDetailsTFNExemptionTypeC;
    @FXML
    private GlenixLabelText FamilyNameT;
    @FXML
    private GlenixLabelText GivenNameT;
    @FXML
    private GlenixLabelText OtherGivenNameT;
    @FXML
    private GlenixLabelText PreviousPersonNameDetailsFamilyNameT;
    @FXML
    private GlenixLabelDate BirthDate;
    @FXML
    private GlenixLabelText Line1T;
    @FXML
    private GlenixLabelText Line2T;
    @FXML
    private GlenixLabelText LocalityNameT;
    @FXML
    private GlenixLabelStateCombo StateOrTerritoryC;
    @FXML
    private GlenixLabelText PostcodeT;
    @FXML
    private GlenixLabelCountryCombo CountryC;
    @FXML
    private GlenixLabelTerminationCodeCombo TerminationC;
    @FXML
    private GlenixLabelResidencyTaxStatusCombo ResidencyTaxPurposesPersonStatusC;
    @FXML
    private GlenixLabelPaymentBasisCombo PaymentBasisC;
    @FXML
    private GlenixLabelBlankYesNoCombo TaxOffsetClaimTaxFreeThresholdI;
    @FXML
    private GlenixLabelBlankYesNoCombo IncomeTaxPayAsYouGoWithholdingStudyAndTrainingLoanRepaymentI;
    @FXML
    private GlenixLabelBlankYesNoCombo StudentLoanStudentFinancialSupplementSchemeI;
    @FXML
    private GlenixLabelBlankYesNoCombo StatementAcceptedI;
    @FXML
    private GlenixLabelDate SignatureD;
    @FXML
    private GlenixLabelDateTimeLabel sbrDocumentDateTime;
    @FXML
    private GlenixLabelLabel sbrDocumentStatus;
    @FXML
    private GlenixLabelLabel businessAustralianBusinessNumberId;
    @FXML
    private GlenixLabelLabel businessWithholdingPayerNumberId;
    @FXML
    private GlenixLabelLabel businessOrganisationDetailsOrganisationBranchC;
    @FXML
    private GlenixLabelLabel businessOrganisationNameDetailsOrganisationalNameT;
    @FXML
    private GlenixLabelLabel businessLine1T;
    @FXML
    private GlenixLabelLabel businessLine2T;
    @FXML
    private GlenixLabelLabel businessLocalityNameT;
    @FXML
    private GlenixLabelLabel businessStateOrTerritoryC;
    @FXML
    private GlenixLabelLabel businessPostcodeT;
    @FXML
    private GlenixLabelCountryLabel businessCountryC;
    @FXML
    private GlenixLabelLabel businessPersonUnstructuredNameFullNameT;
    @FXML
    private GlenixLabelLabel businessTelephoneAreaC;
    @FXML
    private GlenixLabelLabel businessTelephoneMinimalN;
    @FXML
    private GlenixLabelLabel businessElectronicMailAddressT;
    @FXML
    private GlenixLabelCheckbox businessStatementAcceptedI;
    @FXML
    private GlenixLabelDate businessSignatureD;
    @FXML
    private GlenixLabelText businessSignatoryIdentifierT;
    @FXML
    private GlenixLabelLabel agentAustralianBusinessNumberId;
    @FXML
    private GlenixLabelLabel agentTaxAgentNumberId;
    @FXML
    private GlenixLabelLabel agentOrganisationNameDetailsOrganisationalNameT;
    @FXML
    private GlenixLabelLabel agentLine1T;
    @FXML
    private GlenixLabelLabel agentLine2T;
    @FXML
    private GlenixLabelLabel agentLocalityNameT;
    @FXML
    private GlenixLabelLabel agentStateOrTerritoryC;
    @FXML
    private GlenixLabelLabel agentPostcodeT;
    @FXML
    private GlenixLabelCountryLabel agentCountryC;
    @FXML
    private GlenixLabelLabel agentPersonUnstructuredNameFullNameT;
    @FXML
    private GlenixLabelLabel agentTelephoneAreaC;
    @FXML
    private GlenixLabelLabel agentTelephoneMinimalN;
    @FXML
    private GlenixLabelLabel agentElectronicMailAddressT;
    @FXML
    private GlenixLabelCheckbox agentStatementAcceptedI;
    @FXML
    private GlenixLabelDate agentSignatureD;
    @FXML
    private GlenixLabelText agentSignatoryIdentifierT;
    @FXML
    private GlenixVBox intermediarysection;
    private DateTimeFormatter outputDateFormatter = DateTimeFormatter.ofPattern("dd MMM yyyy");
    private SBRDocumentTFND0004 sbrDocumentTFND0004 = null;
    @FXML
    private EventItemsVBox overalleventitemsvbox;
    @FXML
    private EventItemsVBox businesseventitemsvbox;
    @FXML
    private Hyperlink show_detail;
    @FXML
    private Hyperlink hide_detail;
    @FXML
    private Label summary_message;
    @FXML
    private Label payer_declaration;
    private boolean isDisabled = false;

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setNamespaceAware(true);
            this.dBuilder = dbFactory.newDocumentBuilder();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
        }
    }

    public void buildGlenixXBRLSubPart(Document resultDoc, Element resultElement) throws Exception {
        super.buildGlenixXBRL(resultDoc, resultElement);
    }

    public void setSBRDocumentTFND0004Model(SBRDocumentTFND0004 sbrDocumentTFND0004) throws Exception {
        this.sbrDocumentTFND0004 = sbrDocumentTFND0004;
        this.clearGlenixXBRL();
        if (sbrDocumentTFND0004 == null) {
            return;
        }
        Document tdoc = this.dBuilder.newDocument();
        sbrDocumentTFND0004.appendToElement(tdoc);
        this.loadGlenixXBRL(tdoc, tdoc.getDocumentElement());
        String status = sbrDocumentTFND0004.getSBRDocumentStatus();
        if (status != null && status.equalsIgnoreCase("lodge_complete")) {
            this.disableGlenixXBRL();
            this.isDisabled = true;
        } else if (this.isDisabled) {
            this.enableGlenixXBRL();
            this.isDisabled = false;
        }
        EventItems eventItems = sbrDocumentTFND0004.getBusinessEventItems();
        if (eventItems != null) {
            this.businesseventitemsvbox.setEventItemsModel(eventItems);
        }
        if ((eventItems = sbrDocumentTFND0004.getOverallEventItems()) != null) {
            this.overalleventitemsvbox.setEventItemsModel(eventItems);
        }
        String maxBusSeverity = this.businesseventitemsvbox.getMaximumSeverityCode();
        String maxOverSeverity = this.overalleventitemsvbox.getMaximumSeverityCode();
        if (maxBusSeverity == null && maxOverSeverity == null) {
            this.summary_message.setText("No error (yet)");
            this.hide_detail();
        } else if ((maxBusSeverity == null || maxBusSeverity.equals("Information")) && (maxOverSeverity == null || maxOverSeverity.equals("Information"))) {
            if (status != null && status.equals("lodge_complete")) {
                this.summary_message.setText("Successfully lodged");
                this.hide_detail();
            } else {
                this.summary_message.setText("Success");
                this.hide_detail();
            }
        } else {
            this.summary_message.setText("Error");
            this.show_detail();
        }
    }

    public void newCounterpartyTFND() throws Exception {
        this.sbrDocumentStatus.setText("created");
        if (this.isDisabled) {
            this.enableGlenixXBRL();
            this.isDisabled = false;
        }
        this.overalleventitemsvbox.setEventItemsModel(null);
        this.businesseventitemsvbox.setEventItemsModel(null);
        this.summary_message.setText("New form (no lodgement messages)");
    }

    public void setSBRDocumentDateTimeToNow() {
        this.sbrDocumentDateTime.setDateTimeToNow();
    }

    public void setBusinessDetails(BusinessMasterFile businessMasterFile) {
        String status = this.sbrDocumentStatus.getText();
        if (status == null || !status.equals("lodge_complete")) {
            if (businessMasterFile == null) {
                this.businessAustralianBusinessNumberId.setText(null);
                this.businessWithholdingPayerNumberId.setText(null);
                this.businessOrganisationDetailsOrganisationBranchC.setText(null);
                this.businessOrganisationNameDetailsOrganisationalNameT.setText(null);
                this.businessLine1T.setText(null);
                this.businessLine2T.setText(null);
                this.businessLocalityNameT.setText(null);
                this.businessStateOrTerritoryC.setText(null);
                this.businessPostcodeT.setText(null);
                this.businessCountryC.setGlenixElementValue(null);
                this.businessPersonUnstructuredNameFullNameT.setText(null);
                this.businessTelephoneAreaC.setText(null);
                this.businessTelephoneMinimalN.setText(null);
                this.businessElectronicMailAddressT.setText(null);
            } else {
                this.businessAustralianBusinessNumberId.setText(businessMasterFile.getBusinessABN());
                this.businessWithholdingPayerNumberId.setText(businessMasterFile.getBusinessWPN());
                this.businessOrganisationDetailsOrganisationBranchC.setText(businessMasterFile.getBusinessABNBranch());
                this.businessOrganisationNameDetailsOrganisationalNameT.setText(businessMasterFile.getBusinessLegalName());
                TFND0004AddressDetailsBusiness addr = businessMasterFile.getBusinessBusinessAddress();
                if (addr != null) {
                    this.businessLine1T.setText(addr.getLine1T());
                    this.businessLine2T.setText(addr.getLine2T());
                    this.businessLocalityNameT.setText(addr.getLocalityNameT());
                    this.businessStateOrTerritoryC.setText(addr.getStateOrTerritoryC());
                    this.businessPostcodeT.setText(addr.getPostcodeT());
                    this.businessCountryC.setGlenixElementValue(addr.getCountryC());
                } else {
                    this.businessLine1T.setText(null);
                    this.businessLine2T.setText(null);
                    this.businessLocalityNameT.setText(null);
                    this.businessStateOrTerritoryC.setText(null);
                    this.businessPostcodeT.setText(null);
                    this.businessCountryC.setGlenixElementValue(null);
                }
                ElectronicContact ec = businessMasterFile.getBusinessElectronicContact();
                if (ec != null) {
                    this.businessPersonUnstructuredNameFullNameT.setText(ec.getPersonUnstructuredNameFullNameT());
                    this.businessTelephoneAreaC.setText(ec.getTelephoneAreaC());
                    this.businessTelephoneMinimalN.setText(ec.getTelephoneMinimalN());
                    this.businessElectronicMailAddressT.setText(ec.getElectronicMailAddressT());
                } else {
                    this.businessPersonUnstructuredNameFullNameT.setText(null);
                    this.businessTelephoneAreaC.setText(null);
                    this.businessTelephoneMinimalN.setText(null);
                    this.businessElectronicMailAddressT.setText(null);
                }
            }
        }
    }

    public void setProfileDetails(Profile profileXBRL) {
        String status = this.sbrDocumentStatus.getText();
        if (status == null || !status.equals("lodge_complete")) {
            AgentDetails agentDetails = null;
            if (profileXBRL != null) {
                agentDetails = profileXBRL.getAgentDetails();
            }
            if (agentDetails == null) {
                this.agentAustralianBusinessNumberId.setText(null);
                this.agentTaxAgentNumberId.setText(null);
                this.agentOrganisationNameDetailsOrganisationalNameT.setText(null);
                this.agentLine1T.setText(null);
                this.agentLine2T.setText(null);
                this.agentLocalityNameT.setText(null);
                this.agentStateOrTerritoryC.setText(null);
                this.agentPostcodeT.setText(null);
                this.agentCountryC.setGlenixElementValue(null);
                this.agentPersonUnstructuredNameFullNameT.setText(null);
                this.agentTelephoneAreaC.setText(null);
                this.agentTelephoneMinimalN.setText(null);
                this.agentElectronicMailAddressT.setText(null);
                this.agentSignatoryIdentifierT.setText(null);
                this.agentSignatureD.setGlenixElementValue(null);
                this.agentStatementAcceptedI.setGlenixElementValue(null);
                this.intermediarysection.setVisible(false);
                this.intermediarysection.setManaged(false);
                this.businessStatementAcceptedI.getGlenixController().enableGlenixXBRL();
                this.businessSignatureD.getGlenixController().enableGlenixXBRL();
                this.businessSignatoryIdentifierT.getGlenixController().enableGlenixXBRL();
                String declarationText = "I declare that the information transmitted in this Tax File Number Declaration is true and correct and that I am authorised to make this declaration.";
                this.payer_declaration.setText(declarationText);
            } else {
                this.agentAustralianBusinessNumberId.setText(agentDetails.getAgentABN());
                this.agentTaxAgentNumberId.setText(agentDetails.getAgentNumber());
                this.agentOrganisationNameDetailsOrganisationalNameT.setText(agentDetails.getAgentLegalName());
                TFND0004AddressDetailsBusiness addr = agentDetails.getAgentBusinessAddress();
                if (addr != null) {
                    this.agentLine1T.setText(addr.getLine1T());
                    this.agentLine2T.setText(addr.getLine2T());
                    this.agentLocalityNameT.setText(addr.getLocalityNameT());
                    this.agentStateOrTerritoryC.setText(addr.getStateOrTerritoryC());
                    this.agentPostcodeT.setText(addr.getPostcodeT());
                    this.agentCountryC.setGlenixElementValue(addr.getCountryC());
                } else {
                    this.agentLine1T.setText(null);
                    this.agentLine2T.setText(null);
                    this.agentLocalityNameT.setText(null);
                    this.agentStateOrTerritoryC.setText(null);
                    this.agentPostcodeT.setText(null);
                    this.agentCountryC.setGlenixElementValue(null);
                }
                ProfileElectronicContact ec = agentDetails.getAgentElectronicContact();
                if (ec != null) {
                    this.agentPersonUnstructuredNameFullNameT.setText(ec.getPersonUnstructuredNameFullNameT());
                    this.agentTelephoneAreaC.setText(ec.getTelephoneAreaC());
                    this.agentTelephoneMinimalN.setText(ec.getTelephoneMinimalN());
                    this.agentElectronicMailAddressT.setText(ec.getElectronicMailAddressT());
                } else {
                    this.agentPersonUnstructuredNameFullNameT.setText(null);
                    this.agentTelephoneAreaC.setText(null);
                    this.agentTelephoneMinimalN.setText(null);
                    this.agentElectronicMailAddressT.setText(null);
                }
                String agentABN = agentDetails.getAgentABN();
                if (agentABN == null || agentABN.isEmpty()) {
                    this.intermediarysection.setVisible(false);
                    this.intermediarysection.setManaged(false);
                    this.businessStatementAcceptedI.getGlenixController().enableGlenixXBRL();
                    this.businessSignatureD.getGlenixController().enableGlenixXBRL();
                    this.businessSignatoryIdentifierT.getGlenixController().enableGlenixXBRL();
                } else {
                    this.intermediarysection.setVisible(true);
                    this.intermediarysection.setManaged(true);
                    this.businessStatementAcceptedI.getGlenixController().disableGlenixXBRL();
                    this.businessSignatureD.getGlenixController().disableGlenixXBRL();
                    this.businessSignatoryIdentifierT.getGlenixController().disableGlenixXBRL();
                    this.businessStatementAcceptedI.setGlenixElementValue(null);
                    this.businessSignatureD.setGlenixElementValue(null);
                    this.businessSignatoryIdentifierT.setGlenixElementValue(null);
                }
                String declarationText = "I declare that:\n* All of the information I have provided to the agent for the preparation of this document is true and correct,\n* I authorise the agent to give this document to the Commissioner of Taxation.";
                this.payer_declaration.setText(declarationText);
            }
        }
    }

    @FXML
    public void show_detail() {
        this.overalleventitemsvbox.setVisible(true);
        this.businesseventitemsvbox.setVisible(true);
        this.show_detail.setVisible(false);
        this.hide_detail.setVisible(true);
        this.overalleventitemsvbox.setManaged(true);
        this.businesseventitemsvbox.setManaged(true);
        this.hide_detail.setManaged(true);
        this.hide_detail.requestFocus();
        this.show_detail.setManaged(false);
    }

    @FXML
    public void hide_detail() {
        this.overalleventitemsvbox.setVisible(false);
        this.businesseventitemsvbox.setVisible(false);
        this.show_detail.setVisible(true);
        this.hide_detail.setVisible(false);
        this.overalleventitemsvbox.setManaged(false);
        this.businesseventitemsvbox.setManaged(false);
        this.show_detail.setManaged(true);
        this.show_detail.requestFocus();
        this.hide_detail.setManaged(false);
    }

    private boolean validate_required(GlenixLabelText labelText) throws Exception {
        String value = labelText.getGlenixElementValue();
        if (value == null || value.isEmpty()) {
            labelText.setErrorDisplay("error");
            throw new Exception("Error, '" + labelText.getGlenixElementDescription() + "', is required.");
        }
        labelText.setErrorDisplay(null);
        return true;
    }

    public boolean validate() throws Exception {
        String ex;
        String val = this.TaxFileNumberId.getGlenixElementValue();
        if ((val == null || val.isEmpty()) && ((ex = this.IdentificationExemptionDetailsTFNExemptionTypeC.getGlenixElementValue()) == null || ex.isEmpty())) {
            this.TaxFileNumberId.setErrorDisplay("error");
            this.IdentificationExemptionDetailsTFNExemptionTypeC.setErrorDisplay("error");
            throw new Exception("Error, one of TFN or TFN exemption code must be completed.");
        }
        this.TaxFileNumberId.setErrorDisplay(null);
        this.IdentificationExemptionDetailsTFNExemptionTypeC.setErrorDisplay(null);
        this.validate_required(this.Line1T);
        this.validate_required(this.LocalityNameT);
        String countryCode = this.CountryC.getGlenixElementValue();
        if (countryCode == null || countryCode.isEmpty()) {
            this.CountryC.setErrorDisplay("error");
            throw new Exception("Error, Payee country is required.");
        }
        this.CountryC.setErrorDisplay(null);
        val = this.StateOrTerritoryC.getGlenixElementValue();
        if (countryCode.equals("au")) {
            if (val == null || val.isEmpty()) {
                this.StateOrTerritoryC.setErrorDisplay("error");
                throw new Exception("Error, Payee state is required for Australian addresses.");
            }
        } else if (val != null && !val.isEmpty()) {
            this.StateOrTerritoryC.setErrorDisplay("error");
            throw new Exception("Error, Payee state must be blank for overseas addresses.");
        }
        this.StateOrTerritoryC.setErrorDisplay(null);
        val = this.PostcodeT.getGlenixElementValue();
        if (countryCode.equals("au")) {
            if (val == null || val.isEmpty()) {
                this.PostcodeT.setErrorDisplay("error");
                throw new Exception("Error, Payee postcode is required for Australian addresses.");
            }
        } else if (val != null && !val.isEmpty()) {
            this.PostcodeT.setErrorDisplay("error");
            throw new Exception("Error, Payee postcode must be blank for overseas addresses.");
        }
        this.PostcodeT.setErrorDisplay(null);
        val = this.ResidencyTaxPurposesPersonStatusC.getGlenixElementValue();
        if (val == null || val.isEmpty()) {
            this.ResidencyTaxPurposesPersonStatusC.setErrorDisplay("error");
            throw new Exception("Error, Payee residency status is required.");
        }
        this.ResidencyTaxPurposesPersonStatusC.setErrorDisplay(null);
        val = this.PaymentBasisC.getGlenixElementValue();
        if (val == null || val.isEmpty()) {
            this.PaymentBasisC.setErrorDisplay("error");
            throw new Exception("Error, Payee payment basis is required.");
        }
        this.PaymentBasisC.setErrorDisplay(null);
        val = this.TaxOffsetClaimTaxFreeThresholdI.getGlenixElementValue();
        if (val == null || val.isEmpty()) {
            this.TaxOffsetClaimTaxFreeThresholdI.setErrorDisplay("error");
            throw new Exception("Error, Payee claim tax free threshold is required.");
        }
        this.TaxOffsetClaimTaxFreeThresholdI.setErrorDisplay(null);
        val = this.IncomeTaxPayAsYouGoWithholdingStudyAndTrainingLoanRepaymentI.getGlenixElementValue();
        if (val == null || val.isEmpty()) {
            this.IncomeTaxPayAsYouGoWithholdingStudyAndTrainingLoanRepaymentI.setErrorDisplay("error");
            throw new Exception("Error, Payee study and training loan repayment indicator is required.");
        }
        this.IncomeTaxPayAsYouGoWithholdingStudyAndTrainingLoanRepaymentI.setErrorDisplay(null);
        val = this.StudentLoanStudentFinancialSupplementSchemeI.getGlenixElementValue();
        if (val == null || val.isEmpty()) {
            this.StudentLoanStudentFinancialSupplementSchemeI.setErrorDisplay("error");
            throw new Exception("Error, Payee student financial supplement indicator is required.");
        }
        this.StudentLoanStudentFinancialSupplementSchemeI.setErrorDisplay(null);
        val = this.StatementAcceptedI.getGlenixElementValue();
        if (val == null || val.isEmpty()) {
            this.StatementAcceptedI.setErrorDisplay("error");
            throw new Exception("Error, Payee declaration statement accepted indicator is required.");
        }
        this.StatementAcceptedI.setErrorDisplay(null);
        return true;
    }
}

