/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import au.com.glenix.ApplicationController;
import au.com.glenix.Glenix;
import au.com.glenix.GlenixFile;
import au.com.glenix.GlenixSBRAttachment;
import au.com.glenix.GlenixSBRResponse;
import au.com.glenix.MessageDetails;
import au.com.glenix.trn.Business;
import au.com.glenix.trn.BusinessMessage;
import au.com.glenix.trn.GlenixResult;
import au.com.glenix.trn.GlenixTrnXBRL;
import au.com.glenix.widget.GlenixBranchController;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ReceiveFilesController
extends GlenixBranchController {
    @FXML
    private Label error_message;
    private ApplicationController xbrlFileController = null;
    private HashMap<String, File> filesCache = new HashMap();
    private HashMap<String, ReceiveFile> receivedFiles = null;
    @FXML
    private CheckBox overwrite;
    @FXML
    private TableView<ReceiveFile> fileListTable;
    @FXML
    private TableColumn updatedByPublicKey;
    private DocumentBuilder dBuilder;

    public ReceiveFilesController(ApplicationController xbrlFileController) {
        this.xbrlFileController = xbrlFileController;
    }

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        super.initialize(url, rb);
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setNamespaceAware(true);
            this.dBuilder = dbFactory.newDocumentBuilder();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
            this.error_message.setText(e.getMessage());
        }
        this.fileListTable.setRowFactory(tv -> {
            TableRow row = new TableRow();
            row.setOnMouseClicked(event -> {
                if (event.getClickCount() == 2 && !row.isEmpty()) {
                    ReceiveFile rf = (ReceiveFile)row.getItem();
                    if (rf != null) {
                        this.openFile(rf);
                    } else {
                        this.error_message.setText("Error, could not get business file.");
                    }
                }
            });
            return row;
        });
        this.fileListTable.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
    }

    @FXML
    private void downloadSelectedFiles() {
        try {
            final ObservableList selectedFiles = this.fileListTable.getSelectionModel().getSelectedItems();
            if (selectedFiles != null && selectedFiles.size() > 0) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        for (ReceiveFile b : selectedFiles) {
                            b.downloadFile(ReceiveFilesController.this.overwrite.isSelected());
                        }
                        ReceiveFilesController.this.fileListTable.refresh();
                        ReceiveFilesController.this.overwrite.setSelected(false);
                    }
                }).start();
            } else {
                String message = "Error, there are no selected files to download.";
                this.xbrlFileController.setStatusBarMessage(message);
                this.error_message.setText(message);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    private void openSelectedFile() {
        try {
            ObservableList selectedFiles = this.fileListTable.getSelectionModel().getSelectedItems();
            if (selectedFiles != null && selectedFiles.size() > 0) {
                if (selectedFiles.size() > 1) {
                    String message = "Error, more than one file selected. Open one at a time.";
                    this.xbrlFileController.setStatusBarMessage(message);
                    this.error_message.setText(message);
                } else {
                    Iterator message = selectedFiles.iterator();
                    if (message.hasNext()) {
                        ReceiveFile b = (ReceiveFile)message.next();
                        this.openFile(b);
                    }
                }
            } else {
                String message = "Error, there are no selected files to open.";
                this.xbrlFileController.setStatusBarMessage(message);
                this.error_message.setText(message);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    private void openFile(ReceiveFile receiveFile) {
        try {
            if (receiveFile == null) {
                throw new Exception("Error, business file is null cannot open");
            }
            String bi = receiveFile.getBusinessIdentifier();
            if (bi == null) {
                throw new Exception("Error, business identifier is null cannot open");
            }
            String fn = receiveFile.getBusinessFileName();
            if (fn == null) {
                throw new Exception("Error, business file name is null cannot open");
            }
            File file = this.filesCache.get(fn);
            if (file == null) {
                file = this.xbrlFileController.locateDownloadedFile(fn);
            }
            if (file != null && file.exists()) {
                try {
                    this.xbrlFileController.openFileE(file);
                    this.xbrlFileController.setTitle("Temporary file for " + receiveFile.getBusinessLegalName());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.error_message.setText(e.getMessage());
                    this.xbrlFileController.setStatusBarMessage(e.getMessage());
                }
            } else {
                receiveFile.downloadFile(false, receiveFile.getBusinessFileName(), true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    private void getFileList() {
        this.getFileListDoIt();
    }

    private HashMap<String, ReceiveFile> buildReceiveFileCollection(Document doc) {
        if (doc == null) {
            return null;
        }
        Element root = doc.getDocumentElement();
        if (root == null) {
            return null;
        }
        HashMap<String, ReceiveFile> result = new HashMap<String, ReceiveFile>();
        NodeList nodeList = root.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element businessEl;
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || (businessEl = (Element)node).getNamespaceURI() == null || !businessEl.getNamespaceURI().equals("http://www.glenix.com.au/") || businessEl.getLocalName() == null || !businessEl.getLocalName().equals("business")) continue;
            try {
                Business b = new Business();
                b.loadDocumentElement(doc, businessEl);
                String bi = b.getBusinessIdentifier();
                if (bi == null || bi.isEmpty()) continue;
                ReceiveFile rf = result.get(bi);
                if (rf == null) {
                    rf = new ReceiveFile(bi);
                    result.put(bi, rf);
                }
                rf.addBusiness(b);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private void setFileListTableItems(ArrayList<ReceiveFile> items) {
        items.sort(new Comparator<ReceiveFile>(){

            @Override
            public int compare(ReceiveFile b1, ReceiveFile b2) {
                int res;
                String aat1 = b1.getOldestAccountantAction();
                String aat2 = b2.getOldestAccountantAction();
                if (aat1 != null && !aat1.isEmpty()) {
                    if (aat2 == null || aat2.isEmpty()) {
                        return -1;
                    }
                    res = aat2.compareTo(aat1);
                    if (res != 0) {
                        return res;
                    }
                } else if (aat2 != null && !aat2.isEmpty()) {
                    return 1;
                }
                aat1 = b1.getOldestUserAction();
                aat2 = b2.getOldestUserAction();
                if (aat1 != null && !aat1.isEmpty()) {
                    if (aat2 == null || aat2.isEmpty()) {
                        return -1;
                    }
                    res = aat2.compareTo(aat1);
                    if (res != 0) {
                        return res;
                    }
                } else if (aat2 != null && !aat2.isEmpty()) {
                    return 1;
                }
                if ((res = b2.getUpdateTime().compareTo(b1.getUpdateTime())) != 0) {
                    return res;
                }
                return b2.getBusinessIdentifier().compareTo(b1.getBusinessIdentifier());
            }
        });
        ObservableList olb = FXCollections.observableArrayList(items);
        this.fileListTable.setItems(olb);
        this.fileListTable.refresh();
    }

    private void getFileListDoIt() {
        final ApplicationController applicationController = this.xbrlFileController;
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Platform.runLater(() -> applicationController.setStatusBarMessage("Begin request file list..."));
                    GlenixSBRResponse response = applicationController.sendDocumentToFAS(Glenix.soap_service_business_files, "List", (GlenixSBRAttachment)null);
                    response.parseResponse();
                    Document doc = response.getDocumentByHref("res.xml");
                    GlenixResult glenixResult = new GlenixResult();
                    glenixResult.loadDocumentElement(doc, doc.getDocumentElement());
                    Platform.runLater(() -> applicationController.setStatusBarMessage("Interpreting response from FAS..."));
                    String resultCode = null;
                    if (glenixResult != null) {
                        resultCode = glenixResult.getResultCode();
                    }
                    if (resultCode == null) {
                        throw new Exception("Error, unable to send file");
                    }
                    if (!resultCode.equals("OK")) {
                        if (resultCode.equals("ERRORLICENSE")) {
                            throw new Exception("Error, you do not have the required license to perform this action. You may need to contact Free Accounting Software on 1300 113 733.");
                        }
                        if (resultCode.equals("ERRORVERSION")) {
                            throw new Exception("Error, the version of the software you are using is out of date. You need to upgrade first please go to www.freeaccountingsoftware.com.au to download the latest version.");
                        }
                        if (resultCode.equals("ERROR")) {
                            throw new Exception("Error, unable to send file, error code " + resultCode + ", description " + glenixResult.getResultDescription());
                        }
                        throw new Exception("Error, unable to send file, error code " + resultCode + ", description " + glenixResult.getResultDescription());
                    }
                    doc = response.getDocumentByHref("data.xml");
                    ReceiveFilesController.this.receivedFiles = ReceiveFilesController.this.buildReceiveFileCollection(doc);
                    for (ReceiveFile rf : ReceiveFilesController.this.receivedFiles.values()) {
                        rf.setBusinessDetailsFromFile();
                    }
                    ArrayList rfar = new ArrayList();
                    rfar.addAll(ReceiveFilesController.this.receivedFiles.values());
                    ReceiveFilesController.this.setFileListTableItems(rfar);
                    Platform.runLater(() -> {
                        try {
                            ReceiveFilesController.this.error_message.setText("File list received.");
                            applicationController.setStatusBarMessage("File list received.");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            ReceiveFilesController.this.error_message.setText(e.getMessage());
                            applicationController.setStatusBarMessage(e.getMessage());
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Platform.runLater(() -> {
                        e.printStackTrace();
                        ReceiveFilesController.this.error_message.setText(e.getMessage());
                        applicationController.setStatusBarMessage(e.getMessage());
                    });
                }
            }
        }).start();
    }

    public class ReceiveFile {
        private String businessIdentifier = null;
        private HashSet<Business> businesses = new HashSet();
        private Business maxBusiness = null;
        private String lastSender = null;
        private Boolean downloadrequired = null;

        public ReceiveFile(String businessIdentifier) {
            this.businessIdentifier = businessIdentifier;
        }

        public String getBusinessIdentifier() {
            return this.businessIdentifier;
        }

        public void addBusiness(Business business) {
            this.businesses.add(business);
            this.maxBusiness = null;
            this.lastSender = null;
            this.downloadrequired = null;
        }

        public Business getLatestBusiness() {
            if (this.maxBusiness != null) {
                return this.maxBusiness;
            }
            String maxT = null;
            for (Business b : this.businesses) {
                String time = b.getUpdateTime();
                if (maxT != null && time.compareTo(maxT) <= 0) continue;
                this.maxBusiness = b;
                maxT = time;
            }
            return this.maxBusiness;
        }

        public String getSender() {
            block6: {
                if (this.lastSender != null) {
                    return this.lastSender;
                }
                Business b = this.getLatestBusiness();
                if (b == null) {
                    return null;
                }
                String key = b.getUpdatedByPublicKey();
                try {
                    String cn;
                    X509Certificate x = ReceiveFilesController.this.xbrlFileController.readX509Certificate(key);
                    if (x == null || (cn = ReceiveFilesController.this.xbrlFileController.getX509CertificateCommonNameUnverified(x)) == null || cn.isEmpty() || cn.toLowerCase().contains("verified")) break block6;
                    boolean isSigned = false;
                    try {
                        ReceiveFilesController.this.xbrlFileController.x509CertificateIsSigned(x);
                        isSigned = true;
                    }
                    catch (Exception e) {
                        isSigned = false;
                    }
                    cn = isSigned ? cn + " (Identity verified)" : cn + " (NOT verified)";
                    this.lastSender = cn;
                    return this.lastSender;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    ReceiveFilesController.this.xbrlFileController.setStatusBarMessage(e.getMessage());
                }
            }
            return null;
        }

        public String getUpdateTime() {
            Business b = this.getLatestBusiness();
            if (b == null) {
                return null;
            }
            return b.getUpdateTime();
        }

        public String getBusinessLegalName() {
            Business b = this.getLatestBusiness();
            if (b == null) {
                return null;
            }
            return b.getBusinessLegalName();
        }

        public String getBusinessABN() {
            Business b = this.getLatestBusiness();
            if (b == null) {
                return null;
            }
            return b.getBusinessABN();
        }

        public String getBusinessFileName() {
            Business b = this.getLatestBusiness();
            if (b == null) {
                return null;
            }
            return b.getBusinessFileName();
        }

        public String getOldestUserAction() {
            if (this.downloadrequired != null && this.downloadrequired.booleanValue()) {
                return this.getUpdateTime();
            }
            Business b = this.getLatestBusiness();
            if (b == null) {
                return this.getUpdateTime();
            }
            int count = b.getBusinessMessageCount();
            String oldestTimeStr = null;
            for (int i = 0; i < count; ++i) {
                BusinessMessage bm = b.getBusinessMessage(i);
                String status = bm.getMessageStatus();
                if (status == null || !status.equals("user") && !status.equals("client")) continue;
                String tmp = bm.getBusinessMessageTime();
                if (oldestTimeStr != null && tmp.compareTo(oldestTimeStr) >= 0) continue;
                oldestTimeStr = tmp;
            }
            return oldestTimeStr;
        }

        public String getOldestAccountantAction() {
            if (this.downloadrequired != null && this.downloadrequired.booleanValue()) {
                return this.getUpdateTime();
            }
            Business b = this.getLatestBusiness();
            if (b == null) {
                return this.getUpdateTime();
            }
            int count = b.getBusinessMessageCount();
            String oldestTimeStr = null;
            for (int i = 0; i < count; ++i) {
                BusinessMessage bm = b.getBusinessMessage(i);
                String status = bm.getMessageStatus();
                if (status == null || !status.equals("accountant")) continue;
                String tmp = bm.getBusinessMessageTime();
                if (oldestTimeStr != null && tmp.compareTo(oldestTimeStr) >= 0) continue;
                oldestTimeStr = tmp;
            }
            return oldestTimeStr;
        }

        public String getOldestReviewerAction() {
            if (this.downloadrequired != null && this.downloadrequired.booleanValue()) {
                return this.getUpdateTime();
            }
            Business b = this.getLatestBusiness();
            if (b == null) {
                return this.getUpdateTime();
            }
            int count = b.getBusinessMessageCount();
            String oldestTimeStr = null;
            for (int i = 0; i < count; ++i) {
                BusinessMessage bm = b.getBusinessMessage(i);
                String status = bm.getMessageStatus();
                if (status == null || !status.equals("reviewer")) continue;
                String tmp = bm.getBusinessMessageTime();
                if (oldestTimeStr != null && tmp.compareTo(oldestTimeStr) >= 0) continue;
                oldestTimeStr = tmp;
            }
            return oldestTimeStr;
        }

        public String getOldestSupportAction() {
            if (this.downloadrequired != null && this.downloadrequired.booleanValue()) {
                return this.getUpdateTime();
            }
            Business b = this.getLatestBusiness();
            if (b == null) {
                return this.getUpdateTime();
            }
            int count = b.getBusinessMessageCount();
            String oldestTimeStr = null;
            for (int i = 0; i < count; ++i) {
                BusinessMessage bm = b.getBusinessMessage(i);
                String status = bm.getMessageStatus();
                if (status != null && !status.isEmpty() && !status.equals("support")) continue;
                String tmp = bm.getBusinessMessageTime();
                if (oldestTimeStr != null && tmp.compareTo(oldestTimeStr) >= 0) continue;
                oldestTimeStr = tmp;
            }
            return oldestTimeStr;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setBusinessDetailsFromFile() {
            block12: {
                Business b = this.getLatestBusiness();
                if (b == null) {
                    return;
                }
                String fileName = b.getBusinessFileName();
                if (fileName == null || fileName.isEmpty()) {
                    return;
                }
                File file = ReceiveFilesController.this.xbrlFileController.locateDownloadedFile(fileName);
                if (!file.exists()) {
                    return;
                }
                try {
                    GlenixFile gf = ReceiveFilesController.this.xbrlFileController.loadGlenixFile(file);
                    if (gf == null) break block12;
                    try {
                        Document fileBusDoc;
                        Business fileBusiness;
                        GlenixTrnXBRL fileXBRL = ReceiveFilesController.this.xbrlFileController.getBusinessMessageXBRLFromFile(gf);
                        if (fileXBRL != null && (fileBusiness = fileXBRL.getBusiness()) != null) {
                            fileBusDoc = ReceiveFilesController.this.dBuilder.newDocument();
                            fileBusiness.appendToElement(fileBusDoc);
                            b.loadDocumentElement(fileBusDoc, fileBusDoc.getDocumentElement());
                        }
                        if ((fileXBRL = ReceiveFilesController.this.xbrlFileController.getBusinessMasterFileXBRLFromFile(gf)) != null && (fileBusiness = fileXBRL.getBusiness()) != null) {
                            fileBusDoc = ReceiveFilesController.this.dBuilder.newDocument();
                            fileBusiness.appendToElement(fileBusDoc);
                            b.loadDocumentElement(fileBusDoc, fileBusDoc.getDocumentElement());
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        gf.closeFile();
                    }
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                }
            }
        }

        public boolean getDownloadRequired() {
            if (this.downloadrequired != null) {
                return this.downloadrequired;
            }
            for (Business b : this.businesses) {
                File file;
                String fileName = b.getBusinessFileName();
                if (fileName == null || fileName.isEmpty() || (file = ReceiveFilesController.this.xbrlFileController.locateDownloadedFile(fileName)).exists()) continue;
                this.downloadrequired = true;
                return this.downloadrequired;
            }
            this.downloadrequired = false;
            return this.downloadrequired;
        }

        public String getDownloadIndicator() {
            boolean dr = this.getDownloadRequired();
            if (dr) {
                return "Download required";
            }
            return null;
        }

        public void downloadFileAsync(final boolean overwrite) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    ReceiveFile.this.downloadFile(overwrite);
                }
            }).start();
        }

        public void downloadFile(boolean overwrite) {
            for (Business b : this.businesses) {
                String fileName = b.getBusinessFileName();
                if (fileName == null || fileName.isEmpty()) continue;
                File file = ReceiveFilesController.this.xbrlFileController.locateDownloadedFile(fileName);
                if (!file.exists()) {
                    this.downloadFile(b.getBusinessFileName(), false);
                    continue;
                }
                if (!overwrite) continue;
                this.downloadFile(b.getBusinessFileName(), false);
            }
            this.setBusinessDetailsFromFile();
        }

        public void downloadFile(boolean overwrite, String businessFileName, boolean immediateopen) {
            File file = ReceiveFilesController.this.xbrlFileController.locateDownloadedFile(businessFileName);
            if (!file.exists()) {
                this.downloadFile(businessFileName, immediateopen);
            } else if (overwrite) {
                this.downloadFile(businessFileName, immediateopen);
            } else {
                ReceiveFilesController.this.error_message.setText("Error, trying to overwrite an already downloaded file");
                ReceiveFilesController.this.xbrlFileController.setStatusBarMessage("Error, trying to overwrite an already downloaded file");
            }
        }

        private void downloadFile(String businessFileName, boolean immediateopen) {
            this.downloadrequired = null;
            ApplicationController applicationController = ReceiveFilesController.this.xbrlFileController;
            Platform.runLater(() -> applicationController.setStatusBarMessage("Begin request file..."));
            try {
                MessageDetails md = new MessageDetails();
                md.setService(Glenix.soap_service_business_files);
                md.setAction("Get");
                md.setPropBusinessIdentifier(this.businessIdentifier);
                md.setPropBusinessFileName(businessFileName);
                GlenixSBRResponse response = applicationController.sendDocumentToFAS(md);
                response.parseResponse();
                Document doc = response.getDocumentByHref("res.xml");
                GlenixResult glenixResult = new GlenixResult();
                glenixResult.loadDocumentElement(doc, doc.getDocumentElement());
                Platform.runLater(() -> applicationController.setStatusBarMessage("Interpreting response from FAS..."));
                String resultCode = null;
                if (glenixResult != null) {
                    resultCode = glenixResult.getResultCode();
                }
                if (resultCode == null) {
                    throw new Exception("Error, unable to get file");
                }
                if (!resultCode.equals("OK")) {
                    if (resultCode.equals("ERRORLICENSE")) {
                        throw new Exception("Error, you do not have the required license to perform this action. You may need to contact Free Accounting Software on 1300 113 733.");
                    }
                    if (resultCode.equals("ERRORVERSION")) {
                        throw new Exception("Error, the version of the software you are using is out of date. You need to upgrade first please go to www.freeaccountingsoftware.com.au to download the latest version.");
                    }
                    if (resultCode.equals("ERROR")) {
                        throw new Exception("Error, unable to get file, error code " + resultCode + ", description " + glenixResult.getResultDescription());
                    }
                    throw new Exception("Error, unable to get file, error code " + resultCode + ", description " + glenixResult.getResultDescription());
                }
                InputStream is = response.getInputStreamByHref("MyBusiness-download.fas");
                if (is != null) {
                    File outFile = applicationController.getDownloadedFile(businessFileName);
                    FileOutputStream os = new FileOutputStream(outFile);
                    byte[] buf = new byte[1024];
                    int readlen = 0;
                    while ((readlen = is.read(buf)) > 0) {
                        ((OutputStream)os).write(buf, 0, readlen);
                    }
                    os.flush();
                    ((OutputStream)os).close();
                    ReceiveFilesController.this.filesCache.put(businessFileName, outFile);
                    if (immediateopen) {
                        Platform.runLater(() -> {
                            try {
                                applicationController.openFileE(outFile);
                                applicationController.setTitle("Temporary file for " + this.getBusinessLegalName());
                                applicationController.setStatusBarMessage("Download complete file opened");
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                ReceiveFilesController.this.error_message.setText(e.getMessage());
                                applicationController.setStatusBarMessage(e.getMessage());
                            }
                        });
                    }
                }
                Platform.runLater(() -> {
                    try {
                        ReceiveFilesController.this.error_message.setText("File received.");
                        applicationController.setStatusBarMessage("File received.");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        ReceiveFilesController.this.error_message.setText(e.getMessage());
                        applicationController.setStatusBarMessage(e.getMessage());
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
                Platform.runLater(() -> {
                    e.printStackTrace();
                    ReceiveFilesController.this.error_message.setText(e.getMessage());
                    applicationController.setStatusBarMessage(e.getMessage());
                });
            }
        }
    }
}

