/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import au.com.glenix.ApplicationController;
import au.com.glenix.trn.Business;
import au.com.glenix.trn.GlenixTrnXBRL;
import au.com.glenix.trn.Provision;
import au.com.glenix.trn.Transaction;
import au.com.glenix.trn.TransactionLine;
import au.com.glenix.widget.GlenixBranchController;
import au.com.glenix.widget.GlenixPDFWrapper;
import au.com.glenix.widget.GlenixPDFWrapperNewPageCallback;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ProvisionListController
extends GlenixBranchController
implements GlenixPDFWrapperNewPageCallback {
    @FXML
    private TableView provisionTable;
    @FXML
    private TableColumn<Transaction, String> actionColumn;
    @FXML
    private Label error_message;
    @FXML
    private Label page_heading;
    @FXML
    private TableColumn provisionName;
    @FXML
    private TableColumn provisionPercentage;
    @FXML
    private TableColumn provisionDescription;
    @FXML
    private TableColumn provisionGrossBASClassification;
    private ObservableList<Transaction> transactionObservableList;
    private ApplicationController xbrlFileController = null;
    private GlenixTrnXBRL glenixTrnXBRL = null;

    public ProvisionListController(ApplicationController xbrlFileController) {
        this.xbrlFileController = xbrlFileController;
    }

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        this.provisionTable.setRowFactory(tv -> {
            TableRow row = new TableRow();
            row.setOnMouseClicked(event -> {
                if (event.getClickCount() == 2) {
                    if (!row.isEmpty()) {
                        Transaction transaction = (Transaction)row.getItem();
                        if (transaction != null) {
                            TransactionLine line = transaction.getFirstTransactionLine();
                            if (line != null) {
                                Provision p = line.getProvision();
                                if (p != null) {
                                    try {
                                        this.xbrlFileController.gotoProvisionEdit(p);
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                        this.error_message.setText("Error, could not go to provision page.");
                                    }
                                } else {
                                    this.error_message.setText("Error, could not get provision.");
                                }
                            } else {
                                this.error_message.setText("Error, could not get provision transaction line.");
                            }
                        } else {
                            this.error_message.setText("Error, could not get provision transaction.");
                        }
                    } else {
                        this.addProvision();
                    }
                }
            });
            return row;
        });
        this.provisionTable.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
    }

    @Override
    public void buildGlenixXBRL(Document resultDoc, Element resultElement) throws Exception {
        Element xbrlEl = resultDoc.createElementNS("http://www.glenix.com.au/", "gx:glenix");
        if (resultElement == null) {
            resultDoc.appendChild(xbrlEl);
        } else {
            resultElement.appendChild(xbrlEl);
        }
        Element businessEl = resultDoc.createElementNS("http://www.glenix.com.au/", "gx:business");
        xbrlEl.appendChild(businessEl);
        Element transactionEl = resultDoc.createElementNS("http://www.glenix.com.au/", "gx:transaction");
        businessEl.appendChild(transactionEl);
        Element transactionLineEl = resultDoc.createElementNS("http://www.glenix.com.au/", "gx:transactionLine");
        transactionEl.appendChild(transactionLineEl);
        super.buildGlenixXBRL(resultDoc, transactionLineEl);
    }

    @Override
    public void loadGlenixXBRL(Document loadDoc, Element loadElement) throws Exception {
        if (loadElement.getNamespaceURI() != null && loadElement.getNamespaceURI().equals("http://www.glenix.com.au/") && loadElement.getLocalName() != null && loadElement.getLocalName().equals("glenix")) {
            NodeList nodeList = loadElement.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element businessElement;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || (businessElement = (Element)node).getNamespaceURI() == null || !businessElement.getNamespaceURI().equals("http://www.glenix.com.au/") || businessElement.getLocalName() == null || !businessElement.getLocalName().equals("business")) continue;
                NodeList nodeList2 = businessElement.getChildNodes();
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    Element transactionElement;
                    Node node2 = nodeList2.item(j);
                    if (node2.getNodeType() != 1 || (transactionElement = (Element)node2).getNamespaceURI() == null || !transactionElement.getNamespaceURI().equals("http://www.glenix.com.au/") || transactionElement.getLocalName() == null || !transactionElement.getLocalName().equals("transaction")) continue;
                    NodeList nodeList3 = transactionElement.getChildNodes();
                    for (int k = 0; k < nodeList3.getLength(); ++k) {
                        Element transactionLineElement;
                        Node node3 = nodeList3.item(k);
                        if (node3.getNodeType() != 1 || (transactionLineElement = (Element)node3).getNamespaceURI() == null || !transactionLineElement.getNamespaceURI().equals("http://www.glenix.com.au/") || transactionLineElement.getLocalName() == null || !transactionLineElement.getLocalName().equals("transactionLine")) continue;
                        NodeList nodeList4 = transactionLineElement.getChildNodes();
                        for (int m = 0; m < nodeList4.getLength(); ++m) {
                            Node node4 = nodeList4.item(m);
                            if (node4.getNodeType() != 1) continue;
                            Element el = (Element)node4;
                            super.loadGlenixXBRL(loadDoc, el);
                        }
                    }
                }
            }
        }
    }

    @FXML
    private void saveProvision() {
        try {
            this.xbrlFileController.saveProvisionList();
        }
        catch (Exception e) {
            this.error_message.setText(e.getMessage());
            e.printStackTrace();
        }
    }

    @FXML
    private void addProvision() {
        try {
            this.xbrlFileController.gotoProvisionEdit(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText("Error, could not load provision edit page.");
        }
    }

    public void setModel(GlenixTrnXBRL glenixTrnXBRL) throws Exception {
        this.glenixTrnXBRL = glenixTrnXBRL;
        if (glenixTrnXBRL != null) {
            Document doc = glenixTrnXBRL.buildDocument();
            if (doc != null) {
                this.loadGlenixXBRL(doc, doc.getDocumentElement());
            }
            this.setProvisionObservableList();
        }
    }

    private void setProvisionObservableList() {
        Business business = this.glenixTrnXBRL.getBusiness();
        if (business == null) {
            return;
        }
        ArrayList<Transaction> transactionArrayList = business.getTransactionArrayList();
        transactionArrayList.sort(new Comparator<Transaction>(){

            @Override
            public int compare(Transaction t1, Transaction t2) {
                int res;
                int res2;
                Provision a1 = t1.getProvision();
                Provision a2 = t2.getProvision();
                if (a1 == null && a2 != null) {
                    return -1;
                }
                if (a2 == null && a1 != null) {
                    return 1;
                }
                if (a2 == null && a1 == null) {
                    return 0;
                }
                String name1 = a1.getProvisionName();
                String name2 = a2.getProvisionName();
                if ((name1 == null || name1.isEmpty()) && name2 != null && !name2.isEmpty()) {
                    return -1;
                }
                if ((name2 == null || name2.isEmpty()) && name1 != null && !name1.isEmpty()) {
                    return 1;
                }
                if (name1 != null && name2 != null && (res2 = name1.compareToIgnoreCase(name2)) != 0) {
                    return res2;
                }
                String id1 = a1.getProvisionIdentifier();
                String id2 = a2.getProvisionIdentifier();
                if ((id1 == null || id1.isEmpty()) && id2 != null && !id2.isEmpty()) {
                    return -1;
                }
                if ((id2 == null || id2.isEmpty()) && id1 != null && !id1.isEmpty()) {
                    return 1;
                }
                if (id1 != null && id2 != null && (res = id1.compareTo(id2)) != 0) {
                    return res;
                }
                return 0;
            }
        });
        this.transactionObservableList = FXCollections.observableList(transactionArrayList);
        this.provisionTable.setItems(this.transactionObservableList);
    }

    public void refreshTable() {
        this.setProvisionObservableList();
        this.provisionTable.refresh();
    }

    @FXML
    private void deleteSelectedProvisions() {
        try {
            ObservableList selectedProvisionTransactions = this.provisionTable.getSelectionModel().getSelectedItems();
            if (selectedProvisionTransactions != null && selectedProvisionTransactions.size() > 0) {
                this.xbrlFileController.deleteSelectedProvisions((ObservableList<Transaction>)selectedProvisionTransactions);
                this.xbrlFileController.saveProvisionList();
                this.setModel(this.xbrlFileController.getGlenixTrnXBRLProvision());
            } else {
                String message = "Error, there are no selected provisions to delete.";
                this.xbrlFileController.setStatusBarMessage(message);
                this.error_message.setText(message);
            }
            this.refreshTable();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @Override
    public GlenixPDFWrapper buildPDF(boolean includeBlanks) throws Exception {
        GlenixPDFWrapper gpw = new GlenixPDFWrapper();
        gpw.addPDPage();
        gpw.setColumns(6);
        gpw.setColumnLeftPosAndWidthMM(0, 20.0, 180.0);
        gpw.setColumnLeftPosAndWidthMM(1, 20.0, 180.0);
        gpw.setColumnLeftPosAndWidthMM(2, 20.0, 50.0);
        gpw.setColumnLeftPosAndWidthMM(3, 70.0, 30.0);
        gpw.setColumnLeftPosAndWidthMM(4, 100.0, 60.0);
        gpw.setColumnLeftPosAndWidthMM(5, 160.0, 40.0);
        gpw.setColumnFont(0, gpw.muliBoldFont);
        gpw.setColumnFont(1, gpw.muliLightFont);
        gpw.setColumnFont(2, gpw.muliLightFont);
        gpw.setColumnFont(3, gpw.muliLightFont);
        gpw.setColumnFont(4, gpw.muliLightFont);
        gpw.setColumnFont(5, gpw.muliLightFont);
        Double fontSize = this.convertFontSize(this.page_heading.getFont().getSize());
        gpw.prepareString(0, this.page_heading.getText(), true, fontSize);
        gpw.drawStrings(10.0);
        fontSize = this.convertFontSize(new Double(this.xbrlFileController.getCurrentFontSize()));
        this.drawPDFColumnHeadings(gpw);
        gpw.setAddPageCallback(this);
        for (Transaction t : this.transactionObservableList) {
            gpw.prepareString(2, t.getProvisionName(), true, fontSize);
            gpw.prepareString(3, t.getProvisionPercentage(), true, fontSize);
            gpw.prepareString(4, t.getProvisionDescription(), true, fontSize);
            gpw.prepareString(5, t.getProvisionGrossBASClassification(), true, fontSize);
            gpw.drawStrings(5.0);
        }
        gpw.addFooter();
        return gpw;
    }

    private void drawPDFColumnHeadings(GlenixPDFWrapper gpw) throws Exception {
        gpw.setColumnFont(2, gpw.muliBoldFont);
        gpw.setColumnFont(3, gpw.muliBoldFont);
        gpw.setColumnFont(4, gpw.muliBoldFont);
        gpw.setColumnFont(5, gpw.muliBoldFont);
        Double fontSize = this.convertFontSize(new Double(this.xbrlFileController.getCurrentFontSize()));
        gpw.prepareString(2, this.provisionName.getText(), true, fontSize);
        gpw.prepareString(3, this.provisionPercentage.getText(), true, fontSize);
        gpw.prepareString(4, this.provisionDescription.getText(), true, fontSize);
        gpw.prepareString(5, this.provisionGrossBASClassification.getText(), true, fontSize);
        gpw.drawStrings(5.0);
        gpw.setColumnFont(2, gpw.muliLightFont);
        gpw.setColumnFont(3, gpw.muliLightFont);
        gpw.setColumnFont(4, gpw.muliLightFont);
        gpw.setColumnFont(5, gpw.muliLightFont);
    }

    @Override
    public void newPDFPageAdded(GlenixPDFWrapper gpw) throws Exception {
        this.drawPDFColumnHeadings(gpw);
    }
}

