/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import au.com.glenix.ApplicationController;
import au.com.glenix.trn.Provision;
import au.com.glenix.widget.GlenixBranchController;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;

public class ProvisionEditController
extends GlenixBranchController {
    @FXML
    private Label error_message;
    private ApplicationController xbrlFileController = null;
    private DocumentBuilder dBuilder;
    private Provision provision = null;

    public ProvisionEditController(ApplicationController xbrlFileController) {
        this.xbrlFileController = xbrlFileController;
    }

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setNamespaceAware(true);
            this.dBuilder = dbFactory.newDocumentBuilder();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    public void setProvisionElement(Provision provision) throws Exception {
        this.provision = provision;
        this.error_message.setText(null);
        this.xbrlFileController.setStatusBarMessage(null);
        this.clearGlenixXBRL();
        if (provision != null) {
            Document doc = this.dBuilder.newDocument();
            provision.appendToElement(doc);
            this.loadGlenixXBRL(doc, doc.getDocumentElement());
        }
    }

    @FXML
    private void saveProvision() {
        try {
            Document resultDoc = this.dBuilder.newDocument();
            super.buildGlenixXBRL(resultDoc, null);
            if (this.provision == null) {
                this.provision = this.xbrlFileController.addProvision();
            }
            this.provision.loadDocumentElementOverwrite(resultDoc, resultDoc.getDocumentElement());
            this.xbrlFileController.saveProvision(this.provision);
            this.error_message.setText("Saved");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    public void clearProvision() {
        try {
            this.setProvisionElement(null);
            this.error_message.setText("New provision");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    private void gotoProvisionList() {
        this.xbrlFileController.gotoProvisionList();
    }
}

