/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import au.com.glenix.TransactionLineEditController;
import au.com.glenix.trn.Account;
import au.com.glenix.trn.Transaction;
import au.com.glenix.trn.TransactionLine;
import au.com.glenix.widget.GlenixController;
import java.net.URL;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.CheckBox;
import javax.xml.parsers.DocumentBuilderFactory;

public class PaySlipTimeSheetLineEditController
extends TransactionLineEditController {
    @FXML
    private CheckBox select;
    private boolean suspendsdtalert = false;

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        try {
            this.dbFactory = DocumentBuilderFactory.newInstance();
            this.dbFactory.setNamespaceAware(true);
            this.dBuilder = this.dbFactory.newDocumentBuilder();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.quantity != null) {
            this.quantity.setSingleChangeListener(new ChangeListener<String>(){

                public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                    if (PaySlipTimeSheetLineEditController.this.doupdate) {
                        PaySlipTimeSheetLineEditController.this.calculateAmountRateFromQuantity();
                        PaySlipTimeSheetLineEditController.this.updateListener();
                    }
                }
            });
        }
        this.startEndDateTime.setSingleChangeListener(new ChangeListener<Integer>(){

            public void changed(ObservableValue<? extends Integer> observable, Integer oldValue, Integer newValue) {
                if (newValue != null && !PaySlipTimeSheetLineEditController.this.suspendsdtalert) {
                    Double hoursValue = (double)Math.round((double)newValue.intValue() * 1.0E8 / 3600.0) / 1.0E8;
                    PaySlipTimeSheetLineEditController.this.quantity.setGlenixElementValue(hoursValue.toString());
                    PaySlipTimeSheetLineEditController.this.updateListener();
                }
            }
        });
    }

    public LocalDate getStartDate() {
        return this.startEndDateTime.getStartDate();
    }

    public LocalTime getStartTime() {
        return this.startEndDateTime.getStartTime();
    }

    public LocalTime getEndTime() {
        return this.startEndDateTime.getEndTime();
    }

    public LocalDateTime getStartDateTime() {
        return this.startEndDateTime.getStartDateTime();
    }

    public LocalDateTime getEndDateTime() {
        return this.startEndDateTime.getEndDateTime();
    }

    @Override
    public Double getQuantity() {
        return this.quantity.getDouble();
    }

    public void setStartDateTime(LocalDateTime startDateTime) {
        this.startEndDateTime.setStartDateTime(startDateTime);
    }

    public void setEndDateTime(LocalDateTime endDateTime) {
        this.startEndDateTime.setEndDateTime(endDateTime);
    }

    @Override
    public void setQuantity(Double value) throws Exception {
        this.suspendsdtalert = true;
        try {
            this.startEndDateTime.setQuantity(value);
            super.setQuantity(value);
        }
        finally {
            this.suspendsdtalert = false;
        }
    }

    @Override
    public void calculateAmountRateFromQuantity() {
        Double qty = this.quantity.getDouble();
        this.startEndDateTime.setQuantity(qty);
    }

    @Override
    public void setAccountTransactionList(ObservableList<Transaction> accountObservableList) {
        this.account.setItems(accountObservableList);
    }

    @Override
    public GlenixController getGlenixControllerByNameNS(String namespace, String name) {
        if (name != null) {
            if (name.equals("startDateTime")) {
                return super.getGlenixControllerByNameNS(namespace, "startEndDateTime");
            }
            if (name.equals("endDateTime")) {
                return super.getGlenixControllerByNameNS(namespace, "startEndDateTime");
            }
            if (name.equals("breakTime")) {
                return super.getGlenixControllerByNameNS(namespace, "startEndDateTime");
            }
        }
        return super.getGlenixControllerByNameNS(namespace, name);
    }

    @Override
    public void setTransactionLine(TransactionLine transactionLine) {
        this.transactionLine = transactionLine;
        if (transactionLine == null) {
            this.account.setGlenixElementValue(null);
            this.quantity.setGlenixElementValue(null);
        } else {
            Double qty;
            Account a = transactionLine.getAccount();
            if (a == null) {
                this.account.setGlenixElementValue(null);
            } else {
                this.account.setGlenixElementValue(a.getAccountIdentifier());
            }
            LocalDateTime ldt = transactionLine.getStartDateTimeAsDateTime();
            if (ldt != null) {
                this.startEndDateTime.setStartDateTime(ldt);
            }
            if ((ldt = transactionLine.getEndDateTimeAsDateTime()) != null) {
                this.startEndDateTime.setEndDateTime(ldt);
            }
            if ((qty = transactionLine.getQuantityAsDouble()) != null) {
                this.startEndDateTime.setQuantity(qty);
            }
        }
    }

    @Override
    public void calculateRateQuantityFromAmount() {
    }

    @Override
    public void calculateAmountQuantityFromRate() {
    }

    @Override
    public void calculateProvisionAmount() {
    }

    @Override
    public void setDefaultProvision(Transaction accountTransaction) {
    }

    @Override
    public void setProvisionTransactionList(ObservableList<Transaction> provisionObservableList) {
    }

    @Override
    public boolean getSelectValue() {
        return this.select.isSelected();
    }
}

