/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import au.com.glenix.ApplicationController;
import au.com.glenix.PaySlipEditFormController;
import au.com.glenix.PaySlipEditFormVBox;
import au.com.glenix.TransactionEditController;
import au.com.glenix.trn.Account;
import au.com.glenix.trn.BusinessMasterFile;
import au.com.glenix.trn.Counterparty;
import au.com.glenix.trn.GlenixTrnXBRL;
import au.com.glenix.trn.OutgoingMailServer;
import au.com.glenix.trn.PEE0003Payee;
import au.com.glenix.trn.PEE0003RemunerationPAYGW;
import au.com.glenix.trn.PEE0003UnusedAnnualOrLongServiceLeavePayment;
import au.com.glenix.trn.Profile;
import au.com.glenix.trn.Provision;
import au.com.glenix.trn.Transaction;
import au.com.glenix.trn.TransactionLine;
import au.com.glenix.trn.TransactionPaySlipDetail;
import au.com.glenix.widget.GlenixLabelText;
import java.io.File;
import java.net.URL;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ResourceBundle;
import java.util.UUID;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.web.HTMLEditor;

public class PaySlipEditController
extends TransactionEditController {
    @FXML
    protected HTMLEditor html_message;
    @FXML
    protected GlenixLabelText email_to;
    @FXML
    protected GlenixLabelText email_from;
    @FXML
    protected GlenixLabelText email_subject;
    protected DateTimeFormatter displayMonthFormatter = DateTimeFormatter.ofPattern("MM");
    String lastCounterpartyIdentifier = null;
    String lastTransactionDate = null;
    String lastTransactionNumber = null;

    public PaySlipEditController(ApplicationController xbrlFileController) {
        super(xbrlFileController);
    }

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        super.initialize(url, rb);
        ((PaySlipEditFormVBox)this.transactionEditFormVBox).setCounterpartyChangeListener(new ChangeListener<Transaction>(){

            public void changed(ObservableValue<? extends Transaction> observable, Transaction oldValue, Transaction newValue) {
                PaySlipEditController.this.calculateCounterpartyYTDTotals(true);
            }
        });
        ((PaySlipEditFormVBox)this.transactionEditFormVBox).setTransactionDateChangeListener(new ChangeListener<LocalDate>(){

            public void changed(ObservableValue<? extends LocalDate> observable, LocalDate oldValue, LocalDate newValue) {
                PaySlipEditController.this.calculateCounterpartyYTDTotals(true);
            }
        });
    }

    public void calculateCounterpartyYTDTotals(boolean doupdate) {
        String thisCounterpartyIdentifier = null;
        String thisTransactionDate = null;
        thisCounterpartyIdentifier = this.transactionEditFormVBox.getCounterpartyIdentifier();
        thisTransactionDate = this.transactionEditFormVBox.getTransactionDateString();
        LocalDate thisTransactionDateDate = this.transactionEditFormVBox.getTransactionLocalDate();
        if (this.xbrlFileController == null || thisCounterpartyIdentifier == null || thisTransactionDate == null) {
            return;
        }
        String thisTransactionNumber = null;
        if (this.transaction != null) {
            thisTransactionNumber = this.transaction.getTransactionNumber();
        }
        if (thisCounterpartyIdentifier.equals(this.lastCounterpartyIdentifier) && thisTransactionDate.equals(this.lastTransactionDate) && (thisTransactionNumber == null && this.lastTransactionNumber == null || thisTransactionNumber != null && thisTransactionNumber.equals(this.lastTransactionNumber))) {
            return;
        }
        this.lastCounterpartyIdentifier = thisCounterpartyIdentifier;
        this.lastTransactionDate = thisTransactionDate;
        this.lastTransactionNumber = thisTransactionNumber;
        try {
            GlenixTrnXBRL gtx = this.xbrlFileController.getTransactions(thisCounterpartyIdentifier, thisTransactionDateDate);
            if (gtx == null) {
                return;
            }
            GlenixTrnXBRL provisionTrnXBRL = this.xbrlFileController.getGlenixTrnXBRLProvision();
            if (provisionTrnXBRL == null) {
                return;
            }
            GlenixTrnXBRL accountTrnXBRL = this.xbrlFileController.getGlenixTrnXBRLAccount();
            if (accountTrnXBRL == null) {
                return;
            }
            ArrayList<Transaction> allCT = gtx.getTransactionArrayListByCounterparty(thisCounterpartyIdentifier);
            LocalDate paymentDate = ((PaySlipEditFormVBox)this.transactionEditFormVBox).getTransactionLocalDate();
            if (paymentDate != null) {
                int startYear = paymentDate.getYear();
                if (paymentDate.getMonthValue() < 7) {
                    --startYear;
                }
                LocalDate startOfFYDate = LocalDate.parse(startYear + "-07-01");
                LocalDate startOfMonthDate = LocalDate.parse(paymentDate.getYear() + "-" + paymentDate.format(this.displayMonthFormatter) + "-01");
                Double ytdOTEAmount = 0.0;
                Double mtdOTEAmount = 0.0;
                Double mtdSGCSuperAmount = 0.0;
                String transactionNumber = null;
                if (this.transaction != null) {
                    transactionNumber = this.transaction.getTransactionNumber();
                }
                HashMap<String, Double> totals = new HashMap<String, Double>();
                HashMap<String, Double> otherAllowancesTotals = new HashMap<String, Double>();
                HashMap<String, PaySlipEditFormController.ETPValues> etpValuesList = new HashMap<String, PaySlipEditFormController.ETPValues>();
                String lumpSumACode = null;
                for (Transaction t : allCT) {
                    PEE0003UnusedAnnualOrLongServiceLeavePayment lumpSumPayment;
                    PEE0003RemunerationPAYGW r;
                    PEE0003Payee p;
                    String status = t.getTransactionStatus();
                    if (status == null || !status.equals("posted") || transactionNumber != null && transactionNumber.equals(t.getTransactionNumber())) continue;
                    String tDateString = t.getTransactionDate();
                    LocalDate tDate = t.getTransactionDateAsDate();
                    if (tDate == null || tDate.isBefore(startOfFYDate) || tDate.isAfter(paymentDate)) continue;
                    if (tDate.equals(paymentDate)) {
                        String tBatchIdentifier = t.getBatchIdentifier();
                        String paySlipBatchIdentifier = null;
                        if (this.transaction != null) {
                            paySlipBatchIdentifier = this.transaction.getBatchIdentifier();
                        }
                        if (tBatchIdentifier == null || paySlipBatchIdentifier != null && tBatchIdentifier.compareTo(paySlipBatchIdentifier) > 0) continue;
                    }
                    boolean hasLumpSum = false;
                    int lineCount = t.getTransactionLineCount();
                    for (int i = 0; i < lineCount; ++i) {
                        String applySuper;
                        String ai;
                        Transaction accountTransaction;
                        Account a;
                        String pi;
                        Transaction provisionTransaction;
                        TransactionLine tl = t.getTransactionLine(i);
                        Double amount = tl.getAmountAsDouble();
                        Double provisionAmount = tl.getProvisionAmountAsDouble();
                        Provision p2 = tl.getProvision();
                        if (p2 != null && (provisionTransaction = provisionTrnXBRL.getProvisionTransaction(pi = p2.getProvisionIdentifier())) != null) {
                            String taxPSClassification;
                            String grossPSClassification = provisionTransaction.getProvisionGrossPSClassification();
                            if (grossPSClassification != null && amount != null) {
                                PaySlipEditFormController.ETPValues etpValues;
                                Double total = totals.get(grossPSClassification);
                                if (total == null) {
                                    total = 0.0;
                                }
                                total = total + amount;
                                totals.put(grossPSClassification, total);
                                if (grossPSClassification.equals("Individual_Non_Business_Employment_Allowances_Other")) {
                                    Double allowanceTotal;
                                    String key = provisionTransaction.getProvisionDescription();
                                    if (key == null || key.isEmpty()) {
                                        key = pi;
                                    }
                                    if ((allowanceTotal = otherAllowancesTotals.get(key)) == null) {
                                        allowanceTotal = 0.0;
                                    }
                                    allowanceTotal = allowanceTotal + amount;
                                    otherAllowancesTotals.put(key, allowanceTotal);
                                } else if (grossPSClassification.equals("Superannuation_Employment_Termination_Tax_Free_Component_B")) {
                                    etpValues = etpValuesList.get(tDateString + "_B");
                                    if (etpValues == null) {
                                        etpValues = new PaySlipEditFormController.ETPValues();
                                        etpValuesList.put(tDateString + "_B", etpValues);
                                        etpValues.setCode("B");
                                        etpValues.setDate(tDateString);
                                    }
                                    etpValues.addSuperannuation_Employment_Termination_Tax_Free_Component(amount);
                                } else if (grossPSClassification.equals("Superannuation_Employment_Termination_Tax_Free_Component_D")) {
                                    etpValues = etpValuesList.get(tDateString + "_D");
                                    if (etpValues == null) {
                                        etpValues = new PaySlipEditFormController.ETPValues();
                                        etpValuesList.put(tDateString + "_D", etpValues);
                                        etpValues.setCode("D");
                                        etpValues.setDate(tDateString);
                                    }
                                    etpValues.addSuperannuation_Employment_Termination_Tax_Free_Component(amount);
                                } else if (grossPSClassification.equals("Superannuation_Employment_Termination_Tax_Free_Component_N")) {
                                    etpValues = etpValuesList.get(tDateString + "_N");
                                    if (etpValues == null) {
                                        etpValues = new PaySlipEditFormController.ETPValues();
                                        etpValuesList.put(tDateString + "_N", etpValues);
                                        etpValues.setCode("N");
                                        etpValues.setDate(tDateString);
                                    }
                                    etpValues.addSuperannuation_Employment_Termination_Tax_Free_Component(amount);
                                } else if (grossPSClassification.equals("Superannuation_Employment_Termination_Tax_Free_Component_O")) {
                                    etpValues = etpValuesList.get(tDateString + "_O");
                                    if (etpValues == null) {
                                        etpValues = new PaySlipEditFormController.ETPValues();
                                        etpValuesList.put(tDateString + "_O", etpValues);
                                        etpValues.setCode("O");
                                        etpValues.setDate(tDateString);
                                    }
                                    etpValues.addSuperannuation_Employment_Termination_Tax_Free_Component(amount);
                                } else if (grossPSClassification.equals("Superannuation_Employment_Termination_Tax_Free_Component_P")) {
                                    etpValues = etpValuesList.get(tDateString + "_P");
                                    if (etpValues == null) {
                                        etpValues = new PaySlipEditFormController.ETPValues();
                                        etpValuesList.put(tDateString + "_P", etpValues);
                                        etpValues.setCode("P");
                                        etpValues.setDate(tDateString);
                                    }
                                    etpValues.addSuperannuation_Employment_Termination_Tax_Free_Component(amount);
                                } else if (grossPSClassification.equals("Superannuation_Employment_Termination_Tax_Free_Component_R")) {
                                    etpValues = etpValuesList.get(tDateString + "_R");
                                    if (etpValues == null) {
                                        etpValues = new PaySlipEditFormController.ETPValues();
                                        etpValuesList.put(tDateString + "_R", etpValues);
                                        etpValues.setCode("R");
                                        etpValues.setDate(tDateString);
                                    }
                                    etpValues.addSuperannuation_Employment_Termination_Tax_Free_Component(amount);
                                } else if (grossPSClassification.equals("Superannuation_Employment_Termination_Tax_Free_Component_S")) {
                                    etpValues = etpValuesList.get(tDateString + "_S");
                                    if (etpValues == null) {
                                        etpValues = new PaySlipEditFormController.ETPValues();
                                        etpValuesList.put(tDateString + "_S", etpValues);
                                        etpValues.setCode("S");
                                        etpValues.setDate(tDateString);
                                    }
                                    etpValues.addSuperannuation_Employment_Termination_Tax_Free_Component(amount);
                                } else if (grossPSClassification.equals("Superannuation_Employment_Termination_Tax_Free_Component_T")) {
                                    etpValues = etpValuesList.get(tDateString + "_T");
                                    if (etpValues == null) {
                                        etpValues = new PaySlipEditFormController.ETPValues();
                                        etpValuesList.put(tDateString + "_T", etpValues);
                                        etpValues.setCode("T");
                                        etpValues.setDate(tDateString);
                                    }
                                    etpValues.addSuperannuation_Employment_Termination_Tax_Free_Component(amount);
                                } else if (grossPSClassification.equals("Superannuation_Employment_Termination_Taxable_Component_B")) {
                                    etpValues = etpValuesList.get(tDateString + "_B");
                                    if (etpValues == null) {
                                        etpValues = new PaySlipEditFormController.ETPValues();
                                        etpValuesList.put(tDateString + "_B", etpValues);
                                        etpValues.setCode("B");
                                        etpValues.setDate(tDateString);
                                    }
                                    etpValues.addSuperannuation_Employment_Termination_Taxable_Component(amount);
                                } else if (grossPSClassification.equals("Superannuation_Employment_Termination_Taxable_Component_D")) {
                                    etpValues = etpValuesList.get(tDateString + "_D");
                                    if (etpValues == null) {
                                        etpValues = new PaySlipEditFormController.ETPValues();
                                        etpValuesList.put(tDateString + "_D", etpValues);
                                        etpValues.setCode("D");
                                        etpValues.setDate(tDateString);
                                    }
                                    etpValues.addSuperannuation_Employment_Termination_Taxable_Component(amount);
                                } else if (grossPSClassification.equals("Superannuation_Employment_Termination_Taxable_Component_N")) {
                                    etpValues = etpValuesList.get(tDateString + "_N");
                                    if (etpValues == null) {
                                        etpValues = new PaySlipEditFormController.ETPValues();
                                        etpValuesList.put(tDateString + "_N", etpValues);
                                        etpValues.setCode("N");
                                        etpValues.setDate(tDateString);
                                    }
                                    etpValues.addSuperannuation_Employment_Termination_Taxable_Component(amount);
                                } else if (grossPSClassification.equals("Superannuation_Employment_Termination_Taxable_Component_O")) {
                                    etpValues = etpValuesList.get(tDateString + "_O");
                                    if (etpValues == null) {
                                        etpValues = new PaySlipEditFormController.ETPValues();
                                        etpValuesList.put(tDateString + "_O", etpValues);
                                        etpValues.setCode("O");
                                        etpValues.setDate(tDateString);
                                    }
                                    etpValues.addSuperannuation_Employment_Termination_Taxable_Component(amount);
                                } else if (grossPSClassification.equals("Superannuation_Employment_Termination_Taxable_Component_P")) {
                                    etpValues = etpValuesList.get(tDateString + "_P");
                                    if (etpValues == null) {
                                        etpValues = new PaySlipEditFormController.ETPValues();
                                        etpValuesList.put(tDateString + "_P", etpValues);
                                        etpValues.setCode("P");
                                        etpValues.setDate(tDateString);
                                    }
                                    etpValues.addSuperannuation_Employment_Termination_Taxable_Component(amount);
                                } else if (grossPSClassification.equals("Superannuation_Employment_Termination_Taxable_Component_R")) {
                                    etpValues = etpValuesList.get(tDateString + "_R");
                                    if (etpValues == null) {
                                        etpValues = new PaySlipEditFormController.ETPValues();
                                        etpValuesList.put(tDateString + "_R", etpValues);
                                        etpValues.setCode("R");
                                        etpValues.setDate(tDateString);
                                    }
                                    etpValues.addSuperannuation_Employment_Termination_Taxable_Component(amount);
                                } else if (grossPSClassification.equals("Superannuation_Employment_Termination_Taxable_Component_S")) {
                                    etpValues = etpValuesList.get(tDateString + "_S");
                                    if (etpValues == null) {
                                        etpValues = new PaySlipEditFormController.ETPValues();
                                        etpValuesList.put(tDateString + "_S", etpValues);
                                        etpValues.setCode("S");
                                        etpValues.setDate(tDateString);
                                    }
                                    etpValues.addSuperannuation_Employment_Termination_Taxable_Component(amount);
                                } else if (grossPSClassification.equals("Superannuation_Employment_Termination_Taxable_Component_T")) {
                                    etpValues = etpValuesList.get(tDateString + "_T");
                                    if (etpValues == null) {
                                        etpValues = new PaySlipEditFormController.ETPValues();
                                        etpValuesList.put(tDateString + "_T", etpValues);
                                        etpValues.setCode("T");
                                        etpValues.setDate(tDateString);
                                    }
                                    etpValues.addSuperannuation_Employment_Termination_Taxable_Component(amount);
                                } else if (grossPSClassification.equals("Lump_Sum_A") || grossPSClassification.equals("Lump_Sum_B") || grossPSClassification.equals("Lump_Sum_D") || grossPSClassification.equals("Lump_Sum_E")) {
                                    hasLumpSum = true;
                                }
                            }
                            if ((taxPSClassification = provisionTransaction.getProvisionTaxPSClassification()) != null && provisionAmount != null) {
                                PaySlipEditFormController.ETPValues etpValues;
                                Double total = totals.get(taxPSClassification);
                                if (total == null) {
                                    total = 0.0;
                                }
                                total = total - provisionAmount;
                                totals.put(taxPSClassification, total);
                                if (taxPSClassification.equals("Superannuation_SGC_Contributions")) {
                                    if (!tDate.isBefore(startOfMonthDate)) {
                                        mtdSGCSuperAmount = mtdSGCSuperAmount - provisionAmount;
                                    }
                                } else if (taxPSClassification.equals("Individual_Non_Business_Employment_Allowances_Other")) {
                                    Double allowanceTotal;
                                    String key = provisionTransaction.getProvisionDescription();
                                    if (key == null || key.isEmpty()) {
                                        key = pi;
                                    }
                                    if ((allowanceTotal = otherAllowancesTotals.get(key)) == null) {
                                        allowanceTotal = 0.0;
                                    }
                                    allowanceTotal = allowanceTotal - provisionAmount;
                                    otherAllowancesTotals.put(key, allowanceTotal);
                                } else if (taxPSClassification.equals("PAYG_ETP_B")) {
                                    etpValues = etpValuesList.get(tDateString + "_B");
                                    if (etpValues == null) {
                                        etpValues = new PaySlipEditFormController.ETPValues();
                                        etpValuesList.put(tDateString + "_B", etpValues);
                                        etpValues.setCode("B");
                                        etpValues.setDate(tDateString);
                                    }
                                    etpValues.addPAYG_ETP(-provisionAmount.doubleValue());
                                } else if (taxPSClassification.equals("PAYG_ETP_D")) {
                                    etpValues = etpValuesList.get(tDateString + "_D");
                                    if (etpValues == null) {
                                        etpValues = new PaySlipEditFormController.ETPValues();
                                        etpValuesList.put(tDateString + "_D", etpValues);
                                        etpValues.setCode("D");
                                        etpValues.setDate(tDateString);
                                    }
                                    etpValues.addPAYG_ETP(-provisionAmount.doubleValue());
                                } else if (taxPSClassification.equals("PAYG_ETP_N")) {
                                    etpValues = etpValuesList.get(tDateString + "_N");
                                    if (etpValues == null) {
                                        etpValues = new PaySlipEditFormController.ETPValues();
                                        etpValuesList.put(tDateString + "_N", etpValues);
                                        etpValues.setCode("N");
                                        etpValues.setDate(tDateString);
                                    }
                                    etpValues.addPAYG_ETP(-provisionAmount.doubleValue());
                                } else if (taxPSClassification.equals("PAYG_ETP_O")) {
                                    etpValues = etpValuesList.get(tDateString + "_O");
                                    if (etpValues == null) {
                                        etpValues = new PaySlipEditFormController.ETPValues();
                                        etpValuesList.put(tDateString + "_O", etpValues);
                                        etpValues.setCode("O");
                                        etpValues.setDate(tDateString);
                                    }
                                    etpValues.addPAYG_ETP(-provisionAmount.doubleValue());
                                } else if (taxPSClassification.equals("PAYG_ETP_P")) {
                                    etpValues = etpValuesList.get(tDateString + "_P");
                                    if (etpValues == null) {
                                        etpValues = new PaySlipEditFormController.ETPValues();
                                        etpValuesList.put(tDateString + "_P", etpValues);
                                        etpValues.setCode("P");
                                        etpValues.setDate(tDateString);
                                    }
                                    etpValues.addPAYG_ETP(-provisionAmount.doubleValue());
                                } else if (taxPSClassification.equals("PAYG_ETP_R")) {
                                    etpValues = etpValuesList.get(tDateString + "_R");
                                    if (etpValues == null) {
                                        etpValues = new PaySlipEditFormController.ETPValues();
                                        etpValuesList.put(tDateString + "_R", etpValues);
                                        etpValues.setCode("R");
                                        etpValues.setDate(tDateString);
                                    }
                                    etpValues.addPAYG_ETP(-provisionAmount.doubleValue());
                                } else if (taxPSClassification.equals("PAYG_ETP_S")) {
                                    etpValues = etpValuesList.get(tDateString + "_S");
                                    if (etpValues == null) {
                                        etpValues = new PaySlipEditFormController.ETPValues();
                                        etpValuesList.put(tDateString + "_S", etpValues);
                                        etpValues.setCode("S");
                                        etpValues.setDate(tDateString);
                                    }
                                    etpValues.addPAYG_ETP(-provisionAmount.doubleValue());
                                } else if (taxPSClassification.equals("PAYG_ETP_T")) {
                                    etpValues = etpValuesList.get(tDateString + "_T");
                                    if (etpValues == null) {
                                        etpValues = new PaySlipEditFormController.ETPValues();
                                        etpValuesList.put(tDateString + "_T", etpValues);
                                        etpValues.setCode("T");
                                        etpValues.setDate(tDateString);
                                    }
                                    etpValues.addPAYG_ETP(-provisionAmount.doubleValue());
                                }
                            }
                        }
                        if ((a = tl.getAccount()) == null || (accountTransaction = accountTrnXBRL.getAccountTransaction(ai = a.getAccountIdentifier())) == null || (applySuper = accountTransaction.getAccountApplySuper()) == null || !applySuper.equals("true")) continue;
                        ytdOTEAmount = ytdOTEAmount + amount;
                        if (tDate.isBefore(startOfMonthDate)) continue;
                        mtdOTEAmount = mtdOTEAmount + amount;
                    }
                    if (!hasLumpSum || (p = t.getTransactionPayEventEmp()) == null || (r = p.getRemunerationIncomeTaxPayAsYouGoWithholding()) == null || (lumpSumPayment = r.getUnusedAnnualOrLongServiceLeavePayment()) == null) continue;
                    lumpSumACode = lumpSumPayment.getLumpSumAC();
                }
                ((PaySlipEditFormVBox)this.transactionEditFormVBox).updateYTDTotals(totals, otherAllowancesTotals, etpValuesList, lumpSumACode, doupdate);
                ((PaySlipEditFormVBox)this.transactionEditFormVBox).updateYTDOTEAmount(ytdOTEAmount);
                ((PaySlipEditFormVBox)this.transactionEditFormVBox).updateMTDOTEAmount(mtdOTEAmount, doupdate);
                ((PaySlipEditFormVBox)this.transactionEditFormVBox).updateMTDSGCSuperAmount(mtdSGCSuperAmount, doupdate);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @Override
    protected void saveTransaction() throws Exception {
        super.saveTransaction();
        this.setupEmail(this.transaction);
    }

    protected void setupEmail(Transaction transaction) {
        if (transaction == null) {
            this.html_message.setHtmlText(null);
            return;
        }
        String msg = "<html><head></head><body><p>Dear [counterpartyName],</p><p>Please find attached your pay slip dated [transactionDate] for the period [paySlipStartDate] to [paySlipEndDate].</p></body></html>";
        String cid = transaction.getCounterpartyIdentifier();
        String cname = null;
        String lname = null;
        String tname = null;
        if (cid != null && !cid.isEmpty()) {
            try {
                Transaction ct = this.xbrlFileController.getCounterpartyTransaction(cid);
                if (ct != null) {
                    tname = ct.getCounterpartyTradingName();
                    lname = ct.getCounterpartyLegalName();
                    cname = ct.getCounterpartyTradingName();
                    if (cname == null || cname.isEmpty()) {
                        cname = ct.getCounterpartyLegalName();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (cname != null && !cname.isEmpty()) {
            msg = msg.replace("[counterpartyName]", cname);
        }
        if (lname != null && !lname.isEmpty()) {
            msg = msg.replace("[counterpartyLegalName]", lname);
        }
        if (tname != null && !tname.isEmpty()) {
            msg = msg.replace("[counterpartyTradingName]", tname);
        }
        LocalDate payday = transaction.getTransactionDateAsDate();
        String paydayfmt = this.displayDateFormatter.format(payday);
        String startdatefmt = null;
        String enddatefmt = null;
        TransactionPaySlipDetail psd = transaction.getTransactionPaySlipDetail();
        if (psd != null) {
            LocalDate startdate = psd.getTransactionPaySlipStartDateAsDate();
            LocalDate enddate = psd.getTransactionPaySlipEndDateAsDate();
            if (startdate != null && enddate != null) {
                startdatefmt = this.displayDateFormatter.format(startdate);
                enddatefmt = this.displayDateFormatter.format(enddate);
                msg = msg.replace("[paySlipStartDate]", startdatefmt);
                msg = msg.replace("[paySlipEndDate]", enddatefmt);
            }
        }
        msg = msg.replace("[transactionDate]", paydayfmt);
        try {
            OutgoingMailServer oms;
            Profile p = this.xbrlFileController.getOutgoingMailServer();
            if (p != null && (oms = p.getOutgoingMailServer()) != null) {
                this.email_from.setGlenixElementValue(oms.getOutgoingMailFromEmailAddress());
                msg = msg + oms.getOutgoingMailSignature();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
        this.html_message.setHtmlText(msg);
        this.email_subject.setGlenixElementValue("Pay slip");
        BusinessMasterFile bmf = this.xbrlFileController.getBusinessMasterFile();
        if (bmf != null) {
            String name = bmf.getBusinessTradingName();
            if (name == null || name.isEmpty()) {
                name = bmf.getBusinessLegalName();
            }
            this.email_subject.setGlenixElementValue(name + " - Pay slip");
        }
        this.email_to.setText(null);
        try {
            Counterparty c;
            Transaction ct;
            String ci;
            if (transaction != null && (ci = transaction.getCounterpartyIdentifier()) != null && (ct = this.xbrlFileController.getCounterpartyTransaction(ci)) != null && (c = ct.getCounterparty()) != null) {
                String email = c.getCounterpartyEmailAddress();
                this.email_to.setText(email);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @Override
    public void setTransactionElement(Transaction transaction) {
        try {
            String status;
            this.transaction = transaction;
            this.lastCounterpartyIdentifier = null;
            this.lastTransactionDate = null;
            this.lastTransactionNumber = null;
            this.transactionEditFormVBox.setTransactionElement(transaction);
            boolean recalc = true;
            if (this.batchTransaction != null && (status = this.batchTransaction.getBatchStatus()) != null && !status.isEmpty() && !status.equals("created")) {
                recalc = false;
            }
            if (recalc) {
                this.calculateCounterpartyYTDTotals(false);
                this.error_message.setText("Existing transaction");
            } else {
                this.error_message.setText("Existing transaction - locked batch");
            }
            this.setupEmail(transaction);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @Override
    protected String getPDFDocName() {
        return "Pay_slip";
    }

    @Override
    protected File buildTempPDFFile() throws Exception {
        String tmpdir = System.getProperty("java.io.tmpdir");
        UUID uuid = UUID.randomUUID();
        String randomUUIDString = uuid.toString();
        String docname = this.getPDFDocName();
        File file = tmpdir != null && !tmpdir.isEmpty() ? new File(tmpdir + "/" + docname + "_" + randomUUIDString + ".pdf") : new File(docname + "_" + randomUUIDString + ".pdf");
        this.xbrlFileController.buildPDFPaySlip(file, this.transaction);
        return file;
    }

    @FXML
    protected void sendEmail() {
        this.sendEmail(this.email_to.getGlenixElementValue(), this.email_from.getGlenixElementValue(), this.email_subject.getGlenixElementValue(), this.html_message.getHtmlText());
    }

    @Override
    public void setTransactionElementPostBatch(Transaction transaction) {
        String status;
        boolean recalc = true;
        if (this.batchTransaction != null && (status = this.batchTransaction.getBatchStatus()) != null && !status.isEmpty() && !status.equals("created")) {
            recalc = false;
        }
        if (!recalc) {
            this.transactionEditFormVBox.setTransactionElementPostBatch(transaction);
            this.transactionEditFormVBox.disableGlenixXBRL();
        } else {
            this.transactionEditFormVBox.enableGlenixXBRL();
        }
    }

    @FXML
    private void addTimeSheetLine() {
        try {
            ((PaySlipEditFormVBox)this.transactionEditFormVBox).addTimeSheetLine(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    public void deleteSelectedLines() {
        ((PaySlipEditFormVBox)this.transactionEditFormVBox).deleteSelectedLines();
    }

    @FXML
    public void addAdditionalSuperOrReportableFBLine() {
        ((PaySlipEditFormVBox)this.transactionEditFormVBox).addAdditionalSuperOrReportableFBLine();
    }

    @Override
    public void setTransactionDefaults() throws Exception {
        if (this.transaction == null) {
            return;
        }
        this.transaction.setTransactionType("pay_slip");
    }

    @FXML
    private void pdfTransaction() {
        if (this.transaction == null) {
            return;
        }
        this.xbrlFileController.pdfPaySlip(this.transaction);
    }
}

