/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import au.com.glenix.trn.ITPAYGWithholdingDetails;
import au.com.glenix.trn.PAYGWObligation;
import au.com.glenix.widget.GlenixBranchController;
import au.com.glenix.widget.GlenixLabelLabel;
import java.net.URL;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.scene.control.Label;

public class PAYGWObligationController
extends GlenixBranchController {
    @FXML
    private Label error_message;
    @FXML
    private Label page_heading;
    @FXML
    private GlenixLabelLabel IncomeTax_PayAsYouGoWithholding_Total_Amount;
    @FXML
    private GlenixLabelLabel Remuneration_WagesAndSalaries_PlusPaymentsOther_Amount;
    @FXML
    private GlenixLabelLabel DNOABN_TaxWithheld_Amount;
    @FXML
    private GlenixLabelLabel W2_TaxWithheld_Amount;
    @FXML
    private GlenixLabelLabel W3_TaxWithheld_Amount;
    private DateTimeFormatter outputDateFormatter = DateTimeFormatter.ofPattern("dd MMM yyyy");
    private PAYGWObligation paygwObligation = null;
    private String status;

    @Override
    public void initialize(URL url, ResourceBundle rb) {
    }

    public void setPAYGWObligationModel(PAYGWObligation paygwObligation) {
        this.paygwObligation = paygwObligation;
        String startDate = paygwObligation.getStartDate();
        String endDate = paygwObligation.getEndDate();
        if (startDate != null && endDate != null) {
            LocalDate ld = LocalDate.parse(startDate, DateTimeFormatter.ISO_DATE);
            String formattedStartDate = ld.format(this.outputDateFormatter);
            ld = LocalDate.parse(endDate, DateTimeFormatter.ISO_DATE);
            String formattedEndDate = ld.format(this.outputDateFormatter);
            this.page_heading.setText("PAYGW obligation from " + formattedStartDate + " to " + formattedEndDate);
        }
        try {
            ITPAYGWithholdingDetails wd = paygwObligation.getOrAddDNOABNITPAYGWithholdingDetails();
            if (wd != null) {
                wd.setPAYGWPaymentTypeCode("DNOABN");
            }
            if ((wd = paygwObligation.getOrAddW2ITPAYGWithholdingDetails()) != null) {
                wd.setPAYGWPaymentTypeCode("W2");
            }
            if ((wd = paygwObligation.getOrAddW3ITPAYGWithholdingDetails()) != null) {
                wd.setPAYGWPaymentTypeCode("W3");
            }
            this.updateTotals();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
        }
    }

    public void setDocumentStatus(String status) {
        this.status = status;
    }

    public void updateTotals() {
        if (this.status != null && this.status.equals("lodge_complete")) {
            return;
        }
        String salariesTotal = this.Remuneration_WagesAndSalaries_PlusPaymentsOther_Amount.getGlenixElementValue();
        String w2 = this.W2_TaxWithheld_Amount.getGlenixElementValue();
        if (salariesTotal != null && salariesTotal.equals("0") && (w2 == null || w2.isEmpty())) {
            try {
                this.W2_TaxWithheld_Amount.setGlenixElementValue("0");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private Double convertToDouble(String value) {
        if (value == null || value.isEmpty()) {
            return 0.0;
        }
        try {
            return Double.parseDouble(value);
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public Double getIncomeTax_PayAsYouGoWithholding_Total_Amount() {
        return this.convertToDouble(this.IncomeTax_PayAsYouGoWithholding_Total_Amount.getGlenixElementValue());
    }

    public Double getDNOABN_TaxWithheld_Amount() {
        return this.convertToDouble(this.DNOABN_TaxWithheld_Amount.getGlenixElementValue());
    }

    public Double getW2_TaxWithheld_Amount() {
        return this.convertToDouble(this.W2_TaxWithheld_Amount.getGlenixElementValue());
    }

    public Double getW3_TaxWithheld_Amount() {
        return this.convertToDouble(this.W3_TaxWithheld_Amount.getGlenixElementValue());
    }
}

