/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import au.com.glenix.trn.PAYGIObligation;
import au.com.glenix.trn.TaxRate;
import au.com.glenix.widget.GlenixBranchController;
import au.com.glenix.widget.GlenixLabelBlankNoYesCombo;
import au.com.glenix.widget.GlenixLabelLabel;
import au.com.glenix.widget.GlenixLabelOnly;
import au.com.glenix.widget.GlenixLabelText;
import au.com.glenix.widget.GlenixLabelZeroDecimalNumber;
import java.net.URL;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.util.Pair;

public class PAYGIObligationController
extends GlenixBranchController {
    @FXML
    private Label error_message;
    @FXML
    private Label page_heading;
    @FXML
    private GlenixLabelBlankNoYesCombo IncomeTax_LiabilityVariationReason_Code;
    @FXML
    private GlenixLabelBlankNoYesCombo IncomeTax_SelectedReportingOption_Code;
    @FXML
    private GlenixLabelLabel ATO_IncomeTax_Liability_Amount;
    @FXML
    private GlenixLabelZeroDecimalNumber Estimation_IncomeTax_Liability_Amount;
    @FXML
    private GlenixLabelZeroDecimalNumber Variation_IncomeTax_Liability_Amount;
    @FXML
    private GlenixLabelLabel Calculation_IncomeTax_Liability_Amount;
    @FXML
    private GlenixLabelLabel IncomeTax_InstalmentPayable_Amount;
    @FXML
    private GlenixLabelZeroDecimalNumber IncomeTax_InstalmentClaimableCredits_Amount;
    @FXML
    private GlenixLabelLabel IT_CompanyAndSuperDeferredLiabilityInstalment_Amount;
    @FXML
    private GlenixLabelOnly IncomeTax_MessageBeforeAmount_Text;
    @FXML
    private GlenixLabelOnly IncomeTax_MessageAfterAmount_Text;
    @FXML
    private GlenixLabelZeroDecimalNumber IncomeTax_InstalmentIncome_Amount;
    @FXML
    private GlenixLabelOnly IncomeTax_MessageBeforeRate_Text;
    @FXML
    private GlenixLabelOnly IncomeTax_MessageAfterRate_Text;
    @FXML
    private GlenixLabelLabel ATO_TaxRate_Designation_Rate;
    @FXML
    private GlenixLabelText BV_TaxRate_Designation_Rate;
    private DateTimeFormatter outputDateFormatter = DateTimeFormatter.ofPattern("dd MMM yyyy");
    private PAYGIObligation paygiObligation = null;
    private ChangeListener<PAYGIObligation> changeListener = null;
    private String status;

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        ChangeListener<Pair<String, String>> clp = new ChangeListener<Pair<String, String>>(){

            public void changed(ObservableValue<? extends Pair<String, String>> observable, Pair<String, String> oldValue, Pair<String, String> newValue) {
                PAYGIObligationController.this.updateTotals();
                if (PAYGIObligationController.this.changeListener != null) {
                    PAYGIObligationController.this.changeListener.changed(null, (Object)PAYGIObligationController.this.paygiObligation, (Object)PAYGIObligationController.this.paygiObligation);
                }
            }
        };
        this.IncomeTax_SelectedReportingOption_Code.setSingleChangeListener((ChangeListener<String>)clp);
        this.IncomeTax_LiabilityVariationReason_Code.setSingleChangeListener((ChangeListener<String>)clp);
        ChangeListener<String> cl = new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                PAYGIObligationController.this.updateTotals();
                if (PAYGIObligationController.this.changeListener != null) {
                    PAYGIObligationController.this.changeListener.changed(null, (Object)PAYGIObligationController.this.paygiObligation, (Object)PAYGIObligationController.this.paygiObligation);
                }
            }
        };
        this.BV_TaxRate_Designation_Rate.addTextChangeListener(cl);
        this.Variation_IncomeTax_Liability_Amount.addTextChangeListener(cl);
        this.IncomeTax_InstalmentIncome_Amount.addTextChangeListener(cl);
        this.IncomeTax_InstalmentClaimableCredits_Amount.addTextChangeListener(cl);
    }

    public void setSingleChangeListener(ChangeListener<PAYGIObligation> changeListener) {
        this.changeListener = changeListener;
    }

    public void setPAYGIObligationModel(PAYGIObligation paygiObligation) {
        String[] optionsarray;
        this.paygiObligation = paygiObligation;
        String startDate = paygiObligation.getStartDate();
        String endDate = paygiObligation.getEndDate();
        if (startDate != null && endDate != null) {
            LocalDate ld = LocalDate.parse(startDate, DateTimeFormatter.ISO_DATE);
            String formattedStartDate = ld.format(this.outputDateFormatter);
            ld = LocalDate.parse(endDate, DateTimeFormatter.ISO_DATE);
            String formattedEndDate = ld.format(this.outputDateFormatter);
            this.page_heading.setText("PAYGI obligation from " + formattedStartDate + " to " + formattedEndDate);
        }
        ArrayList<Pair> pairs = new ArrayList<Pair>();
        pairs.add(new Pair((Object)"", (Object)""));
        pairs.add(new Pair((Object)"21", (Object)"21 - Change in investments"));
        pairs.add(new Pair((Object)"22", (Object)"22 - Current business structure not continuing"));
        pairs.add(new Pair((Object)"23", (Object)"23 - Significant change in trading conditions"));
        pairs.add(new Pair((Object)"24", (Object)"24 - Internal business restructure"));
        pairs.add(new Pair((Object)"25", (Object)"25 - Change in legislation or product mix"));
        pairs.add(new Pair((Object)"26", (Object)"26 - Financial market changes"));
        pairs.add(new Pair((Object)"27", (Object)"27 - Use of income tax losses"));
        pairs.add(new Pair((Object)"28", (Object)"28 - Entering STS"));
        pairs.add(new Pair((Object)"29", (Object)"29 - Exiting STS"));
        pairs.add(new Pair((Object)"33", (Object)"33 - Consolidations"));
        ObservableList olPairs = FXCollections.observableList(pairs);
        this.IncomeTax_LiabilityVariationReason_Code.setItems((ObservableList<Pair<String, String>>)olPairs);
        String selectedValue = paygiObligation.getLiabilityVariationReasonCode();
        this.IncomeTax_LiabilityVariationReason_Code.setGlenixElementValue(selectedValue);
        pairs = new ArrayList();
        String options = paygiObligation.getAvailableReportingOptionsText();
        for (String anoption : optionsarray = options.split(",")) {
            if ("0".equals(anoption)) {
                pairs.add(new Pair((Object)"0", (Object)"0 - None"));
                continue;
            }
            if ("1".equals(anoption)) {
                pairs.add(new Pair((Object)"1", (Object)"1 - Amount"));
                continue;
            }
            if (!"2".equals(anoption)) continue;
            pairs.add(new Pair((Object)"2", (Object)"2 - Rate"));
        }
        olPairs = FXCollections.observableList(pairs);
        this.IncomeTax_SelectedReportingOption_Code.setItems((ObservableList<Pair<String, String>>)olPairs);
        selectedValue = paygiObligation.getSelectedReportingOptionCode();
        this.IncomeTax_SelectedReportingOption_Code.setGlenixElementValue(selectedValue);
        try {
            TaxRate tr = paygiObligation.getOrAddATOTaxRate();
            if (tr != null) {
                tr.setTaxRateTypeCode("Instalment");
            }
            if ((tr = paygiObligation.getOrAddBVTaxRate()) != null) {
                tr.setTaxRateTypeCode("Instalment");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
        }
    }

    public void setDocumentStatus(String status) {
        this.status = status;
    }

    public void updateTotals() {
        Double rate;
        if (this.status != null && this.status.equals("lodge_complete")) {
            return;
        }
        String liabilityVariationCode = this.IncomeTax_LiabilityVariationReason_Code.getGlenixElementValue();
        if (liabilityVariationCode == null || liabilityVariationCode.isEmpty()) {
            rate = this.convertToDouble(this.ATO_TaxRate_Designation_Rate.getGlenixElementValue());
            Double amount = this.convertToDouble(this.IncomeTax_InstalmentIncome_Amount.getGlenixElementValue());
            Double calcedInstalment = rate * amount / 100.0;
            this.Calculation_IncomeTax_Liability_Amount.setText("" + calcedInstalment.intValue());
            this.BV_TaxRate_Designation_Rate.setDisable(true);
            this.BV_TaxRate_Designation_Rate.setText(null);
        } else {
            rate = this.convertToDouble(this.BV_TaxRate_Designation_Rate.getGlenixElementValue());
            Double amount = this.convertToDouble(this.IncomeTax_InstalmentIncome_Amount.getGlenixElementValue());
            Double calcedInstalment = rate * amount / 100.0;
            this.Calculation_IncomeTax_Liability_Amount.setText("" + calcedInstalment.intValue());
            this.BV_TaxRate_Designation_Rate.setDisable(false);
        }
        String reportingOption = this.IncomeTax_SelectedReportingOption_Code.getGlenixElementValue();
        if (reportingOption == null || reportingOption.isEmpty() || reportingOption.equals("0") || reportingOption.equals("1")) {
            this.BV_TaxRate_Designation_Rate.setDisable(true);
            this.BV_TaxRate_Designation_Rate.setText(null);
            if (liabilityVariationCode == null || liabilityVariationCode.isEmpty()) {
                this.IncomeTax_InstalmentPayable_Amount.setText(this.ATO_IncomeTax_Liability_Amount.getText());
                this.Variation_IncomeTax_Liability_Amount.setDisable(true);
                this.Variation_IncomeTax_Liability_Amount.setText(null);
                this.Estimation_IncomeTax_Liability_Amount.setDisable(true);
                this.Estimation_IncomeTax_Liability_Amount.setText(null);
            } else {
                this.IncomeTax_InstalmentPayable_Amount.setText(this.Variation_IncomeTax_Liability_Amount.getText());
                this.Variation_IncomeTax_Liability_Amount.setDisable(false);
                this.Estimation_IncomeTax_Liability_Amount.setDisable(false);
            }
        } else {
            this.Variation_IncomeTax_Liability_Amount.setDisable(true);
            this.Variation_IncomeTax_Liability_Amount.setText(null);
            this.Estimation_IncomeTax_Liability_Amount.setDisable(true);
            this.Estimation_IncomeTax_Liability_Amount.setText(null);
            this.BV_TaxRate_Designation_Rate.setDisable(false);
            this.IncomeTax_InstalmentPayable_Amount.setText(this.Calculation_IncomeTax_Liability_Amount.getText());
        }
    }

    private Double convertToDouble(String value) {
        if (value == null || value.isEmpty()) {
            return 0.0;
        }
        try {
            return Double.parseDouble(value);
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public Double getIncomeTax_InstalmentPayable_Amount() {
        return this.convertToDouble(this.IncomeTax_InstalmentPayable_Amount.getGlenixElementValue());
    }

    public Double getIncomeTax_InstalmentClaimableCredits_Amount() {
        return this.convertToDouble(this.IncomeTax_InstalmentClaimableCredits_Amount.getGlenixElementValue());
    }

    public Double getIT_CompanyAndSuperDeferredLiabilityInstalment_Amount() {
        return this.convertToDouble(this.IT_CompanyAndSuperDeferredLiabilityInstalment_Amount.getGlenixElementValue());
    }
}

