/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import au.com.glenix.ApplicationController;
import au.com.glenix.trn.OutgoingMailServer;
import au.com.glenix.trn.Profile;
import au.com.glenix.widget.GlenixBranchController;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.scene.web.HTMLEditor;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;

public class OutgoingMailServerController
extends GlenixBranchController {
    @FXML
    private Label error_message;
    @FXML
    private HTMLEditor outgoingMailSignature;
    private Profile profile = null;
    private ApplicationController xbrlFileController = null;
    private DocumentBuilder dBuilder;

    public OutgoingMailServerController(ApplicationController xbrlFileController) {
        this.xbrlFileController = xbrlFileController;
    }

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setNamespaceAware(true);
            this.dBuilder = dbFactory.newDocumentBuilder();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    public void setModel(Profile profileXBRL) throws Exception {
        Document doc;
        this.profile = profileXBRL;
        if (this.profile != null && (doc = this.profile.buildDocument()) != null) {
            this.loadGlenixXBRL(doc, doc.getDocumentElement());
        }
    }

    @FXML
    public void saveProfile() {
        try {
            Document resultDoc = this.dBuilder.newDocument();
            super.buildGlenixXBRL(resultDoc, null);
            if (this.profile != null) {
                this.profile.loadDocumentElementOverwrite(resultDoc, resultDoc.getDocumentElement());
                OutgoingMailServer oms = this.profile.getOutgoingMailServer();
                oms.setOutgoingMailSignature(this.outgoingMailSignature.getHtmlText());
                this.xbrlFileController.saveOutgoingMailServer();
                this.error_message.setText("Saved");
            } else {
                this.error_message.setText("Could not save no profile loaded.");
            }
        }
        catch (Exception e) {
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
            e.printStackTrace();
        }
    }
}

