/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import au.com.glenix.ApplicationController;
import au.com.glenix.GlenixAUSKey;
import au.com.glenix.GlenixFile;
import au.com.glenix.trn.Profile;
import au.com.glenix.widget.GlenixBranchController;
import java.net.URL;
import java.security.InvalidKeyException;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;

public class OpenProfileController
extends GlenixBranchController {
    @FXML
    private Label fas_identity_description;
    @FXML
    private PasswordField password;
    @FXML
    private Label error_message;
    @FXML
    private Label filename;
    private GlenixFile gf;
    private ApplicationController xbrlFileController = null;
    private Profile profile = null;
    private DocumentBuilder dBuilder;
    @FXML
    private Button unlockProfileButton;

    public OpenProfileController(ApplicationController xbrlFileController) {
        this.xbrlFileController = xbrlFileController;
    }

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setNamespaceAware(true);
            this.dBuilder = dbFactory.newDocumentBuilder();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setModel(Profile profileXBRL) throws Exception {
        Document doc;
        this.profile = profileXBRL;
        if (this.profile != null && (doc = this.profile.buildDocument()) != null) {
            this.loadGlenixXBRL(doc, doc.getDocumentElement());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGlenixFile(GlenixFile glenixFile) {
        block18: {
            if (this.gf != null) {
                try {
                    this.gf.closeFile();
                }
                catch (Exception ee) {
                    this.error_message.setText("Please exit and restart software: " + ee.getMessage());
                    this.xbrlFileController.setStatusBarMessage("Please exit and restart software: " + ee.getMessage());
                }
                this.gf = null;
            }
            if (glenixFile == null) {
                this.filename.setText(null);
                this.password.setText(null);
                this.clearGlenixXBRL();
                this.unlockProfileButton.disableProperty().set(true);
                return;
            }
            this.unlockProfileButton.disableProperty().set(false);
            this.gf = glenixFile;
            try {
                this.filename.setText(this.gf.getFileName());
                Document cdoc = this.gf.getDocument("profile.xml");
                if (cdoc == null) {
                    this.error_message.setText("Error, no FAS identity file opened, you need to open your FAS Identity (.fid) file.");
                    this.xbrlFileController.setStatusBarMessage("Error, no FAS identity file opened, you need to open your FAS Identity (.fid) file.");
                    try {
                        this.gf.closeFile();
                    }
                    catch (Exception e) {
                        this.error_message.setText(e.getMessage());
                        this.xbrlFileController.setStatusBarMessage(e.getMessage());
                    }
                    finally {
                        this.gf = null;
                    }
                    return;
                }
                this.profile = new Profile();
                this.profile.loadDocumentElement(cdoc, cdoc.getDocumentElement());
                String desc = this.profile.getFullName();
                String tan = this.profile.getAgentNumber();
                if (desc != null && !desc.isEmpty()) {
                    if (tan != null && !tan.isEmpty()) {
                        desc = desc + " (Agent number: " + tan + ")";
                    }
                    this.fas_identity_description.setText(desc);
                } else {
                    this.fas_identity_description.setText(null);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.error_message.setText(e.getMessage());
                this.xbrlFileController.setStatusBarMessage(e.getMessage());
                this.profile = null;
                this.fas_identity_description.setText(null);
                if (this.gf == null) break block18;
                try {
                    this.gf.closeFile();
                }
                catch (Exception ee) {
                    this.error_message.setText("Please exit and restart software: " + e.getMessage());
                    this.xbrlFileController.setStatusBarMessage("Please exit and restart software: " + e.getMessage());
                }
                this.gf = null;
            }
        }
    }

    @FXML
    public void openFile() {
        block7: {
            try {
                GlenixFile glenixFile = null;
                try {
                    glenixFile = this.xbrlFileController.openProfileFile();
                }
                catch (Exception e) {
                    this.error_message.setText(e.getMessage());
                    this.xbrlFileController.setStatusBarMessage(e.getMessage());
                    this.setGlenixFile(null);
                    return;
                }
                if (glenixFile == null) {
                    this.error_message.setText("Error, no FAS identity file opened");
                    this.xbrlFileController.setStatusBarMessage("Error, no FAS identity file opened");
                    this.setGlenixFile(null);
                    return;
                }
                this.setGlenixFile(glenixFile);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.error_message.setText(e.getMessage());
                this.xbrlFileController.setStatusBarMessage(e.getMessage());
                this.profile = null;
                if (this.gf == null) break block7;
                try {
                    this.gf.closeFile();
                }
                catch (Exception ee) {
                    this.error_message.setText("Please exit and restart software: " + e.getMessage());
                    this.xbrlFileController.setStatusBarMessage("Please exit and restart software: " + e.getMessage());
                }
                this.gf = null;
            }
        }
    }

    @FXML
    public void unlockProfile() {
        if (this.profile == null) {
            try {
                this.openFile();
            }
            catch (Exception e) {
                this.error_message.setText(e.getMessage());
                this.xbrlFileController.setStatusBarMessage(e.getMessage());
                e.printStackTrace();
                return;
            }
        }
        if (this.profile == null) {
            this.error_message.setText("Error, no file has been opened. You may need to create a new FAS identity.");
            this.xbrlFileController.setStatusBarMessage("Error, no file has been opened. You may need to create a new FAS identity.");
            return;
        }
        try {
            if (this.gf == null) {
                throw new Exception("Error, no file selected or the file is not a FAS identity \".fid\" file.");
            }
            GlenixAUSKey gak = new GlenixAUSKey();
            gak.setProtectedPrivateKey(this.profile.getProtectedPrivateKey());
            gak.setPublicKeyBase64(this.profile.getPublicKey());
            gak.loadOtherCredential(this.password.getText().toCharArray());
            int its = 0;
            try {
                its = gak.getOtherCredentialIterations();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (its < 65536) {
                gak.generateProtectedPrivateKey(this.password.getText().toCharArray());
                this.profile.setProtectedPrivateKey(gak.getBase64ProtectedPrivateKeyOneLine());
                Document cdoc = this.profile.buildDocument();
                this.gf.saveFile("profile.xml", cdoc);
                this.xbrlFileController.setProfileFile(this.gf, this.profile);
            } else {
                this.xbrlFileController.setProfileFile(this.gf, this.profile);
            }
            this.xbrlFileController.setGlenixKey(gak);
            this.gf.closeFile();
            if (!this.gf.hasGlenixCertificateListFile()) {
                byte[] pem = this.xbrlFileController.getProfilePublicCertificatePemFile();
                this.gf.reopenFile();
                this.gf.createGlenixCertificateList(pem);
                this.gf.closeFile();
            }
            this.error_message.setText("Success FAS identity is unlocked. You may now open your business file.");
            this.filename.setText("");
            this.gf = null;
            this.profile = null;
            this.xbrlFileController.gotoPostUnlockPage();
        }
        catch (InvalidKeyException ike) {
            this.error_message.setText("Incorrect password");
        }
        catch (Exception e) {
            this.error_message.setText(e.getMessage());
            e.printStackTrace();
        }
    }

    @FXML
    private void createProfile() {
        this.xbrlFileController.gotoNewProfile();
    }
}

