/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import au.com.glenix.ApplicationController;
import au.com.glenix.GlenixAUSKey;
import au.com.glenix.GlenixFile;
import au.com.glenix.GlenixSBRAttachment;
import au.com.glenix.GlenixSBRResponse;
import au.com.glenix.trn.Profile;
import au.com.glenix.widget.GlenixBranchController;
import au.com.glenix.widget.GlenixLabelPassword;
import au.com.glenix.widget.GlenixLabelText;
import java.nio.file.FileSystemAlreadyExistsException;
import java.util.UUID;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.w3c.dom.Document;

public class NewProfileController
extends GlenixBranchController {
    @FXML
    private GlenixLabelText first_name;
    @FXML
    private GlenixLabelText other_given_names;
    @FXML
    private GlenixLabelText surname;
    @FXML
    private GlenixLabelPassword password;
    @FXML
    private GlenixLabelPassword confirm_password;
    @FXML
    private GlenixLabelText registered_agent_number;
    @FXML
    private GlenixLabelText agent_ABN;
    @FXML
    private GlenixLabelText agent_ABN_branch_code;
    @FXML
    private GlenixLabelText TelephoneAreaC;
    @FXML
    private GlenixLabelText TelephoneMinimalNumber;
    @FXML
    private GlenixLabelText ElectronicMailAddressT;
    @FXML
    private Label error_message;
    private GlenixAUSKey gak;
    private GlenixFile gf;
    private ApplicationController xbrlFileController = null;

    public NewProfileController(ApplicationController xbrlFileController) {
        this.xbrlFileController = xbrlFileController;
    }

    protected String generateMessageIdentifier() {
        UUID uuid = UUID.randomUUID();
        return uuid.toString() + "@freeaccountingsoftware.com.au";
    }

    public boolean isValidEmailAddress(String email) {
        boolean result = true;
        try {
            InternetAddress emailAddr = new InternetAddress(email);
            emailAddr.validate();
        }
        catch (AddressException ex) {
            result = false;
        }
        return result;
    }

    @FXML
    public void createProfile() {
        try {
            this.gak = new GlenixAUSKey();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
            return;
        }
        String commonName = ((this.first_name.getText() + " " + this.other_given_names.getText()).trim() + " " + this.surname.getText()).trim();
        if (commonName.equalsIgnoreCase("")) {
            this.error_message.setText("Error, you have not filled in your name");
            this.error_message.getStyleClass().clear();
            this.error_message.getStyleClass().add((Object)"error");
            return;
        }
        String passwordString = this.password.getText();
        if (passwordString == null || passwordString.equals("")) {
            this.error_message.setText("Error, password is not set");
            this.error_message.getStyleClass().clear();
            this.error_message.getStyleClass().add((Object)"error");
            return;
        }
        if (!NewProfileController.checkPasswordComplexity(passwordString)) {
            this.error_message.setText("Error, the entered password does not meet the minimum requirements.");
            this.error_message.getStyleClass().clear();
            this.error_message.getStyleClass().add((Object)"error");
            return;
        }
        String confirmPasswordString = this.confirm_password.getText();
        if (confirmPasswordString == null || confirmPasswordString.equals("")) {
            this.error_message.setText("Error, password confirmation is not set");
            this.error_message.getStyleClass().clear();
            this.error_message.getStyleClass().add((Object)"error");
            return;
        }
        if (!confirmPasswordString.equals(passwordString)) {
            this.error_message.setText("Error, password confirmation does not match entered password.");
            this.error_message.getStyleClass().clear();
            this.error_message.getStyleClass().add((Object)"error");
            return;
        }
        String email = this.ElectronicMailAddressT.getText().trim();
        if (email.isEmpty() || !this.isValidEmailAddress(email)) {
            this.error_message.setText("Error, email address is invalid.");
            this.error_message.getStyleClass().clear();
            this.error_message.getStyleClass().add((Object)"error");
            return;
        }
        String telephone = this.TelephoneMinimalNumber.getText().trim();
        if (telephone.isEmpty()) {
            this.error_message.setText("Error, telephone is required.");
            this.error_message.getStyleClass().clear();
            this.error_message.getStyleClass().add((Object)"error");
            return;
        }
        String areacode = this.TelephoneAreaC.getText().trim();
        if (areacode.isEmpty()) {
            this.error_message.setText("Error, telephone area code is required.");
            this.error_message.getStyleClass().clear();
            this.error_message.getStyleClass().add((Object)"error");
            return;
        }
        try {
            this.gak.generatePrivateKey(passwordString.toCharArray(), commonName);
            Profile profile = new Profile();
            profile.setFirstName(this.first_name.getGlenixElementValue());
            profile.setOtherGivenNames(this.other_given_names.getGlenixElementValue());
            profile.setLastName(this.surname.getGlenixElementValue());
            profile.setAgentABN(this.agent_ABN.getGlenixElementValue());
            profile.setAgentABNBranch(this.agent_ABN_branch_code.getGlenixElementValue());
            profile.setAgentNumber(this.registered_agent_number.getGlenixElementValue());
            profile.setPublicKey(this.gak.getBase64PublicKeyOneLine());
            profile.setTelephoneAreaC(areacode);
            profile.setTelephoneMinimalN(telephone);
            profile.setElectronicMailAddressT(email);
            Document profiledoc = profile.buildSignableDocument();
            GlenixSBRAttachment gatt = new GlenixSBRAttachment(profiledoc, "profile", this.gak.calcDigest(profiledoc.getDocumentElement(), "SHA-1"));
            gatt.setMimeType("text/xml");
            gatt.setDocumentType("PROFILE");
            gatt.setDocumentName("profile.xml");
            String messageId = this.generateMessageIdentifier();
            GlenixSBRResponse glenixSBRResponse = this.xbrlFileController.sendRegisterProfile(this.gak, commonName, messageId, gatt);
            glenixSBRResponse.parseResponse();
            int count = glenixSBRResponse.getSignalMessageErrorSize();
            for (int i = 0; i < count; ++i) {
                System.out.println("GOT ERROR CODE " + glenixSBRResponse.getSignalMessageErrorCode(i));
            }
            profile.setProtectedPrivateKey(this.gak.getBase64ProtectedPrivateKeyOneLine());
            String fileDefaultName = "MyFasIdentity";
            GlenixFile profileFile = null;
            try {
                profileFile = this.xbrlFileController.getNewProfileFileDefaultLocation();
            }
            catch (Exception e) {
                profileFile = null;
                e.printStackTrace();
            }
            if (profileFile == null) {
                profileFile = this.xbrlFileController.getNewProfileFile(fileDefaultName);
            }
            String protectedPrivateKey = this.gak.getProtectedPrivateKeyPEM();
            byte[] protectedPrivateKeyBytes = protectedPrivateKey.getBytes("UTF-8");
            profileFile.saveBytes("private.pem", protectedPrivateKeyBytes, 0, protectedPrivateKeyBytes.length);
            String publicKey = this.gak.getPublicKeyPEM();
            byte[] publicKeyBytes = publicKey.getBytes("UTF-8");
            profileFile.saveBytes("public.pem", publicKeyBytes, 0, publicKeyBytes.length);
            Document cdoc = profile.buildDocument();
            profileFile.saveFile("profile.xml", cdoc);
            profileFile.closeFile();
            this.xbrlFileController.setProfileFile(profileFile, profile);
            this.xbrlFileController.setGlenixKey(this.gak);
            String message = "Success, now click on, File -> New, to create your business file";
            this.error_message.setText(message);
            this.xbrlFileController.setStatusBarMessage(message);
            this.error_message.getStyleClass().clear();
            this.error_message.getStyleClass().add((Object)"success");
            this.xbrlFileController.gotoNewFileE(null, "You have successfully created your FAS identity. You may now create a new business file.");
        }
        catch (FileSystemAlreadyExistsException e) {
            this.error_message.setText("Error, this is overwriting an existing FAS identity please choose a new file.");
            this.xbrlFileController.setStatusBarMessage("Error, this is overwriting an existing FAS identity please choose a new file.");
            this.error_message.getStyleClass().clear();
            this.error_message.getStyleClass().add((Object)"error");
            e.printStackTrace();
        }
        catch (Exception e) {
            if (e.getMessage() != null) {
                this.error_message.setText(e.getMessage());
                this.xbrlFileController.setStatusBarMessage(e.getMessage());
            } else {
                this.error_message.setText(e.toString());
                this.xbrlFileController.setStatusBarMessage(e.toString());
            }
            this.error_message.getStyleClass().clear();
            this.error_message.getStyleClass().add((Object)"error");
            e.printStackTrace();
        }
    }

    @FXML
    public void gotoOpenProfile() {
        this.xbrlFileController.gotoOpenProfile(null);
    }

    public static boolean checkPasswordComplexity(String password) {
        if (password == null || password.isEmpty() || password.length() < 6) {
            return false;
        }
        int score = 0;
        if (password.matches(".*[a-z]{1}.*")) {
            ++score;
        }
        if (password.matches(".*[A-Z].*")) {
            ++score;
        }
        if (password.matches(".*[0-9].*")) {
            ++score;
        }
        if (password.matches(".*[^a-zA-Z0-9].*")) {
            ++score;
        }
        return score >= 2;
    }
}

