/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import au.com.glenix.ApplicationController;
import au.com.glenix.GlenixFile;
import au.com.glenix.trn.GlenixResult;
import au.com.glenix.trn.Profile;
import au.com.glenix.widget.GlenixBranchController;
import au.com.glenix.widget.GlenixLabelPassword;
import au.com.glenix.widget.GlenixLabelText;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.UUID;
import javafx.fxml.FXML;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;

public class LinkV2Controller
extends GlenixBranchController {
    public static String v2putpublickeyurl = "https://local.freeaccountingsoftware.com.au/login/putpk";
    public static String v2putloginurl = "https://local.freeaccountingsoftware.com.au/login";
    @FXML
    private GlenixLabelPassword password;
    @FXML
    private GlenixLabelText username;
    @FXML
    private GlenixLabelText otp;
    @FXML
    private GlenixLabelText email_login_code;
    @FXML
    protected Hyperlink resultlink;
    @FXML
    protected TextField resulttext;
    @FXML
    private Label error_message;
    private Profile profile = null;
    private GlenixFile profileFile = null;
    protected DocumentBuilderFactory docFactory;
    protected DocumentBuilder docBuilder;
    private ApplicationController xbrlFileController = null;

    public LinkV2Controller(ApplicationController xbrlFileController) {
        this.xbrlFileController = xbrlFileController;
    }

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        try {
            this.docFactory = DocumentBuilderFactory.newInstance();
            this.docFactory.setNamespaceAware(true);
            this.docBuilder = this.docFactory.newDocumentBuilder();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    private void sendField(OutputStream out, String name, String field) throws Exception {
        String o = "Content-Disposition: form-data; name=\"" + URLEncoder.encode(name, "UTF-8") + "\"\r\n\r\n";
        out.write(o.getBytes(StandardCharsets.UTF_8));
        out.write(URLEncoder.encode(field, "UTF-8").getBytes(StandardCharsets.UTF_8));
        out.write("\r\n".getBytes(StandardCharsets.UTF_8));
    }

    @FXML
    public void submitLinkV2() {
        try {
            this.error_message.setText(null);
            this.xbrlFileController.setStatusBarMessage(null);
            URL url = new URL(v2putpublickeyurl);
            URLConnection con = url.openConnection();
            HttpURLConnection conn = (HttpURLConnection)con;
            conn.setRequestMethod("POST");
            conn.setDoOutput(true);
            String boundary = UUID.randomUUID().toString();
            byte[] boundaryBytes = ("--" + boundary + "\r\n").getBytes(StandardCharsets.UTF_8);
            byte[] finishBoundaryBytes = ("--" + boundary + "--").getBytes(StandardCharsets.UTF_8);
            conn.setRequestProperty("Content-Type", "multipart/form-data; charset=UTF-8; boundary=" + boundary);
            conn.setChunkedStreamingMode(0);
            OutputStream out = conn.getOutputStream();
            out.write(boundaryBytes);
            this.sendField(out, "putpk_email", this.username.getGlenixElementValue());
            out.write(boundaryBytes);
            this.sendField(out, "putpk_password", this.password.getGlenixElementValue());
            out.write(boundaryBytes);
            this.sendField(out, "putpk_public_key", this.xbrlFileController.getPublicKeyDer());
            out.write(boundaryBytes);
            this.sendField(out, "putpk_public_key_identifier", this.xbrlFileController.getPublicKeyIdentifier());
            out.write(boundaryBytes);
            this.sendField(out, "otp", this.otp.getGlenixElementValue());
            out.write(boundaryBytes);
            this.sendField(out, "email_login_code", this.email_login_code.getGlenixElementValue());
            out.write(finishBoundaryBytes);
            out.flush();
            int responseCode = conn.getResponseCode();
            Map<String, List<String>> headerFields = conn.getHeaderFields();
            InputStream is = conn.getInputStream();
            if (is == null) {
                is = conn.getErrorStream();
            }
            Document doc = this.docBuilder.parse(is);
            GlenixResult gr = new GlenixResult();
            gr.loadDocumentElement(doc, doc.getDocumentElement());
            String code = gr.getResultCode();
            if (code != null && code.equals("OK")) {
                String desc = gr.getResultDescription();
                if (desc != null && !desc.isEmpty()) {
                    this.error_message.setText(desc);
                } else {
                    this.error_message.setText("OK, your account is now linked");
                }
            } else {
                String desc = gr.getResultDescription();
                if (desc != null && !desc.isEmpty()) {
                    this.error_message.setText(desc);
                } else {
                    this.error_message.setText("Error, an error occurred (" + code + ")");
                }
            }
            out.close();
            conn.disconnect();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    public void setModel(GlenixFile profileFile, Profile profileXBRL) throws Exception {
        Document doc;
        this.profile = profileXBRL;
        this.profileFile = profileFile;
        if (this.profile != null && (doc = this.profile.buildDocument()) != null) {
            this.loadGlenixXBRL(doc, doc.getDocumentElement());
        }
        String signdata = this.xbrlFileController.getPublicKeyIdentifier();
        signdata = signdata + ":" + System.currentTimeMillis() / 1000L;
        signdata = signdata + ":" + this.xbrlFileController.signString(signdata);
        System.out.println("TEsting " + signdata);
        String link = v2putloginurl + "?pkd=" + URLEncoder.encode(signdata, "UTF-8");
        this.resultlink.setText(link);
        this.resulttext.setText(link);
    }
}

