/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class KeyPairNode {
    Node node = null;
    Node protectedPrivateKeyNode = null;
    Node publicKeyNode = null;
    String protectedPrivateKey = null;
    String publicKey = null;

    public KeyPairNode(Node node) {
        this.node = node;
        if (node != null) {
            int i = 0;
            NodeList nodeList = node.getChildNodes();
            while (i < nodeList.getLength()) {
                Node xnode;
                if ((xnode = nodeList.item(i++)) == null || xnode.getNodeType() != 1) continue;
                if (xnode.getNamespaceURI().equals("http://www.glenix.com.au/") && xnode.getNodeName().equals("protectedPrivateKey")) {
                    this.protectedPrivateKey = xnode.getTextContent();
                    this.protectedPrivateKeyNode = xnode;
                    continue;
                }
                if (!xnode.getNamespaceURI().equals("http://www.glenix.com.au/") || !xnode.getNodeName().equals("publicKey")) continue;
                this.publicKey = xnode.getTextContent();
                this.publicKeyNode = xnode;
            }
        }
    }

    public KeyPairNode() {
        this(null);
    }

    public String getProtectedPrivateKey() {
        return this.protectedPrivateKey;
    }

    public void setProtectedPrivateKey(String protectedPrivateKey) {
        this.protectedPrivateKey = protectedPrivateKey;
        if (this.protectedPrivateKeyNode != null) {
            this.protectedPrivateKeyNode.setTextContent(protectedPrivateKey);
        }
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
        if (this.publicKeyNode != null) {
            this.publicKeyNode.setTextContent(publicKey);
        }
    }

    public Node getNode(Document doc) {
        if (this.node != null) {
            if (this.node.getOwnerDocument().equals(doc)) {
                return this.node;
            }
            return doc.adoptNode(this.node.cloneNode(true));
        }
        this.node = doc.createElementNS("http://www.glenix.com.au/", "keyPair");
        if (this.protectedPrivateKey != null) {
            this.protectedPrivateKeyNode = doc.createElementNS("http://www.glenix.com.au/", "protectedPrivateKey");
            this.protectedPrivateKeyNode.setTextContent(this.protectedPrivateKey);
            this.node.appendChild(this.protectedPrivateKeyNode);
        }
        if (this.publicKey != null) {
            this.publicKeyNode = doc.createElementNS("http://www.glenix.com.au/", "publicKey");
            this.publicKeyNode.setTextContent(this.publicKey);
            this.node.appendChild(this.publicKeyNode);
        }
        return this.node;
    }
}

