/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import au.com.glenix.ApplicationController;
import au.com.glenix.GlenixAUSKey;
import au.com.glenix.GlenixFile;
import au.com.glenix.trn.GlenixResult;
import au.com.glenix.trn.Profile;
import au.com.glenix.widget.GlenixBranchController;
import au.com.glenix.widget.GlenixLabelText;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.util.ResourceBundle;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.Label;

public class InstallController
extends GlenixBranchController {
    @FXML
    private GlenixLabelText password;
    @FXML
    private Label error_message;
    @FXML
    private Button installButton;
    @FXML
    private Button downloadUpgradeButton;
    @FXML
    private Button selectLocationButton;
    @FXML
    private Button defaultLocationButton;
    @FXML
    private Button skipInstallButton;
    @FXML
    private Button skipInstallRememberButton;
    @FXML
    private Label install_location;
    private GlenixAUSKey gak = null;
    private GlenixFile gf;
    private ApplicationController xbrlFileController = null;
    private Profile profile = null;
    private File installDir;
    private String fas3DesktopDownloadURL = null;
    private boolean isokversion = false;

    public InstallController(ApplicationController xbrlFileController, String fas3DesktopDownloadURL) {
        this.xbrlFileController = xbrlFileController;
        this.fas3DesktopDownloadURL = fas3DesktopDownloadURL;
    }

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        try {
            this.installDir = this.xbrlFileController.locateInstallDirectory();
            if (this.installDir != null) {
                this.install_location.setText(this.installDir.getAbsolutePath());
            } else {
                this.installButton.disableProperty().setValue(Boolean.valueOf(true));
                this.downloadUpgradeButton.disableProperty().setValue(Boolean.valueOf(this.isokversion));
                this.selectLocationButton.disableProperty().setValue(Boolean.valueOf(false));
                this.defaultLocationButton.disableProperty().setValue(Boolean.valueOf(false));
                this.skipInstallButton.disableProperty().setValue(Boolean.valueOf(false));
                this.skipInstallRememberButton.disableProperty().setValue(Boolean.valueOf(false));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    private void install() {
        if (!this.isokversion) {
            this.downloadUpgrade();
            return;
        }
        try {
            this.installButton.disableProperty().setValue(Boolean.valueOf(true));
            this.downloadUpgradeButton.disableProperty().setValue(Boolean.valueOf(true));
            this.selectLocationButton.disableProperty().setValue(Boolean.valueOf(true));
            this.defaultLocationButton.disableProperty().setValue(Boolean.valueOf(true));
            this.skipInstallButton.disableProperty().setValue(Boolean.valueOf(true));
            this.skipInstallRememberButton.disableProperty().setValue(Boolean.valueOf(true));
            final File installedJar = this.xbrlFileController.installJarFile(this.installDir);
            if (installedJar != null && installedJar.exists()) {
                this.error_message.setText("Successfully installed, starting installed version in 5 seconds");
                this.xbrlFileController.setStatusBarMessage("Successfully installed, starting installed version in 5 seconds");
                ScheduledExecutorService exec = Executors.newSingleThreadScheduledExecutor();
                exec.scheduleWithFixedDelay(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Runtime rt = Runtime.getRuntime();
                            String[] cmdarray = new String[]{"java", "-jar", installedJar.getAbsolutePath()};
                            Process p = rt.exec(cmdarray);
                            InstallController.this.xbrlFileController.processExit();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            InstallController.this.error_message.setText(e.getMessage());
                            InstallController.this.xbrlFileController.setStatusBarMessage(e.getMessage());
                            InstallController.this.installButton.disableProperty().setValue(Boolean.valueOf(false));
                            InstallController.this.downloadUpgradeButton.disableProperty().setValue(Boolean.valueOf(InstallController.this.isokversion));
                            InstallController.this.selectLocationButton.disableProperty().setValue(Boolean.valueOf(!InstallController.this.isokversion));
                            InstallController.this.defaultLocationButton.disableProperty().setValue(Boolean.valueOf(!InstallController.this.isokversion));
                            InstallController.this.skipInstallButton.disableProperty().setValue(Boolean.valueOf(!InstallController.this.isokversion));
                            InstallController.this.skipInstallRememberButton.disableProperty().setValue(Boolean.valueOf(!InstallController.this.isokversion));
                        }
                    }
                }, 5L, 5L, TimeUnit.SECONDS);
            } else {
                this.error_message.setText("Unable to install");
                this.xbrlFileController.setStatusBarMessage("Unable to install");
                this.installButton.disableProperty().setValue(Boolean.valueOf(false));
                this.downloadUpgradeButton.disableProperty().setValue(Boolean.valueOf(this.isokversion));
                this.selectLocationButton.disableProperty().setValue(Boolean.valueOf(!this.isokversion));
                this.defaultLocationButton.disableProperty().setValue(Boolean.valueOf(!this.isokversion));
                this.skipInstallButton.disableProperty().setValue(Boolean.valueOf(!this.isokversion));
                this.skipInstallRememberButton.disableProperty().setValue(Boolean.valueOf(!this.isokversion));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
            this.installButton.disableProperty().setValue(Boolean.valueOf(false));
            this.downloadUpgradeButton.disableProperty().setValue(Boolean.valueOf(this.isokversion));
            this.selectLocationButton.disableProperty().setValue(Boolean.valueOf(!this.isokversion));
            this.defaultLocationButton.disableProperty().setValue(Boolean.valueOf(!this.isokversion));
            this.skipInstallButton.disableProperty().setValue(Boolean.valueOf(!this.isokversion));
            this.skipInstallRememberButton.disableProperty().setValue(Boolean.valueOf(!this.isokversion));
        }
    }

    @FXML
    private void selectLocation() {
        File dir = this.xbrlFileController.chooseSaveLocation();
        if (dir != null) {
            this.installDir = dir;
        }
        if (this.installDir == null) {
            this.error_message.setText("No file selected, choosing default location");
            this.xbrlFileController.setStatusBarMessage("No file selected, choosing default location");
            try {
                this.installDir = this.xbrlFileController.locateInstallDirectory();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.error_message.setText(e.getMessage());
                this.xbrlFileController.setStatusBarMessage(e.getMessage());
            }
        }
        if (this.installDir == null) {
            this.install_location.setText(null);
            this.installButton.disableProperty().setValue(Boolean.valueOf(true));
            this.downloadUpgradeButton.disableProperty().setValue(Boolean.valueOf(this.isokversion));
            this.selectLocationButton.disableProperty().setValue(Boolean.valueOf(!this.isokversion));
            this.defaultLocationButton.disableProperty().setValue(Boolean.valueOf(!this.isokversion));
            this.skipInstallButton.disableProperty().setValue(Boolean.valueOf(!this.isokversion));
            this.skipInstallRememberButton.disableProperty().setValue(Boolean.valueOf(!this.isokversion));
        } else {
            this.install_location.setText(this.installDir.getAbsolutePath());
            this.installButton.disableProperty().setValue(Boolean.valueOf(false));
            this.downloadUpgradeButton.disableProperty().setValue(Boolean.valueOf(this.isokversion));
            this.selectLocationButton.disableProperty().setValue(Boolean.valueOf(!this.isokversion));
            this.defaultLocationButton.disableProperty().setValue(Boolean.valueOf(!this.isokversion));
            this.skipInstallButton.disableProperty().setValue(Boolean.valueOf(!this.isokversion));
            this.skipInstallRememberButton.disableProperty().setValue(Boolean.valueOf(!this.isokversion));
        }
    }

    @FXML
    private void defaultLocation() {
        try {
            this.installDir = this.xbrlFileController.locateInstallDirectory();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
        if (this.installDir == null) {
            this.install_location.setText(null);
            this.installButton.disableProperty().setValue(Boolean.valueOf(true));
            this.downloadUpgradeButton.disableProperty().setValue(Boolean.valueOf(this.isokversion));
            this.selectLocationButton.disableProperty().setValue(Boolean.valueOf(!this.isokversion));
            this.defaultLocationButton.disableProperty().setValue(Boolean.valueOf(!this.isokversion));
            this.skipInstallButton.disableProperty().setValue(Boolean.valueOf(!this.isokversion));
            this.skipInstallRememberButton.disableProperty().setValue(Boolean.valueOf(!this.isokversion));
        } else {
            this.install_location.setText(this.installDir.getAbsolutePath());
            this.installButton.disableProperty().setValue(Boolean.valueOf(false));
            this.downloadUpgradeButton.disableProperty().setValue(Boolean.valueOf(this.isokversion));
            this.selectLocationButton.disableProperty().setValue(Boolean.valueOf(!this.isokversion));
            this.defaultLocationButton.disableProperty().setValue(Boolean.valueOf(!this.isokversion));
            this.skipInstallButton.disableProperty().setValue(Boolean.valueOf(!this.isokversion));
            this.skipInstallRememberButton.disableProperty().setValue(Boolean.valueOf(!this.isokversion));
        }
    }

    @FXML
    private void skipInstall() {
        this.xbrlFileController.gotoWelcomePage(true);
    }

    @FXML
    private void skipInstallRemember() {
        this.xbrlFileController.setConfigValue("skip_install_check", "true");
        this.xbrlFileController.gotoWelcomePage(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @FXML
    private void downloadUpgrade() {
        block35: {
            File downloadJar;
            block34: {
                int readBytes2333333332;
                downloadJar = null;
                try {
                    downloadJar = File.createTempFile("FAS3Desktop", ".jar");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.error_message.setText(e.getMessage());
                    this.xbrlFileController.setStatusBarMessage(e.getMessage());
                }
                if (downloadJar == null) break block35;
                this.installButton.disableProperty().setValue(Boolean.valueOf(true));
                this.downloadUpgradeButton.disableProperty().setValue(Boolean.valueOf(true));
                this.selectLocationButton.disableProperty().setValue(Boolean.valueOf(true));
                this.defaultLocationButton.disableProperty().setValue(Boolean.valueOf(true));
                this.skipInstallButton.disableProperty().setValue(Boolean.valueOf(true));
                this.skipInstallRememberButton.disableProperty().setValue(Boolean.valueOf(true));
                InputStream is = null;
                FilterOutputStream os = null;
                this.error_message.setText("Downloading new version...");
                this.xbrlFileController.setStatusBarMessage("Downloading new version...");
                is = new BufferedInputStream(new URL(this.fas3DesktopDownloadURL).openStream());
                os = new BufferedOutputStream(new FileOutputStream(downloadJar));
                byte[] b = new byte[1024];
                while ((readBytes2333333332 = is.read(b)) != -1) {
                    ((BufferedOutputStream)os).write(b, 0, readBytes2333333332);
                }
                ((BufferedOutputStream)os).flush();
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException readBytes2333333332) {
                    // empty catch block
                }
                try {
                    if (os != null) {
                        os.close();
                    }
                    break block34;
                }
                catch (IOException e) {
                    if (this.installDir != null) {
                        this.installButton.disableProperty().setValue(Boolean.valueOf(false));
                    } else {
                        this.installButton.disableProperty().setValue(Boolean.valueOf(true));
                    }
                    this.downloadUpgradeButton.disableProperty().setValue(Boolean.valueOf(this.isokversion));
                    this.selectLocationButton.disableProperty().setValue(Boolean.valueOf(!this.isokversion));
                    this.defaultLocationButton.disableProperty().setValue(Boolean.valueOf(!this.isokversion));
                    this.skipInstallButton.disableProperty().setValue(Boolean.valueOf(!this.isokversion));
                    this.skipInstallRememberButton.disableProperty().setValue(Boolean.valueOf(!this.isokversion));
                }
                break block34;
                catch (Exception e322222222) {
                    try {
                        e322222222.printStackTrace();
                        this.error_message.setText(e322222222.getMessage());
                        this.xbrlFileController.setStatusBarMessage(e322222222.getMessage());
                    }
                    catch (Throwable throwable) {
                        try {
                            if (is != null) {
                                is.close();
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        try {
                            if (os != null) {
                                os.close();
                            }
                        }
                        catch (IOException e2) {
                            if (this.installDir != null) {
                                this.installButton.disableProperty().setValue(Boolean.valueOf(false));
                            } else {
                                this.installButton.disableProperty().setValue(Boolean.valueOf(true));
                            }
                            this.downloadUpgradeButton.disableProperty().setValue(Boolean.valueOf(this.isokversion));
                            this.selectLocationButton.disableProperty().setValue(Boolean.valueOf(!this.isokversion));
                            this.defaultLocationButton.disableProperty().setValue(Boolean.valueOf(!this.isokversion));
                            this.skipInstallButton.disableProperty().setValue(Boolean.valueOf(!this.isokversion));
                            this.skipInstallRememberButton.disableProperty().setValue(Boolean.valueOf(!this.isokversion));
                        }
                        throw throwable;
                    }
                    try {
                        if (is != null) {
                            is.close();
                        }
                    }
                    catch (IOException e322222222) {
                        // empty catch block
                    }
                    try {
                        if (os != null) {
                            os.close();
                        }
                    }
                    catch (IOException e4) {
                        if (this.installDir != null) {
                            this.installButton.disableProperty().setValue(Boolean.valueOf(false));
                        } else {
                            this.installButton.disableProperty().setValue(Boolean.valueOf(true));
                        }
                        this.downloadUpgradeButton.disableProperty().setValue(Boolean.valueOf(this.isokversion));
                        this.selectLocationButton.disableProperty().setValue(Boolean.valueOf(!this.isokversion));
                        this.defaultLocationButton.disableProperty().setValue(Boolean.valueOf(!this.isokversion));
                        this.skipInstallButton.disableProperty().setValue(Boolean.valueOf(!this.isokversion));
                        this.skipInstallRememberButton.disableProperty().setValue(Boolean.valueOf(!this.isokversion));
                    }
                }
            }
            Platform.runLater(() -> {
                this.error_message.setText("Download complete, installing and starting downloaded version in 5 seconds");
                this.xbrlFileController.setStatusBarMessage("Download complete, installing and starting downloaded version in 5 seconds");
            });
            final String downloadJarPath = downloadJar.getAbsolutePath();
            try {
                final File thisJar = this.xbrlFileController.getThisJarFile();
                if (thisJar != null) {
                    ScheduledExecutorService exec = Executors.newSingleThreadScheduledExecutor();
                    exec.scheduleWithFixedDelay(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Runtime rt = Runtime.getRuntime();
                                String[] cmdarray = new String[]{"java", "-jar", downloadJarPath, "-install", thisJar.getAbsolutePath()};
                                Process p = rt.exec(cmdarray);
                                InstallController.this.xbrlFileController.processExit();
                            }
                            catch (Exception e) {
                                Platform.runLater(() -> {
                                    e.printStackTrace();
                                    InstallController.this.error_message.setText(e.getMessage());
                                    InstallController.this.xbrlFileController.setStatusBarMessage(e.getMessage());
                                    InstallController.this.installButton.disableProperty().setValue(Boolean.valueOf(false));
                                    InstallController.this.downloadUpgradeButton.disableProperty().setValue(Boolean.valueOf(InstallController.this.isokversion));
                                    InstallController.this.selectLocationButton.disableProperty().setValue(Boolean.valueOf(!InstallController.this.isokversion));
                                    InstallController.this.defaultLocationButton.disableProperty().setValue(Boolean.valueOf(!InstallController.this.isokversion));
                                    InstallController.this.skipInstallButton.disableProperty().setValue(Boolean.valueOf(!InstallController.this.isokversion));
                                    InstallController.this.skipInstallRememberButton.disableProperty().setValue(Boolean.valueOf(!InstallController.this.isokversion));
                                });
                            }
                        }
                    }, 5L, 5L, TimeUnit.SECONDS);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.error_message.setText(e.getMessage());
                this.xbrlFileController.setStatusBarMessage(e.getMessage());
                return;
            }
        }
    }

    protected String generateMessageIdentifier() {
        UUID uuid = UUID.randomUUID();
        return uuid.toString() + "@freeaccountingsoftware.com.au";
    }

    public void doVersionCheck() {
        final ApplicationController xbrlFileController = this.xbrlFileController;
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Platform.runLater(() -> {
                        InstallController.this.installButton.disableProperty().setValue(Boolean.valueOf(true));
                        InstallController.this.downloadUpgradeButton.disableProperty().setValue(Boolean.valueOf(true));
                        InstallController.this.selectLocationButton.disableProperty().setValue(Boolean.valueOf(true));
                        InstallController.this.defaultLocationButton.disableProperty().setValue(Boolean.valueOf(true));
                        InstallController.this.skipInstallButton.disableProperty().setValue(Boolean.valueOf(true));
                        InstallController.this.skipInstallRememberButton.disableProperty().setValue(Boolean.valueOf(true));
                        xbrlFileController.setStatusBarMessage("Doing version check...");
                        InstallController.this.error_message.setText("Doing version check...");
                    });
                    String usageMessageID = InstallController.this.generateMessageIdentifier();
                    GlenixResult glenixResult = xbrlFileController.doVersionCheck(usageMessageID);
                    String resultCode = null;
                    if (glenixResult != null) {
                        resultCode = glenixResult.getResultCode();
                    }
                    boolean isupgradable = false;
                    if (resultCode == null) {
                        InstallController.this.isokversion = true;
                        Platform.runLater(() -> {
                            InstallController.this.error_message.setText("Warning: unable to check the version.");
                            xbrlFileController.setStatusBarMessage("Warning: unable to check the version.");
                            InstallController.this.checkSkipInstall();
                        });
                    } else if (!resultCode.equals("OK")) {
                        InstallController.this.isokversion = false;
                        isupgradable = true;
                        if (resultCode.equals("WARNVERSION")) {
                            InstallController.this.isokversion = true;
                            Platform.runLater(() -> InstallController.this.error_message.setText("Warning: The version you are using is not the latest version it is recommended to download and install the latest version. To do this click \"Other options\" and then click \"Download and install latest version\"."));
                        } else if (resultCode.equals("WARNLICENSE")) {
                            InstallController.this.isokversion = true;
                            Platform.runLater(() -> InstallController.this.error_message.setText("Warning: " + glenixResult.getResultDescription()));
                        } else if (resultCode.equals("WARNING")) {
                            InstallController.this.isokversion = true;
                            Platform.runLater(() -> InstallController.this.error_message.setText("Warning: " + glenixResult.getResultDescription()));
                        } else if (resultCode.equals("ERRORLICENSE")) {
                            Platform.runLater(() -> InstallController.this.error_message.setText("Error: " + glenixResult.getResultDescription()));
                        } else if (resultCode.equals("ERRORVERSION")) {
                            Platform.runLater(() -> InstallController.this.error_message.setText("Error: The version you are using is out of date you must download and install the latest version to continue. To do this click \"Other options\" and then click \"Download and install latest version\"."));
                        } else if (resultCode.equals("ERROR")) {
                            Platform.runLater(() -> InstallController.this.error_message.setText("Error: " + glenixResult.getResultDescription()));
                        } else {
                            Platform.runLater(() -> InstallController.this.error_message.setText("Error: " + glenixResult.getResultDescription()));
                        }
                    } else {
                        InstallController.this.isokversion = true;
                        Platform.runLater(() -> {
                            InstallController.this.error_message.setText(null);
                            xbrlFileController.setStatusBarMessage(null);
                            InstallController.this.checkSkipInstall();
                        });
                    }
                    boolean dup = isupgradable;
                    Platform.runLater(() -> {
                        if (InstallController.this.installDir != null) {
                            InstallController.this.installButton.disableProperty().setValue(Boolean.valueOf(false));
                            if (InstallController.this.isokversion) {
                                InstallController.this.installButton.setText("Install");
                            } else {
                                InstallController.this.installButton.setText("Download latest version");
                            }
                        } else {
                            InstallController.this.installButton.setText("Install");
                            InstallController.this.installButton.disableProperty().setValue(Boolean.valueOf(true));
                        }
                        InstallController.this.downloadUpgradeButton.disableProperty().setValue(Boolean.valueOf(!dup));
                        InstallController.this.selectLocationButton.disableProperty().setValue(Boolean.valueOf(!InstallController.this.isokversion));
                        InstallController.this.defaultLocationButton.disableProperty().setValue(Boolean.valueOf(!InstallController.this.isokversion));
                        InstallController.this.skipInstallButton.disableProperty().setValue(Boolean.valueOf(!InstallController.this.isokversion));
                        InstallController.this.skipInstallRememberButton.disableProperty().setValue(Boolean.valueOf(!InstallController.this.isokversion));
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Platform.runLater(() -> {
                        e.printStackTrace();
                        InstallController.this.error_message.setText(e.getMessage());
                        xbrlFileController.setStatusBarMessage(e.getMessage());
                        if (InstallController.this.installDir != null) {
                            InstallController.this.installButton.disableProperty().setValue(Boolean.valueOf(false));
                        } else {
                            InstallController.this.installButton.disableProperty().setValue(Boolean.valueOf(true));
                        }
                        InstallController.this.downloadUpgradeButton.disableProperty().setValue(Boolean.valueOf(true));
                        InstallController.this.selectLocationButton.disableProperty().setValue(Boolean.valueOf(false));
                        InstallController.this.defaultLocationButton.disableProperty().setValue(Boolean.valueOf(false));
                        InstallController.this.skipInstallButton.disableProperty().setValue(Boolean.valueOf(false));
                        InstallController.this.skipInstallRememberButton.disableProperty().setValue(Boolean.valueOf(false));
                    });
                }
            }
        }).start();
    }

    private void checkSkipInstall() {
        String skipInstallConfig = this.xbrlFileController.getConfigValue("skip_install_check", null);
        if (skipInstallConfig == null || skipInstallConfig.isEmpty() || !skipInstallConfig.equals("true")) {
            try {
                File installedJar;
                File thisJar = this.xbrlFileController.getThisJarFile();
                if (!(thisJar == null || (installedJar = this.xbrlFileController.getInstalledJarFile(this.install_location.getText())) != null && installedJar.exists() && Files.isSameFile(thisJar.toPath(), installedJar.toPath()))) {
                    return;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.error_message.setText(e.getMessage());
                this.xbrlFileController.setStatusBarMessage(e.getMessage());
            }
        }
        this.skipInstall();
    }
}

