/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import au.com.glenix.ApplicationController;
import au.com.glenix.IncomeAndExpenditureAccountDetailController;
import au.com.glenix.trn.Account;
import au.com.glenix.trn.Provision;
import au.com.glenix.trn.Transaction;
import au.com.glenix.widget.GlenixPDFWrapper;
import java.net.URL;
import java.time.LocalDate;
import java.util.List;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.util.Callback;

public class IncomeAndExpenditureProvisionDetailController
extends IncomeAndExpenditureAccountDetailController {
    @FXML
    private TableColumn accountNameColumn;
    private Provision provision;

    public IncomeAndExpenditureProvisionDetailController(ApplicationController applicationController) {
        super(applicationController);
    }

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        super.initialize(url, rb);
        if (this.accountNameColumn != null) {
            this.accountNameColumn.setCellFactory((Callback)new Callback<TableColumn<Transaction.TransactionTransactionLine, Account>, TableCell<Transaction.TransactionTransactionLine, Account>>(){

                public TableCell call(TableColumn<Transaction.TransactionTransactionLine, Account> param) {
                    TableCell<Transaction.TransactionTransactionLine, String> cell = new TableCell<Transaction.TransactionTransactionLine, String>(){

                        public void updateItem(String item, boolean empty) {
                            super.updateItem((Object)item, empty);
                            this.setGraphic(null);
                            if (empty) {
                                this.setText(null);
                            } else {
                                Transaction.TransactionTransactionLine ttl = (Transaction.TransactionTransactionLine)this.getTableView().getItems().get(this.getIndex());
                                String id = ttl.getProvisionIdentifier();
                                boolean isset = false;
                                if (id != null) {
                                    try {
                                        Transaction ct = IncomeAndExpenditureProvisionDetailController.this.applicationController.getAccountTransaction(id);
                                        if (ct != null) {
                                            this.setText(ct.getAccountName());
                                            isset = true;
                                        }
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                }
                                if (!isset) {
                                    this.setText("null");
                                }
                            }
                        }
                    };
                    return cell;
                }
            });
        }
    }

    @Override
    public void setTransactionLineList(String provisionIdentifier, List<Transaction.TransactionTransactionLine> transactionLines) throws Exception {
        Transaction t;
        this.provision = null;
        if (provisionIdentifier != null && !provisionIdentifier.isEmpty() && (t = this.applicationController.getProvisionTransaction(provisionIdentifier)) != null) {
            this.provision = t.getProvision();
        }
        if (this.provision == null) {
            this.page_heading.setText("Income and expenditure tax transaction listing");
            this.setGlenixElementDescription("Income and expenditure tax transaction listing");
        } else {
            this.page_heading.setText(this.provision.getProvisionName() + " - transaction listing");
            this.setGlenixElementDescription(this.provision.getProvisionName() + " - transaction listing");
            String classification = this.provision.getProvisionClassificationReference();
            this.multiplier = 1;
            if (classification != null && (classification.equals("income") || classification.equals("netincome") || classification.equals("totalincome")) || classification.equals("equity") || classification.equals("distribution") || classification.equals("totalequity")) {
                this.multiplier = -1;
            }
        }
        if (transactionLines == null) {
            this.incomeAndExpenditure.setItems(null);
            return;
        }
        this.transactionLineObservableList = FXCollections.observableList(transactionLines);
        this.setTransactionObservableList((ObservableList<Transaction.TransactionTransactionLine>)this.transactionLineObservableList);
        this.updateFilter();
        this.incomeAndExpenditure.refresh();
    }

    @Override
    protected void updateTotalAmount() {
        Double totalAmount = 0.0;
        Double totalProvisionAmount = 0.0;
        Double totalQuantity = 0.0;
        for (Transaction.TransactionTransactionLine ttl : this.filteredItems) {
            totalAmount = totalAmount + ttl.getDebitAmount();
            totalProvisionAmount = totalProvisionAmount + ttl.getDebitProvisionAmount();
            totalQuantity = totalQuantity + ttl.getDebitQuantity();
        }
        totalAmount = (double)this.multiplier * totalAmount;
        totalProvisionAmount = (double)this.multiplier * totalProvisionAmount;
        totalQuantity = (double)this.multiplier * totalQuantity;
        this.total_label.setText("Total displayed tax amount: " + this.amountFormat.format(totalProvisionAmount) + ", total gross: " + this.amountFormat.format(totalAmount) + ", net amount: " + this.amountFormat.format(totalAmount - totalProvisionAmount) + ", total quantity " + this.quantityFormat.format(totalQuantity));
    }

    @Override
    public GlenixPDFWrapper buildPDF(boolean includeBlanks) throws Exception {
        String filterTextValue;
        GlenixPDFWrapper gpw = new GlenixPDFWrapper();
        gpw.addPDPageLandscape();
        gpw.setColumns(10);
        gpw.setColumnLeftPosAndWidthMM(0, 20.0, 266.0);
        gpw.setColumnLeftPosAndWidthMM(1, 20.0, 266.0);
        gpw.setColumnLeftPosAndWidthMM(2, 20.0, 24.0);
        gpw.setColumnLeftPosAndWidthMM(3, 44.0, 40.0);
        gpw.setColumnLeftPosAndWidthMM(4, 84.0, 50.0);
        gpw.setColumnLeftPosAndWidthMM(5, 134.0, 26.0);
        gpw.setColumnLeftPosAndWidthMM(6, 160.0, 20.0);
        gpw.setColumnLeftPosAndWidthMM(7, 180.0, 26.0);
        gpw.setColumnLeftPosAndWidthMM(8, 206.0, 20.0);
        gpw.setColumnLeftPosAndWidthMM(9, 228.0, 58.0);
        gpw.setColumnFont(0, gpw.muliBoldFont);
        gpw.setColumnFont(1, gpw.muliLightFont);
        gpw.setColumnFont(2, gpw.muliLightFont);
        gpw.setColumnFont(3, gpw.muliLightFont);
        gpw.setColumnFont(4, gpw.muliLightFont);
        gpw.setColumnFont(5, gpw.muliLightFont);
        gpw.setColumnFont(6, gpw.muliLightFont);
        gpw.setColumnFont(7, gpw.muliLightFont);
        gpw.setColumnFont(8, gpw.muliLightFont);
        gpw.setColumnFont(9, gpw.muliLightFont);
        Double fontSize = this.convertFontSize(this.page_heading.getFont().getSize());
        gpw.prepareString(0, this.page_heading.getText(), true, fontSize);
        gpw.drawStrings(10.0);
        fontSize = this.convertFontSize(new Double(this.applicationController.getCurrentFontSize()));
        if (this.filterText != null && (filterTextValue = this.filterText.getGlenixElementValue()) != null && !filterTextValue.isEmpty()) {
            gpw.prepareString(1, "Filter: " + filterTextValue, true, fontSize);
            gpw.drawStrings(10.0);
        }
        this.drawPDFColumnHeadings(gpw);
        gpw.setAddPageCallback(this);
        Double totalAmount = 0.0;
        Double totalNetAmount = 0.0;
        Double totalProvisionAmount = 0.0;
        Double totalQuantity = 0.0;
        for (Transaction.TransactionTransactionLine ttl : this.filteredItems) {
            Double qty;
            String id;
            LocalDate d = ttl.getTransactionDateAsDate();
            if (d != null) {
                gpw.prepareString(2, this.displayDateFormatter.format(d), true, fontSize);
            }
            if ((id = ttl.getCounterpartyIdentifier()) != null && !id.isEmpty()) {
                try {
                    Transaction ct = this.applicationController.getCounterpartyTransaction(id);
                    if (ct != null) {
                        gpw.prepareString(3, ct.getCounterpartyLegalName(), true, fontSize);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            gpw.prepareString(4, ttl.getTransactionComment(), true, fontSize);
            Double amt = ttl.getProvisionAmount();
            if (amt != null) {
                totalAmount = totalAmount + amt;
                gpw.prepareString(5, this.amountFormat.format(amt), true, fontSize, "right");
            }
            if ((qty = ttl.getQuantity()) != null) {
                totalQuantity = totalQuantity + qty;
                gpw.prepareString(6, this.quantityFormat.format(qty), true, fontSize, "right");
            }
            if ((amt = ttl.getAmount()) != null) {
                totalAmount = totalAmount + amt;
                gpw.prepareString(7, this.amountFormat.format(amt), true, fontSize, "right");
            }
            if ((amt = ttl.getNetAmount()) != null) {
                totalNetAmount = totalNetAmount + amt;
                gpw.prepareString(8, this.amountFormat.format(amt), true, fontSize, "right");
            }
            if ((id = ttl.getAccountIdentifier()) != null && !id.isEmpty()) {
                try {
                    Transaction at = this.applicationController.getAccountTransaction(id);
                    if (at != null) {
                        gpw.prepareString(9, at.getAccountName(), true, fontSize);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            gpw.drawStrings(2.0);
        }
        gpw.setColumnFont(2, gpw.muliBoldFont);
        gpw.setColumnFont(5, gpw.muliBoldFont);
        gpw.setColumnFont(6, gpw.muliBoldFont);
        gpw.setColumnFont(7, gpw.muliBoldFont);
        gpw.setColumnFont(8, gpw.muliBoldFont);
        gpw.prepareString(2, "Totals", true, fontSize);
        gpw.prepareString(5, this.amountFormat.format(totalProvisionAmount), true, fontSize, "right");
        gpw.prepareString(6, this.quantityFormat.format(totalQuantity), true, fontSize, "right");
        gpw.prepareString(7, this.amountFormat.format(totalAmount), true, fontSize, "right");
        gpw.prepareString(8, this.amountFormat.format(totalNetAmount), true, fontSize, "right");
        gpw.drawStrings();
        gpw.addFooter();
        return gpw;
    }

    private void drawPDFColumnHeadings(GlenixPDFWrapper gpw) throws Exception {
        gpw.setColumnFont(2, gpw.muliBoldFont);
        gpw.setColumnFont(3, gpw.muliBoldFont);
        gpw.setColumnFont(4, gpw.muliBoldFont);
        gpw.setColumnFont(5, gpw.muliBoldFont);
        gpw.setColumnFont(6, gpw.muliBoldFont);
        gpw.setColumnFont(7, gpw.muliBoldFont);
        gpw.setColumnFont(8, gpw.muliBoldFont);
        gpw.setColumnFont(9, gpw.muliBoldFont);
        Double fontSize = this.convertFontSize(new Double(this.applicationController.getCurrentFontSize()));
        gpw.prepareString(2, this.dateColumn.getText(), true, fontSize);
        gpw.prepareString(3, this.counterpartyNameColumn.getText(), true, fontSize);
        gpw.prepareString(4, this.detailCommentColumn.getText(), true, fontSize);
        gpw.prepareString(5, this.provisionAmountColumn.getText(), true, fontSize, "right");
        gpw.prepareString(6, this.quantityColumn.getText(), true, fontSize, "right");
        gpw.prepareString(7, this.amountColumn.getText(), true, fontSize, "right");
        gpw.prepareString(8, this.netAmountColumn.getText(), true, fontSize, "right");
        gpw.prepareString(9, this.accountNameColumn.getText(), true, fontSize);
        gpw.drawStrings(2.0);
        gpw.setColumnFont(2, gpw.muliLightFont);
        gpw.setColumnFont(3, gpw.muliLightFont);
        gpw.setColumnFont(4, gpw.muliLightFont);
        gpw.setColumnFont(5, gpw.muliLightFont);
        gpw.setColumnFont(6, gpw.muliLightFont);
        gpw.setColumnFont(7, gpw.muliLightFont);
        gpw.setColumnFont(8, gpw.muliLightFont);
        gpw.setColumnFont(9, gpw.muliLightFont);
    }
}

