/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import au.com.glenix.ApplicationController;
import au.com.glenix.trn.Account;
import au.com.glenix.trn.Provision;
import au.com.glenix.trn.Transaction;
import au.com.glenix.trn.TransactionLine;
import au.com.glenix.widget.GlenixBranchController;
import au.com.glenix.widget.GlenixLabelDate;
import au.com.glenix.widget.GlenixLabelText;
import au.com.glenix.widget.GlenixPDFWrapper;
import au.com.glenix.widget.GlenixPDFWrapperNewPageCallback;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.input.MouseEvent;
import javafx.scene.text.Text;

public class IncomeAndExpenditureController
extends GlenixBranchController
implements GlenixPDFWrapperNewPageCallback {
    protected Transaction summaryTransaction = null;
    @FXML
    protected Label error_message;
    @FXML
    protected Label page_heading;
    @FXML
    protected TableView incomeAndExpenditure;
    @FXML
    protected TableColumn nameColumn;
    @FXML
    protected TableColumn netColumn;
    @FXML
    protected TableColumn quantityColumn;
    @FXML
    protected TableColumn grossColumn;
    @FXML
    protected TableColumn provisionAmountsColumn;
    @FXML
    protected GlenixLabelText filterText;
    @FXML
    protected GlenixLabelDate filterFromDate;
    @FXML
    protected GlenixLabelDate filterToDate;
    protected LocalDate lastMaxDate;
    protected ObservableList<ReportLine> reportLineObservableList = null;
    protected ApplicationController applicationController;
    private NumberFormat formatTwoDpDollars = new DecimalFormat("$#,##0.00");

    public IncomeAndExpenditureController(ApplicationController applicationController) {
        this.applicationController = applicationController;
    }

    public void setupIncomeAndExpenditureTable() {
        this.incomeAndExpenditure.setRowFactory(tv -> {
            TableRow<ReportLine> row = new TableRow<ReportLine>(){

                protected final void updateItem(ReportLine reportLine, boolean empty) {
                    super.updateItem((Object)reportLine, empty);
                    if (reportLine != null && reportLine.getClassification() != null && (reportLine.getClassification().equals("incomeheader") || reportLine.getClassification().equals("totalincome") || reportLine.getClassification().equals("expenseheader") || reportLine.getClassification().equals("totalexpense") || reportLine.getClassification().equals("netincome") || reportLine.getClassification().equals("totalasset") || reportLine.getClassification().equals("totalliability") || reportLine.getClassification().equals("totalequity") || reportLine.getClassification().equals("totalequityincrease") || reportLine.getClassification().equals("totaldistribution") || reportLine.getClassification().equals("assetheader") || reportLine.getClassification().equals("liabilityheader") || reportLine.getClassification().equals("equityheader") || reportLine.getClassification().equals("distributionheader"))) {
                        this.getStyleClass().add((Object)"totalRow");
                    }
                }
            };
            row.setOnMouseClicked(arg_0 -> this.lambda$null$0((TableRow)row, arg_0));
            return row;
        });
    }

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        this.setupIncomeAndExpenditureTable();
        this.nameColumn.setSortable(false);
        this.netColumn.setSortable(false);
        this.quantityColumn.setSortable(false);
        this.grossColumn.setSortable(false);
        this.provisionAmountsColumn.setSortable(false);
        this.nameColumn.setCellFactory(tc -> {
            TableCell cell = new TableCell();
            Text text = new Text();
            cell.setGraphic((Node)text);
            cell.setPrefHeight(-1.0);
            text.wrappingWidthProperty().bind((ObservableValue)this.nameColumn.widthProperty());
            text.textProperty().bind((ObservableValue)cell.itemProperty());
            return cell;
        });
    }

    public void gotoIncomeAndExpenditureAccountDetail(String ai) {
        try {
            this.applicationController.gotoIncomeAndExpenditureAccountDetail(ai, this.filterText.getGlenixElementValue(), this.filterFromDate.getLocalDate(), this.filterToDate.getLocalDate());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.applicationController.setStatusBarMessage(e.getMessage());
        }
    }

    public void gotoIncomeAndExpenditureProvisionDetail(String pi) {
        try {
            this.applicationController.gotoIncomeAndExpenditureProvisionDetail(pi, this.filterText.getGlenixElementValue(), this.filterFromDate.getLocalDate(), this.filterToDate.getLocalDate());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.applicationController.setStatusBarMessage(e.getMessage());
        }
    }

    public String getFilterText() {
        if (this.filterText == null) {
            return null;
        }
        return this.filterText.getGlenixElementValue();
    }

    public LocalDate getFromDate() {
        if (this.filterFromDate == null) {
            return null;
        }
        return this.filterFromDate.getLocalDate();
    }

    public LocalDate getToDate() {
        if (this.filterToDate == null) {
            return null;
        }
        return this.filterToDate.getLocalDate();
    }

    public void setFromDate(String dateStr) {
        if (this.filterFromDate != null) {
            this.filterFromDate.setGlenixElementValue(dateStr);
        }
    }

    public void setToDate(String dateStr) {
        if (this.filterToDate != null) {
            this.filterToDate.setGlenixElementValue(dateStr);
        }
    }

    public void setFromDate(LocalDate date) {
        if (this.filterFromDate != null) {
            this.filterFromDate.setLocalDate(date);
        }
    }

    public void setToDate(LocalDate date) {
        if (this.filterToDate != null) {
            this.filterToDate.setLocalDate(date);
        }
        this.lastMaxDate = date;
    }

    @FXML
    protected void updateFilter() {
        String filterTextValue = null;
        if (this.filterText != null) {
            filterTextValue = this.filterText.getGlenixElementValue();
        }
        LocalDate fromDateValue = null;
        if (this.filterFromDate != null) {
            fromDateValue = this.filterFromDate.getLocalDate();
        }
        LocalDate toDateValue = null;
        if (this.filterToDate != null) {
            toDateValue = this.filterToDate.getLocalDate();
        }
        try {
            List<Transaction> summaryTransaction = this.applicationController.getAccountProvisionTotals(filterTextValue, fromDateValue, toDateValue, null, null);
            if (summaryTransaction == null) {
                throw new Exception("Error, unable to generate Income and expenditure report");
            }
            this.setSummaryTransaction(summaryTransaction);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.applicationController.setStatusBarMessage(e.getMessage());
        }
    }

    public void addTotalLines(HashMap<String, ReportLine> reportLineHashMap) throws Exception {
        ReportLine incomeHeader = new ReportLine(null);
        incomeHeader.setClassification("incomeheader");
        incomeHeader.setName("Income");
        ReportLine totalIncome = new ReportLine(null);
        totalIncome.setClassification("totalincome");
        totalIncome.setSubClassification("totalincome");
        totalIncome.setName("Total income");
        ReportLine expenseHeader = new ReportLine(null);
        expenseHeader.setClassification("expenseheader");
        expenseHeader.setName("Expenditure");
        ReportLine totalExpense = new ReportLine(null);
        totalExpense.setClassification("totalexpense");
        totalExpense.setSubClassification("totalexpense");
        totalExpense.setName("Total expenditure");
        ReportLine netIncome = new ReportLine(null);
        netIncome.setClassification("netincome");
        netIncome.setSubClassification("netincome");
        netIncome.setName("Net income");
        ReportLine assetHeader = new ReportLine(null);
        assetHeader.setClassification("assetheader");
        assetHeader.setName("Asset increase/(decrease)");
        ReportLine totalAsset = new ReportLine(null);
        totalAsset.setClassification("totalasset");
        totalAsset.setSubClassification("totalasset");
        totalAsset.setName("Net asset increase/(decrease)");
        ReportLine liabilityHeader = new ReportLine(null);
        liabilityHeader.setClassification("liabilityheader");
        liabilityHeader.setName("Liability descrease/(increase)");
        ReportLine totalLiability = new ReportLine(null);
        totalLiability.setClassification("totalliability");
        totalLiability.setSubClassification("totalliability");
        totalLiability.setName("Net liability decrease/(increase)");
        ReportLine equityHeader = new ReportLine(null);
        equityHeader.setClassification("equityheader");
        equityHeader.setName("Equity increase/(decrease)");
        ReportLine totalEquity = new ReportLine(null);
        totalEquity.setClassification("totalequity");
        totalEquity.setSubClassification("totalequity");
        totalEquity.setName("Net equity increase/(decrease)");
        for (ReportLine rl : reportLineHashMap.values()) {
            Double tmp;
            String classification = rl.getClassification();
            if (classification != null && classification.equals("income")) {
                tmp = rl.getGrossAsDoubleCalc();
                if (tmp != null) {
                    totalIncome.addAmount(-tmp.doubleValue());
                }
                if ((tmp = rl.getQuantityAsDoubleCalc()) != null) {
                    totalIncome.addQuantity(-tmp.doubleValue());
                }
                totalIncome.addTransactionLines("cash_payment", rl.getTransactionLines());
                continue;
            }
            if (classification != null && classification.equals("expense")) {
                tmp = rl.getGrossAsDoubleCalc();
                if (tmp != null) {
                    totalExpense.addAmount(tmp);
                }
                if ((tmp = rl.getQuantityAsDoubleCalc()) != null) {
                    totalExpense.addQuantity(tmp);
                }
                totalExpense.addTransactionLines("cash_payment", rl.getTransactionLines());
                continue;
            }
            if (classification != null && classification.equals("asset")) {
                tmp = rl.getGrossAsDoubleCalc();
                if (tmp != null) {
                    totalAsset.addAmount(tmp);
                }
                if ((tmp = rl.getQuantityAsDoubleCalc()) != null) {
                    totalAsset.addQuantity(tmp);
                }
                totalAsset.addTransactionLines("cash_payment", rl.getTransactionLines());
                continue;
            }
            if (classification != null && classification.equals("liability")) {
                tmp = rl.getGrossAsDoubleCalc();
                if (tmp != null) {
                    totalLiability.addAmount(tmp);
                }
                if ((tmp = rl.getQuantityAsDoubleCalc()) != null) {
                    totalLiability.addQuantity(tmp);
                }
                totalLiability.addTransactionLines("cash_payment", rl.getTransactionLines());
                continue;
            }
            if (classification == null || !classification.equals("equity") && !classification.equals("distribution")) continue;
            tmp = rl.getGrossAsDoubleCalc();
            if (tmp != null) {
                totalEquity.addAmount(tmp);
            }
            if ((tmp = rl.getQuantityAsDoubleCalc()) != null) {
                totalEquity.addQuantity(tmp);
            }
            totalEquity.addTransactionLines("cash_payment", rl.getTransactionLines());
        }
        reportLineHashMap.put("incomeheader", incomeHeader);
        reportLineHashMap.put("totalincome", totalIncome);
        reportLineHashMap.put("expenseheader", expenseHeader);
        reportLineHashMap.put("totalexpense", totalExpense);
        Double tmp = totalIncome.getGrossAsDouble();
        if (tmp != null) {
            netIncome.addAmount(-tmp.doubleValue());
        }
        if ((tmp = totalIncome.getQuantityAsDouble()) != null) {
            netIncome.addQuantity(-tmp.doubleValue());
        }
        netIncome.addTransactionLines("cash_payment", totalIncome.getTransactionLines());
        tmp = totalExpense.getGrossAsDouble();
        if (tmp != null) {
            netIncome.addAmount(tmp);
        }
        if ((tmp = totalExpense.getQuantityAsDouble()) != null) {
            netIncome.addQuantity(tmp);
        }
        netIncome.addTransactionLines("cash_payment", totalExpense.getTransactionLines());
        reportLineHashMap.put("netincome", netIncome);
        if (totalAsset.hasValue()) {
            reportLineHashMap.put("assetheader", assetHeader);
            reportLineHashMap.put("totalasset", totalAsset);
        }
        if (totalLiability.hasValue()) {
            reportLineHashMap.put("liabilityheader", liabilityHeader);
            reportLineHashMap.put("totalliability", totalLiability);
        }
        if (totalEquity.hasValue()) {
            reportLineHashMap.put("equityheader", equityHeader);
            reportLineHashMap.put("totalequity", totalEquity);
        }
    }

    public void setSummaryTransaction(Transaction transaction) throws Exception {
        if (transaction == null) {
            this.setSummaryTransaction((List<Transaction>)null);
        }
        ArrayList<Transaction> trns = new ArrayList<Transaction>();
        trns.add(transaction);
        this.setSummaryTransaction(trns);
    }

    public HashMap<String, ReportLine> buildReportLineHashMap(List<Transaction> transactions) throws Exception {
        HashMap<String, ReportLine> reportLineHashMap = new HashMap<String, ReportLine>();
        for (Transaction transaction : transactions) {
            String tt = transaction.getTransactionType();
            for (int i = 0; i < transaction.getTransactionLineCount(); ++i) {
                String pi;
                TransactionLine tl = transaction.getTransactionLine(i);
                Account a = tl.getAccount();
                String ai = null;
                if (a != null) {
                    ai = a.getAccountIdentifier();
                }
                if (ai != null && !ai.isEmpty()) {
                    String pi2;
                    ReportLine rl = reportLineHashMap.get(ai);
                    if (rl == null) {
                        rl = new ReportLine(a);
                        reportLineHashMap.put(ai, rl);
                        rl.setAmount(tl.getDebitAmount(tt));
                        rl.setQuantity(tl.getDebitQuantity(tt));
                        rl.setClassification(a.getAccountClassificationReference());
                    } else {
                        rl.addAmount(tl.getDebitAmount(tt));
                        rl.addQuantity(tl.getDebitQuantity(tt));
                    }
                    rl.addTransactionLine(tt, tl);
                    Provision p = tl.getProvision();
                    if (p == null || (pi2 = p.getProvisionIdentifier()) == null || pi2.isEmpty()) continue;
                    ReportLine prl = reportLineHashMap.get("p_" + pi2);
                    if (prl == null) {
                        prl = new ReportLine(null);
                        reportLineHashMap.put("p_" + pi2, prl);
                        prl.setAmount(tl.getDebitAmount(tt));
                        prl.setQuantity(tl.getDebitQuantity(tt));
                        prl.setClassification(p.getProvisionClassificationReference());
                    } else {
                        prl.addAmount(tl.getDebitAmount(tt));
                        prl.addQuantity(tl.getDebitQuantity(tt));
                    }
                    prl.addTransactionLine(tt, tl);
                    continue;
                }
                Provision p = tl.getProvision();
                if (p == null || (pi = p.getProvisionIdentifier()) == null || pi.isEmpty()) continue;
                ReportLine rl = reportLineHashMap.get("p_" + pi);
                if (rl == null) {
                    rl = new ReportLine(null);
                    reportLineHashMap.put("p_" + pi, rl);
                    rl.setAmount(tl.getDebitAmount(tt));
                    rl.setQuantity(tl.getDebitQuantity(tt));
                    rl.setClassification(p.getProvisionClassificationReference());
                } else {
                    rl.addAmount(tl.getDebitAmount(tt));
                    rl.addQuantity(tl.getDebitQuantity(tt));
                }
                rl.addTransactionLine(tt, tl);
            }
        }
        return reportLineHashMap;
    }

    public void setSummaryTransaction(List<Transaction> transactions) throws Exception {
        if (transactions == null || transactions.size() == 0) {
            this.incomeAndExpenditure.getItems().clear();
            return;
        }
        HashMap<String, ReportLine> reportLineHashMap = this.buildReportLineHashMap(transactions);
        this.addTotalLines(reportLineHashMap);
        ArrayList<ReportLine> rlal = new ArrayList<ReportLine>();
        rlal.addAll(reportLineHashMap.values());
        rlal.sort(new Comparator<ReportLine>(){

            @Override
            public int compare(ReportLine rl1, ReportLine rl2) {
                String rl1class = rl1.getClassification();
                String rl2class = rl2.getClassification();
                if (rl1class != null) {
                    if (rl2class == null) {
                        return -1;
                    }
                    if (rl1class.equals("incomeheader") && !rl2class.equals("incomeheader")) {
                        return -1;
                    }
                    if (!rl1class.equals("incomeheader") && rl2class.equals("incomeheader")) {
                        return 1;
                    }
                    if (rl1class.equals("income") && !rl2class.equals("income")) {
                        return -1;
                    }
                    if (!rl1class.equals("income") && rl2class.equals("income")) {
                        return 1;
                    }
                    if (rl1class.equals("totalincome") && !rl2class.equals("totalincome")) {
                        return -1;
                    }
                    if (!rl1class.equals("totalincome") && rl2class.equals("totalincome")) {
                        return 1;
                    }
                    if (rl1class.equals("expenseheader") && !rl2class.equals("expenseheader")) {
                        return -1;
                    }
                    if (!rl1class.equals("expenseheader") && rl2class.equals("expenseheader")) {
                        return 1;
                    }
                    if (rl1class.equals("expense") && !rl2class.equals("expense")) {
                        return -1;
                    }
                    if (!rl1class.equals("expense") && rl2class.equals("expense")) {
                        return 1;
                    }
                    if (rl1class.equals("totalexpense") && !rl2class.equals("totalexpense")) {
                        return -1;
                    }
                    if (!rl1class.equals("totalexpense") && rl2class.equals("totalexpense")) {
                        return 1;
                    }
                    if (rl1class.equals("netincome") && !rl2class.equals("netincome")) {
                        return -1;
                    }
                    if (!rl1class.equals("netincome") && rl2class.equals("netincome")) {
                        return 1;
                    }
                    if (rl1class.equals("assetheader") && !rl2class.equals("assetheader")) {
                        return -1;
                    }
                    if (!rl1class.equals("assetheader") && rl2class.equals("assetheader")) {
                        return 1;
                    }
                    if (rl1class.equals("asset") && !rl2class.equals("asset")) {
                        return -1;
                    }
                    if (!rl1class.equals("asset") && rl2class.equals("asset")) {
                        return 1;
                    }
                    if (rl1class.equals("totalasset") && !rl2class.equals("totalasset")) {
                        return -1;
                    }
                    if (!rl1class.equals("totalasset") && rl2class.equals("totalasset")) {
                        return 1;
                    }
                    if (rl1class.equals("liabilityheader") && !rl2class.equals("liabilityheader")) {
                        return -1;
                    }
                    if (!rl1class.equals("liabilityheader") && rl2class.equals("liabilityheader")) {
                        return 1;
                    }
                    if (rl1class.equals("liability") && !rl2class.equals("liability")) {
                        return -1;
                    }
                    if (!rl1class.equals("liability") && rl2class.equals("liability")) {
                        return 1;
                    }
                    if (rl1class.equals("totalliability") && !rl2class.equals("totalliability")) {
                        return -1;
                    }
                    if (!rl1class.equals("totalliability") && rl2class.equals("totalliability")) {
                        return 1;
                    }
                    if (rl1class.equals("netassets") && !rl2class.equals("netassets")) {
                        return -1;
                    }
                    if (!rl1class.equals("netassets") && rl2class.equals("netassets")) {
                        return 1;
                    }
                    if (rl1class.equals("equityheader") && !rl2class.equals("equityheader")) {
                        return -1;
                    }
                    if (!rl1class.equals("equityheader") && rl2class.equals("equityheader")) {
                        return 1;
                    }
                    if (rl1class.equals("retainedearnings") && !rl2class.equals("retainedearnings")) {
                        return -1;
                    }
                    if (!rl1class.equals("retainedearnings") && rl2class.equals("retainedearnings")) {
                        return 1;
                    }
                    if ((rl1class.equals("equity") || rl1class.equals("distribution")) && !rl2class.equals("equity") && !rl2class.equals("distribution")) {
                        return -1;
                    }
                    if (!rl1class.equals("equity") && !rl1class.equals("distribution") && (rl2class.equals("equity") || rl2class.equals("distribution"))) {
                        return 1;
                    }
                    if (rl1class.equals("totalequity") && !rl2class.equals("totalequity")) {
                        return -1;
                    }
                    if (!rl1class.equals("totalequity") && rl2class.equals("totalequity")) {
                        return 1;
                    }
                    if (rl1class.equals("totalequityincrease") && !rl2class.equals("totalequityincrease")) {
                        return -1;
                    }
                    if (!rl1class.equals("totalequityincrease") && rl2class.equals("totalequityincrease")) {
                        return 1;
                    }
                    if (!rl1class.equals(rl2class)) {
                        return rl1class.compareTo(rl2class);
                    }
                } else if (rl2class != null) {
                    return 1;
                }
                return rl1.getName().compareTo(rl2.getName());
            }
        });
        this.reportLineObservableList = FXCollections.observableList(rlal);
        this.incomeAndExpenditure.setItems(this.reportLineObservableList);
        this.incomeAndExpenditure.refresh();
    }

    @Override
    public GlenixPDFWrapper buildPDF(boolean includeBlanks) throws Exception {
        GlenixPDFWrapper gpw = new GlenixPDFWrapper();
        gpw.addPDPage();
        gpw.setColumns(7);
        gpw.setColumnLeftPosAndWidthMM(0, 20.0, 180.0);
        gpw.setColumnLeftPosAndWidthMM(1, 20.0, 180.0);
        gpw.setColumnLeftPosAndWidthMM(2, 20.0, 48.0);
        gpw.setColumnLeftPosAndWidthMM(3, 70.0, 24.0);
        gpw.setColumnLeftPosAndWidthMM(4, 96.0, 24.0);
        gpw.setColumnLeftPosAndWidthMM(5, 122.0, 24.0);
        gpw.setColumnLeftPosAndWidthMM(6, 150.0, 50.0);
        gpw.setColumnFont(0, gpw.muliBoldFont);
        gpw.setColumnFont(1, gpw.muliLightFont);
        gpw.setColumnFont(2, gpw.muliLightFont);
        gpw.setColumnFont(3, gpw.muliLightFont);
        gpw.setColumnFont(4, gpw.muliLightFont);
        gpw.setColumnFont(5, gpw.muliLightFont);
        gpw.setColumnFont(6, gpw.muliLightFont);
        Double fontSize = this.convertFontSize(this.page_heading.getFont().getSize());
        gpw.prepareString(0, this.page_heading.getText(), true, fontSize);
        gpw.drawStrings(10.0);
        fontSize = this.convertFontSize(new Double(this.applicationController.getCurrentFontSize()));
        this.drawPDFColumnHeadings(gpw);
        gpw.setAddPageCallback(this);
        for (ReportLine rl : this.reportLineObservableList) {
            String rlclass = rl.getClassification();
            if (rlclass != null && (rlclass.equals("incomeheader") || rlclass.equals("totalincome") || rlclass.equals("expenseheader") || rlclass.equals("totalexpense") || rlclass.equals("netincome") || rlclass.equals("totalasset") || rlclass.equals("assetheader") || rlclass.equals("totalliability") || rlclass.equals("liabilityheader") || rlclass.equals("totalequity") || rlclass.equals("equityheader"))) {
                gpw.setColumnFont(2, gpw.muliBoldFont);
                gpw.setColumnFont(3, gpw.muliBoldFont);
                gpw.setColumnFont(4, gpw.muliBoldFont);
                gpw.setColumnFont(5, gpw.muliBoldFont);
                gpw.setColumnFont(6, gpw.muliBoldFont);
                gpw.prepareString(2, rl.getName(), true, fontSize);
                gpw.prepareString(3, rl.getNet(), true, fontSize, "right");
                gpw.prepareString(4, rl.getQuantity(), true, fontSize, "right");
                gpw.prepareString(5, rl.getGross(), true, fontSize, "right");
                gpw.prepareString(6, rl.getProvisionAmounts(), true, fontSize);
                if (rlclass.equals("totalincome") || rlclass.equals("totalexpense") || rlclass.equals("netincome") || rlclass.equals("totalasset") || rlclass.equals("totalliability") || rlclass.equals("totalequity")) {
                    gpw.drawStrings(12.0);
                } else {
                    gpw.drawStrings(2.0);
                }
                gpw.setColumnFont(2, gpw.muliLightFont);
                gpw.setColumnFont(3, gpw.muliLightFont);
                gpw.setColumnFont(4, gpw.muliLightFont);
                gpw.setColumnFont(5, gpw.muliLightFont);
                gpw.setColumnFont(6, gpw.muliLightFont);
                continue;
            }
            gpw.prepareString(2, rl.getName(), true, fontSize);
            gpw.prepareString(3, rl.getNet(), true, fontSize, "right");
            gpw.prepareString(4, rl.getQuantity(), true, fontSize, "right");
            gpw.prepareString(5, rl.getGross(), true, fontSize, "right");
            gpw.prepareString(6, rl.getProvisionAmounts(), true, fontSize);
            gpw.drawStrings(5.0);
        }
        gpw.addFooter();
        return gpw;
    }

    private void drawPDFColumnHeadings(GlenixPDFWrapper gpw) throws Exception {
        gpw.setColumnFont(2, gpw.muliBoldFont);
        gpw.setColumnFont(3, gpw.muliBoldFont);
        gpw.setColumnFont(4, gpw.muliBoldFont);
        gpw.setColumnFont(5, gpw.muliBoldFont);
        gpw.setColumnFont(6, gpw.muliBoldFont);
        Double fontSize = this.convertFontSize(new Double(this.applicationController.getCurrentFontSize()));
        gpw.prepareString(2, this.nameColumn.getText(), true, fontSize);
        gpw.prepareString(3, this.netColumn.getText(), true, fontSize, "right");
        gpw.prepareString(4, this.quantityColumn.getText(), true, fontSize, "right");
        gpw.prepareString(5, this.grossColumn.getText(), true, fontSize, "right");
        gpw.prepareString(6, this.provisionAmountsColumn.getText(), true, fontSize, "right");
        gpw.drawStrings(5.0);
        gpw.setColumnFont(2, gpw.muliLightFont);
        gpw.setColumnFont(3, gpw.muliLightFont);
        gpw.setColumnFont(4, gpw.muliLightFont);
        gpw.setColumnFont(5, gpw.muliLightFont);
        gpw.setColumnFont(6, gpw.muliLightFont);
    }

    @Override
    public void newPDFPageAdded(GlenixPDFWrapper gpw) throws Exception {
        this.drawPDFColumnHeadings(gpw);
    }

    private /* synthetic */ void lambda$null$0(TableRow row, MouseEvent event) {
        ReportLine reportItem;
        if (event.getClickCount() == 2 && !row.isEmpty() && (reportItem = (ReportLine)row.getItem()) != null) {
            String ai = reportItem.getAccountIdentifier();
            if (ai != null && !ai.isEmpty()) {
                this.gotoIncomeAndExpenditureAccountDetail(ai);
            } else {
                String pi = reportItem.getProvisionIdentifier();
                if (pi != null && !pi.isEmpty()) {
                    this.gotoIncomeAndExpenditureProvisionDetail(pi);
                }
            }
        }
    }

    public class ReportLine {
        String classification;
        String subClassification;
        String name;
        Account account;
        Double amount;
        Double quantity;
        boolean hidequantitygross = false;
        HashMap<String, TransactionLine> lines = new HashMap();
        Provision provision = null;
        Set<String> provisionIdentifiers = new HashSet<String>();

        public ReportLine(Account account, Provision provision) {
            this.account = account;
            this.provision = provision;
        }

        public void addProvisionIdentifier(String value) {
            this.provisionIdentifiers.add(value);
        }

        public ReportLine(Account account) {
            this.account = account;
        }

        public boolean hasValue() {
            if (this.amount != null) {
                return true;
            }
            if (this.quantity != null) {
                return true;
            }
            return this.lines.size() > 0;
        }

        public void setHideQuantityGross(boolean value) {
            this.hidequantitygross = value;
        }

        public String getAccountName() {
            if (this.account == null) {
                return "Unknown";
            }
            return this.account.getAccountName();
        }

        public String getAccountIdentifier() {
            if (this.account == null) {
                return null;
            }
            return this.account.getAccountIdentifier();
        }

        public Set<String> getProvisionIdentifiers() {
            return this.provisionIdentifiers;
        }

        public String getProvisionIdentifier() {
            if (this.provision != null) {
                return this.provision.getProvisionIdentifier();
            }
            if (this.lines.size() != 1) {
                return null;
            }
            for (TransactionLine tl : this.lines.values()) {
                Provision p = tl.getProvision();
                if (p == null) continue;
                return p.getProvisionIdentifier();
            }
            return null;
        }

        public String getName() {
            String acName;
            if (this.name != null && !this.name.isEmpty()) {
                return this.name;
            }
            if (this.account != null && (acName = this.account.getAccountName()) != null && !acName.isEmpty()) {
                return acName;
            }
            for (TransactionLine tl : this.lines.values()) {
                String pn;
                Provision p = tl.getProvision();
                if (p == null || (pn = p.getProvisionName()) == null || pn.isEmpty()) continue;
                return pn;
            }
            return "Unknown";
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setAmount(Double amount) {
            this.amount = amount;
        }

        private Double addDouble(Double d, Double dd) {
            if (d == null) {
                return dd;
            }
            if (dd == null) {
                return d;
            }
            return dd + d;
        }

        private Double subtractDouble(Double d, Double dd) {
            if (d == null) {
                if (dd == null) {
                    return null;
                }
                return -dd.doubleValue();
            }
            if (dd == null) {
                return d;
            }
            return d - dd;
        }

        public void addAmount(Double amount) {
            this.amount = this.addDouble(this.amount, amount);
        }

        public void setQuantity(Double quantity) {
            this.quantity = quantity;
        }

        public void addQuantity(Double quantity) {
            this.quantity = this.addDouble(this.quantity, quantity);
        }

        public String getQuantity() {
            if (this.hidequantitygross) {
                return null;
            }
            Double result = this.getQuantityAsDouble();
            if (result == null) {
                return null;
            }
            return result.toString();
        }

        public Double getQuantityAsDouble() {
            if (this.hidequantitygross) {
                return null;
            }
            return this.getQuantityAsDoubleCalc();
        }

        public Double getQuantityAsDoubleCalc() {
            if (this.quantity == null) {
                return null;
            }
            if (this.classification != null && (this.classification.equals("income") || this.classification.equals("netincome") || this.classification.equals("totalincome") || this.classification.equals("equity") || this.classification.equals("distribution") || this.classification.equals("retainedearnings") || this.classification.equals("liability") || this.classification.equals("totalliability") || this.classification.equals("totalequity"))) {
                return -this.quantity.doubleValue();
            }
            return this.quantity;
        }

        public String getGross() {
            if (this.hidequantitygross) {
                return null;
            }
            Double result = this.getGrossAsDouble();
            if (result == null) {
                return null;
            }
            return IncomeAndExpenditureController.this.formatTwoDpDollars.format(result);
        }

        public Double getGrossAsDoubleCalc() {
            if (this.amount == null) {
                return null;
            }
            if (this.classification != null && (this.classification.equals("income") || this.classification.equals("netincome") || this.classification.equals("totalincome") || this.classification.equals("equity") || this.classification.equals("distribution") || this.classification.equals("retainedearnings") || this.classification.equals("liability") || this.classification.equals("totalliability") || this.classification.equals("totalequity"))) {
                return -this.amount.doubleValue();
            }
            return this.amount;
        }

        public Double getGrossAsDouble() {
            if (this.hidequantitygross) {
                return null;
            }
            return this.getGrossAsDoubleCalc();
        }

        public String getNet() {
            Double net = this.getNetAsDouble();
            if (net == null) {
                return null;
            }
            return IncomeAndExpenditureController.this.formatTwoDpDollars.format(net);
        }

        public Double getNetAsDouble() {
            Double total = this.amount;
            for (TransactionLine tl : this.lines.values()) {
                total = this.subtractDouble(total, tl.getProvisionAmountAsDouble());
            }
            if (total == null) {
                return null;
            }
            if (this.classification != null && (this.classification.equals("income") || this.classification.equals("netincome") || this.classification.equals("totalincome") || this.classification.equals("equity") || this.classification.equals("distribution") || this.classification.equals("retainedearnings") || this.classification.equals("liability") || this.classification.equals("totalliability") || this.classification.equals("totalequity"))) {
                total = -total.doubleValue();
            }
            return total;
        }

        public Double getProvisionAmountAsDouble() {
            Double total = null;
            for (TransactionLine tl : this.lines.values()) {
                total = this.addDouble(total, tl.getProvisionAmountAsDouble());
            }
            if (total == null) {
                return null;
            }
            if (this.classification != null && (this.classification.equals("income") || this.classification.equals("netincome") || this.classification.equals("totalincome") || this.classification.equals("equity") || this.classification.equals("distribution") || this.classification.equals("retainedearnings") || this.classification.equals("liability") || this.classification.equals("totalliability") || this.classification.equals("totalequity"))) {
                total = -total.doubleValue();
            }
            return total;
        }

        public String getProvisionAmount() {
            Double tax = this.getProvisionAmountAsDouble();
            if (tax == null) {
                return null;
            }
            return IncomeAndExpenditureController.this.formatTwoDpDollars.format(tax);
        }

        public String getBalanceSheetNet() {
            if (this.account == null) {
                if (this.subClassification != null && (this.subClassification.equals("cash") || this.subClassification.equals("accountsreceivable") || this.subClassification.equals("accountspayable") || this.subClassification.equals("totalasset") || this.subClassification.equals("totalliability") || this.subClassification.equals("netassets") || this.subClassification.equals("retainedearnings") || this.subClassification.equals("totalequity"))) {
                    return this.getNet();
                }
                return this.getProvisionAmount();
            }
            return this.getNet();
        }

        public Double getBalanceSheetNetAsDouble() {
            if (this.account == null) {
                if (this.subClassification != null && (this.subClassification.equals("cash") || this.subClassification.equals("accountsreceivable") || this.subClassification.equals("accountspayable") || this.subClassification.equals("totalasset") || this.subClassification.equals("totalliability") || this.subClassification.equals("netassets") || this.subClassification.equals("retainedearnings") || this.subClassification.equals("totalequity"))) {
                    return this.getNetAsDouble();
                }
                return this.getProvisionAmountAsDouble();
            }
            return this.getNetAsDouble();
        }

        public Double getBalanceSheetGrossAsDouble() {
            if (this.account == null) {
                if (this.subClassification != null && (this.subClassification.equals("cash") || this.subClassification.equals("accountsreceivable") || this.subClassification.equals("accountspayable") || this.subClassification.equals("totalasset") || this.subClassification.equals("totalliability") || this.subClassification.equals("netassets") || this.subClassification.equals("retainedearnings") || this.subClassification.equals("totalequity"))) {
                    return this.getGrossAsDouble();
                }
                return this.getProvisionAmountAsDouble();
            }
            return this.getGrossAsDoubleCalc();
        }

        public void setClassification(String classification) {
            this.classification = classification;
        }

        public String getClassification() {
            return this.classification;
        }

        public void setSubClassification(String subClassification) {
            this.subClassification = subClassification;
        }

        public String getSubClassification() {
            return this.subClassification;
        }

        public void addTransactionLine(String tt, TransactionLine tl) throws Exception {
            Provision addP = tl.getProvision();
            String pi = null;
            if (addP != null) {
                pi = addP.getProvisionIdentifier();
            }
            if (pi != null && !pi.isEmpty()) {
                TransactionLine ttl = this.lines.get(pi);
                if (ttl == null) {
                    ttl = new TransactionLine();
                    Provision tp = ttl.getOrAddProvision();
                    tp.setProvisionIdentifier(pi);
                    tp.setProvisionName(addP.getProvisionName());
                }
                ttl.setProvisionAmount(this.addDouble(ttl.getProvisionAmountAsDouble(), tl.getDebitProvisionAmount(tt)));
                this.lines.put(pi, ttl);
            }
        }

        public Collection<TransactionLine> getTransactionLines() {
            return this.lines.values();
        }

        public void addTransactionLines(String tt, Collection<TransactionLine> addLines) throws Exception {
            for (TransactionLine tl : addLines) {
                this.addTransactionLine(tt, tl);
            }
        }

        public String getProvisionAmounts() {
            StringBuilder sb = new StringBuilder();
            String prefix = "";
            for (TransactionLine tl : this.lines.values()) {
                Double pa;
                Provision p = tl.getProvision();
                if (p == null || (pa = tl.getProvisionAmountAsDouble()) == null) continue;
                sb.append(prefix);
                sb.append(p.getProvisionName());
                sb.append(": ");
                if (this.classification != null && (this.classification.equals("income") || this.classification.equals("netincome") || this.classification.equals("totalincome") || this.classification.equals("equity") || this.classification.equals("distribution") || this.classification.equals("retainedearnings") || this.classification.equals("liability") || this.classification.equals("totalliability") || this.classification.equals("totalequity"))) {
                    sb.append(IncomeAndExpenditureController.this.formatTwoDpDollars.format(-pa.doubleValue()));
                } else {
                    sb.append(IncomeAndExpenditureController.this.formatTwoDpDollars.format(pa));
                }
                prefix = ",\n";
            }
            return sb.toString();
        }
    }
}

