/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import au.com.glenix.ApplicationController;
import au.com.glenix.GlenixLabelAccountCombo;
import au.com.glenix.GlenixLabelCounterpartyCombo;
import au.com.glenix.GlenixLabelProvisionCombo;
import au.com.glenix.trn.Account;
import au.com.glenix.trn.ActivityStatement;
import au.com.glenix.trn.Batch;
import au.com.glenix.trn.GlenixTrnXBRL;
import au.com.glenix.trn.Provision;
import au.com.glenix.trn.Transaction;
import au.com.glenix.widget.GlenixBranchController;
import au.com.glenix.widget.GlenixLabelBlankNoYesCombo;
import au.com.glenix.widget.GlenixLabelDate;
import au.com.glenix.widget.GlenixLabelText;
import au.com.glenix.widget.GlenixPDFWrapper;
import au.com.glenix.widget.GlenixPDFWrapperNewPageCallback;
import java.math.RoundingMode;
import java.net.URL;
import java.text.DecimalFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.input.MouseEvent;
import javafx.util.Callback;

public class IncomeAndExpenditureAccountDetailController
extends GlenixBranchController
implements GlenixPDFWrapperNewPageCallback {
    protected Transaction summaryTransaction = null;
    @FXML
    protected Label error_message;
    @FXML
    protected Label page_heading;
    @FXML
    protected TableView<Transaction.TransactionTransactionLine> incomeAndExpenditure;
    @FXML
    protected TableColumn dateColumn;
    @FXML
    protected TableColumn counterpartyNameColumn;
    @FXML
    protected TableColumn detailCommentColumn;
    @FXML
    protected TableColumn provisionNameColumn;
    @FXML
    protected TableColumn provisionAmountColumn;
    @FXML
    protected TableColumn netAmountColumn;
    @FXML
    protected TableColumn quantityColumn;
    @FXML
    protected TableColumn amountColumn;
    @FXML
    protected GlenixLabelCounterpartyCombo counterpartyIdentifier;
    @FXML
    protected GlenixLabelAccountCombo accountIdentifier;
    @FXML
    protected GlenixLabelProvisionCombo provisionIdentifier;
    @FXML
    protected GlenixLabelBlankNoYesCombo calculateProvisionAmounts;
    @FXML
    protected GlenixLabelText filterText;
    @FXML
    protected GlenixLabelDate filterFromDate;
    @FXML
    protected GlenixLabelDate filterToDate;
    protected LocalDate lastMaxDate = null;
    @FXML
    protected Label total_label;
    protected DecimalFormat amountFormat;
    protected DecimalFormat quantityFormat;
    protected ApplicationController applicationController = null;
    protected ObservableList<Transaction.TransactionTransactionLine> transactionLineObservableList = null;
    protected FilteredList<Transaction.TransactionTransactionLine> filteredItems = null;
    protected String pattern = "dd MMM yyyy";
    protected DateTimeFormatter displayDateFormatter;
    protected Account account;
    protected int multiplier = -1;
    protected boolean suspendSelectionChange = false;
    protected HashSet<Transaction.TransactionTransactionLine> selectedRows = new HashSet();
    protected Double totalAmount = 0.0;
    protected Double totalProvisionAmount = 0.0;
    protected Double totalQuantity = 0.0;
    protected boolean selection_visible = true;
    protected Double totalSelectedAmount = 0.0;
    protected Double totalSelectedProvisionAmount = 0.0;
    protected int totalSelectedCount = 0;

    public IncomeAndExpenditureAccountDetailController(ApplicationController applicationController) {
        this.applicationController = applicationController;
        this.amountFormat = new DecimalFormat("$#,##0.00");
        this.amountFormat.setRoundingMode(RoundingMode.HALF_UP);
        this.quantityFormat = new DecimalFormat("#,##0.######");
        this.quantityFormat.setRoundingMode(RoundingMode.HALF_UP);
        this.displayDateFormatter = DateTimeFormatter.ofPattern(this.pattern);
    }

    public void setupIncomeAndExpenditureTable() {
        this.incomeAndExpenditure.setRowFactory(tv -> {
            TableRow<Transaction.TransactionTransactionLine> row = new TableRow<Transaction.TransactionTransactionLine>(){};
            row.setOnMouseClicked(arg_0 -> this.lambda$null$0((TableRow)row, arg_0));
            return row;
        });
    }

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        if (this.counterpartyNameColumn != null) {
            this.counterpartyNameColumn.setCellFactory((Callback)new Callback<TableColumn<Transaction.TransactionTransactionLine, String>, TableCell<Transaction.TransactionTransactionLine, String>>(){

                public TableCell call(TableColumn<Transaction.TransactionTransactionLine, String> param) {
                    TableCell<Transaction.TransactionTransactionLine, String> cell = new TableCell<Transaction.TransactionTransactionLine, String>(){

                        public void updateItem(String item, boolean empty) {
                            super.updateItem((Object)item, empty);
                            this.setGraphic(null);
                            if (empty) {
                                this.setText(null);
                            } else {
                                Transaction.TransactionTransactionLine ttl = (Transaction.TransactionTransactionLine)this.getTableView().getItems().get(this.getIndex());
                                String id = ttl.getCounterpartyIdentifier();
                                boolean isset = false;
                                if (id != null) {
                                    try {
                                        Transaction ct = IncomeAndExpenditureAccountDetailController.this.applicationController.getCounterpartyTransaction(id);
                                        if (ct != null) {
                                            this.setText(ct.getCounterpartyLegalName());
                                            isset = true;
                                        }
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                }
                                if (!isset) {
                                    this.setText(null);
                                }
                            }
                        }
                    };
                    return cell;
                }
            });
        }
        if (this.dateColumn != null) {
            this.dateColumn.setCellFactory((Callback)new Callback<TableColumn<Transaction.TransactionTransactionLine, LocalDate>, TableCell<Transaction.TransactionTransactionLine, LocalDate>>(){

                public TableCell call(TableColumn<Transaction.TransactionTransactionLine, LocalDate> param) {
                    TableCell<Transaction.TransactionTransactionLine, LocalDate> cell = new TableCell<Transaction.TransactionTransactionLine, LocalDate>(){

                        public void updateItem(LocalDate item, boolean empty) {
                            super.updateItem((Object)item, empty);
                            this.setGraphic(null);
                            if (empty) {
                                this.setText(null);
                            } else if (item == null) {
                                this.setText(null);
                            } else {
                                this.setText(IncomeAndExpenditureAccountDetailController.this.displayDateFormatter.format(item));
                            }
                        }
                    };
                    return cell;
                }
            });
        }
        if (this.amountColumn != null) {
            this.amountColumn.setCellFactory((Callback)new Callback<TableColumn<Transaction.TransactionTransactionLine, Double>, TableCell<Transaction.TransactionTransactionLine, Double>>(){

                public TableCell call(TableColumn<Transaction.TransactionTransactionLine, Double> param) {
                    TableCell<Transaction.TransactionTransactionLine, Double> cell = new TableCell<Transaction.TransactionTransactionLine, Double>(){

                        public void updateItem(Double item, boolean empty) {
                            super.updateItem((Object)item, empty);
                            this.setGraphic(null);
                            if (empty || item == null) {
                                this.setText(null);
                            } else {
                                this.setText(IncomeAndExpenditureAccountDetailController.this.amountFormat.format((double)IncomeAndExpenditureAccountDetailController.this.multiplier * item));
                            }
                        }
                    };
                    return cell;
                }
            });
        }
        if (this.netAmountColumn != null) {
            this.netAmountColumn.setCellFactory((Callback)new Callback<TableColumn<Transaction.TransactionTransactionLine, Double>, TableCell<Transaction.TransactionTransactionLine, Double>>(){

                public TableCell call(TableColumn<Transaction.TransactionTransactionLine, Double> param) {
                    TableCell<Transaction.TransactionTransactionLine, Double> cell = new TableCell<Transaction.TransactionTransactionLine, Double>(){

                        public void updateItem(Double item, boolean empty) {
                            super.updateItem((Object)item, empty);
                            this.setGraphic(null);
                            if (empty || item == null) {
                                this.setText(null);
                            } else {
                                this.setText(IncomeAndExpenditureAccountDetailController.this.amountFormat.format((double)IncomeAndExpenditureAccountDetailController.this.multiplier * item));
                            }
                        }
                    };
                    return cell;
                }
            });
        }
        if (this.provisionAmountColumn != null) {
            this.provisionAmountColumn.setCellFactory((Callback)new Callback<TableColumn<Transaction.TransactionTransactionLine, Double>, TableCell<Transaction.TransactionTransactionLine, Double>>(){

                public TableCell call(TableColumn<Transaction.TransactionTransactionLine, Double> param) {
                    TableCell<Transaction.TransactionTransactionLine, Double> cell = new TableCell<Transaction.TransactionTransactionLine, Double>(){

                        public void updateItem(Double item, boolean empty) {
                            super.updateItem((Object)item, empty);
                            this.setGraphic(null);
                            if (empty || item == null) {
                                this.setText(null);
                            } else {
                                this.setText(IncomeAndExpenditureAccountDetailController.this.amountFormat.format((double)IncomeAndExpenditureAccountDetailController.this.multiplier * item));
                            }
                        }
                    };
                    return cell;
                }
            });
        }
        if (this.quantityColumn != null) {
            this.quantityColumn.setCellFactory((Callback)new Callback<TableColumn<Transaction.TransactionTransactionLine, Double>, TableCell<Transaction.TransactionTransactionLine, Double>>(){

                public TableCell call(TableColumn<Transaction.TransactionTransactionLine, Double> param) {
                    TableCell<Transaction.TransactionTransactionLine, Double> cell = new TableCell<Transaction.TransactionTransactionLine, Double>(){

                        public void updateItem(Double item, boolean empty) {
                            super.updateItem((Object)item, empty);
                            this.setGraphic(null);
                            if (empty || item == null) {
                                this.setText(null);
                            } else {
                                this.setText("" + (double)IncomeAndExpenditureAccountDetailController.this.multiplier * item);
                            }
                        }
                    };
                    return cell;
                }
            });
        }
        if (this.provisionNameColumn != null) {
            this.provisionNameColumn.setCellFactory((Callback)new Callback<TableColumn<Transaction.TransactionTransactionLine, Provision>, TableCell<Transaction.TransactionTransactionLine, Provision>>(){

                public TableCell call(TableColumn<Transaction.TransactionTransactionLine, Provision> param) {
                    TableCell<Transaction.TransactionTransactionLine, String> cell = new TableCell<Transaction.TransactionTransactionLine, String>(){

                        public void updateItem(String item, boolean empty) {
                            super.updateItem((Object)item, empty);
                            this.setGraphic(null);
                            if (empty) {
                                this.setText(null);
                            } else {
                                Transaction.TransactionTransactionLine ttl = (Transaction.TransactionTransactionLine)this.getTableView().getItems().get(this.getIndex());
                                String id = ttl.getProvisionIdentifier();
                                boolean isset = false;
                                if (id != null) {
                                    try {
                                        Transaction ct = IncomeAndExpenditureAccountDetailController.this.applicationController.getProvisionTransaction(id);
                                        if (ct != null) {
                                            this.setText(ct.getProvisionName());
                                            isset = true;
                                        }
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                }
                                if (!isset) {
                                    this.setText("null");
                                }
                            }
                        }
                    };
                    return cell;
                }
            });
        }
        this.incomeAndExpenditure.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.filterText.addTextChangeListener((ChangeListener<String>)((ChangeListener)(obs, oldValue, newValue) -> this.updateFilter()));
        this.incomeAndExpenditure.getSelectionModel().getSelectedItems().addListener(new ListChangeListener(){

            public void onChanged(ListChangeListener.Change change) {
                IncomeAndExpenditureAccountDetailController.this.updateSelectedRows();
                IncomeAndExpenditureAccountDetailController.this.updateSelectedAmount();
            }
        });
        this.setupIncomeAndExpenditureTable();
    }

    @FXML
    protected void clearSelection() {
        this.suspendSelectionChange = true;
        this.selectedRows = new HashSet();
        this.incomeAndExpenditure.getSelectionModel().clearSelection();
        this.suspendSelectionChange = false;
    }

    protected void updateSelectedRows() {
        if (this.suspendSelectionChange) {
            return;
        }
        ObservableList selectedItems = this.incomeAndExpenditure.getSelectionModel().getSelectedItems();
        for (Transaction.TransactionTransactionLine ttl : this.filteredItems) {
            if (selectedItems.contains((Object)ttl)) {
                if (this.selectedRows.contains(ttl)) continue;
                this.selectedRows.add(ttl);
                continue;
            }
            if (!this.selectedRows.contains(ttl)) continue;
            this.selectedRows.remove(ttl);
        }
    }

    public void setFilterText(String filterTextValue) {
        if (this.filterText != null) {
            this.filterText.setGlenixElementValue(filterTextValue);
        }
    }

    public void setFromDate(LocalDate date) {
        if (this.filterFromDate != null) {
            this.filterFromDate.setLocalDate(date);
        }
    }

    public void setToDate(LocalDate date) {
        if (this.filterToDate != null) {
            this.filterToDate.setLocalDate(date);
        }
        this.lastMaxDate = date;
    }

    public void updateHeading() {
        if (this.account == null) {
            this.page_heading.setText("Income and expenditure transaction listing");
            this.setGlenixElementDescription("Income and expenditure transaction listing");
        } else {
            this.page_heading.setText(this.account.getAccountName() + " - transaction listing");
            this.setGlenixElementDescription(this.account.getAccountName() + " - transaction listing");
            String classification = this.account.getAccountClassificationReference();
            this.multiplier = 1;
            if (classification != null && (classification.equals("income") || classification.equals("netincome") || classification.equals("totalincome") || classification.equals("equity") || classification.equals("distribution") || classification.equals("liability") || classification.equals("totalliability") || classification.equals("totalequity"))) {
                this.multiplier = -1;
            }
        }
    }

    public void setTransactionLineList(String accountIdentifier, List<Transaction.TransactionTransactionLine> transactionLines) throws Exception {
        Transaction t;
        this.account = null;
        if (accountIdentifier != null && !accountIdentifier.isEmpty() && (t = this.applicationController.getAccountTransaction(accountIdentifier)) != null) {
            this.account = t.getAccount();
        }
        this.updateHeading();
        if (transactionLines == null) {
            this.incomeAndExpenditure.setItems(null);
            return;
        }
        this.transactionLineObservableList = FXCollections.observableList(transactionLines);
        this.setTransactionObservableList(this.transactionLineObservableList);
        this.updateFilter();
        this.incomeAndExpenditure.refresh();
    }

    protected void createFilteredItems() {
        this.filteredItems = new FilteredList(this.transactionLineObservableList, ttl -> true);
        this.incomeAndExpenditure.setItems(this.filteredItems);
        this.updateTotalAmount();
    }

    protected void setTransactionObservableList(ObservableList<Transaction.TransactionTransactionLine> transactionLineObservableList) {
        if (transactionLineObservableList != null) {
            transactionLineObservableList.sort((Comparator)new Comparator<Transaction.TransactionTransactionLine>(){

                @Override
                public int compare(Transaction.TransactionTransactionLine t1, Transaction.TransactionTransactionLine t2) {
                    return t1.compareTo(t2);
                }
            });
        }
        this.transactionLineObservableList = transactionLineObservableList;
        this.clearSelection();
        this.createFilteredItems();
    }

    @FXML
    protected void updateFilterReload() {
        this.updateFilter();
    }

    protected void updateFilter() {
        String filterTextValue = null;
        if (this.filterText != null) {
            filterTextValue = this.filterText.getText();
        }
        LocalDate fromDateValue = null;
        if (this.filterFromDate != null) {
            fromDateValue = this.filterFromDate.getLocalDate();
        }
        LocalDate toDateValue = null;
        if (this.filterToDate != null) {
            this.lastMaxDate = toDateValue = this.filterToDate.getLocalDate();
        }
        this.updateFilter(filterTextValue, fromDateValue, toDateValue);
    }

    protected void updateFilter(String newValue, LocalDate fromDate, LocalDate toDate) {
        if (this.filteredItems == null) {
            return;
        }
        this.filteredItems.setPredicate(ttl -> {
            String formattedDate;
            String pid;
            LocalDate localDate = ttl.getTransactionDateAsDate();
            if (fromDate != null || toDate != null) {
                if (localDate == null) {
                    return false;
                }
                if (fromDate != null && localDate.isBefore(fromDate)) {
                    return false;
                }
                if (toDate != null && localDate.isAfter(toDate)) {
                    return false;
                }
            }
            if (newValue == null || newValue.isEmpty()) {
                return true;
            }
            String transactionComment = ttl.getTransactionCommentLineComment();
            if (transactionComment != null && transactionComment.toLowerCase().contains(newValue.toLowerCase())) {
                return true;
            }
            String cid = ttl.getCounterpartyIdentifier();
            if (cid != null && !cid.isEmpty()) {
                try {
                    String cname;
                    Transaction ct = this.applicationController.getCounterpartyTransaction(cid);
                    if (ct != null && (cname = ct.getCounterpartyLegalName()) != null && !cname.isEmpty() && cname.toLowerCase().contains(newValue.toLowerCase())) {
                        return true;
                    }
                }
                catch (Exception ct) {
                    // empty catch block
                }
            }
            if ((pid = ttl.getProvisionIdentifier()) != null && !pid.isEmpty()) {
                try {
                    String pname;
                    Transaction pt = this.applicationController.getProvisionTransaction(pid);
                    if (pt != null && (pname = pt.getProvisionName()) != null && !pname.isEmpty() && pname.toLowerCase().contains(newValue.toLowerCase())) {
                        return true;
                    }
                }
                catch (Exception pt) {
                    // empty catch block
                }
            }
            return localDate != null && (formattedDate = this.displayDateFormatter.format(localDate)) != null && !formattedDate.isEmpty() && formattedDate.toLowerCase().contains(newValue.toLowerCase());
        });
        this.updateTotalAmount();
    }

    public void refreshTable() {
        this.incomeAndExpenditure.refresh();
    }

    @Override
    public GlenixPDFWrapper buildPDF(boolean includeBlanks) throws Exception {
        String filterTextValue;
        GlenixPDFWrapper gpw = new GlenixPDFWrapper();
        gpw.addPDPageLandscape();
        gpw.setColumns(10);
        gpw.setColumnLeftPosAndWidthMM(0, 20.0, 266.0);
        gpw.setColumnLeftPosAndWidthMM(1, 20.0, 266.0);
        gpw.setColumnLeftPosAndWidthMM(2, 20.0, 24.0);
        gpw.setColumnLeftPosAndWidthMM(3, 44.0, 40.0);
        gpw.setColumnLeftPosAndWidthMM(4, 84.0, 50.0);
        gpw.setColumnLeftPosAndWidthMM(5, 134.0, 26.0);
        gpw.setColumnLeftPosAndWidthMM(6, 160.0, 20.0);
        gpw.setColumnLeftPosAndWidthMM(7, 180.0, 26.0);
        gpw.setColumnLeftPosAndWidthMM(8, 206.0, 20.0);
        gpw.setColumnLeftPosAndWidthMM(9, 228.0, 58.0);
        gpw.setColumnFont(0, gpw.muliBoldFont);
        gpw.setColumnFont(1, gpw.muliLightFont);
        gpw.setColumnFont(2, gpw.muliLightFont);
        gpw.setColumnFont(3, gpw.muliLightFont);
        gpw.setColumnFont(4, gpw.muliLightFont);
        gpw.setColumnFont(5, gpw.muliLightFont);
        gpw.setColumnFont(6, gpw.muliLightFont);
        gpw.setColumnFont(7, gpw.muliLightFont);
        gpw.setColumnFont(8, gpw.muliLightFont);
        gpw.setColumnFont(9, gpw.muliLightFont);
        Double fontSize = this.convertFontSize(this.page_heading.getFont().getSize());
        gpw.prepareString(0, this.page_heading.getText(), true, fontSize);
        gpw.drawStrings(10.0);
        fontSize = this.convertFontSize(new Double(this.applicationController.getCurrentFontSize()));
        if (this.filterText != null && (filterTextValue = this.filterText.getGlenixElementValue()) != null && !filterTextValue.isEmpty()) {
            gpw.prepareString(1, "Filter: " + filterTextValue, true, fontSize);
            gpw.drawStrings(10.0);
        }
        this.drawPDFColumnHeadings(gpw);
        gpw.setAddPageCallback(this);
        Double totalAmount = 0.0;
        Double totalNetAmount = 0.0;
        Double totalProvisionAmount = 0.0;
        Double totalQuantity = 0.0;
        for (Transaction.TransactionTransactionLine ttl : this.filteredItems) {
            Double qty;
            String id;
            LocalDate d = ttl.getTransactionDateAsDate();
            if (d != null) {
                gpw.prepareString(2, this.displayDateFormatter.format(d), true, fontSize);
            }
            if ((id = ttl.getCounterpartyIdentifier()) != null && !id.isEmpty()) {
                try {
                    Transaction ct = this.applicationController.getCounterpartyTransaction(id);
                    if (ct != null) {
                        gpw.prepareString(3, ct.getCounterpartyLegalName(), true, fontSize);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            gpw.prepareString(4, ttl.getTransactionComment(), true, fontSize);
            Double amt = ttl.getNetAmount();
            if (amt != null) {
                totalNetAmount = totalNetAmount + amt;
                gpw.prepareString(5, this.amountFormat.format(amt), true, fontSize, "right");
            }
            if ((qty = ttl.getQuantity()) != null) {
                totalQuantity = totalQuantity + qty;
                gpw.prepareString(6, this.quantityFormat.format(qty), true, fontSize, "right");
            }
            if ((amt = ttl.getAmount()) != null) {
                totalAmount = totalAmount + amt;
                gpw.prepareString(7, this.amountFormat.format(amt), true, fontSize, "right");
            }
            if ((amt = ttl.getProvisionAmount()) != null) {
                totalAmount = totalAmount + amt;
                gpw.prepareString(8, this.amountFormat.format(amt), true, fontSize, "right");
            }
            if ((id = ttl.getProvisionIdentifier()) != null && !id.isEmpty()) {
                try {
                    Transaction pt = this.applicationController.getProvisionTransaction(id);
                    if (pt != null) {
                        gpw.prepareString(9, pt.getProvisionName(), true, fontSize);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            gpw.drawStrings(2.0);
        }
        gpw.setColumnFont(2, gpw.muliBoldFont);
        gpw.setColumnFont(5, gpw.muliBoldFont);
        gpw.setColumnFont(6, gpw.muliBoldFont);
        gpw.setColumnFont(7, gpw.muliBoldFont);
        gpw.setColumnFont(8, gpw.muliBoldFont);
        gpw.prepareString(2, "Totals", true, fontSize);
        gpw.prepareString(5, this.amountFormat.format(totalNetAmount), true, fontSize, "right");
        gpw.prepareString(6, this.quantityFormat.format(totalQuantity), true, fontSize, "right");
        gpw.prepareString(7, this.amountFormat.format(totalAmount), true, fontSize, "right");
        gpw.prepareString(8, this.amountFormat.format(totalProvisionAmount), true, fontSize, "right");
        gpw.drawStrings();
        gpw.addFooter();
        return gpw;
    }

    private void drawPDFColumnHeadings(GlenixPDFWrapper gpw) throws Exception {
        gpw.setColumnFont(2, gpw.muliBoldFont);
        gpw.setColumnFont(3, gpw.muliBoldFont);
        gpw.setColumnFont(4, gpw.muliBoldFont);
        gpw.setColumnFont(5, gpw.muliBoldFont);
        gpw.setColumnFont(6, gpw.muliBoldFont);
        gpw.setColumnFont(7, gpw.muliBoldFont);
        gpw.setColumnFont(8, gpw.muliBoldFont);
        gpw.setColumnFont(9, gpw.muliBoldFont);
        Double fontSize = this.convertFontSize(new Double(this.applicationController.getCurrentFontSize()));
        gpw.prepareString(2, this.dateColumn.getText(), true, fontSize);
        gpw.prepareString(3, this.counterpartyNameColumn.getText(), true, fontSize);
        gpw.prepareString(4, this.detailCommentColumn.getText(), true, fontSize);
        gpw.prepareString(5, this.netAmountColumn.getText(), true, fontSize, "right");
        gpw.prepareString(6, this.quantityColumn.getText(), true, fontSize, "right");
        gpw.prepareString(7, this.amountColumn.getText(), true, fontSize, "right");
        gpw.prepareString(8, this.provisionAmountColumn.getText(), true, fontSize, "right");
        gpw.prepareString(9, this.provisionNameColumn.getText(), true, fontSize);
        gpw.drawStrings(2.0);
        gpw.setColumnFont(2, gpw.muliLightFont);
        gpw.setColumnFont(3, gpw.muliLightFont);
        gpw.setColumnFont(4, gpw.muliLightFont);
        gpw.setColumnFont(5, gpw.muliLightFont);
        gpw.setColumnFont(6, gpw.muliLightFont);
        gpw.setColumnFont(7, gpw.muliLightFont);
        gpw.setColumnFont(8, gpw.muliLightFont);
        gpw.setColumnFont(9, gpw.muliLightFont);
    }

    @Override
    public void newPDFPageAdded(GlenixPDFWrapper gpw) throws Exception {
        this.drawPDFColumnHeadings(gpw);
    }

    private boolean lodgedActivityStatementIsChangedTransaction(Transaction.TransactionTransactionLine ttl, String provisionIdentifier, Double amount, Double provisionAmount) throws Exception {
        if (ttl == null) {
            return false;
        }
        String asn = ttl.getActivityStatementNumber();
        if (asn == null || asn.isEmpty()) {
            return false;
        }
        GlenixTrnXBRL asg = this.applicationController.loadActivityStatement(asn);
        if (asg == null) {
            return false;
        }
        ActivityStatement as = asg.getActivityStatement();
        if (as == null) {
            return false;
        }
        String status = as.getSBRDocumentStatus();
        if (status == null || !status.equals("lodge_complete") && !status.equals("lodge_in_progress")) {
            return false;
        }
        String ttlProvisionIdentifier = ttl.getProvisionIdentifier();
        if (ttlProvisionIdentifier == null || ttlProvisionIdentifier.isEmpty()) {
            if (provisionIdentifier == null || provisionIdentifier.isEmpty()) {
                return false;
            }
            Transaction pt = this.applicationController.getProvisionTransaction(provisionIdentifier);
            String basc = pt.getProvisionGrossBASClassification();
            return basc != null && !basc.isEmpty() && !basc.equals("NA");
        }
        if (provisionIdentifier == null || provisionIdentifier.isEmpty()) {
            Transaction pt = this.applicationController.getProvisionTransaction(provisionIdentifier);
            String basc = pt.getProvisionGrossBASClassification();
            return basc != null && !basc.isEmpty() && !basc.equals("NA");
        }
        Double ta = ttl.getAmount();
        if ((amount == null || amount.equals(0.0)) && ta != null && !ta.equals(0.0) || (ta == null || ta.equals(0.0)) && amount != null && !amount.equals(0.0) || ta != null && amount != null && !ta.equals(amount)) {
            return true;
        }
        Double tpa = ttl.getAmount();
        if ((provisionAmount == null || provisionAmount.equals(0.0)) && tpa != null && !tpa.equals(0.0) || (tpa == null || tpa.equals(0.0)) && provisionAmount != null && !provisionAmount.equals(0.0) || tpa != null && provisionAmount != null && !tpa.equals(provisionAmount)) {
            return true;
        }
        if (ttlProvisionIdentifier.equals(provisionIdentifier)) {
            return false;
        }
        Transaction ttlpt = this.applicationController.getProvisionTransaction(ttlProvisionIdentifier);
        String ttlbasc = ttlpt.getProvisionGrossBASClassification();
        Transaction pt = this.applicationController.getProvisionTransaction(provisionIdentifier);
        String ptbasc = pt.getProvisionGrossBASClassification();
        if (ttlbasc == null || ttlbasc.isEmpty() || ttlbasc.equals("NA")) {
            return ptbasc != null && !ptbasc.isEmpty() && !ptbasc.equals("NA");
        }
        return !ttlbasc.equals(ptbasc);
    }

    private boolean transactionBatchIsLocked(Transaction.TransactionTransactionLine ttl) {
        Batch b;
        Transaction t;
        String trBi = null;
        if (ttl != null && (t = ttl.getTransaction()) != null && (b = t.getBatch()) != null && (trBi = b.getBatchIdentifier()) != null && !trBi.isEmpty()) {
            String status;
            Transaction bt = null;
            try {
                bt = this.applicationController.getBatchTransaction(trBi);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (bt != null && (status = bt.getBatchStatus()) != null && !status.equals("created")) {
                return true;
            }
        }
        return false;
    }

    protected void validateTransactionTransaction(Transaction.TransactionTransactionLine ttl, String provisionIdentifier, Double amount, Double provisionAmount) throws Exception {
        if (ttl == null) {
            throw new Exception("Error, transaction line is null");
        }
        if (this.lodgedActivityStatementIsChangedTransaction(ttl, provisionIdentifier, amount, provisionAmount)) {
            throw new Exception("Error, the line is on a lodged Activity Statment.");
        }
        if (this.transactionBatchIsLocked(ttl)) {
            throw new Exception("Error, you cannot modify the transaction as it is on an authorised or lodged Batch.");
        }
        LocalDate ld = ttl.getTransactionDateAsDate();
        if (ld == null) {
            throw new Exception("Error, transaction date is blank or incorrect");
        }
        String counterpartyIdentifier = ttl.getCounterpartyIdentifier();
        if (counterpartyIdentifier == null || counterpartyIdentifier.isEmpty()) {
            throw new Exception("Error, the transaction does not have a counterparty, select a counterparty");
        }
        String accountIdentifier = ttl.getAccountIdentifier();
        if (accountIdentifier == null || accountIdentifier.isEmpty()) {
            throw new Exception("Error a transaction line is missing an account");
        }
    }

    @FXML
    protected void applySelectedOptions() {
        try {
            String calcProvisionAmounts = this.calculateProvisionAmounts.getGlenixElementValue();
            boolean calcblank = true;
            boolean calcall = false;
            if (calcProvisionAmounts != null && calcProvisionAmounts.equals("false")) {
                calcblank = false;
            } else if (calcProvisionAmounts != null && calcProvisionAmounts.equals("true")) {
                calcall = true;
            }
            ObservableList selectedtrns = this.incomeAndExpenditure.getSelectionModel().getSelectedItems();
            if (selectedtrns.size() == 0) {
                throw new Exception("You have not selected any transactions");
            }
            String ci = this.counterpartyIdentifier.getGlenixElementValue();
            String ai = this.accountIdentifier.getGlenixElementValue();
            String pi = this.provisionIdentifier.getGlenixElementValue();
            if (!(ci != null && !ci.isEmpty() || ai != null && !ai.isEmpty() || pi != null && !pi.isEmpty() || calcall)) {
                throw new Exception("Error you have not selected any values to apply");
            }
            Double pipercent = null;
            if (pi != null && !pi.isEmpty()) {
                Transaction pt = this.applicationController.getProvisionTransaction(pi);
                Provision p = pt.getProvision();
                pipercent = p.getProvisionPercentageAsDouble();
            }
            for (Transaction.TransactionTransactionLine ttl : selectedtrns) {
                String tlpi;
                String tlpa;
                Double amt = ttl.getAmount();
                Double provAmt = ttl.getProvisionAmount();
                if (pi != null && !pi.isEmpty() && !calcall && calcblank && ((tlpa = ttl.getProvisionAmountString()) == null || tlpa.isEmpty()) && pipercent != null) {
                    try {
                        provAmt = amt * pipercent / 100.0;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (calcall && (tlpi = ttl.getProvisionIdentifier()) != null && !tlpi.isEmpty()) {
                    try {
                        Double percent = pipercent;
                        if (!tlpi.equals(pi)) {
                            Transaction pt = this.applicationController.getProvisionTransaction(tlpi);
                            Provision p = pt.getProvision();
                            percent = p.getProvisionPercentageAsDouble();
                        }
                        if (amt != null && percent != null) {
                            provAmt = amt * percent / 100.0;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                this.validateTransactionTransaction(ttl, pi, amt, (double)Math.round(provAmt * 100.0) / 100.0);
            }
            HashMap<String, Transaction> changedTransactions = new HashMap<String, Transaction>();
            for (Transaction.TransactionTransactionLine ttl : selectedtrns) {
                String tlpi;
                if (ci != null && !ci.isEmpty()) {
                    ttl.setCounterpartyIdentifier(ci);
                    changedTransactions.put(ttl.getTransaction().getTransactionNumber(), ttl.getTransaction());
                }
                if (ai != null && !ai.isEmpty()) {
                    ttl.setAccountIdentifier(ai);
                    changedTransactions.put(ttl.getTransaction().getTransactionNumber(), ttl.getTransaction());
                }
                if (pi != null && !pi.isEmpty()) {
                    String tlpa;
                    ttl.setProvisionIdentifier(pi);
                    changedTransactions.put(ttl.getTransaction().getTransactionNumber(), ttl.getTransaction());
                    if (!calcall && calcblank && ((tlpa = ttl.getProvisionAmountString()) == null || tlpa.isEmpty()) && pipercent != null) {
                        try {
                            Double amount = ttl.getAmount();
                            ttl.setProvisionAmount(amount * pipercent / 100.0);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                if (!calcall || (tlpi = ttl.getProvisionIdentifier()) == null || tlpi.isEmpty()) continue;
                try {
                    Double amount;
                    Double percent = pipercent;
                    if (!tlpi.equals(pi)) {
                        Transaction pt = this.applicationController.getProvisionTransaction(tlpi);
                        Provision p = pt.getProvision();
                        percent = p.getProvisionPercentageAsDouble();
                    }
                    if ((amount = ttl.getAmount()) == null || percent == null) continue;
                    ttl.setProvisionAmount(amount * percent / 100.0);
                    changedTransactions.put(ttl.getTransaction().getTransactionNumber(), ttl.getTransaction());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.applicationController.saveTransactions(changedTransactions.values());
            this.updateFilterReload();
            this.refreshTable();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.applicationController.setStatusBarMessage(e.getMessage());
        }
    }

    public void setCounterpartyTransactionList(ObservableList<Transaction> counterpartyObservableList) {
        this.counterpartyIdentifier.setItems(counterpartyObservableList);
    }

    public void setProvisionList(ObservableList<Transaction> provisionObservableList) {
        this.provisionIdentifier.setItems(provisionObservableList);
    }

    public void setAccountList(ObservableList<Transaction> accountObservableList) {
        this.accountIdentifier.setItems(accountObservableList);
    }

    protected Double addDouble(Double d1, Double d2) {
        if (d1 == null) {
            return d2;
        }
        if (d2 == null) {
            return d1;
        }
        return d1 + d2;
    }

    protected void updateTotalLabel() {
        if (this.total_label == null) {
            return;
        }
        if (this.totalSelectedCount == 0) {
            this.total_label.setText("Total displayed net amount: " + this.amountFormat.format(this.totalAmount - this.totalProvisionAmount) + ", total gross: " + this.amountFormat.format(this.totalAmount) + ", total tax: " + this.amountFormat.format(this.totalProvisionAmount) + ", total quantity " + this.quantityFormat.format(this.totalQuantity) + ", No transactions/transaction lines selected");
            return;
        }
        if (this.selection_visible) {
            this.total_label.setText("Total displayed net amount: " + this.amountFormat.format(this.totalAmount - this.totalProvisionAmount) + ", total gross: " + this.amountFormat.format(this.totalAmount) + ", total tax: " + this.amountFormat.format(this.totalProvisionAmount) + ", total quantity " + this.quantityFormat.format(this.totalQuantity) + ", Total selected net amount: " + this.amountFormat.format(this.totalSelectedAmount));
        } else {
            this.total_label.setText("Total displayed net amount: " + this.amountFormat.format(this.totalAmount - this.totalProvisionAmount) + ", total gross: " + this.amountFormat.format(this.totalAmount) + ", total tax: " + this.amountFormat.format(this.totalProvisionAmount) + ", total quantity " + this.quantityFormat.format(this.totalQuantity) + ", Total selected net amount: " + this.amountFormat.format(this.totalSelectedAmount) + " (some selections are filtered out)");
        }
    }

    protected void updateTotalAmount() {
        Double totalAmount = 0.0;
        Double totalProvisionAmount = 0.0;
        Double totalQuantity = 0.0;
        for (Transaction.TransactionTransactionLine ttl : this.filteredItems) {
            totalAmount = totalAmount + ttl.getDebitAmount();
            totalProvisionAmount = totalProvisionAmount + ttl.getDebitProvisionAmount();
            totalQuantity = totalQuantity + ttl.getDebitQuantity();
        }
        totalAmount = (double)this.multiplier * totalAmount;
        totalProvisionAmount = (double)this.multiplier * totalProvisionAmount;
        totalQuantity = (double)this.multiplier * totalQuantity;
        this.totalAmount = totalAmount;
        this.totalProvisionAmount = totalProvisionAmount;
        this.totalQuantity = totalQuantity;
        this.updateTotalLabel();
    }

    protected void updateSelectedAmount() {
        Double totalAmount = 0.0;
        Double totalProvisionAmount = 0.0;
        boolean hasselected = false;
        boolean selection_visible = true;
        HashMap<String, Double> workings = new HashMap<String, Double>();
        HashMap<String, Double> pworkings = new HashMap<String, Double>();
        for (Transaction.TransactionTransactionLine ttl : this.selectedRows) {
            workings.put(ttl.getReconciliationNumber(), ttl.getReconciliationAmount());
            pworkings.put(ttl.getProvisionReconciliationNumber(), ttl.getProvisionReconciliationAmount());
            hasselected = true;
            if (this.filteredItems.contains((Object)ttl)) continue;
            selection_visible = false;
        }
        for (Double d : workings.values()) {
            totalAmount = this.addDouble(totalAmount, d);
        }
        for (Double d : pworkings.values()) {
            totalProvisionAmount = this.addDouble(totalProvisionAmount, d);
        }
        if (hasselected) {
            this.totalSelectedAmount = (double)this.multiplier * totalAmount;
            this.totalSelectedProvisionAmount = (double)this.multiplier * totalProvisionAmount;
            this.totalSelectedCount = this.selectedRows.size();
            this.selection_visible = selection_visible;
            this.updateTotalLabel();
        } else {
            this.totalSelectedAmount = 0.0;
            this.totalSelectedProvisionAmount = 0.0;
            this.totalSelectedCount = 0;
            this.selection_visible = selection_visible;
            this.updateTotalLabel();
        }
    }

    private /* synthetic */ void lambda$null$0(TableRow row, MouseEvent event) {
        block14: {
            String tt;
            Transaction t;
            Transaction.TransactionTransactionLine reportItem;
            if (event.getClickCount() == 2 && !row.isEmpty() && (reportItem = (Transaction.TransactionTransactionLine)row.getItem()) != null && (t = reportItem.getTransaction()) != null && (tt = t.getTransactionType()) != null) {
                String batchIdentifier;
                if (tt.equals("sales_invoice") || tt.equals("sales_credit") || tt.equals("cash_received") || tt.equals("sales_quote")) {
                    try {
                        String batchIdentifier2 = t.getBatchIdentifier();
                        if (batchIdentifier2 != null && !batchIdentifier2.isEmpty()) {
                            this.applicationController.gotoBatchTransactionEdit(t, batchIdentifier2);
                            break block14;
                        }
                        this.applicationController.gotoSalesTransactionsE(t);
                    }
                    catch (Exception e) {
                        this.error_message.setText(e.getMessage());
                        this.applicationController.setStatusBarMessage(e.getMessage());
                        e.printStackTrace();
                    }
                } else if (tt.equals("purchase_invoice") || tt.equals("purchase_credit") || tt.equals("purchase_quote") || tt.equals("cash_payment")) {
                    try {
                        String batchIdentifier3 = t.getBatchIdentifier();
                        if (batchIdentifier3 != null && !batchIdentifier3.isEmpty()) {
                            this.applicationController.gotoBatchTransactionEdit(t, batchIdentifier3);
                            break block14;
                        }
                        this.applicationController.gotoOtherPurchasesTransactionsE(t);
                    }
                    catch (Exception e) {
                        this.error_message.setText(e.getMessage());
                        this.applicationController.setStatusBarMessage(e.getMessage());
                        e.printStackTrace();
                    }
                } else if (tt.equals("pay_slip") && (batchIdentifier = t.getBatchIdentifier()) != null && !batchIdentifier.isEmpty()) {
                    try {
                        this.applicationController.gotoBatchPaySlipEdit(t, batchIdentifier);
                    }
                    catch (Exception e) {
                        this.error_message.setText(e.getMessage());
                        this.applicationController.setStatusBarMessage(e.getMessage());
                        e.printStackTrace();
                    }
                }
            }
        }
    }
}

