/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import au.com.glenix.ApplicationController;
import au.com.glenix.GlenixLabelAccountCombo;
import au.com.glenix.GlenixLabelCounterpartyCombo;
import au.com.glenix.GlenixLabelProvisionCombo;
import au.com.glenix.GlenixLabelTransactionTypeCombo;
import au.com.glenix.TransactionEditShortFormVBox;
import au.com.glenix.TransactionTransactionLineTableController;
import au.com.glenix.trn.Account;
import au.com.glenix.trn.ActivityStatement;
import au.com.glenix.trn.Batch;
import au.com.glenix.trn.Business;
import au.com.glenix.trn.Counterparty;
import au.com.glenix.trn.GlenixTrnXBRL;
import au.com.glenix.trn.ImportData;
import au.com.glenix.trn.Provision;
import au.com.glenix.trn.Transaction;
import au.com.glenix.trn.TransactionLine;
import au.com.glenix.widget.GlenixLabelBlankNoYesCombo;
import au.com.glenix.widget.GlenixLabelDate;
import au.com.glenix.widget.GlenixLabelText;
import au.com.glenix.widget.GlenixPDFWrapper;
import java.net.URL;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.fxml.FXML;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.util.Callback;
import javafx.util.Pair;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;

public class ImportDataListController
extends TransactionTransactionLineTableController {
    @FXML
    protected GlenixLabelText filterText;
    @FXML
    protected GlenixLabelDate filterFromDate;
    @FXML
    protected GlenixLabelDate filterToDate;
    @FXML
    protected GlenixLabelCounterpartyCombo counterpartyIdentifier;
    @FXML
    protected GlenixLabelAccountCombo accountIdentifier;
    @FXML
    protected GlenixLabelProvisionCombo provisionIdentifier;
    @FXML
    protected GlenixLabelBlankNoYesCombo calculateProvisionAmounts;
    @FXML
    protected GlenixLabelTransactionTypeCombo transactionTypeCombo;
    @FXML
    protected GlenixLabelBlankNoYesCombo reverseAmountCombo;
    @FXML
    protected TableColumn transactionCommentColumn;
    @FXML
    protected TableColumn transactionTypeColumn;
    @FXML
    protected TableColumn lineCommentColumn;
    @FXML
    protected TableColumn quantityColumn;
    @FXML
    protected TableColumn accountColumn;
    @FXML
    protected TableColumn provisionColumn;
    private GlenixTrnXBRL importDataGlenixTrnXBRL = null;
    protected ObservableList<Transaction.TransactionTransactionLine> importDataTransactionLineObservableList = null;
    protected FilteredList<Transaction.TransactionTransactionLine> filteredItems = null;
    protected String pattern = "dd MMM yyyy";
    protected DateTimeFormatter displayDateFormatter = DateTimeFormatter.ofPattern(this.pattern);
    private HashMap<String, Double> importDataIdentifierAmounts;
    @FXML
    protected TransactionEditShortFormVBox transactionEditFormVBox;
    protected Transaction transaction = null;
    private HashMap<String, Counterparty> identifierCounterparty;
    private HashMap<String, Counterparty> legalNameCounterparty;
    private HashMap<String, Counterparty> tradingNameCounterparty;
    private HashMap<String, Counterparty> paymentReferenceCounterparty;
    private HashMap<String, Provision> identifierProvision;
    private HashMap<String, Provision> nameProvision;
    private HashMap<String, Account> identifierAccount;
    private HashMap<String, Account> nameAccount;

    public ImportDataListController(ApplicationController xbrlFileController) {
        super(xbrlFileController);
    }

    @Override
    protected void setupActionColumn() {
        this.transactionTransactionLineTable.setRowFactory(tv -> {
            TableRow row = new TableRow();
            row.setOnMouseClicked(event -> {
                block9: {
                    if (event.getClickCount() == 2) {
                        if (!row.isEmpty()) {
                            Transaction.TransactionTransactionLine ttl = (Transaction.TransactionTransactionLine)row.getItem();
                            if (ttl != null) {
                                try {
                                    String batchIdentifier = ttl.getBatchIdentifier();
                                    if (batchIdentifier != null && !batchIdentifier.isEmpty()) {
                                        this.error_message.setText("Error, cannot edit batch transaction on import data page.");
                                        this.xbrlFileController.setStatusBarMessage("Error, cannot edit batch transaction on import data page.");
                                        break block9;
                                    }
                                    ImportData importData = ttl.getImportData();
                                    if (importData != null) {
                                        this.error_message.setText(null);
                                        this.xbrlFileController.setStatusBarMessage(null);
                                        this.xbrlFileController.gotoImportDataTransactionsE(null, (List)this.importDataTransactionLineObservableList, ttl.getTransaction());
                                        break block9;
                                    }
                                    this.error_message.setText(null);
                                    this.xbrlFileController.setStatusBarMessage(null);
                                    this.loadTransaction(ttl.getTransaction());
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                    this.error_message.setText("Error, could not go to transaction edit page.");
                                    this.xbrlFileController.setStatusBarMessage("Error, could not go to transaction edit page.");
                                }
                            } else {
                                this.error_message.setText("Error, could not get transaction.");
                                this.xbrlFileController.setStatusBarMessage("Error, could not get transaction.");
                            }
                        } else {
                            this.clearTransaction();
                        }
                    }
                }
            });
            return row;
        });
        this.transactionTransactionLineTable.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<Transaction.TransactionTransactionLine>(){

            public void changed(ObservableValue<? extends Transaction.TransactionTransactionLine> observable, Transaction.TransactionTransactionLine oldValue, final Transaction.TransactionTransactionLine newValue) {
                if (newValue != null && newValue.getTransaction() != null && newValue.getTransaction() != ImportDataListController.this.transaction) {
                    ImportDataListController.this.error_message.setText("Loading...");
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Thread.sleep(100L);
                                Platform.runLater(() -> ImportDataListController.this.loadTransaction(newValue.getTransaction()));
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }).start();
                }
            }
        });
    }

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setNamespaceAware(true);
            this.dBuilder = dbFactory.newDocumentBuilder();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
        this.displayDateFormatter = DateTimeFormatter.ofPattern(this.pattern);
        if (this.transactionEditFormVBox != null) {
            this.lastLocalDate = LocalDate.now();
            this.transactionEditFormVBox.setTransactionLocalDate(this.lastLocalDate);
        }
        this.setupActionColumn();
        if (this.transactionCounterpartyColumn != null) {
            this.transactionCounterpartyColumn.setCellFactory((Callback)new Callback<TableColumn<Transaction.TransactionTransactionLine, String>, TableCell<Transaction.TransactionTransactionLine, String>>(){

                public TableCell call(TableColumn<Transaction.TransactionTransactionLine, String> param) {
                    TableCell<Transaction.TransactionTransactionLine, String> cell = new TableCell<Transaction.TransactionTransactionLine, String>(){

                        public void updateItem(String item, boolean empty) {
                            super.updateItem((Object)item, empty);
                            this.setGraphic(null);
                            if (empty) {
                                this.setText(null);
                            } else {
                                this.setText(ImportDataListController.this.getCounterpartyColumnValue((Transaction.TransactionTransactionLine)this.getTableView().getItems().get(this.getIndex())));
                            }
                        }
                    };
                    return cell;
                }
            });
        }
        if (this.transactionCommentColumn != null) {
            this.transactionCommentColumn.setCellFactory((Callback)new Callback<TableColumn<Transaction.TransactionTransactionLine, String>, TableCell<Transaction.TransactionTransactionLine, String>>(){

                public TableCell call(TableColumn<Transaction.TransactionTransactionLine, String> param) {
                    TableCell<Transaction.TransactionTransactionLine, String> cell = new TableCell<Transaction.TransactionTransactionLine, String>(){

                        public void updateItem(String item, boolean empty) {
                            super.updateItem((Object)item, empty);
                            this.setGraphic(null);
                            if (empty) {
                                this.setText(null);
                            } else {
                                this.setText(ImportDataListController.this.getCommentColumnValue((Transaction.TransactionTransactionLine)this.getTableView().getItems().get(this.getIndex())));
                            }
                        }
                    };
                    return cell;
                }
            });
        }
        if (this.transactionDateColumn != null) {
            this.transactionDateColumn.setCellFactory((Callback)new Callback<TableColumn<Transaction.TransactionTransactionLine, LocalDate>, TableCell<Transaction.TransactionTransactionLine, LocalDate>>(){

                public TableCell call(TableColumn<Transaction.TransactionTransactionLine, LocalDate> param) {
                    TableCell<Transaction.TransactionTransactionLine, LocalDate> cell = new TableCell<Transaction.TransactionTransactionLine, LocalDate>(){

                        public void updateItem(LocalDate item, boolean empty) {
                            super.updateItem((Object)item, empty);
                            this.setGraphic(null);
                            if (empty) {
                                this.setText(null);
                            } else {
                                this.setText(ImportDataListController.this.getTransactionDateColumnValue((Transaction.TransactionTransactionLine)this.getTableView().getItems().get(this.getIndex())));
                            }
                        }
                    };
                    return cell;
                }
            });
        }
        if (this.amountColumn != null) {
            this.amountColumn.setCellFactory((Callback)new Callback<TableColumn<Transaction.TransactionTransactionLine, Double>, TableCell<Transaction.TransactionTransactionLine, Double>>(){

                public TableCell call(TableColumn<Transaction.TransactionTransactionLine, Double> param) {
                    TableCell<Transaction.TransactionTransactionLine, Double> cell = new TableCell<Transaction.TransactionTransactionLine, Double>(){

                        public void updateItem(Double item, boolean empty) {
                            super.updateItem((Object)item, empty);
                            this.setGraphic(null);
                            if (empty) {
                                this.setText(null);
                            } else {
                                this.setText(ImportDataListController.this.getAmountColumnValue((Transaction.TransactionTransactionLine)this.getTableView().getItems().get(this.getIndex())));
                            }
                        }
                    };
                    return cell;
                }
            });
        }
        if (this.taxAmountColumn != null) {
            this.taxAmountColumn.setCellFactory((Callback)new Callback<TableColumn<Transaction.TransactionTransactionLine, Double>, TableCell<Transaction.TransactionTransactionLine, Double>>(){

                public TableCell call(TableColumn<Transaction.TransactionTransactionLine, Double> param) {
                    TableCell<Transaction.TransactionTransactionLine, Double> cell = new TableCell<Transaction.TransactionTransactionLine, Double>(){

                        public void updateItem(Double item, boolean empty) {
                            super.updateItem((Object)item, empty);
                            this.setGraphic(null);
                            if (empty) {
                                this.setText(null);
                            } else {
                                this.setText(ImportDataListController.this.getProvisionAmountColumnValue((Transaction.TransactionTransactionLine)this.getTableView().getItems().get(this.getIndex())));
                            }
                        }
                    };
                    return cell;
                }
            });
        }
        if (this.quantityColumn != null) {
            this.quantityColumn.setCellFactory((Callback)new Callback<TableColumn<Transaction.TransactionTransactionLine, Double>, TableCell<Transaction.TransactionTransactionLine, Double>>(){

                public TableCell call(TableColumn<Transaction.TransactionTransactionLine, Double> param) {
                    TableCell<Transaction.TransactionTransactionLine, Double> cell = new TableCell<Transaction.TransactionTransactionLine, Double>(){

                        public void updateItem(Double item, boolean empty) {
                            super.updateItem((Object)item, empty);
                            this.setGraphic(null);
                            if (empty) {
                                this.setText(null);
                            } else {
                                this.setText(ImportDataListController.this.getQuantityColumnValue((Transaction.TransactionTransactionLine)this.getTableView().getItems().get(this.getIndex())));
                            }
                        }
                    };
                    return cell;
                }
            });
        }
        if (this.accountColumn != null) {
            this.accountColumn.setCellFactory((Callback)new Callback<TableColumn<Transaction.TransactionTransactionLine, String>, TableCell<Transaction.TransactionTransactionLine, String>>(){

                public TableCell call(TableColumn<Transaction.TransactionTransactionLine, String> param) {
                    TableCell<Transaction.TransactionTransactionLine, String> cell = new TableCell<Transaction.TransactionTransactionLine, String>(){

                        public void updateItem(String item, boolean empty) {
                            super.updateItem((Object)item, empty);
                            this.setGraphic(null);
                            if (empty) {
                                this.setText(null);
                            } else {
                                this.setText(ImportDataListController.this.getAccountColumnValue((Transaction.TransactionTransactionLine)this.getTableView().getItems().get(this.getIndex())));
                            }
                        }
                    };
                    return cell;
                }
            });
        }
        if (this.provisionColumn != null) {
            this.provisionColumn.setCellFactory((Callback)new Callback<TableColumn<Transaction.TransactionTransactionLine, String>, TableCell<Transaction.TransactionTransactionLine, String>>(){

                public TableCell call(TableColumn<Transaction.TransactionTransactionLine, String> param) {
                    TableCell<Transaction.TransactionTransactionLine, String> cell = new TableCell<Transaction.TransactionTransactionLine, String>(){

                        public void updateItem(String item, boolean empty) {
                            super.updateItem((Object)item, empty);
                            this.setGraphic(null);
                            if (empty) {
                                this.setText(null);
                            } else {
                                this.setText(ImportDataListController.this.getProvisionColumnValue((Transaction.TransactionTransactionLine)this.getTableView().getItems().get(this.getIndex())));
                            }
                        }
                    };
                    return cell;
                }
            });
        }
        this.transactionTransactionLineTable.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        ArrayList<Pair<String, String>> pairs = new ArrayList<Pair<String, String>>();
        pairs.add(new Pair((Object)"", (Object)""));
        pairs.add(new Pair((Object)"sales_invoice", (Object)"Sales invoice"));
        pairs.add(new Pair((Object)"sales_credit", (Object)"Sales credit"));
        pairs.add(new Pair((Object)"cash_received", (Object)"Cash received"));
        pairs.add(new Pair((Object)"purchase_invoice", (Object)"Purchase invoice"));
        pairs.add(new Pair((Object)"purchase_credit", (Object)"Purchase credit"));
        pairs.add(new Pair((Object)"cash_payment", (Object)"Cash payment"));
        this.transactionEditFormVBox.setTransactionTypeVisibleOptions(pairs, true, null);
    }

    public String getCounterpartyColumnValue(Transaction.TransactionTransactionLine ttl) {
        String importCounterparty;
        Transaction t = ttl.getTransaction();
        String counterpartyIdentifier = t.getCounterpartyIdentifier();
        if (counterpartyIdentifier != null && !counterpartyIdentifier.isEmpty()) {
            try {
                Transaction ct = this.xbrlFileController.getCounterpartyTransaction(counterpartyIdentifier);
                if (ct != null) {
                    return ct.getCounterpartyLegalName();
                }
                return counterpartyIdentifier;
            }
            catch (Exception ct) {
                // empty catch block
            }
        }
        if ((importCounterparty = t.getFirstImportDataCounterparty()) != null && !importCounterparty.isEmpty()) {
            return "(I) " + importCounterparty;
        }
        return null;
    }

    public String getCommentColumnValue(Transaction.TransactionTransactionLine ttl) {
        Transaction t = ttl.getTransaction();
        String comment = t.getTransactionComment();
        if (comment != null && !comment.isEmpty()) {
            return comment;
        }
        comment = t.getFirstImportDataComment();
        if (comment != null && !comment.isEmpty()) {
            return "(I) " + comment;
        }
        return null;
    }

    public String getTransactionDateColumnValue(Transaction.TransactionTransactionLine ttl) {
        Transaction t = ttl.getTransaction();
        LocalDate ld = t.getTransactionDateAsDate();
        if (ld != null) {
            return this.displayDateFormatter.format(ld);
        }
        ld = t.getFirstImportDataDateAsDate();
        if (ld != null) {
            return "(I) " + this.displayDateFormatter.format(ld);
        }
        return null;
    }

    public String getAmountColumnValue(Transaction.TransactionTransactionLine ttl) {
        Double amount = ttl.getAmount();
        if (amount != null) {
            return this.amountFormat.format(amount);
        }
        amount = ttl.getImportDataAmount();
        if (amount != null) {
            return "(I) " + this.amountFormat.format(amount);
        }
        return null;
    }

    public String getProvisionAmountColumnValue(Transaction.TransactionTransactionLine ttl) {
        Double amount = ttl.getProvisionAmount();
        if (amount != null) {
            return this.amountFormat.format(amount);
        }
        amount = ttl.getImportDataProvisionAmount();
        if (amount != null) {
            return "(I) " + this.amountFormat.format(amount);
        }
        return null;
    }

    public String getQuantityColumnValue(Transaction.TransactionTransactionLine ttl) {
        Double quantity = ttl.getQuantity();
        if (quantity != null) {
            return this.quantityFormat.format(quantity);
        }
        quantity = ttl.getImportDataQuantity();
        if (quantity != null) {
            return "(I) " + this.quantityFormat.format(quantity);
        }
        return null;
    }

    public String getAccountColumnValue(Transaction.TransactionTransactionLine ttl) {
        String accountIdentifier = null;
        accountIdentifier = ttl.getAccountIdentifier();
        if (accountIdentifier != null && !accountIdentifier.isEmpty()) {
            try {
                Transaction ct = this.xbrlFileController.getAccountTransaction(accountIdentifier);
                if (ct != null) {
                    return ct.getAccountName();
                }
                return accountIdentifier;
            }
            catch (Exception ct) {
                return accountIdentifier;
            }
        }
        String accountStr = ttl.getImportDataAccount();
        if (accountStr != null && !accountStr.isEmpty()) {
            return "(I) " + accountStr;
        }
        return null;
    }

    public String getProvisionColumnValue(Transaction.TransactionTransactionLine ttl) {
        String provisionIdentifier = null;
        provisionIdentifier = ttl.getProvisionIdentifier();
        if (provisionIdentifier != null && !provisionIdentifier.isEmpty()) {
            try {
                Transaction ct = this.xbrlFileController.getProvisionTransaction(provisionIdentifier);
                if (ct != null) {
                    return ct.getProvisionName();
                }
                return provisionIdentifier;
            }
            catch (Exception ct) {
                return provisionIdentifier;
            }
        }
        String provisionStr = ttl.getImportDataProvision();
        if (provisionStr != null && !provisionStr.isEmpty()) {
            return "(I) " + provisionStr;
        }
        return null;
    }

    private void saveImportDataTransactionFromVBox() throws Exception {
        Document resultDoc = this.dBuilder.newDocument();
        this.transactionEditFormVBox.buildGlenixXBRLTransactionPart(resultDoc, null);
        this.transaction.loadDocumentElementOverwrite(resultDoc, resultDoc.getDocumentElement());
        this.setImportDataTransactionDefaults();
        this.xbrlFileController.saveImportData(this.transaction);
    }

    public void setImportDataTransactionDefaults() throws Exception {
        if (this.transaction == null) {
            return;
        }
        String tt = this.transaction.getTransactionType();
        if (tt == null) {
            this.transaction.setTransactionType("cash_payment");
        }
    }

    protected void validateImportDataTransaction() throws Exception {
        if (this.transactionEditFormVBox == null) {
            throw new Exception("Error, no transaction edit form found");
        }
        LocalDate ld = this.transactionEditFormVBox.getTransactionLocalDate();
        if (ld == null) {
            throw new Exception("Error, a transaction date is blank or incorrect");
        }
        String counterpartyIdentifier = this.transactionEditFormVBox.getCounterpartyIdentifier();
        if (counterpartyIdentifier == null || counterpartyIdentifier.isEmpty()) {
            throw new Exception("Error, the transaction does not have a counterparty, select a counterparty");
        }
        if (!this.transactionEditFormVBox.allLinesHaveAccount()) {
            throw new Exception("Error, a transaction line is missing an account");
        }
    }

    @FXML
    private void saveImportDataTransactionE() throws Exception {
        this.validateImportDataTransaction();
        if (this.transaction == null) {
            throw new Exception("Error, transaction is null");
        }
        this.transaction.setTransactionStatus("posted");
        this.saveImportDataTransactionFromVBox();
        this.error_message.setText("Saved");
        this.lastLocalDate = this.transactionEditFormVBox.getTransactionLocalDate();
    }

    @FXML
    private void saveImportDataTransaction() {
        try {
            this.saveImportDataTransactionE();
            this.updateFilter();
            this.refreshTable();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    private void addImportData() {
        try {
            this.xbrlFileController.gotoImportDataEdit((List<Transaction.TransactionTransactionLine>)this.importDataTransactionLineObservableList, null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText("Error, could not load import data edit page.");
        }
    }

    @FXML
    private void gotoImportDataImportFile() {
        try {
            this.xbrlFileController.gotoImportDataImportFile();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText("Error, could not load import file page.");
        }
    }

    @Override
    public void setBusinessTransactions(Business business) throws Exception {
    }

    public void setImportDataTransactions(GlenixTrnXBRL glenixTrnXBRL) throws Exception {
        this.importDataGlenixTrnXBRL = glenixTrnXBRL;
        if (this.importDataGlenixTrnXBRL != null) {
            Document doc = this.importDataGlenixTrnXBRL.buildDocument();
            if (doc != null) {
                this.loadGlenixXBRL(doc, doc.getDocumentElement());
            }
            this.setImportDataObservableList();
        }
        this.page_heading.setText("Import data - " + this.xbrlFileController.getBusinessLegalName());
    }

    @Override
    protected void updateFilter() {
        String filterTextValue = null;
        if (this.filterText != null) {
            filterTextValue = this.filterText.getText();
        }
        LocalDate fromDateValue = null;
        if (this.filterFromDate != null) {
            fromDateValue = this.filterFromDate.getLocalDate();
        }
        LocalDate toDateValue = null;
        if (this.filterToDate != null) {
            toDateValue = this.filterToDate.getLocalDate();
        }
        this.updateFilter(filterTextValue, fromDateValue, toDateValue);
    }

    protected void updateFilter(String newValue, LocalDate fromDate, LocalDate toDate) {
        this.filteredItems.setPredicate(ttl -> {
            String formattedDate;
            Transaction t = ttl.getTransaction();
            LocalDate localDate = t.getFirstImportDataDateAsDate();
            if (fromDate != null || toDate != null) {
                if (localDate == null) {
                    return false;
                }
                if (fromDate != null && localDate.isBefore(fromDate)) {
                    return false;
                }
                if (toDate != null && localDate.isAfter(toDate)) {
                    return false;
                }
            }
            if (newValue == null || newValue.isEmpty()) {
                return true;
            }
            String transactionComment = t.getFirstImportDataComment();
            if (transactionComment != null && transactionComment.toLowerCase().contains(newValue.toLowerCase())) {
                return true;
            }
            String cid = t.getFirstImportDataCounterparty();
            if (cid != null && !cid.isEmpty() && cid.toLowerCase().contains(newValue.toLowerCase())) {
                return true;
            }
            if (localDate != null && (formattedDate = this.displayDateFormatter.format(localDate)) != null && !formattedDate.isEmpty() && formattedDate.toLowerCase().contains(newValue.toLowerCase())) {
                return true;
            }
            String aid = ttl.getImportDataAccount();
            if (aid != null && !aid.isEmpty() && aid.toLowerCase().contains(newValue.toLowerCase())) {
                return true;
            }
            String pid = ttl.getImportDataProvision();
            return pid != null && !pid.isEmpty() && pid.toLowerCase().contains(newValue.toLowerCase());
        });
    }

    private void setImportDataObservableList() {
        if (this.importDataGlenixTrnXBRL == null) {
            return;
        }
        Business importDataBusiness = this.importDataGlenixTrnXBRL.getBusiness();
        if (importDataBusiness == null) {
            return;
        }
        ArrayList<Transaction> transactionArrayList = importDataBusiness.getTransactionArrayList();
        ArrayList<Transaction.TransactionTransactionLine> ttlal = new ArrayList<Transaction.TransactionTransactionLine>();
        for (Transaction t : transactionArrayList) {
            for (int i = 0; i < t.getTransactionLineCount(); ++i) {
                ttlal.addAll(t.getTransactionTransactionLineLineArrayList());
            }
        }
        this.importDataTransactionLineObservableList = FXCollections.observableList(ttlal);
        this.filteredItems = new FilteredList(this.importDataTransactionLineObservableList, ttl -> true);
        SortedList sl = new SortedList(this.filteredItems);
        sl.comparatorProperty().bind((ObservableValue)this.transactionTransactionLineTable.comparatorProperty());
        this.transactionTransactionLineTable.setItems((ObservableList)sl);
        if (this.filterText != null) {
            this.filterText.addTextChangeListener((ChangeListener<String>)((ChangeListener)(obs, oldValue, newValue) -> this.updateFilter()));
        }
        if (this.filterFromDate != null) {
            this.filterFromDate.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(obs, oldValue, newValue) -> this.updateFilter()));
        }
        if (this.filterToDate != null) {
            this.filterToDate.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(obs, oldValue, newValue) -> this.updateFilter()));
        }
    }

    @Override
    public void refreshTable() {
        this.setImportDataObservableList();
        this.transactionTransactionLineTable.refresh();
    }

    @FXML
    private void deleteSelectedImportData() {
        try {
            ObservableList selectedImportDataTransactions = this.transactionTransactionLineTable.getSelectionModel().getSelectedItems();
            if (selectedImportDataTransactions == null || selectedImportDataTransactions.size() == 0) {
                throw new Exception("Error, there is no selected imported data to delete.");
            }
            HashSet<Transaction.TransactionTransactionLine> trns = new HashSet<Transaction.TransactionTransactionLine>();
            for (Transaction.TransactionTransactionLine ttl : selectedImportDataTransactions) {
                trns.add(ttl);
            }
            this.xbrlFileController.deleteSelectedImportData(trns);
            this.xbrlFileController.saveImportData(null);
            this.refreshTable();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    private void generateTransactionValues() {
        try {
            HashSet<Transaction> donets = new HashSet<Transaction>();
            ObservableList selectedImportDataTransactions = this.transactionTransactionLineTable.getSelectionModel().getSelectedItems();
            for (Transaction.TransactionTransactionLine ttl : selectedImportDataTransactions) {
                Double amt;
                Account ac = this.findMatchingAccount(ttl);
                if (ac != null) {
                    String aci = ac.getAccountIdentifier();
                    ttl.setAccountIdentifier(aci);
                } else {
                    ttl.removeAccount();
                }
                Provision p = this.findMatchingProvision(ttl);
                if (p != null) {
                    String pi = p.getProvisionIdentifier();
                    ttl.setProvisionIdentifier(pi);
                } else {
                    ttl.removeProvision();
                }
                ttl.setProvisionAmount(ttl.getImportDataProvisionAmount());
                ttl.setQuantity(ttl.getImportDataQuantity());
                ttl.setLineComment(ttl.getImportDataComment());
                Transaction t = ttl.getTransaction();
                int multiplier = -1;
                String transactionType = t.getFirstImportDataTransactionType();
                if (transactionType != null) {
                    if (transactionType.equals("sales_quote") || transactionType.equals("sales_invoice") || transactionType.equals("cash_received") || transactionType.equals("purchase_credit")) {
                        multiplier = 1;
                    } else if (transactionType.equals("sales_credit") || transactionType.equals("purchase_order") || transactionType.equals("purchase_invoice") || transactionType.equals("cash_payment")) {
                        multiplier = -1;
                    } else {
                        transactionType = null;
                    }
                }
                if (!donets.contains(t)) {
                    donets.add(t);
                    t.setTransactionDate(ttl.getImportDataDate());
                    if (transactionType == null) {
                        Double totalImportDataAmount = t.getTotalImportDataAmount();
                        if (totalImportDataAmount > 0.0) {
                            transactionType = "sales_invoice";
                            multiplier = 1;
                        } else {
                            transactionType = "purchase_invoice";
                            multiplier = -1;
                        }
                    }
                    ttl.setTransactionType(transactionType);
                    t.setTransactionComment(t.getFirstImportDataComment());
                    t.removeCounterparty();
                    Counterparty c = this.findMatchingCounterparty(t);
                    String ci = null;
                    if (c != null) {
                        ci = c.getCounterpartyIdentifier();
                    }
                    t.setCounterpartyIdentifier(ci);
                    if (t == this.transaction) {
                        this.loadTransaction(t);
                    }
                }
                if ((amt = ttl.getImportDataAmount()) != null && !amt.equals("0D")) {
                    amt = amt * (double)multiplier;
                }
                ttl.setAmount(amt);
            }
            this.xbrlFileController.saveImportDataTransactions(donets);
            this.refreshTable();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @Override
    public void setCounterpartyTransactionList(ObservableList<Transaction> counterpartyObservableList) {
        super.setCounterpartyTransactionList(counterpartyObservableList);
        this.identifierCounterparty = new HashMap();
        this.legalNameCounterparty = new HashMap();
        this.tradingNameCounterparty = new HashMap();
        this.paymentReferenceCounterparty = new HashMap();
        for (Transaction t : counterpartyObservableList) {
            String paymentReference;
            String tradingName;
            String legalName;
            Counterparty c = t.getCounterparty();
            if (c == null) continue;
            String identifier = c.getCounterpartyIdentifier();
            if (identifier != null && !identifier.isEmpty()) {
                this.identifierCounterparty.put(identifier, c);
            }
            if ((legalName = c.getCounterpartyLegalName()) != null && !legalName.isEmpty()) {
                this.legalNameCounterparty.put(legalName.toLowerCase(), c);
            }
            if ((tradingName = c.getCounterpartyTradingName()) != null && !tradingName.isEmpty()) {
                this.tradingNameCounterparty.put(tradingName.toLowerCase(), c);
            }
            if ((paymentReference = c.getCounterpartyPaymentReference()) == null || paymentReference.isEmpty()) continue;
            this.paymentReferenceCounterparty.put(paymentReference.toLowerCase(), c);
        }
        if (this.transactionEditFormVBox != null) {
            this.transactionEditFormVBox.setCounterpartyTransactionList(counterpartyObservableList);
        }
        this.counterpartyIdentifier.setItems(counterpartyObservableList);
    }

    @Override
    public void setProvisionList(ObservableList<Transaction> provisionObservableList) {
        super.setProvisionList(provisionObservableList);
        this.identifierProvision = new HashMap();
        this.nameProvision = new HashMap();
        for (Transaction t : provisionObservableList) {
            String name;
            Provision p = t.getProvision();
            if (p == null) continue;
            String identifier = p.getProvisionIdentifier();
            if (identifier != null && !identifier.isEmpty()) {
                this.identifierProvision.put(identifier, p);
            }
            if ((name = p.getProvisionName()) == null || name.isEmpty()) continue;
            this.nameProvision.put(name.toLowerCase(), p);
        }
        if (this.transactionEditFormVBox != null) {
            this.transactionEditFormVBox.setProvisionList(provisionObservableList);
        }
        this.provisionIdentifier.setItems(provisionObservableList);
    }

    @Override
    public void setAccountList(ObservableList<Transaction> accountObservableList) {
        super.setAccountList(accountObservableList);
        this.identifierAccount = new HashMap();
        this.nameAccount = new HashMap();
        for (Transaction t : accountObservableList) {
            String name;
            Account a = t.getAccount();
            if (a == null) continue;
            String identifier = a.getAccountIdentifier();
            if (identifier != null && !identifier.isEmpty()) {
                this.identifierAccount.put(identifier, a);
            }
            if ((name = a.getAccountName()) == null || name.isEmpty()) continue;
            this.nameAccount.put(name.toLowerCase(), a);
        }
        if (this.transactionEditFormVBox != null) {
            this.transactionEditFormVBox.setAccountList(accountObservableList);
        }
        this.accountIdentifier.setItems(accountObservableList);
    }

    public Counterparty findMatchingCounterparty(Transaction t) {
        Counterparty c;
        String counterpartyStr;
        ImportData id;
        TransactionLine tl;
        int i;
        if (t == null) {
            return null;
        }
        for (i = 0; i < t.getTransactionLineCount(); ++i) {
            tl = t.getTransactionLine(i);
            if (tl == null || (id = tl.getImportData()) == null || (counterpartyStr = id.getImportDataCounterparty()) == null || counterpartyStr.isEmpty() || (c = this.identifierCounterparty.get(counterpartyStr.toLowerCase())) == null) continue;
            return c;
        }
        for (i = 0; i < t.getTransactionLineCount(); ++i) {
            tl = t.getTransactionLine(i);
            if (tl == null || (id = tl.getImportData()) == null || (counterpartyStr = id.getImportDataCounterparty()) == null || counterpartyStr.isEmpty()) continue;
            c = this.legalNameCounterparty.get(counterpartyStr.toLowerCase());
            if (c != null) {
                return c;
            }
            c = this.tradingNameCounterparty.get(counterpartyStr.toLowerCase());
            if (c == null) continue;
            return c;
        }
        for (i = 0; i < t.getTransactionLineCount(); ++i) {
            tl = t.getTransactionLine(i);
            if (tl == null || (id = tl.getImportData()) == null || (counterpartyStr = id.getImportDataCounterparty()) == null || counterpartyStr.isEmpty() || (c = this.paymentReferenceCounterparty.get(counterpartyStr.toLowerCase())) == null) continue;
            return c;
        }
        int bestindex = 100;
        Counterparty bestc = null;
        for (int i2 = 0; i2 < t.getTransactionLineCount(); ++i2) {
            int index;
            String counterpartyStr2;
            ImportData id2;
            TransactionLine tl2 = t.getTransactionLine(i2);
            if (tl2 == null || (id2 = tl2.getImportData()) == null || (counterpartyStr2 = id2.getImportDataCounterparty()) == null || counterpartyStr2.length() <= 5) continue;
            counterpartyStr2 = counterpartyStr2.toLowerCase();
            Set<String> keySet = this.legalNameCounterparty.keySet();
            for (String key : keySet) {
                index = key.indexOf(counterpartyStr2);
                if (index == 0) {
                    return this.legalNameCounterparty.get(key);
                }
                if (index <= 0 || index >= bestindex) continue;
                bestindex = index;
                bestc = this.legalNameCounterparty.get(key);
            }
            keySet = this.tradingNameCounterparty.keySet();
            for (String key : keySet) {
                index = key.indexOf(counterpartyStr2);
                if (index == 0) {
                    return this.tradingNameCounterparty.get(key);
                }
                if (index <= 0 || index >= bestindex) continue;
                bestindex = index;
                bestc = this.tradingNameCounterparty.get(key);
            }
        }
        if (bestc != null) {
            return bestc;
        }
        return null;
    }

    public Account findMatchingAccount(Transaction.TransactionTransactionLine tl) {
        if (tl == null) {
            return null;
        }
        ImportData id = tl.getImportData();
        if (id == null) {
            return null;
        }
        String accountStr = id.getImportDataAccount();
        if (accountStr == null || accountStr.isEmpty()) {
            return null;
        }
        Account a = this.identifierAccount.get(accountStr.toLowerCase());
        if (a != null) {
            return a;
        }
        a = this.nameAccount.get(accountStr.toLowerCase());
        if (a != null) {
            return a;
        }
        int bestindex = 100;
        Account besta = null;
        if (accountStr != null && accountStr.length() > 5) {
            accountStr = accountStr.toLowerCase();
            Set<String> keySet = this.nameAccount.keySet();
            for (String key : keySet) {
                int index = key.indexOf(accountStr);
                if (index == 0) {
                    return this.nameAccount.get(key);
                }
                if (index <= 0 || index >= bestindex) continue;
                bestindex = index;
                besta = this.nameAccount.get(key);
            }
        }
        if (besta != null) {
            return besta;
        }
        return null;
    }

    public Provision findMatchingProvision(Transaction.TransactionTransactionLine tl) {
        if (tl == null) {
            return null;
        }
        ImportData id = tl.getImportData();
        if (id == null) {
            return null;
        }
        String provisionStr = id.getImportDataProvision();
        if (provisionStr == null || provisionStr.isEmpty()) {
            return null;
        }
        Provision a = this.identifierProvision.get(provisionStr.toLowerCase());
        if (a != null) {
            return a;
        }
        a = this.nameProvision.get(provisionStr.toLowerCase());
        if (a != null) {
            return a;
        }
        int bestindex = 100;
        Provision besta = null;
        if (provisionStr != null && provisionStr.length() > 5) {
            provisionStr = provisionStr.toLowerCase();
            Set<String> keySet = this.nameProvision.keySet();
            for (String key : keySet) {
                int index = key.indexOf(provisionStr);
                if (index == 0) {
                    return this.nameProvision.get(key);
                }
                if (index <= 0 || index >= bestindex) continue;
                bestindex = index;
                besta = this.nameProvision.get(key);
            }
        }
        if (besta != null) {
            return besta;
        }
        return null;
    }

    @Override
    public GlenixPDFWrapper buildPDF(boolean includeBlanks) throws Exception {
        GlenixPDFWrapper gpw = new GlenixPDFWrapper();
        gpw.addPDPageLandscape();
        gpw.setColumns(10);
        gpw.setColumnLeftPosAndWidthMM(0, 20.0, 277.0);
        gpw.setColumnLeftPosAndWidthMM(1, 20.0, 277.0);
        gpw.setColumnLeftPosAndWidthMM(2, 20.0, 20.0);
        gpw.setColumnLeftPosAndWidthMM(3, 40.0, 40.0);
        gpw.setColumnLeftPosAndWidthMM(4, 80.0, 40.0);
        gpw.setColumnLeftPosAndWidthMM(5, 120.0, 30.0);
        gpw.setColumnLeftPosAndWidthMM(6, 155.0, 40.0);
        gpw.setColumnLeftPosAndWidthMM(7, 195.0, 40.0);
        gpw.setColumnLeftPosAndWidthMM(8, 235.0, 30.0);
        gpw.setColumnLeftPosAndWidthMM(9, 265.0, 32.0);
        gpw.setColumnFont(0, gpw.muliBoldFont);
        gpw.setColumnFont(1, gpw.muliLightFont);
        gpw.setColumnFont(2, gpw.muliLightFont);
        gpw.setColumnFont(3, gpw.muliLightFont);
        gpw.setColumnFont(4, gpw.muliLightFont);
        gpw.setColumnFont(5, gpw.muliLightFont);
        gpw.setColumnFont(6, gpw.muliLightFont);
        gpw.setColumnFont(7, gpw.muliLightFont);
        gpw.setColumnFont(8, gpw.muliLightFont);
        gpw.setColumnFont(9, gpw.muliLightFont);
        Double fontSize = this.convertFontSize(this.page_heading.getFont().getSize());
        gpw.prepareString(0, this.page_heading.getText(), true, fontSize);
        gpw.drawStrings(10.0);
        fontSize = this.convertFontSize(new Double(this.xbrlFileController.getCurrentFontSize()));
        this.drawPDFColumnHeadings(gpw);
        gpw.setAddPageCallback(this);
        for (Transaction.TransactionTransactionLine ttl : this.importDataTransactionLineObservableList) {
            gpw.prepareString(2, this.getTransactionDateColumnValue(ttl), true, fontSize);
            gpw.prepareString(3, this.getCounterpartyColumnValue(ttl), true, fontSize);
            gpw.prepareString(4, this.getCommentColumnValue(ttl), true, fontSize);
            gpw.prepareString(5, this.getAmountColumnValue(ttl), true, fontSize, "right");
            gpw.prepareString(6, this.getAccountColumnValue(ttl), true, fontSize);
            gpw.prepareString(7, this.getProvisionColumnValue(ttl), true, fontSize);
            gpw.prepareString(8, this.getProvisionAmountColumnValue(ttl), true, fontSize, "right");
            gpw.prepareString(9, this.getQuantityColumnValue(ttl), true, fontSize, "right");
            gpw.drawStrings(5.0);
        }
        gpw.addFooter();
        return gpw;
    }

    private void drawPDFColumnHeadings(GlenixPDFWrapper gpw) throws Exception {
        gpw.setColumnFont(2, gpw.muliBoldFont);
        gpw.setColumnFont(3, gpw.muliBoldFont);
        gpw.setColumnFont(4, gpw.muliBoldFont);
        gpw.setColumnFont(5, gpw.muliBoldFont);
        gpw.setColumnFont(6, gpw.muliBoldFont);
        gpw.setColumnFont(7, gpw.muliBoldFont);
        gpw.setColumnFont(8, gpw.muliBoldFont);
        gpw.setColumnFont(9, gpw.muliBoldFont);
        Double fontSize = this.convertFontSize(new Double(this.xbrlFileController.getCurrentFontSize()));
        gpw.prepareString(2, this.transactionDateColumn.getText(), true, fontSize);
        gpw.prepareString(3, this.transactionCounterpartyColumn.getText(), true, fontSize);
        gpw.prepareString(4, this.transactionCommentColumn.getText(), true, fontSize);
        gpw.prepareString(5, this.amountColumn.getText(), true, fontSize, "right");
        gpw.prepareString(6, this.accountColumn.getText(), true, fontSize);
        gpw.prepareString(7, this.provisionColumn.getText(), true, fontSize);
        gpw.prepareString(8, this.taxAmountColumn.getText(), true, fontSize, "right");
        gpw.prepareString(9, this.quantityColumn.getText(), true, fontSize, "right");
        gpw.drawStrings(5.0);
        gpw.setColumnFont(2, gpw.muliLightFont);
        gpw.setColumnFont(3, gpw.muliLightFont);
        gpw.setColumnFont(4, gpw.muliLightFont);
        gpw.setColumnFont(5, gpw.muliLightFont);
        gpw.setColumnFont(6, gpw.muliLightFont);
        gpw.setColumnFont(7, gpw.muliLightFont);
        gpw.setColumnFont(8, gpw.muliLightFont);
        gpw.setColumnFont(9, gpw.muliLightFont);
    }

    @Override
    public void newPDFPageAdded(GlenixPDFWrapper gpw) throws Exception {
        this.drawPDFColumnHeadings(gpw);
    }

    @FXML
    protected void applySelectedOptions() {
        try {
            String calcProvisionAmounts = this.calculateProvisionAmounts.getGlenixElementValue();
            boolean calcblank = true;
            boolean calcall = false;
            if (calcProvisionAmounts != null && calcProvisionAmounts.equals("false")) {
                calcblank = false;
            } else if (calcProvisionAmounts != null && calcProvisionAmounts.equals("true")) {
                calcall = true;
            }
            ObservableList selectedtrns = this.transactionTransactionLineTable.getSelectionModel().getSelectedItems();
            if (selectedtrns.size() == 0) {
                throw new Exception("You have not selected any transactions");
            }
            String ci = this.counterpartyIdentifier.getGlenixElementValue();
            String ai = this.accountIdentifier.getGlenixElementValue();
            String pi = this.provisionIdentifier.getGlenixElementValue();
            String tt = this.transactionTypeCombo.getGlenixElementValue();
            String ra = this.reverseAmountCombo.getGlenixElementValue();
            if (!(tt != null && !tt.isEmpty() || ci != null && !ci.isEmpty() || ai != null && !ai.isEmpty() || pi != null && !pi.isEmpty() || calcall)) {
                throw new Exception("Error you have not selected any values to apply");
            }
            Double pipercent = null;
            if (pi != null && !pi.isEmpty()) {
                Transaction pt = this.xbrlFileController.getProvisionTransaction(pi);
                Provision p = pt.getProvision();
                pipercent = p.getProvisionPercentageAsDouble();
            }
            boolean doreload = false;
            HashMap<String, Transaction> changedTransactions = new HashMap<String, Transaction>();
            for (Transaction.TransactionTransactionLine ttl : selectedtrns) {
                String tlpi;
                if (tt != null && !tt.isEmpty()) {
                    String currenttt = ttl.getTransactionType();
                    if (currenttt != null && !currenttt.isEmpty() && ra != null && ra.equals("true")) {
                        Double amt;
                        if ((currenttt.equals("sales_invoice") || currenttt.equals("cash_received") || currenttt.equals("sales_quote") || currenttt.equals("purchase_credit")) && !tt.equals("sales_invoice") && !tt.equals("cash_received") && !tt.equals("sales_quote") && !tt.equals("purchase_credit")) {
                            amt = ttl.getAmount();
                            if (amt != null && !amt.equals(0.0)) {
                                ttl.setAmount(-amt.doubleValue());
                            }
                        } else if (!(currenttt.equals("sales_invoice") || currenttt.equals("cash_received") || currenttt.equals("sales_quote") || currenttt.equals("purchase_credit") || !tt.equals("sales_invoice") && !tt.equals("cash_received") && !tt.equals("sales_quote") && !tt.equals("purchase_credit") || (amt = ttl.getAmount()) == null || amt.equals(0.0))) {
                            ttl.setAmount(-amt.doubleValue());
                        }
                    }
                    ttl.setTransactionType(tt);
                    changedTransactions.put(ttl.getTransaction().getTransactionNumber(), ttl.getTransaction());
                }
                if (ci != null && !ci.isEmpty()) {
                    ttl.setCounterpartyIdentifier(ci);
                    changedTransactions.put(ttl.getTransaction().getTransactionNumber(), ttl.getTransaction());
                }
                if (ai != null && !ai.isEmpty()) {
                    ttl.setAccountIdentifier(ai);
                    changedTransactions.put(ttl.getTransaction().getTransactionNumber(), ttl.getTransaction());
                }
                if (pi != null && !pi.isEmpty()) {
                    String tlpa;
                    ttl.setProvisionIdentifier(pi);
                    changedTransactions.put(ttl.getTransaction().getTransactionNumber(), ttl.getTransaction());
                    if (!calcall && calcblank && ((tlpa = ttl.getProvisionAmountString()) == null || tlpa.isEmpty()) && pipercent != null) {
                        try {
                            Double amount = ttl.getAmount();
                            ttl.setProvisionAmount(amount * pipercent / 100.0);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                if (calcall && (tlpi = ttl.getProvisionIdentifier()) != null && !tlpi.isEmpty()) {
                    try {
                        Double amount;
                        Double percent = pipercent;
                        if (!tlpi.equals(pi)) {
                            Transaction pt = this.xbrlFileController.getProvisionTransaction(tlpi);
                            Provision p = pt.getProvision();
                            percent = p.getProvisionPercentageAsDouble();
                        }
                        if ((amount = ttl.getAmount()) != null && percent != null) {
                            ttl.setProvisionAmount(amount * percent / 100.0);
                            changedTransactions.put(ttl.getTransaction().getTransactionNumber(), ttl.getTransaction());
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (ttl.getTransaction() != this.transaction) continue;
                doreload = true;
            }
            this.xbrlFileController.saveImportDataTransactions(changedTransactions.values());
            if (doreload) {
                this.setTransaction(this.transaction);
            }
            this.refreshTable();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    private void addTransaction() {
        try {
            this.xbrlFileController.gotoTransactionEdit(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    protected void loadTransaction(Transaction newTransaction) {
        block15: {
            if (newTransaction != null) {
                try {
                    String batchIdentifier = newTransaction.getBatchIdentifier();
                    if (batchIdentifier != null && !batchIdentifier.isEmpty()) {
                        this.error_message.setText("Error, the selected transaction is on a batch. Double click to go to edit.");
                        this.xbrlFileController.setStatusBarMessage("Error, the selected transaction is on a batch. Double click to go to edit.");
                        if (this.transactionEditFormVBox != null) {
                            this.transactionEditFormVBox.setTransactionElement(null);
                        }
                        this.transaction = null;
                        break block15;
                    }
                    String type = newTransaction.getTransactionType();
                    if (type != null && type.equals("pay_slip")) {
                        this.error_message.setText("Error, cannot edit pay slip on this page. Double click to go to the pay slip edit page.");
                        if (this.transactionEditFormVBox != null) {
                            this.transactionEditFormVBox.setTransactionElement(null);
                        }
                        this.transaction = null;
                    } else {
                        if (this.transactionEditFormVBox != null) {
                            this.transactionEditFormVBox.setTransactionElement(newTransaction);
                        }
                        this.transaction = newTransaction;
                    }
                    this.error_message.setText(null);
                    this.xbrlFileController.setStatusBarMessage(null);
                }
                catch (Exception e) {
                    this.transaction = null;
                    e.printStackTrace();
                    this.error_message.setText("Error, could not quick edit transaction.");
                    this.xbrlFileController.setStatusBarMessage("Error, could not quick edit transaction.");
                    try {
                        this.transactionEditFormVBox.setTransactionElement(null);
                    }
                    catch (Exception exception) {}
                }
            } else {
                this.transaction = null;
                this.error_message.setText(null);
                this.xbrlFileController.setStatusBarMessage(null);
                if (this.transactionEditFormVBox != null) {
                    try {
                        this.transactionEditFormVBox.setTransactionElement(null);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.error_message.setText(e.getMessage());
                        this.xbrlFileController.setStatusBarMessage(e.getMessage());
                    }
                }
            }
        }
    }

    public void setTransaction(Transaction transaction) {
        this.loadTransaction(transaction);
    }

    public void setTransactionDefaults() throws Exception {
        if (this.transaction == null) {
            return;
        }
        String tt = this.transaction.getTransactionType();
        if (tt == null) {
            this.transaction.setTransactionType("cash_payment");
        }
    }

    private boolean lodgedActivityStatementIsChanged(boolean statusChange) {
        if (this.transaction == null) {
            return false;
        }
        HashSet<String> ass = new HashSet<String>();
        boolean hasas = false;
        for (int i = 0; i < this.transaction.getTransactionLineCount(); ++i) {
            String status;
            ActivityStatement as;
            TransactionLine tl = this.transaction.getTransactionLine(i);
            String asNumber = tl.getActivityStatementNumber();
            if (asNumber == null || asNumber.isEmpty()) continue;
            hasas = true;
            GlenixTrnXBRL asTrn = null;
            try {
                asTrn = this.xbrlFileController.loadActivityStatement(asNumber);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (asTrn == null || (as = asTrn.getActivityStatement()) == null || (status = as.getSBRDocumentStatus()) == null || status.equals("created") || status.equals("list_complete") || status.equals("list_in_progress") || status.equals("prefill_complete") || status.equals("prefill_in_progress") || status.equals("prelodge_complete") || status.equals("prelodge_in_progress")) continue;
            if (statusChange) {
                return true;
            }
            ass.add(asNumber);
        }
        if (this.transactionEditFormVBox == null) {
            return hasas;
        }
        return this.transactionEditFormVBox.basChanged(ass);
    }

    private boolean lodgedActivityStatementIsChangedTransaction(Transaction transaction, boolean statusChange) {
        if (transaction == null) {
            return false;
        }
        HashSet<String> ass = new HashSet<String>();
        boolean hasas = false;
        for (int i = 0; i < transaction.getTransactionLineCount(); ++i) {
            String status;
            ActivityStatement as;
            TransactionLine tl = transaction.getTransactionLine(i);
            String asNumber = tl.getActivityStatementNumber();
            if (asNumber == null || asNumber.isEmpty()) continue;
            hasas = true;
            GlenixTrnXBRL asTrn = null;
            try {
                asTrn = this.xbrlFileController.loadActivityStatement(asNumber);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (asTrn == null || (as = asTrn.getActivityStatement()) == null || (status = as.getSBRDocumentStatus()) == null || status.equals("created") || status.equals("list_complete") || status.equals("list_in_progress") || status.equals("prefill_complete") || status.equals("prefill_in_progress") || status.equals("prelodge_complete") || status.equals("prelodge_in_progress")) continue;
            if (statusChange) {
                return true;
            }
            ass.add(asNumber);
        }
        return hasas;
    }

    private boolean transactionBatchIsLocked() {
        String bi;
        Transaction bt;
        Batch b;
        String trBi = null;
        if (this.transaction != null && (b = this.transaction.getBatch()) != null && (trBi = b.getBatchIdentifier()) != null && !trBi.isEmpty()) {
            String status;
            bt = null;
            try {
                bt = this.xbrlFileController.getBatchTransaction(trBi);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (bt != null && (status = bt.getBatchStatus()) != null && !status.equals("created")) {
                return true;
            }
        }
        if (this.transactionEditFormVBox != null && (bi = this.transactionEditFormVBox.getTransactionBatchIdentifier()) != null && !bi.isEmpty() && !bi.equals(trBi)) {
            bt = null;
            try {
                bt = this.xbrlFileController.getBatchTransaction(bi);
            }
            catch (Exception status) {
                // empty catch block
            }
            if (bt != null && (status = bt.getBatchStatus()) != null && !status.equals("created")) {
                return true;
            }
        }
        return false;
    }

    protected void saveTransaction() throws Exception {
        Document resultDoc = this.dBuilder.newDocument();
        this.transactionEditFormVBox.buildGlenixXBRLTransactionPart(resultDoc, null);
        this.transaction.loadDocumentElementOverwrite(resultDoc, resultDoc.getDocumentElement());
        this.setTransactionDefaults();
        this.xbrlFileController.saveTransaction(this.transaction);
    }

    protected void validateTransaction() throws Exception {
        String status;
        if (this.transactionEditFormVBox == null) {
            throw new Exception("Error, no transaction edit form found");
        }
        boolean statusChange = false;
        if (this.transaction != null && !(status = this.transaction.getTransactionStatus()).equals("posted")) {
            statusChange = true;
        }
        if (this.lodgedActivityStatementIsChanged(statusChange)) {
            this.transactionEditFormVBox.setTransactionElement(this.transaction);
            throw new Exception("Error, one of the modified lines is on a lodged Activity Statment.");
        }
        if (this.transactionBatchIsLocked()) {
            this.transactionEditFormVBox.setTransactionElement(this.transaction);
            throw new Exception("Error, you cannot modify the transaction as it is on an authorised or lodged Batch.");
        }
        LocalDate ld = this.transactionEditFormVBox.getTransactionLocalDate();
        if (ld == null) {
            throw new Exception("Error, a transaction date is blank or incorrect");
        }
        String counterpartyIdentifier = this.transactionEditFormVBox.getCounterpartyIdentifier();
        if (counterpartyIdentifier == null || counterpartyIdentifier.isEmpty()) {
            throw new Exception("Error, the transaction does not have a counterparty, select a counterparty");
        }
        if (!this.transactionEditFormVBox.allLinesHaveAccount()) {
            throw new Exception("Error, a transaction line is missing an account");
        }
    }

    protected void validateTransactionTransaction(Transaction transaction) throws Exception {
        if (transaction == null) {
            throw new Exception("Error, transaction is null");
        }
        if (this.lodgedActivityStatementIsChangedTransaction(transaction, true)) {
            throw new Exception("Error, one of the modified lines is on a lodged Activity Statment.");
        }
        if (this.transactionBatchIsLocked()) {
            throw new Exception("Error, you cannot modify the transaction as it is on an authorised or lodged Batch.");
        }
        LocalDate ld = transaction.getTransactionDateAsDate();
        if (ld == null) {
            throw new Exception("Error, transaction date is blank or incorrect");
        }
        String counterpartyIdentifier = transaction.getCounterpartyIdentifier();
        if (counterpartyIdentifier == null || counterpartyIdentifier.isEmpty()) {
            throw new Exception("Error, the transaction does not have a counterparty, select a counterparty");
        }
        for (int i = 0; i < transaction.getTransactionLineCount(); ++i) {
            TransactionLine tl = transaction.getTransactionLine(i);
            String accountIdentifier = tl.getAccountIdentifier();
            if (accountIdentifier != null && !accountIdentifier.isEmpty()) continue;
            throw new Exception("Error a transaction line is missing an account");
        }
    }

    private void postSelectedTransactionsE() throws Exception {
        ObservableList selectedtrns = this.transactionTransactionLineTable.getSelectionModel().getSelectedItems();
        if (selectedtrns.size() == 0) {
            throw new Exception("You have not selected any transactions");
        }
        HashSet<Transaction> trns = new HashSet<Transaction>();
        for (Transaction.TransactionTransactionLine ttl : selectedtrns) {
            trns.add(ttl.getTransaction());
        }
        boolean clearform = false;
        for (Transaction t : trns) {
            this.validateTransactionTransaction(t);
            if (this.transaction != t) continue;
            clearform = true;
        }
        for (Transaction t : trns) {
            t.setTransactionStatus("posted");
        }
        this.xbrlFileController.postImportDataTransactions(trns);
        this.error_message.setText("Saved");
        if (clearform) {
            this.transactionEditFormVBox.setTransactionElement(null);
            this.transaction = null;
        }
    }

    @FXML
    private void postSelectedTransactions() {
        try {
            this.postSelectedTransactionsE();
            this.updateFilter();
            this.refreshTable();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    private void postTransactionE() throws Exception {
        this.validateTransaction();
        if (this.transaction == null) {
            this.transaction = this.xbrlFileController.addTransaction();
        }
        if (this.transaction == null) {
            throw new Exception("Error, transaction is null");
        }
        this.transaction.setTransactionStatus("posted");
        this.saveTransaction();
        this.error_message.setText("Saved");
        this.lastLocalDate = this.transactionEditFormVBox.getTransactionLocalDate();
    }

    @FXML
    private void postTransaction() {
        try {
            this.postTransactionE();
            this.updateFilter();
            this.refreshTable();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    public void clearTransaction() {
        if (this.transactionEditFormVBox != null) {
            try {
                this.transactionEditFormVBox.setTransactionElement(null);
                this.transaction = null;
                if (this.lastLocalDate != null) {
                    this.transactionEditFormVBox.setTransactionLocalDate(this.lastLocalDate);
                }
                this.transactionEditFormVBox.requestFocus();
                this.error_message.setText("New transaction");
                this.xbrlFileController.setStatusBarMessage(null);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.error_message.setText(e.getMessage());
                this.xbrlFileController.setStatusBarMessage(e.getMessage());
            }
        }
    }

    @FXML
    public void postAndClearTransaction() {
        try {
            this.postTransactionE();
            this.clearTransaction();
            this.updateFilter();
            this.refreshTable();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    public void copyToNewTransaction() {
        try {
            this.transaction = null;
            this.transactionEditFormVBox.setActivityStatmentNumber(null);
            this.transactionEditFormVBox.setBatchTransactionElement(null);
            this.transactionEditFormVBox.requestFocus();
            this.error_message.setText("New transaction");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    public void cancelTransaction() {
        try {
            String status;
            boolean statusChange = false;
            if (this.transaction != null && !(status = this.transaction.getTransactionStatus()).equals("cancelled")) {
                statusChange = true;
            }
            if (this.lodgedActivityStatementIsChanged(statusChange)) {
                this.transactionEditFormVBox.setTransactionElement(this.transaction);
                this.error_message.setText("Error, one of the modified lines is on a lodged Activity Statment.");
                this.xbrlFileController.setStatusBarMessage("Error, one of the modified lines is on a lodged Activity Statment.");
                return;
            }
            if (this.transactionBatchIsLocked()) {
                this.transactionEditFormVBox.setTransactionElement(this.transaction);
                this.error_message.setText("Error, you cannot modify the transaction as it is on an authorised or lodged Batch.");
                this.xbrlFileController.setStatusBarMessage("Error, you cannot modify the transaction as it is on an authorised or lodged Batch.");
                return;
            }
            if (this.transaction == null) {
                throw new Exception("Error, transaction is null, no transaction to cancel");
            }
            this.transaction.setTransactionStatus("cancelled");
            this.saveTransaction();
            this.error_message.setText("Cancelled");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
        this.updateFilter();
        this.refreshTable();
    }

    protected Double addDouble(Double d1, Double d2) {
        if (d1 == null) {
            return d2;
        }
        if (d2 == null) {
            return d1;
        }
        return d1 + d2;
    }

    @Override
    protected void updateTotalAmount() {
        Double totalAmount = 0.0;
        Double totalProvisionAmount = 0.0;
        Double totalQuantity = 0.0;
        if (this.filteredItems != null) {
            for (Transaction.TransactionTransactionLine ttl : this.filteredItems) {
                totalAmount = this.addDouble(totalAmount, ttl.getAmount());
                totalProvisionAmount = this.addDouble(totalProvisionAmount, ttl.getProvisionAmount());
                totalQuantity = this.addDouble(totalQuantity, ttl.getQuantity());
            }
        }
        if (this.total_label != null) {
            this.total_label.setText("Total displayed amount: " + this.amountFormat.format(totalAmount) + ", total tax: " + this.amountFormat.format(totalProvisionAmount) + ", total quantity " + this.quantityFormat.format(totalQuantity));
        }
    }

    @FXML
    protected void addTransactionLine() {
        try {
            this.transactionEditFormVBox.addTransactionLine(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    protected void deleteSelectedTransactionLines() {
        block8: {
            try {
                if (this.transaction != null) {
                    HashSet<String> ass = new HashSet<String>();
                    for (int i = 0; i < this.transaction.getTransactionLineCount(); ++i) {
                        String status;
                        ActivityStatement as;
                        TransactionLine tl = this.transaction.getTransactionLine(i);
                        String asNumber = tl.getActivityStatementNumber();
                        if (asNumber == null || asNumber.isEmpty()) continue;
                        GlenixTrnXBRL asTrn = null;
                        try {
                            asTrn = this.xbrlFileController.loadActivityStatement(asNumber);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (asTrn == null || (as = asTrn.getActivityStatement()) == null || (status = as.getSBRDocumentStatus()) == null || status.equals("created") || status.equals("list_complete") || status.equals("list_in_progress") || status.equals("prefill_complete") || status.equals("prefill_in_progress") || status.equals("prelodge_complete") || status.equals("prelodge_in_progress")) continue;
                        ass.add(asNumber);
                    }
                    if (ass.size() == 0) {
                        this.transactionEditFormVBox.deleteSelectedTransactionLines(null);
                    } else {
                        this.transactionEditFormVBox.deleteSelectedTransactionLines(ass);
                    }
                    break block8;
                }
                this.transactionEditFormVBox.deleteSelectedTransactionLines(null);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.error_message.setText(e.getMessage());
                this.xbrlFileController.setStatusBarMessage(e.getMessage());
            }
        }
    }
}

