/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import au.com.glenix.ApplicationController;
import au.com.glenix.trn.ImportData;
import au.com.glenix.trn.Transaction;
import au.com.glenix.trn.TransactionLine;
import au.com.glenix.widget.GlenixBranchController;
import au.com.glenix.widget.GlenixLabelBlankNoYesCombo;
import com.opencsv.CSVReader;
import java.io.File;
import java.io.FileReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.util.Pair;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

public class ImportDataImportFileFieldSelectController
extends GlenixBranchController {
    @FXML
    private Label error_message;
    private ApplicationController applicationController = null;
    private DocumentBuilder dBuilder;
    private CSVReader reader;
    private File afile;
    private String[] firstline;
    @FXML
    private GlenixLabelBlankNoYesCombo importDataDate;
    @FXML
    private GlenixLabelBlankNoYesCombo importDataCounterparty;
    @FXML
    private GlenixLabelBlankNoYesCombo importDataComment;
    @FXML
    private GlenixLabelBlankNoYesCombo importDataAmount;
    @FXML
    private GlenixLabelBlankNoYesCombo importDataAccount;
    @FXML
    private GlenixLabelBlankNoYesCombo importDataProvision;
    @FXML
    private GlenixLabelBlankNoYesCombo importDataQuantity;
    @FXML
    private GlenixLabelBlankNoYesCombo importDataProvisionAmount;
    @FXML
    private GlenixLabelBlankNoYesCombo importDataBankAccount;
    @FXML
    private GlenixLabelBlankNoYesCombo importDataTransactionReference;
    @FXML
    private GlenixLabelBlankNoYesCombo importDataTransactionType;

    public ImportDataImportFileFieldSelectController(ApplicationController applicationController) {
        this.applicationController = applicationController;
    }

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setNamespaceAware(true);
            this.dBuilder = dbFactory.newDocumentBuilder();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.applicationController.setStatusBarMessage(e.getMessage());
        }
    }

    public void setImportDataFileDetails(CSVReader reader, File afile, String[] firstline) throws Exception {
        this.afile = afile;
        this.reader = reader;
        this.firstline = firstline;
        ArrayList<Pair> values = new ArrayList<Pair>();
        values.add(new Pair((Object)"-1", (Object)"Not in file"));
        for (int i = 0; i < firstline.length; ++i) {
            values.add(new Pair((Object)("" + i), (Object)firstline[i]));
        }
        ObservableList valuesol = FXCollections.observableList(values);
        this.importDataDate.setItems((ObservableList<Pair<String, String>>)valuesol);
        this.importDataCounterparty.setItems((ObservableList<Pair<String, String>>)valuesol);
        this.importDataComment.setItems((ObservableList<Pair<String, String>>)valuesol);
        this.importDataAmount.setItems((ObservableList<Pair<String, String>>)valuesol);
        this.importDataAccount.setItems((ObservableList<Pair<String, String>>)valuesol);
        this.importDataProvision.setItems((ObservableList<Pair<String, String>>)valuesol);
        this.importDataQuantity.setItems((ObservableList<Pair<String, String>>)valuesol);
        this.importDataProvisionAmount.setItems((ObservableList<Pair<String, String>>)valuesol);
        this.importDataBankAccount.setItems((ObservableList<Pair<String, String>>)valuesol);
        this.importDataTransactionReference.setItems((ObservableList<Pair<String, String>>)valuesol);
        this.importDataTransactionType.setItems((ObservableList<Pair<String, String>>)valuesol);
    }

    private ImportData processLine(String[] line) throws Exception {
        int index;
        ImportData result = new ImportData();
        String indexStr = this.importDataDate.getGlenixElementValue();
        if (indexStr != null && !indexStr.isEmpty() && !indexStr.equals("-1") && (index = Integer.parseInt(indexStr)) >= 0) {
            result.setImportDataDate(line[index]);
        }
        if ((indexStr = this.importDataCounterparty.getGlenixElementValue()) != null && !indexStr.isEmpty() && !indexStr.equals("-1") && (index = Integer.parseInt(indexStr)) >= 0) {
            result.setImportDataCounterparty(line[index]);
        }
        if ((indexStr = this.importDataComment.getGlenixElementValue()) != null && !indexStr.isEmpty() && !indexStr.equals("-1") && (index = Integer.parseInt(indexStr)) >= 0) {
            result.setImportDataComment(line[index]);
        }
        if ((indexStr = this.importDataAmount.getGlenixElementValue()) != null && !indexStr.isEmpty() && !indexStr.equals("-1") && (index = Integer.parseInt(indexStr)) >= 0) {
            result.setImportDataAmount(line[index]);
        }
        if ((indexStr = this.importDataAccount.getGlenixElementValue()) != null && !indexStr.isEmpty() && !indexStr.equals("-1") && (index = Integer.parseInt(indexStr)) >= 0) {
            result.setImportDataAccount(line[index]);
        }
        if ((indexStr = this.importDataProvision.getGlenixElementValue()) != null && !indexStr.isEmpty() && !indexStr.equals("-1") && (index = Integer.parseInt(indexStr)) >= 0) {
            result.setImportDataProvision(line[index]);
        }
        if ((indexStr = this.importDataQuantity.getGlenixElementValue()) != null && !indexStr.isEmpty() && !indexStr.equals("-1") && (index = Integer.parseInt(indexStr)) >= 0) {
            result.setImportDataQuantity(line[index]);
        }
        if ((indexStr = this.importDataProvisionAmount.getGlenixElementValue()) != null && !indexStr.isEmpty() && !indexStr.equals("-1") && (index = Integer.parseInt(indexStr)) >= 0) {
            result.setImportDataProvisionAmount(line[index]);
        }
        if ((indexStr = this.importDataBankAccount.getGlenixElementValue()) != null && !indexStr.isEmpty() && !indexStr.equals("-1") && (index = Integer.parseInt(indexStr)) >= 0) {
            result.setImportDataBankAccount(line[index]);
        }
        if ((indexStr = this.importDataTransactionReference.getGlenixElementValue()) != null && !indexStr.isEmpty() && !indexStr.equals("-1") && (index = Integer.parseInt(indexStr)) >= 0) {
            result.setImportDataTransactionReference(line[index]);
        }
        if ((indexStr = this.importDataTransactionType.getGlenixElementValue()) != null && !indexStr.isEmpty() && !indexStr.equals("-1") && (index = Integer.parseInt(indexStr)) >= 0) {
            result.setImportDataTransactionType(line[index]);
        }
        return result;
    }

    @FXML
    private void processImportDataCsv() {
        try {
            String[] aline;
            ArrayList<Transaction> importDataTransactionList = new ArrayList<Transaction>();
            CSVReader reader = new CSVReader(new FileReader(this.afile));
            String[] firstline = reader.readNext();
            if (firstline == null) {
                throw new Exception("Error, the csv file does not have any lines");
            }
            while (firstline.length == 0) {
                firstline = reader.readNext();
                if (firstline != null) continue;
                throw new Exception("Error, the csv file does not have any data");
            }
            while ((aline = reader.readNext()) != null) {
                ImportData id = this.processLine(aline);
                if (id == null) continue;
                String ii = id.getImportDataIdentifier();
                if (ii == null || ii.isEmpty()) {
                    id.assignUUIDToImportDataIdentifier();
                }
                Transaction t = new Transaction();
                TransactionLine tl = t.addBlankTransactionLine();
                tl.setImportData(id);
                importDataTransactionList.add(t);
            }
            if (importDataTransactionList.size() == 0) {
                throw new Exception("Error, nothing to process");
            }
            this.applicationController.addImportDataTransactions(importDataTransactionList);
            this.applicationController.saveImportDataTransactions(importDataTransactionList);
            this.applicationController.gotoImportDataList();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.applicationController.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    private void gotoImportDataImportFile() {
        try {
            this.applicationController.gotoImportDataImportFile();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.applicationController.setStatusBarMessage(e.getMessage());
        }
    }
}

