/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import au.com.glenix.ApplicationController;
import au.com.glenix.trn.GlenixTrnXBRL;
import au.com.glenix.widget.GlenixBranchController;
import com.opencsv.CSVReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import org.w3c.dom.Document;

public class ImportDataImportFileController
extends GlenixBranchController {
    @FXML
    private Label error_message;
    @FXML
    private Label filename;
    private GlenixTrnXBRL glenixTrnXBRL;
    File file;
    private ApplicationController xbrlFileController = null;

    public ImportDataImportFileController(ApplicationController xbrlFileController) {
        this.xbrlFileController = xbrlFileController;
    }

    public void setModel(GlenixTrnXBRL glenixTrnXBRL) throws Exception {
        Document doc;
        this.glenixTrnXBRL = glenixTrnXBRL;
        if (glenixTrnXBRL != null && (doc = glenixTrnXBRL.buildDocument()) != null) {
            this.loadGlenixXBRL(doc, doc.getDocumentElement());
        }
    }

    @FXML
    public void openFile() {
        try {
            File afile = this.xbrlFileController.openCsvImportFile();
            CSVReader reader = null;
            try {
                reader = new CSVReader(new FileReader(afile));
                String[] firstline = reader.readNext();
                if (firstline == null) {
                    throw new Exception("Error, the csv file does not have any lines");
                }
                while (firstline.length == 0) {
                    firstline = reader.readNext();
                    if (firstline != null) continue;
                    throw new Exception("Error, the csv file does not have any data");
                }
                while (reader.readNext() != null) {
                }
                this.xbrlFileController.gotoImportDataImportFileFieldSelect(reader, afile, firstline);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new Exception("Error, the csv file could not be parsed");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }
}

