/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import au.com.glenix.ApplicationController;
import au.com.glenix.trn.ImportData;
import au.com.glenix.trn.Transaction;
import au.com.glenix.trn.TransactionLine;
import au.com.glenix.widget.GlenixBranchController;
import java.net.URL;
import java.util.List;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ImportDataEditController
extends GlenixBranchController {
    @FXML
    private Label error_message;
    private ApplicationController applicationController = null;
    private DocumentBuilder dBuilder;
    private ImportData importData = null;
    private List<Transaction> transactionList;
    private Transaction transaction;
    private List<Transaction.TransactionTransactionLine> transactionTransactionLineList;
    private Transaction.TransactionTransactionLine importDataTransactionTransactionLine;

    public ImportDataEditController(ApplicationController applicationController) {
        this.applicationController = applicationController;
    }

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setNamespaceAware(true);
            this.dBuilder = dbFactory.newDocumentBuilder();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.applicationController.setStatusBarMessage(e.getMessage());
        }
    }

    @Override
    public void buildGlenixXBRL(Document resultDoc, Element resultElement) throws Exception {
        Element xbrlEl = resultDoc.createElementNS("http://www.glenix.com.au/", "gx:glenix");
        if (resultElement == null) {
            resultDoc.appendChild(xbrlEl);
        } else {
            resultElement.appendChild(xbrlEl);
        }
        Element businessEl = resultDoc.createElementNS("http://www.glenix.com.au/", "gx:business");
        xbrlEl.appendChild(businessEl);
        Element transactionEl = resultDoc.createElementNS("http://www.glenix.com.au/", "gx:transaction");
        businessEl.appendChild(transactionEl);
        Element transactionLineEl = resultDoc.createElementNS("http://www.glenix.com.au/", "gx:transactionLine");
        transactionEl.appendChild(transactionLineEl);
        super.buildGlenixXBRL(resultDoc, transactionLineEl);
    }

    @Override
    public void loadGlenixXBRL(Document loadDoc, Element loadElement) throws Exception {
        if (loadElement.getNamespaceURI() != null && loadElement.getNamespaceURI().equals("http://www.glenix.com.au/") && loadElement.getLocalName() != null && loadElement.getLocalName().equals("glenix")) {
            NodeList nodeList = loadElement.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element businessElement;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || (businessElement = (Element)node).getNamespaceURI() == null || !businessElement.getNamespaceURI().equals("http://www.glenix.com.au/") || businessElement.getLocalName() == null || !businessElement.getLocalName().equals("business")) continue;
                NodeList nodeList2 = businessElement.getChildNodes();
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    Element transactionElement;
                    Node node2 = nodeList2.item(j);
                    if (node2.getNodeType() != 1 || (transactionElement = (Element)node2).getNamespaceURI() == null || !transactionElement.getNamespaceURI().equals("http://www.glenix.com.au/") || transactionElement.getLocalName() == null || !transactionElement.getLocalName().equals("transaction")) continue;
                    NodeList nodeList3 = transactionElement.getChildNodes();
                    for (int k = 0; k < nodeList3.getLength(); ++k) {
                        Element transactionLineElement;
                        Node node3 = nodeList3.item(k);
                        if (node3.getNodeType() != 1 || (transactionLineElement = (Element)node3).getNamespaceURI() == null || !transactionLineElement.getNamespaceURI().equals("http://www.glenix.com.au/") || transactionLineElement.getLocalName() == null || !transactionLineElement.getLocalName().equals("transactionLine")) continue;
                        NodeList nodeList4 = transactionLineElement.getChildNodes();
                        for (int m = 0; m < nodeList3.getLength(); ++m) {
                            Node node4 = nodeList4.item(m);
                            if (node4.getNodeType() != 1) continue;
                            Element el = (Element)node4;
                            super.loadGlenixXBRL(loadDoc, el);
                        }
                    }
                }
            }
        }
    }

    public void setImportDataElement(List<Transaction.TransactionTransactionLine> transactionTransactionLineList, Transaction.TransactionTransactionLine importDataTransactionTransactionLine, ImportData importData) throws Exception {
        this.transactionTransactionLineList = transactionTransactionLineList;
        this.importDataTransactionTransactionLine = importDataTransactionTransactionLine;
        this.transaction = importDataTransactionTransactionLine == null ? null : importDataTransactionTransactionLine.getTransaction();
        if (importData == null) {
            this.clearImportDataElement();
            return;
        }
        this.importData = importData;
    }

    public void clearImportDataElement() {
        this.importData = null;
    }

    @FXML
    private void saveImportData() {
        try {
            Document resultDoc = this.dBuilder.newDocument();
            super.buildGlenixXBRL(resultDoc, null);
            if (this.transaction == null) {
                try {
                    this.transaction = this.applicationController.addTransaction();
                    TransactionLine tl = this.transaction.addBlankTransactionLine();
                    this.importData = tl.getOrAddImportData();
                    this.importData.loadDocumentElement(resultDoc, resultDoc.getDocumentElement());
                    this.applicationController.addImportDataTransaction(this.transaction);
                }
                catch (Exception e) {
                    this.transaction = null;
                    throw e;
                }
            } else {
                this.importData.loadDocumentElement(resultDoc, resultDoc.getDocumentElement());
            }
            this.applicationController.saveImportData(this.transaction);
            this.error_message.setText("Saved");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.applicationController.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    public void clearImportData() {
        this.clearGlenixXBRL();
        this.clearImportDataElement();
        this.error_message.setText("New import data");
    }

    @FXML
    private void gotoImportDataList() {
        this.applicationController.gotoImportDataList();
    }

    @FXML
    private void gotoImportDataTransactions() {
        try {
            this.applicationController.gotoImportDataTransactionsE(null, this.transactionList, this.transaction);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.applicationController.setStatusBarMessage(e.getMessage());
        }
    }
}

