/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import au.com.glenix.ApplicationController;
import au.com.glenix.trn.GlenixTrnXBRL;
import au.com.glenix.widget.GlenixBranchController;
import java.io.File;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import org.w3c.dom.Document;

public class ImportDataController
extends GlenixBranchController {
    @FXML
    private Label error_message;
    @FXML
    private Label filename;
    private GlenixTrnXBRL glenixTrnXBRL;
    File file;
    private ApplicationController xbrlFileController = null;

    public ImportDataController(ApplicationController xbrlFileController) {
        this.xbrlFileController = xbrlFileController;
    }

    public void setModel(GlenixTrnXBRL glenixTrnXBRL) throws Exception {
        Document doc;
        this.glenixTrnXBRL = glenixTrnXBRL;
        if (glenixTrnXBRL != null && (doc = glenixTrnXBRL.buildDocument()) != null) {
            this.loadGlenixXBRL(doc, doc.getDocumentElement());
        }
    }

    @FXML
    public void openFile() {
        try {
            this.file = this.xbrlFileController.openImportFile();
            this.filename.setText(this.file.getAbsolutePath());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @FXML
    public void importDataNow() {
        try {
            if (this.file == null) {
                throw new Exception("Error, you have not yet opened the xbrlgl import file.");
            }
            this.error_message.setText("Processing...");
            String filenameStr = this.file.getName();
            if (filenameStr.endsWith(".xbrlgl")) {
                this.xbrlFileController.importFasV2ExportFile(this.file);
            } else if (filenameStr.endsWith(".fas")) {
                this.xbrlFileController.importFasFile(this.file);
            } else {
                if (!filenameStr.endsWith(".xml")) throw new Exception("Error, unknown file type. Must be .xbrlgl, .fas, .xml");
                if (filenameStr.equals("transactions.xml")) {
                    this.xbrlFileController.importXmlFile_transactions(this.file);
                } else if (filenameStr.equals("account.xml")) {
                    this.xbrlFileController.importXmlFile_account(this.file);
                } else if (filenameStr.equals("provision.xml")) {
                    this.xbrlFileController.importXmlFile_provision(this.file);
                } else if (filenameStr.equals("batch.xml")) {
                    this.xbrlFileController.importXmlFile_batch(this.file);
                } else if (filenameStr.equals("counterparty.xml")) {
                    this.xbrlFileController.importXmlFile_counterparty(this.file);
                } else if (filenameStr.equals("activityStatementList.xml")) {
                    this.xbrlFileController.importXmlFile_activityStatementList(this.file);
                } else {
                    if (!filenameStr.startsWith("activityStatement_")) throw new Exception("Error, xml file name invalid");
                    String asNumber = filenameStr.replaceFirst("activityStatement_", "");
                    asNumber = asNumber.replaceFirst(".xml", "");
                    this.xbrlFileController.importXmlFile_activityStatement(this.file, asNumber);
                }
            }
            this.error_message.setText("Import complete");
            this.file = null;
            this.filename.setText(null);
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }
}

