/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import au.com.glenix.ApplicationController;
import au.com.glenix.trn.Business;
import au.com.glenix.trn.GlenixTrnXBRL;
import au.com.glenix.trn.HomeOffice;
import au.com.glenix.trn.Transaction;
import au.com.glenix.trn.TransactionLine;
import au.com.glenix.widget.GlenixBranchController;
import au.com.glenix.widget.GlenixPDFWrapper;
import au.com.glenix.widget.GlenixPDFWrapperNewPageCallback;
import java.net.URL;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HomeOfficeListController
extends GlenixBranchController
implements GlenixPDFWrapperNewPageCallback {
    @FXML
    private TableView homeOfficeTable;
    @FXML
    private Label error_message;
    @FXML
    private Label page_heading;
    @FXML
    private TableColumn homeOfficeFullAddress;
    @FXML
    private TableColumn homeOfficeStartDate;
    @FXML
    private TableColumn homeOfficeEndDate;
    private ApplicationController xbrlFileController = null;
    private GlenixTrnXBRL glenixTrnXBRL = null;
    private ObservableList<Transaction> transactionObservableList;

    public HomeOfficeListController(ApplicationController xbrlFileController) {
        this.xbrlFileController = xbrlFileController;
    }

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        this.homeOfficeTable.setRowFactory(tv -> {
            TableRow row = new TableRow();
            row.setOnMouseClicked(event -> {
                if (event.getClickCount() == 2) {
                    if (!row.isEmpty()) {
                        Transaction transaction = (Transaction)row.getItem();
                        if (transaction != null) {
                            TransactionLine line = transaction.getFirstTransactionLine();
                            if (line != null) {
                                HomeOffice p = line.getHomeOffice();
                                if (p != null) {
                                    try {
                                        this.xbrlFileController.gotoHomeOfficeEdit(p);
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                        this.error_message.setText("Error, could not go to home office page.");
                                    }
                                } else {
                                    this.error_message.setText("Error, could not get home office.");
                                }
                            } else {
                                this.error_message.setText("Error, could not get home office.");
                            }
                        } else {
                            this.error_message.setText("Error, could not get home office.");
                        }
                    } else {
                        this.addHomeOffice();
                    }
                }
            });
            return row;
        });
        this.homeOfficeTable.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
    }

    @Override
    public void buildGlenixXBRL(Document resultDoc, Element resultElement) throws Exception {
        Element xbrlEl = resultDoc.createElementNS("http://www.glenix.com.au/", "gx:glenix");
        if (resultElement == null) {
            resultDoc.appendChild(xbrlEl);
        } else {
            resultElement.appendChild(xbrlEl);
        }
        Element businessEl = resultDoc.createElementNS("http://www.glenix.com.au/", "gx:business");
        xbrlEl.appendChild(businessEl);
        Element transactionEl = resultDoc.createElementNS("http://www.glenix.com.au/", "gx:transaction");
        businessEl.appendChild(transactionEl);
        Element transactionLineEl = resultDoc.createElementNS("http://www.glenix.com.au/", "gx:transactionLine");
        transactionEl.appendChild(transactionLineEl);
        super.buildGlenixXBRL(resultDoc, transactionLineEl);
    }

    @Override
    public void loadGlenixXBRL(Document loadDoc, Element loadElement) throws Exception {
        if (loadElement.getNamespaceURI() != null && loadElement.getNamespaceURI().equals("http://www.glenix.com.au/") && loadElement.getLocalName() != null && loadElement.getLocalName().equals("glenix")) {
            NodeList nodeList = loadElement.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element businessElement;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || (businessElement = (Element)node).getNamespaceURI() == null || !businessElement.getNamespaceURI().equals("http://www.glenix.com.au/") || businessElement.getLocalName() == null || !businessElement.getLocalName().equals("business")) continue;
                NodeList nodeList2 = businessElement.getChildNodes();
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    Element transactionElement;
                    Node node2 = nodeList2.item(j);
                    if (node2.getNodeType() != 1 || (transactionElement = (Element)node2).getNamespaceURI() == null || !transactionElement.getNamespaceURI().equals("http://www.glenix.com.au/") || transactionElement.getLocalName() == null || !transactionElement.getLocalName().equals("transaction")) continue;
                    NodeList nodeList3 = transactionElement.getChildNodes();
                    for (int k = 0; k < nodeList3.getLength(); ++k) {
                        Element transactionLineElement;
                        Node node3 = nodeList3.item(k);
                        if (node3.getNodeType() != 1 || (transactionLineElement = (Element)node3).getNamespaceURI() == null || !transactionLineElement.getNamespaceURI().equals("http://www.glenix.com.au/") || transactionLineElement.getLocalName() == null || !transactionLineElement.getLocalName().equals("transactionLine")) continue;
                        NodeList nodeList4 = transactionLineElement.getChildNodes();
                        for (int m = 0; m < nodeList4.getLength(); ++m) {
                            Node node4 = nodeList4.item(m);
                            if (node4.getNodeType() != 1) continue;
                            Element el = (Element)node4;
                            super.loadGlenixXBRL(loadDoc, el);
                        }
                    }
                }
            }
        }
    }

    @FXML
    private void addHomeOffice() {
        try {
            this.xbrlFileController.gotoHomeOfficeEdit(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText("Error, could not load home office edit page.");
        }
    }

    public void setModel(GlenixTrnXBRL glenixTrnXBRL) throws Exception {
        this.glenixTrnXBRL = glenixTrnXBRL;
        if (glenixTrnXBRL != null) {
            Document doc = glenixTrnXBRL.buildDocument();
            if (doc != null) {
                this.loadGlenixXBRL(doc, doc.getDocumentElement());
            }
            this.setHomeOfficeObservableList();
        }
        this.page_heading.setText("Home office list - " + this.xbrlFileController.getBusinessLegalName());
    }

    private void setHomeOfficeObservableList() {
        Business business = this.glenixTrnXBRL.getBusiness();
        if (business == null) {
            return;
        }
        ArrayList<Transaction> transactionArrayList = business.getTransactionArrayList();
        this.transactionObservableList = FXCollections.observableList(transactionArrayList);
        this.homeOfficeTable.setItems(this.transactionObservableList);
    }

    public void refreshTable() {
        this.setHomeOfficeObservableList();
        this.homeOfficeTable.refresh();
    }

    @FXML
    private void deleteSelectedHomeOffices() {
        try {
            ObservableList selectedHomeOfficeTransactions = this.homeOfficeTable.getSelectionModel().getSelectedItems();
            if (selectedHomeOfficeTransactions != null && selectedHomeOfficeTransactions.size() > 0) {
                this.xbrlFileController.deleteSelectedHomeOffices((ObservableList<Transaction>)selectedHomeOfficeTransactions);
            } else {
                String message = "Error, there are no selected home office(s) to delete.";
                this.xbrlFileController.setStatusBarMessage(message);
                this.error_message.setText(message);
            }
            this.refreshTable();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @Override
    public GlenixPDFWrapper buildPDF(boolean includeBlanks) throws Exception {
        GlenixPDFWrapper gpw = new GlenixPDFWrapper();
        gpw.addPDPage();
        gpw.setColumns(5);
        gpw.setColumnLeftPosAndWidthMM(0, 20.0, 180.0);
        gpw.setColumnLeftPosAndWidthMM(1, 20.0, 180.0);
        gpw.setColumnLeftPosAndWidthMM(2, 20.0, 100.0);
        gpw.setColumnLeftPosAndWidthMM(3, 120.0, 40.0);
        gpw.setColumnLeftPosAndWidthMM(4, 160.0, 40.0);
        gpw.setColumnFont(0, gpw.muliBoldFont);
        gpw.setColumnFont(1, gpw.muliLightFont);
        gpw.setColumnFont(2, gpw.muliLightFont);
        gpw.setColumnFont(3, gpw.muliLightFont);
        gpw.setColumnFont(4, gpw.muliLightFont);
        Double fontSize = this.convertFontSize(this.page_heading.getFont().getSize());
        gpw.prepareString(0, this.page_heading.getText(), true, fontSize);
        gpw.drawStrings(10.0);
        fontSize = this.convertFontSize(new Double(this.xbrlFileController.getCurrentFontSize()));
        this.drawPDFColumnHeadings(gpw);
        gpw.setAddPageCallback(this);
        for (Transaction t : this.transactionObservableList) {
            gpw.prepareString(2, t.getHomeOfficeFullAddress(), true, fontSize);
            gpw.prepareString(3, t.getHomeOfficeStartDate(), true, fontSize);
            gpw.prepareString(4, t.getHomeOfficeEndDate(), true, fontSize);
            gpw.drawStrings(5.0);
        }
        gpw.addFooter();
        return gpw;
    }

    private void drawPDFColumnHeadings(GlenixPDFWrapper gpw) throws Exception {
        gpw.setColumnFont(2, gpw.muliBoldFont);
        gpw.setColumnFont(3, gpw.muliBoldFont);
        gpw.setColumnFont(4, gpw.muliBoldFont);
        Double fontSize = this.convertFontSize(new Double(this.xbrlFileController.getCurrentFontSize()));
        gpw.prepareString(2, this.homeOfficeFullAddress.getText(), true, fontSize);
        gpw.prepareString(3, this.homeOfficeStartDate.getText(), true, fontSize);
        gpw.prepareString(4, this.homeOfficeEndDate.getText(), true, fontSize);
        gpw.drawStrings(5.0);
        gpw.setColumnFont(2, gpw.muliLightFont);
        gpw.setColumnFont(3, gpw.muliLightFont);
        gpw.setColumnFont(4, gpw.muliLightFont);
    }

    @Override
    public void newPDFPageAdded(GlenixPDFWrapper gpw) throws Exception {
        this.drawPDFColumnHeadings(gpw);
    }
}

