/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import au.com.glenix.ApplicationController;
import au.com.glenix.GlenixLabelAccountCombo;
import au.com.glenix.trn.HomeOffice;
import au.com.glenix.trn.Transaction;
import au.com.glenix.trn.TransactionLine;
import au.com.glenix.widget.GlenixBranchController;
import au.com.glenix.widget.GlenixLabelDate;
import au.com.glenix.widget.GlenixLabelTwoDecimalPositiveAmountTR;
import au.com.glenix.widget.GlenixLabelTwoDecimalPositiveNumber;
import java.math.RoundingMode;
import java.net.URL;
import java.text.DecimalFormat;
import java.time.LocalDate;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HomeOfficeEditController
extends GlenixBranchController {
    @FXML
    private Label error_message;
    @FXML
    private GlenixLabelTwoDecimalPositiveNumber homeOfficeHoursUsagePerWeek;
    @FXML
    private GlenixLabelTwoDecimalPositiveNumber homeOfficeTotalHoursUsage;
    @FXML
    private GlenixLabelTwoDecimalPositiveAmountTR calculatedAmount;
    @FXML
    private GlenixLabelAccountCombo expenseAccount;
    @FXML
    private GlenixLabelDate homeOfficeStartDate;
    @FXML
    private GlenixLabelDate homeOfficeEndDate;
    @FXML
    private GlenixLabelTwoDecimalPositiveNumber homeOfficeWeeksUnused;
    private DecimalFormat df;
    private ApplicationController applicationController = null;
    private DocumentBuilder dBuilder;
    private HomeOffice homeOffice = null;
    private Transaction transaction = null;
    private boolean disableUpdates = false;

    public HomeOfficeEditController(ApplicationController applicationController) {
        this.applicationController = applicationController;
    }

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setNamespaceAware(true);
            this.dBuilder = dbFactory.newDocumentBuilder();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.applicationController.setStatusBarMessage(e.getMessage());
        }
        this.df = new DecimalFormat("#.##");
        this.df.setRoundingMode(RoundingMode.HALF_UP);
        this.homeOfficeHoursUsagePerWeek.setSingleChangeListener(new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                HomeOfficeEditController.this.updateTotalFromWeek();
            }
        });
        this.homeOfficeTotalHoursUsage.setSingleChangeListener(new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                HomeOfficeEditController.this.updateWeekFromTotal();
            }
        });
        this.homeOfficeStartDate.setSingleDateChangeListener(new ChangeListener<LocalDate>(){

            public void changed(ObservableValue<? extends LocalDate> observable, LocalDate oldValue, LocalDate newValue) {
                HomeOfficeEditController.this.updateTotalFromWeek();
            }
        });
        this.homeOfficeEndDate.setSingleDateChangeListener(new ChangeListener<LocalDate>(){

            public void changed(ObservableValue<? extends LocalDate> observable, LocalDate oldValue, LocalDate newValue) {
                HomeOfficeEditController.this.updateTotalFromWeek();
            }
        });
        this.homeOfficeWeeksUnused.setSingleChangeListener(new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                HomeOfficeEditController.this.updateTotalFromWeek();
            }
        });
    }

    private void updateAmount(Double totalHours) {
        if (totalHours <= 0.0) {
            this.calculatedAmount.setGlenixElementValue(null);
            return;
        }
        LocalDate startDate = this.homeOfficeStartDate.getLocalDate();
        if (startDate == null) {
            this.calculatedAmount.setGlenixElementValue(null);
            return;
        }
        Double rate = 0.45;
        LocalDate july2014 = LocalDate.parse("2014-07-01");
        if (startDate.isBefore(july2014)) {
            LocalDate july2010 = LocalDate.parse("2010-07-01");
            if (startDate.isBefore(july2010)) {
                this.calculatedAmount.setGlenixElementValue(null);
                return;
            }
            rate = 0.34;
        }
        Double amt = rate * totalHours;
        this.calculatedAmount.setGlenixElementValue(this.df.format(amt));
    }

    private void updateTotalFromWeek() {
        Double weeksUsed;
        LocalDate ledgerEndDate;
        if (this.disableUpdates) {
            return;
        }
        this.disableUpdates = true;
        Double weekHours = this.homeOfficeHoursUsagePerWeek.getDouble();
        if (weekHours == null || weekHours <= 0.0) {
            this.homeOfficeTotalHoursUsage.setGlenixElementValue(null);
            this.calculatedAmount.setGlenixElementValue(null);
            this.disableUpdates = false;
            return;
        }
        LocalDate startDate = this.homeOfficeStartDate.getLocalDate();
        LocalDate endDate = this.homeOfficeEndDate.getLocalDate();
        if (startDate == null || endDate == null || endDate.isBefore(startDate)) {
            this.homeOfficeTotalHoursUsage.setGlenixElementValue(null);
            this.calculatedAmount.setGlenixElementValue(null);
            this.disableUpdates = false;
            return;
        }
        LocalDate ledgerStartDate = this.applicationController.getLedgerStartDateAsDate();
        if (startDate.isBefore(ledgerStartDate)) {
            this.homeOfficeStartDate.setLocalDate(ledgerStartDate);
            startDate = ledgerStartDate;
        }
        if (endDate.isAfter(ledgerEndDate = this.applicationController.getLedgerEndDateAsDate())) {
            this.homeOfficeEndDate.setLocalDate(ledgerEndDate);
            endDate = ledgerEndDate;
        }
        long days = endDate.toEpochDay() - startDate.toEpochDay();
        Double weeksUnused = this.homeOfficeWeeksUnused.getDouble();
        if (weeksUnused == null) {
            weeksUnused = 0.0;
        }
        if ((weeksUsed = Double.valueOf((double)days / 7.0 - weeksUnused)) <= 0.0) {
            this.homeOfficeTotalHoursUsage.setGlenixElementValue(null);
            this.calculatedAmount.setGlenixElementValue(null);
            this.disableUpdates = false;
            return;
        }
        Double totalHours = weeksUsed * weekHours;
        this.homeOfficeTotalHoursUsage.setGlenixElementValue(this.df.format(totalHours));
        this.updateAmount(totalHours);
        this.disableUpdates = false;
    }

    private void updateWeekFromTotal() {
        Double weeksUsed;
        LocalDate ledgerEndDate;
        if (this.disableUpdates) {
            return;
        }
        this.disableUpdates = true;
        Double totalHours = this.homeOfficeTotalHoursUsage.getDouble();
        if (totalHours == null || totalHours <= 0.0) {
            this.homeOfficeHoursUsagePerWeek.setGlenixElementValue(null);
            this.calculatedAmount.setGlenixElementValue(null);
            this.disableUpdates = false;
            return;
        }
        LocalDate startDate = this.homeOfficeStartDate.getLocalDate();
        LocalDate endDate = this.homeOfficeEndDate.getLocalDate();
        if (startDate == null || endDate == null || endDate.isBefore(startDate)) {
            this.homeOfficeHoursUsagePerWeek.setGlenixElementValue(null);
            this.calculatedAmount.setGlenixElementValue(null);
            this.disableUpdates = false;
            return;
        }
        LocalDate ledgerStartDate = this.applicationController.getLedgerStartDateAsDate();
        if (startDate.isBefore(ledgerStartDate)) {
            this.homeOfficeStartDate.setLocalDate(ledgerStartDate);
            startDate = ledgerStartDate;
        }
        if (endDate.isAfter(ledgerEndDate = this.applicationController.getLedgerEndDateAsDate())) {
            this.homeOfficeEndDate.setLocalDate(ledgerEndDate);
            endDate = ledgerEndDate;
        }
        long days = endDate.toEpochDay() - startDate.toEpochDay();
        Double weeksUnused = this.homeOfficeWeeksUnused.getDouble();
        if (weeksUnused == null) {
            weeksUnused = 0.0;
        }
        if ((weeksUsed = Double.valueOf((double)days / 7.0 - weeksUnused)) <= 0.0) {
            this.homeOfficeHoursUsagePerWeek.setGlenixElementValue(null);
            this.calculatedAmount.setGlenixElementValue(null);
            this.disableUpdates = false;
            return;
        }
        Double weekHours = totalHours / weeksUsed;
        this.homeOfficeHoursUsagePerWeek.setGlenixElementValue(this.df.format(totalHours));
        this.updateAmount(totalHours);
        this.disableUpdates = false;
    }

    @Override
    public void buildGlenixXBRL(Document resultDoc, Element resultElement) throws Exception {
        Element xbrlEl = resultDoc.createElementNS("http://www.glenix.com.au/", "gx:glenix");
        if (resultElement == null) {
            resultDoc.appendChild(xbrlEl);
        } else {
            resultElement.appendChild(xbrlEl);
        }
        Element businessEl = resultDoc.createElementNS("http://www.glenix.com.au/", "gx:business");
        xbrlEl.appendChild(businessEl);
        Element transactionEl = resultDoc.createElementNS("http://www.glenix.com.au/", "gx:transaction");
        businessEl.appendChild(transactionEl);
        Element transactionLineEl = resultDoc.createElementNS("http://www.glenix.com.au/", "gx:transactionLine");
        transactionEl.appendChild(transactionLineEl);
        super.buildGlenixXBRL(resultDoc, transactionLineEl);
    }

    @Override
    public void loadGlenixXBRL(Document loadDoc, Element loadElement) throws Exception {
        this.disableUpdates = true;
        if (loadElement.getNamespaceURI() != null && loadElement.getNamespaceURI().equals("http://www.glenix.com.au/") && loadElement.getLocalName() != null && loadElement.getLocalName().equals("glenix")) {
            NodeList nodeList = loadElement.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element businessElement;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || (businessElement = (Element)node).getNamespaceURI() == null || !businessElement.getNamespaceURI().equals("http://www.glenix.com.au/") || businessElement.getLocalName() == null || !businessElement.getLocalName().equals("business")) continue;
                NodeList nodeList2 = businessElement.getChildNodes();
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    Element transactionElement;
                    Node node2 = nodeList2.item(j);
                    if (node2.getNodeType() != 1 || (transactionElement = (Element)node2).getNamespaceURI() == null || !transactionElement.getNamespaceURI().equals("http://www.glenix.com.au/") || transactionElement.getLocalName() == null || !transactionElement.getLocalName().equals("transaction")) continue;
                    NodeList nodeList3 = transactionElement.getChildNodes();
                    for (int k = 0; k < nodeList3.getLength(); ++k) {
                        Element transactionLineElement;
                        Node node3 = nodeList3.item(k);
                        if (node3.getNodeType() != 1 || (transactionLineElement = (Element)node3).getNamespaceURI() == null || !transactionLineElement.getNamespaceURI().equals("http://www.glenix.com.au/") || transactionLineElement.getLocalName() == null || !transactionLineElement.getLocalName().equals("transactionLine")) continue;
                        NodeList nodeList4 = transactionLineElement.getChildNodes();
                        for (int m = 0; m < nodeList3.getLength(); ++m) {
                            Node node4 = nodeList4.item(m);
                            if (node4.getNodeType() != 1) continue;
                            Element el = (Element)node4;
                            super.loadGlenixXBRL(loadDoc, el);
                        }
                    }
                }
            }
        }
        this.disableUpdates = false;
    }

    public void setHomeOfficeElement(HomeOffice homeOffice) throws Exception {
        if (homeOffice == null) {
            this.clearHomeOfficeElement();
            return;
        }
        this.homeOffice = homeOffice;
        String transactionNumber = homeOffice.getHomeOfficeTransactionNumber();
        if (transactionNumber != null && !transactionNumber.isEmpty()) {
            this.transaction = this.applicationController.getTransactionByTransactionNumber(transactionNumber);
            if (this.transaction != null) {
                TransactionLine tl = this.transaction.getFirstTransactionLine();
                String amountStr = null;
                String accountId = null;
                if (tl != null) {
                    amountStr = tl.getAmountString();
                    accountId = tl.getAccountIdentifier();
                }
                this.calculatedAmount.setGlenixElementValue(amountStr);
                this.expenseAccount.setGlenixElementValue(accountId);
            } else {
                this.calculatedAmount.setGlenixElementValue(null);
                this.expenseAccount.setGlenixElementValue(null);
            }
        } else {
            this.transaction = null;
            this.calculatedAmount.setGlenixElementValue(null);
            this.expenseAccount.setGlenixElementValue(null);
        }
    }

    public void clearHomeOfficeElement() {
        this.homeOffice = null;
        this.transaction = null;
    }

    public void setAccountList(ObservableList<Transaction> tol) {
        this.expenseAccount.setItems(tol);
    }

    @FXML
    private void saveHomeOffice() {
        try {
            Document resultDoc = this.dBuilder.newDocument();
            super.buildGlenixXBRL(resultDoc, null);
            if (this.homeOffice == null) {
                this.homeOffice = this.applicationController.addHomeOffice();
            }
            this.homeOffice.loadDocumentElement(resultDoc, resultDoc.getDocumentElement());
            String amountString = this.calculatedAmount.getGlenixElementValue();
            String accountIdentifierStr = this.expenseAccount.getGlenixElementValue();
            String endDateStr = this.homeOfficeEndDate.getGlenixElementValue();
            if (!(amountString == null || amountString.isEmpty() || accountIdentifierStr == null || accountIdentifierStr.isEmpty() || endDateStr == null || endDateStr.isEmpty())) {
                if (this.transaction == null) {
                    this.transaction = this.applicationController.addTransaction();
                }
                this.transaction.setTransactionType("cash_payment");
                this.transaction.setTransactionStatus("posted");
                this.transaction.setTransactionComment("Home office heating lighting cooling and depreciation of furniture for: \n" + this.homeOffice.getFullAddress());
                this.transaction.setTransactionDate(endDateStr);
                TransactionLine tl = this.transaction.getFirstTransactionLine();
                if (tl == null) {
                    tl = this.transaction.addBlankTransactionLine();
                }
                tl.setAmount(amountString);
                tl.setAccountIdentifier(accountIdentifierStr);
                tl.setQuantity(this.homeOfficeTotalHoursUsage.getDouble());
                tl.setHomeOfficeIdentifier(this.homeOffice.getHomeOfficeIdentifier());
                tl.setFullAmount(amountString);
                tl.setApportionmentMethod("direct");
            } else if (this.transaction != null) {
                this.transaction.setTransactionStatus("cancelled");
            }
            this.applicationController.saveHomeOffice(this.homeOffice, this.transaction);
            this.error_message.setText("Saved");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.applicationController.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    public void clearHomeOffice() {
        this.clearGlenixXBRL();
        this.clearHomeOfficeElement();
        this.error_message.setText("New home office");
    }

    @FXML
    private void gotoHomeOfficeList() {
        this.applicationController.gotoHomeOfficeList();
    }

    @FXML
    private void gotoHomeOfficeTransactions() {
        try {
            this.applicationController.gotoHomeOfficeTransactionsE(null, this.homeOffice);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.applicationController.setStatusBarMessage(e.getMessage());
        }
    }
}

