/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import au.com.glenix.widget.GlenixBranchController;
import au.com.glenix.widget.GlenixController;
import au.com.glenix.widget.GlenixLabelDateInterface;
import au.com.glenix.widget.GlenixLabelTimeInterface;
import java.net.URL;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ResourceBundle;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GlenixStartEndDateTimeController
extends GlenixBranchController {
    @FXML
    private GlenixLabelDateInterface startDate;
    @FXML
    private GlenixLabelTimeInterface startTime;
    @FXML
    private GlenixLabelTimeInterface endTime;
    @FXML
    private GlenixLabelTimeInterface breakTime;
    private ChangeListener<Integer> changeListener = null;
    private Integer lastNotifiedQuantity = null;
    private DateTimeFormatter outputDateTimeFormatter;
    private DateTimeFormatter inputDateTimeFormatter;
    private DateTimeFormatter breakTimeFormatter;

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        this.outputDateTimeFormatter = DateTimeFormatter.ISO_LOCAL_DATE_TIME;
        this.inputDateTimeFormatter = DateTimeFormatter.ISO_LOCAL_DATE_TIME;
        this.breakTimeFormatter = DateTimeFormatter.ISO_LOCAL_TIME;
        ChangeListener<String> cl = new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                GlenixStartEndDateTimeController.this.updateListener();
            }
        };
        this.startTime.setSingleChangeListener(cl);
        this.endTime.setSingleChangeListener(cl);
        this.breakTime.setSingleChangeListener(cl);
        this.startDate.setSingleDateChangeListener(new ChangeListener<LocalDate>(){

            public void changed(ObservableValue<? extends LocalDate> observable, LocalDate oldValue, LocalDate newValue) {
                GlenixStartEndDateTimeController.this.updateListener();
            }
        });
        this.breakTime.addTextChangeListener(cl);
    }

    public LocalDate getStartDate() {
        return this.startDate.getLocalDate();
    }

    public LocalTime getStartTime() {
        return this.startTime.getLocalTime();
    }

    public LocalTime getEndTime() {
        return this.endTime.getLocalTime();
    }

    public LocalDateTime getStartDateTime() {
        LocalDate sd = this.getStartDate();
        if (sd == null) {
            return null;
        }
        LocalTime st = this.getStartTime();
        if (st == null) {
            return null;
        }
        return LocalDateTime.of(sd, st);
    }

    public LocalDateTime getEndDateTime() {
        LocalTime st = this.getStartTime();
        if (st == null) {
            return null;
        }
        LocalTime et = this.getEndTime();
        if (et == null) {
            return null;
        }
        LocalDate sd = this.getStartDate();
        if (sd == null) {
            return null;
        }
        if (et.isAfter(st)) {
            return LocalDateTime.of(sd, et);
        }
        LocalDate ed = this.getStartDate().plusDays(1L);
        return LocalDateTime.of(ed, et);
    }

    public Integer calculateQuantitySeconds() {
        LocalDate sd = this.startDate.getLocalDate();
        LocalTime st = this.startTime.getLocalTime();
        LocalTime et = this.endTime.getLocalTime();
        LocalTime bt = this.breakTime.getLocalTime();
        if (sd == null || st == null || et == null || bt == null) {
            return null;
        }
        if (et.compareTo(st) > 0) {
            return 3600 * (et.getHour() - st.getHour()) + 60 * (et.getMinute() - st.getMinute()) + et.getSecond() - st.getSecond() - bt.getHour() * 3600 - bt.getMinute() * 60 - bt.getSecond();
        }
        return 86400 + 3600 * (et.getHour() - st.getHour()) + 60 * (et.getMinute() - st.getMinute()) + et.getSecond() - st.getSecond() - bt.getHour() * 3600 - bt.getMinute() * 60 - bt.getSecond();
    }

    public Double calculateQuantity() {
        Integer secs = this.calculateQuantitySeconds();
        if (secs == null) {
            return null;
        }
        return (double)secs.intValue() / 3600.0;
    }

    public void setQuantity(Double newQuantity) {
        if (newQuantity == null) {
            this.startDate.setLocalDate(null);
            this.startTime.setText(null);
            this.endTime.setText(null);
            this.breakTime.setText(null);
            return;
        }
        if (newQuantity < 0.0 || newQuantity > 24.0) {
            this.startDate.setLocalDate(null);
            this.startTime.setText(null);
            this.endTime.setText(null);
            this.breakTime.setText(null);
            return;
        }
        LocalDate sd = this.startDate.getLocalDate();
        LocalTime st = this.startTime.getLocalTime();
        LocalTime et = this.endTime.getLocalTime();
        if (sd == null || st == null) {
            return;
        }
        int break_seconds = 0;
        LocalTime bt = this.breakTime.getLocalTime();
        if (bt != null) {
            break_seconds = bt.getHour() * 3600 + bt.getMinute() * 60 + bt.getSecond();
        }
        int newQuantitySeconds = Double.valueOf(newQuantity * 3600.0).intValue();
        if (et == null) {
            if (break_seconds + newQuantitySeconds > 86400) {
                break_seconds = 86400 - newQuantitySeconds;
            }
            et = st.plusSeconds(newQuantitySeconds + break_seconds);
            this.endTime.setLocalTime(et);
            this.breakTime.setTimeBySeconds(break_seconds);
            return;
        }
        int duration = 0;
        duration = et.compareTo(st) > 0 ? 3600 * (et.getHour() - st.getHour()) + 60 * (et.getMinute() - st.getMinute()) + et.getSecond() - st.getSecond() : 86400 + 3600 * (et.getHour() - st.getHour()) + 60 * (et.getMinute() - st.getMinute()) + et.getSecond() - st.getSecond();
        break_seconds = duration - newQuantitySeconds;
        if (break_seconds < 0) {
            break_seconds = 0;
            LocalDateTime edt = LocalDateTime.of(sd, st);
            edt = edt.plusSeconds(newQuantitySeconds);
            this.endTime.setLocalTime(edt.toLocalTime());
            this.breakTime.setTimeBySeconds(break_seconds);
            return;
        }
        this.breakTime.setTimeBySeconds(break_seconds);
    }

    public void setStartDateTime(LocalDateTime ldt) {
        this.startDate.setLocalDate(ldt.toLocalDate());
        this.startTime.setLocalTime(ldt.toLocalTime());
    }

    public void setEndDateTime(LocalDateTime ldt) {
        this.endTime.setLocalTime(ldt.toLocalTime());
    }

    private void updateListener() {
        Integer quantity = this.calculateQuantitySeconds();
        if (quantity == null && this.lastNotifiedQuantity == null) {
            return;
        }
        LocalDate sd = this.startDate.getLocalDate();
        if (sd == null && this.startTime.glenixTextIsEmpty() && this.endTime.glenixTextIsEmpty() && this.breakTime.glenixTextIsEmpty() || quantity != null && !quantity.equals(this.lastNotifiedQuantity) || this.lastNotifiedQuantity != null && !this.lastNotifiedQuantity.equals(quantity)) {
            ReadOnlyObjectWrapper observableInteger = new ReadOnlyObjectWrapper((Object)quantity);
            this.changeListener.changed((ObservableValue)observableInteger, (Object)this.lastNotifiedQuantity, (Object)quantity);
            this.lastNotifiedQuantity = quantity;
        }
    }

    public void setSingleChangeListener(ChangeListener<Integer> changeListener) {
        this.changeListener = changeListener;
    }

    public LocalDateTime getStartLocalDateTime() {
        LocalDate sd = this.startDate.getLocalDate();
        LocalTime st = this.startTime.getLocalTime();
        if (sd == null || st == null) {
            return null;
        }
        return LocalDateTime.of(sd, st);
    }

    public LocalDateTime getEndLocalDateTime() {
        LocalDate sd = this.startDate.getLocalDate();
        LocalTime st = this.startTime.getLocalTime();
        LocalTime et = this.endTime.getLocalTime();
        if (sd == null || st == null || et == null) {
            return null;
        }
        if (et.compareTo(st) > 0) {
            return LocalDateTime.of(sd, et);
        }
        return LocalDateTime.of(sd.plusDays(1L), et);
    }

    public LocalTime getBreakLocalTime() {
        return this.breakTime.getLocalTime();
    }

    @Override
    public void buildGlenixXBRL(Document resultDoc, Element resultElement) {
        String namespace = "http://www.glenix.com.au/";
        String nsp = GlenixController.getNSP(namespace);
        Element el = resultDoc.createElementNS(namespace, nsp + ":startDateTime");
        LocalDateTime sdt = this.getStartLocalDateTime();
        if (sdt != null) {
            el.setTextContent(sdt.format(this.outputDateTimeFormatter));
        }
        resultElement.appendChild(el);
        el = resultDoc.createElementNS(namespace, nsp + ":endDateTime");
        LocalDateTime edt = this.getEndLocalDateTime();
        if (edt != null) {
            el.setTextContent(edt.format(this.outputDateTimeFormatter));
        }
        resultElement.appendChild(el);
        el = resultDoc.createElementNS(namespace, nsp + ":breakTime");
        LocalTime bt = this.getBreakLocalTime();
        if (bt != null) {
            el.setTextContent(bt.format(this.breakTimeFormatter));
        }
        resultElement.appendChild(el);
    }

    @Override
    public void loadGlenixXBRL(Document loadDoc, Element loadElement) {
        if (loadElement.getNamespaceURI() != null && loadElement.getNamespaceURI().equals("http://www.glenix.com.au/") && loadElement.getLocalName() != null && loadElement.getLocalName().equals("startDateTime")) {
            try {
                LocalDateTime startDateTime = LocalDateTime.parse(loadElement.getTextContent(), this.inputDateTimeFormatter);
                if (startDateTime != null) {
                    this.startDate.setLocalDate(startDateTime.toLocalDate());
                    this.startTime.setLocalTime(startDateTime.toLocalTime());
                }
            }
            catch (Exception startDateTime) {}
        } else if (loadElement.getNamespaceURI() != null && loadElement.getNamespaceURI().equals("http://www.glenix.com.au/") && loadElement.getLocalName() != null && loadElement.getLocalName().equals("endDateTime")) {
            try {
                LocalDateTime endDateTime = LocalDateTime.parse(loadElement.getTextContent(), this.inputDateTimeFormatter);
                if (endDateTime != null) {
                    this.endTime.setLocalTime(endDateTime.toLocalTime());
                }
            }
            catch (Exception endDateTime) {}
        } else if (loadElement.getNamespaceURI() != null && loadElement.getNamespaceURI().equals("http://www.glenix.com.au/") && loadElement.getLocalName() != null && loadElement.getLocalName().equals("breakTime")) {
            try {
                LocalTime breakLocalTime = LocalTime.parse(loadElement.getTextContent(), this.breakTimeFormatter);
                if (breakLocalTime != null) {
                    this.breakTime.setLocalTime(breakLocalTime);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

