/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import au.com.glenix.GlenixFile;
import au.com.glenix.GlenixMultiInputStream;
import au.com.glenix.GlenixSBREventItem;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class GlenixSBRResponse {
    private int responseCode;
    private Map<String, List<String>> headerFields;
    private String charset = "UTF-8";
    private String start = null;
    private String type = null;
    private String boundary = null;
    private GlenixMultiInputStream gmis = null;
    private GlenixFile glenixFile = null;
    private DocumentBuilder dBuilder = null;
    private Transformer transformer = null;
    private String timestamp = null;
    private String messageid = null;
    private String reftomessageid = null;
    private String partinfohref = null;
    private String receipt = null;
    private HashMap<String, String> cidMimeTypes = new HashMap();
    private HashMap<String, String> cidFilenames = new HashMap();
    private HashMap<String, String> cidDocumentNames = new HashMap();
    private HashMap<String, PartInfo> partInfoList = new HashMap();
    private String MaximumSeverity_Code = null;
    private HashMap<String, String> overallEvents = new HashMap();
    private ArrayList<SignalMessageError> signalMessageErrorList = new ArrayList();
    private String pemSignedPublicCertificate = null;
    Iterator<String> partInfoIterator = null;

    public GlenixSBRResponse(int responseCode, Map<String, List<String>> headerFields, InputStream responseInputStream, OutputStream logFileOutputStream) throws IOException, ParserConfigurationException, SAXException, TransformerConfigurationException, TransformerException, Exception {
        this.responseCode = responseCode;
        this.headerFields = headerFields;
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        dbFactory.setNamespaceAware(true);
        this.dBuilder = dbFactory.newDocumentBuilder();
        TransformerFactory tf = TransformerFactory.newInstance();
        this.transformer = tf.newTransformer();
        this.transformer.setOutputProperty("omit-xml-declaration", "no");
        this.transformer.setOutputProperty("method", "xml");
        this.transformer.setOutputProperty("encoding", "UTF-8");
        this.transformer.setOutputProperty("standalone", "yes");
        this.glenixFile = new GlenixFile(null, null);
        this.glenixFile.openTempFile();
        this.glenixFile.saveAndEncryptStream("response", responseInputStream, logFileOutputStream);
    }

    public void printResponse() {
        try {
            InputStream responseInputStream = this.glenixFile.readAndDecryptDataSource("response", null, null);
            byte[] bytes = new byte[2000];
            int readlen = 0;
            while ((readlen = responseInputStream.read(bytes)) > 0) {
                System.out.print("READ:" + new String(bytes));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void parseResponse() throws Exception {
        Set<String> keys = this.headerFields.keySet();
        Iterator<String> keystrit = keys.iterator();
        this.boundary = null;
        while (keystrit.hasNext()) {
            String keystr = keystrit.next();
            if (keystr == null || !keystr.equalsIgnoreCase("Content-Type")) continue;
            List<String> strlist = this.headerFields.get(keystr);
            for (int i = 0; i < strlist.size(); ++i) {
                String headerval = strlist.get(i);
                String[] parts = headerval.split(";");
                for (int j = 1; j < parts.length; ++j) {
                    String[] pp = parts[j].trim().split("=", 2);
                    if (pp.length != 2 || pp[0] == null) continue;
                    if (pp[0].equalsIgnoreCase("boundary")) {
                        this.boundary = pp[1];
                        continue;
                    }
                    if (pp[0].equalsIgnoreCase("type")) {
                        this.type = pp[1];
                        continue;
                    }
                    if (pp[0].equalsIgnoreCase("start")) {
                        this.start = pp[1];
                        continue;
                    }
                    if (!pp[0].equalsIgnoreCase("charset")) continue;
                    this.charset = pp[1];
                }
            }
        }
        if (this.boundary != null) {
            InputStream responseInputStream = this.glenixFile.readAndDecryptDataSource("response", null, null);
            this.boundary = this.boundary.replaceAll("^\"|\"$", "");
            byte[] boundarybytes = this.boundary.getBytes("UTF-8");
            byte[] boundaryplus = new byte[boundarybytes.length + 6];
            boundaryplus[0] = 13;
            boundaryplus[1] = 10;
            boundaryplus[2] = 45;
            boundaryplus[3] = 45;
            System.arraycopy(boundarybytes, 0, boundaryplus, 4, boundarybytes.length);
            boundaryplus[boundarybytes.length + 4] = 13;
            boundaryplus[boundarybytes.length + 5] = 10;
            this.gmis = new GlenixMultiInputStream(responseInputStream, boundaryplus, -1, "MAIN", true);
            byte[] buf = new byte[1000];
            while (!this.gmis.isClosed()) {
                String string;
                String mimeType;
                String documentName;
                int readlen;
                GlenixMultiInputStream gmishb = new GlenixMultiInputStream(this.gmis, "\r\n\r\n".getBytes("UTF-8"), 1, "HEADERBODY", false);
                String contentid = null;
                String charset = null;
                String contentType = null;
                while ((readlen = gmishb.readln(buf)) > 0) {
                    String headerval = new String(buf, 0, readlen);
                    String[] parts = headerval.split(":", 2);
                    if (parts.length != 2) continue;
                    String headerfield = parts[0].trim();
                    if (headerfield.equalsIgnoreCase("Content-ID")) {
                        contentid = parts[1].trim().replaceAll("^\"|\"$", "");
                        contentid = contentid.replaceAll("^<|>$", "");
                        continue;
                    }
                    if (!headerfield.equalsIgnoreCase("Content-Type")) continue;
                    String tmp = parts[1].trim().replaceAll("^\"|\"$", "");
                    String[] tmpparts = tmp.split(";");
                    for (int i = 0; i < tmpparts.length; ++i) {
                        String nameeqname;
                        String[] nameeq = tmpparts[i].split("=", 2);
                        if (nameeq.length == 1) {
                            contentType = nameeq[0];
                            continue;
                        }
                        if (nameeq.length != 2 || !(nameeqname = nameeq[0].trim()).equalsIgnoreCase("charset")) continue;
                        charset = nameeq[1].trim().replaceAll("^\"|\"$", "");
                    }
                }
                gmishb.nextBoundary();
                if (charset == null) {
                    charset = "UTF-8";
                }
                InputStreamReader reader = new InputStreamReader((InputStream)gmishb, charset);
                if (contentType != null && (contentType.trim().equalsIgnoreCase("application/soap+xml") || contentType.trim().equalsIgnoreCase("text/xml") && this.start != null && this.start.equalsIgnoreCase(contentid))) {
                    InputSource is = new InputSource(reader);
                    is.setEncoding(charset);
                    Document doc = this.dBuilder.parse(is);
                    this.process_start_document(doc);
                } else if (contentType != null && contentType.trim().equalsIgnoreCase("application/gzip")) {
                    documentName = this.cidDocumentNames.get("cid:" + contentid);
                    mimeType = this.cidMimeTypes.get("cid:" + contentid);
                    string = this.cidFilenames.get("cid:" + contentid);
                } else {
                    documentName = this.cidDocumentNames.get("cid:" + contentid);
                    mimeType = this.cidMimeTypes.get("cid:" + contentid);
                    string = this.cidFilenames.get("cid:" + contentid);
                }
                this.gmis.nextBoundary();
            }
        }
    }

    public void printDocument(Document doc, OutputStream out) throws IOException, TransformerException {
        this.transformer.transform(new DOMSource(doc), new StreamResult(new OutputStreamWriter(out, "UTF-8")));
    }

    public void process_EventMessage(Document doc, HashMap<String, GlenixSBREventItem> eventHash) {
        Element root = doc.getDocumentElement();
        if (root.getNodeType() == 1 && root.getNamespaceURI() != null && root.getNamespaceURI().equals("http://sbr.gov.au/comn/event.02.data") && root.getLocalName() != null && root.getLocalName().equals("Event")) {
            NodeList eventnl = root.getChildNodes();
            for (int eventi = 0; eventi < eventnl.getLength(); ++eventi) {
                Node event_child = eventnl.item(eventi);
                if (event_child.getNodeType() == 1 && event_child.getNamespaceURI() != null && event_child.getNamespaceURI().equals("http://sbr.gov.au/comn/event.02.data") && event_child.getLocalName() != null && event_child.getLocalName().equals("MaximumSeverity.Code")) {
                    this.MaximumSeverity_Code = event_child.getTextContent();
                }
                if (event_child.getNodeType() != 1 || event_child.getNamespaceURI() == null || !event_child.getNamespaceURI().equals("http://sbr.gov.au/comn/event.02.data") || event_child.getLocalName() == null || !event_child.getLocalName().equals("EventItems")) continue;
                NodeList eventitemsnl = event_child.getChildNodes();
                for (int eventitemsi = 0; eventitemsi < eventitemsnl.getLength(); ++eventitemsi) {
                    Node eventitems_child = eventitemsnl.item(eventitemsi);
                    if (eventitems_child.getNodeType() != 1 || eventitems_child.getNamespaceURI() == null || !eventitems_child.getNamespaceURI().equals("http://sbr.gov.au/comn/event.02.data") || eventitems_child.getLocalName() == null || !eventitems_child.getLocalName().equals("EventItem")) continue;
                    try {
                        GlenixSBREventItem gei = new GlenixSBREventItem((Element)eventitems_child);
                        eventHash.put(gei.getErrorCode(), gei);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public void process_start_document(Document doc) {
        Element root = doc.getDocumentElement();
        if (root.getNodeType() == 1 && root.getNamespaceURI() != null && root.getNamespaceURI().equals("http://www.w3.org/2003/05/soap-envelope") && root.getLocalName() != null && root.getLocalName().equals("Envelope")) {
            NodeList envelopenl = root.getChildNodes();
            for (int envelopei = 0; envelopei < envelopenl.getLength(); ++envelopei) {
                Node envelope_child = envelopenl.item(envelopei);
                if (envelope_child.getNodeType() != 1 || envelope_child.getNamespaceURI() == null || !envelope_child.getNamespaceURI().equals("http://www.w3.org/2003/05/soap-envelope") || envelope_child.getLocalName() == null || !envelope_child.getLocalName().equals("Header")) continue;
                NodeList headernl = envelope_child.getChildNodes();
                for (int headeri = 0; headeri < headernl.getLength(); ++headeri) {
                    Node header_child = headernl.item(headeri);
                    if (header_child.getNodeType() != 1 || header_child.getNamespaceURI() == null || !header_child.getNamespaceURI().equals("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/") || header_child.getLocalName() == null || !header_child.getLocalName().equals("Messaging")) continue;
                    NodeList messagingnl = header_child.getChildNodes();
                    for (int messagingi = 0; messagingi < messagingnl.getLength(); ++messagingi) {
                        Node messaging_child = messagingnl.item(messagingi);
                        if (messaging_child.getNodeType() != 1 || messaging_child.getNamespaceURI() == null || !messaging_child.getNamespaceURI().equals("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/") || messaging_child.getLocalName() == null || !messaging_child.getLocalName().equals("UserMessage") && !messaging_child.getLocalName().equals("SignalMessage")) continue;
                        NodeList usermessagenl = messaging_child.getChildNodes();
                        for (int usermessagei = 0; usermessagei < usermessagenl.getLength(); ++usermessagei) {
                            Node usermessage_child = usermessagenl.item(usermessagei);
                            if (usermessage_child.getNodeType() == 1 && usermessage_child.getNamespaceURI() != null && usermessage_child.getNamespaceURI().equals("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/") && usermessage_child.getLocalName() != null && usermessage_child.getLocalName().equals("MessageInfo")) {
                                NodeList messageinfonl = usermessage_child.getChildNodes();
                                for (int messageinfoi = 0; messageinfoi < messageinfonl.getLength(); ++messageinfoi) {
                                    Node messageinfo_child = messageinfonl.item(messageinfoi);
                                    if (messageinfo_child.getNodeType() != 1 || messageinfo_child.getNamespaceURI() == null || !messageinfo_child.getNamespaceURI().equals("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/")) continue;
                                    if (messageinfo_child.getLocalName() != null && messageinfo_child.getLocalName().equals("Timestamp")) {
                                        this.timestamp = messageinfo_child.getTextContent();
                                        continue;
                                    }
                                    if (messageinfo_child.getLocalName() != null && messageinfo_child.getLocalName().equals("MessageId")) {
                                        this.messageid = messageinfo_child.getTextContent();
                                        continue;
                                    }
                                    if (messageinfo_child.getLocalName() == null || !messageinfo_child.getLocalName().equals("RefToMessageId")) continue;
                                    this.reftomessageid = messageinfo_child.getTextContent();
                                }
                            }
                            if (messaging_child.getLocalName().equals("UserMessage")) {
                                if (usermessage_child.getNodeType() != 1 || usermessage_child.getNamespaceURI() == null || !usermessage_child.getNamespaceURI().equals("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/") || usermessage_child.getLocalName() == null || !usermessage_child.getLocalName().equals("PayloadInfo")) continue;
                                NodeList payloadinfonl = usermessage_child.getChildNodes();
                                for (int payloadinfoi = 0; payloadinfoi < payloadinfonl.getLength(); ++payloadinfoi) {
                                    Node payloadinfo_child = payloadinfonl.item(payloadinfoi);
                                    if (payloadinfo_child.getNodeType() != 1 || payloadinfo_child.getNamespaceURI() == null || !payloadinfo_child.getNamespaceURI().equals("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/") || payloadinfo_child.getLocalName() == null || !payloadinfo_child.getLocalName().equals("PartInfo")) continue;
                                    this.partinfohref = ((Element)payloadinfo_child).getAttribute("href");
                                    PartInfo partInfo = new PartInfo(this.partinfohref);
                                    NodeList partinfonl = payloadinfo_child.getChildNodes();
                                    for (int partinfoi = 0; partinfoi < partinfonl.getLength(); ++partinfoi) {
                                        Node partinfo_child = partinfonl.item(partinfoi);
                                        if (partinfo_child.getNodeType() != 1 || partinfo_child.getNamespaceURI() == null || !partinfo_child.getNamespaceURI().equals("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/") || partinfo_child.getLocalName() == null || !partinfo_child.getLocalName().equals("PartProperties")) continue;
                                        NodeList partpropertiesnl = partinfo_child.getChildNodes();
                                        for (int partpropertiesi = 0; partpropertiesi < partpropertiesnl.getLength(); ++partpropertiesi) {
                                            String name;
                                            Node partproperties_child = partpropertiesnl.item(partpropertiesi);
                                            if (partproperties_child.getNodeType() != 1 || partproperties_child.getNamespaceURI() == null || !partproperties_child.getNamespaceURI().equals("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/") || partproperties_child.getLocalName() == null || !partproperties_child.getLocalName().equals("Property") || (name = ((Element)partproperties_child).getAttribute("name")) == null) continue;
                                            String textContent = partproperties_child.getTextContent();
                                            partInfo.setProperty(name, textContent);
                                            if (name.equalsIgnoreCase("MimeType")) {
                                                this.cidMimeTypes.put(this.partinfohref, partproperties_child.getTextContent());
                                                continue;
                                            }
                                            if (name.equalsIgnoreCase("filename")) {
                                                this.cidFilenames.put(this.partinfohref, partproperties_child.getTextContent());
                                                continue;
                                            }
                                            if (!name.equalsIgnoreCase("DocumentName")) continue;
                                            this.cidDocumentNames.put(this.partinfohref, partproperties_child.getTextContent());
                                        }
                                    }
                                    this.partInfoList.put(this.partinfohref, partInfo);
                                }
                                continue;
                            }
                            if (!messaging_child.getLocalName().equals("SignalMessage") || usermessage_child.getNodeType() != 1 || usermessage_child.getNamespaceURI() == null || !usermessage_child.getNamespaceURI().equals("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/") || usermessage_child.getLocalName() == null) continue;
                            if (usermessage_child.getLocalName().equals("Receipt")) {
                                this.receipt = usermessage_child.getTextContent();
                                continue;
                            }
                            if (!usermessage_child.getLocalName().equals("Error")) continue;
                            SignalMessageError sme = new SignalMessageError();
                            sme.setCategory(((Element)usermessage_child).getAttribute("category"));
                            sme.setErrorCode(((Element)usermessage_child).getAttribute("errorCode"));
                            sme.setSeverity(((Element)usermessage_child).getAttribute("severity"));
                            NodeList errornl = usermessage_child.getChildNodes();
                            for (int errori = 0; errori < errornl.getLength(); ++errori) {
                                Node error_child = errornl.item(errori);
                                if (error_child.getNodeType() != 1 || error_child.getNamespaceURI() == null || !error_child.getNamespaceURI().equals("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/")) continue;
                                if (error_child.getLocalName() != null && error_child.getLocalName().equals("Description")) {
                                    sme.setDescription(error_child.getTextContent());
                                    continue;
                                }
                                if (error_child.getLocalName() == null || !error_child.getLocalName().equals("ErrorDetail")) continue;
                                sme.setErrorDetail(error_child.getTextContent());
                            }
                            this.signalMessageErrorList.add(sme);
                        }
                    }
                }
            }
        }
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public String getMessageId() {
        return this.messageid;
    }

    public String getRefToMessageId() {
        return this.reftomessageid;
    }

    public String getReceipt() {
        return this.receipt;
    }

    public InputStream getInputStreamByHref(String href) throws Exception {
        if (this.boundary == null) {
            throw new Exception("getInputStreamByHref: Boundary not set parseResponse first");
        }
        String seekContentId = href.replaceFirst("^cid:", "");
        InputStream responseInputStream = this.glenixFile.readAndDecryptDataSource("response", null, null);
        byte[] boundarybytes = this.boundary.getBytes("UTF-8");
        byte[] boundaryplus = new byte[boundarybytes.length + 6];
        boundaryplus[0] = 13;
        boundaryplus[1] = 10;
        boundaryplus[2] = 45;
        boundaryplus[3] = 45;
        System.arraycopy(boundarybytes, 0, boundaryplus, 4, boundarybytes.length);
        boundaryplus[boundarybytes.length + 4] = 13;
        boundaryplus[boundarybytes.length + 5] = 10;
        this.gmis = new GlenixMultiInputStream(responseInputStream, boundaryplus, -1, "MAIN", true);
        byte[] buf = new byte[1000];
        while (!this.gmis.isClosed() || this.gmis.available() > 0) {
            int readlen;
            GlenixMultiInputStream gmishb = new GlenixMultiInputStream(this.gmis, "\r\n\r\n".getBytes("UTF-8"), 1, "HEBO", false);
            String contentid = null;
            String charset = null;
            String contentType = null;
            while ((readlen = gmishb.readln(buf)) > 0) {
                String headerval = new String(buf, 0, readlen);
                String[] parts = headerval.split(":", 2);
                if (parts.length != 2) continue;
                String headerfield = parts[0].trim();
                if (headerfield.equalsIgnoreCase("Content-ID")) {
                    contentid = parts[1].trim().replaceAll("^\"|\"$", "");
                    contentid = contentid.replaceAll("^<|>$", "");
                    continue;
                }
                if (!headerfield.equalsIgnoreCase("Content-Type")) continue;
                String tmp = parts[1].trim().replaceAll("^\"|\"$", "");
                String[] tmpparts = tmp.split(";");
                for (int i = 0; i < tmpparts.length; ++i) {
                    String nameeqname;
                    String[] nameeq = tmpparts[i].split("=", 2);
                    if (nameeq.length == 1) {
                        contentType = nameeq[0];
                        continue;
                    }
                    if (nameeq.length != 2 || !(nameeqname = nameeq[0].trim()).equalsIgnoreCase("charset")) continue;
                    charset = nameeq[1].trim().replaceAll("^\"|\"$", "");
                }
            }
            gmishb.nextBoundary();
            if (contentid != null && contentid.equalsIgnoreCase(seekContentId)) {
                gmishb.setCloseMainOnClose(true);
                String compressionType = this.getPartProperty(href, "CompressionType");
                if (compressionType != null && compressionType.equals("application/gzip")) {
                    GZIPInputStream gzis = new GZIPInputStream(gmishb);
                    return gzis;
                }
                return gmishb;
            }
            if (charset == null) {
                charset = "UTF-8";
            }
            InputStreamReader reader = new InputStreamReader((InputStream)gmishb, charset);
            char[] tmpbuf = new char[20000];
            while ((readlen = reader.read(tmpbuf)) > 0) {
            }
            this.gmis.nextBoundary();
        }
        return null;
    }

    public Document getDocumentByHref(String href) throws Exception {
        InputStream is = this.getInputStreamByHref(href);
        if (is == null) {
            return null;
        }
        return this.dBuilder.parse(is);
    }

    public String getHrefByDocumentName(String documentName) {
        if (documentName == null) {
            return null;
        }
        Set<String> keys = this.partInfoList.keySet();
        for (String keystr : keys) {
            PartInfo partInfo = this.partInfoList.get(keystr);
            String piDocName = partInfo.getProperty("DocumentName");
            if (!documentName.equalsIgnoreCase(piDocName)) continue;
            return partInfo.href;
        }
        return null;
    }

    public InputStream getInputStreamByDocumentName(String documentName) throws Exception {
        String href = this.getHrefByDocumentName(documentName);
        if (href == null) {
            return null;
        }
        return this.getInputStreamByHref(href);
    }

    public Document getDocumentByDocumentName(String documentName) throws Exception {
        InputStream is = this.getInputStreamByDocumentName(documentName);
        if (is == null) {
            return null;
        }
        return this.dBuilder.parse(is);
    }

    public String getHrefByFilename(String filename) {
        if (filename == null) {
            return null;
        }
        Set<String> keys = this.partInfoList.keySet();
        for (String keystr : keys) {
            PartInfo partInfo = this.partInfoList.get(keystr);
            String piFilename = partInfo.getProperty("filename");
            if (!filename.equalsIgnoreCase(piFilename)) continue;
            return partInfo.href;
        }
        return null;
    }

    public InputStream getInputStreamByFilename(String filename) throws Exception {
        String href = this.getHrefByFilename(filename);
        if (href == null) {
            return null;
        }
        return this.getInputStreamByHref(href);
    }

    public Document getDocumentByFilename(String filename) throws Exception {
        InputStream is = this.getInputStreamByFilename(filename);
        if (is == null) {
            return null;
        }
        return this.dBuilder.parse(is);
    }

    public int getPartCount() {
        if (this.partInfoList == null) {
            return 0;
        }
        return this.partInfoList.size();
    }

    public void resetPartIterator() {
        this.partInfoIterator = this.partInfoList.keySet().iterator();
    }

    public boolean hasNextPart() {
        if (this.partInfoIterator == null) {
            return false;
        }
        return this.partInfoIterator.hasNext();
    }

    public String nextPartHref() {
        if (this.partInfoIterator == null) {
            return null;
        }
        return this.partInfoIterator.next();
    }

    public String getPartProperty(String href, String propertyName) {
        if (this.partInfoList == null) {
            return null;
        }
        PartInfo partInfo = this.partInfoList.get(href);
        if (partInfo == null) {
            return null;
        }
        return partInfo.getProperty(propertyName);
    }

    public int getSignalMessageErrorSize() {
        return this.signalMessageErrorList.size();
    }

    public String getSignalMessageCategory(int index) {
        return this.signalMessageErrorList.get(index).getCategory();
    }

    public String getSignalMessageErrorCode(int index) {
        return this.signalMessageErrorList.get(index).getErrorCode();
    }

    public String getSignalMessageSeverity(int index) {
        return this.signalMessageErrorList.get(index).getSeverity();
    }

    public String getSignalMessageDescription(int index) {
        return this.signalMessageErrorList.get(index).getDescription();
    }

    public String getSignalMessageErrorDetail(int index) {
        return this.signalMessageErrorList.get(index).getErrorDetail();
    }

    public class SignalMessageError {
        String category = null;
        String errorCode = null;
        String severity = null;
        String description = null;
        String errorDetail = null;

        public String getCategory() {
            return this.category;
        }

        public void setCategory(String value) {
            this.category = value;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String value) {
            this.errorCode = value;
        }

        public String getSeverity() {
            return this.severity;
        }

        public void setSeverity(String value) {
            this.severity = value;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String value) {
            this.description = value;
        }

        public String getErrorDetail() {
            return this.errorDetail;
        }

        public void setErrorDetail(String value) {
            this.errorDetail = value;
        }
    }

    static class PartInfo {
        private String href = null;
        private HashMap<String, String> propertyNameValueList = new HashMap();

        PartInfo(String href) {
            this.href = href;
        }

        void setProperty(String name, String value) {
            this.propertyNameValueList.put(name, value);
        }

        String getProperty(String name) {
            return this.propertyNameValueList.get(name);
        }
    }
}

