/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import au.com.glenix.GlenixSBRAttachment;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.zip.GZIPOutputStream;
import javax.xml.transform.TransformerConfigurationException;
import org.w3c.dom.Document;

public class GlenixSBRAttachmentGzip
extends GlenixSBRAttachment {
    protected byte[] zippedBytes = null;
    protected byte[] unzippedBytes = null;
    protected OutputStream ungzippedLogFileOS;

    public GlenixSBRAttachmentGzip(Document attachedDocument, String attachmentCID) throws TransformerConfigurationException, IOException, NoSuchAlgorithmException {
        super(attachedDocument, attachmentCID, null);
        this.setCompressionType("application/gzip");
        this.prepareGzipBytes();
        this.calcDigestBytes();
    }

    public GlenixSBRAttachmentGzip(InputStream inputStream, String attachmentCID) throws IOException, NoSuchAlgorithmException {
        super(inputStream, attachmentCID, null);
        this.setCompressionType("application/gzip");
        this.prepareGzipBytes();
        this.calcDigestBytes();
    }

    public void calcDigestBytes() throws NoSuchAlgorithmException {
        this.attachmentDigest = MessageDigest.getInstance("SHA-1");
        this.attachmentDigest.reset();
        this.attachmentDigest.update(this.zippedBytes);
    }

    public void prepareGzipBytes() throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ByteArrayOutputStream outputLog = new ByteArrayOutputStream();
        GZIPOutputStream gzipOs = new GZIPOutputStream(output);
        byte[] bs2 = new byte[1024];
        int readlen2 = 0;
        InputStream is = super.getInputStream();
        while ((readlen2 = is.read(bs2)) >= 0) {
            gzipOs.write(bs2, 0, readlen2);
            outputLog.write(bs2, 0, readlen2);
        }
        gzipOs.flush();
        gzipOs.close();
        outputLog.flush();
        outputLog.close();
        this.zippedBytes = output.toByteArray();
        this.unzippedBytes = outputLog.toByteArray();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.zippedBytes);
    }

    @Override
    public InputStream getLogInputStream() throws IOException {
        return new ByteArrayInputStream(this.unzippedBytes);
    }
}

