/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.security.MessageDigest;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;

public class GlenixSBRAttachment {
    protected Document attachedDocument = null;
    protected byte[] zippedData = null;
    protected String attachmentCID;
    protected MessageDigest attachmentDigest;
    protected Transformer transformer = null;
    protected String DocumentName = null;
    protected String DocumentType = null;
    protected String MimeType = "text/xml";
    protected String DocumentID = null;
    protected String RelatedDocumentID = null;
    protected String CompressionType = null;
    protected String Schema = null;
    protected String PartID = null;
    protected String filename = null;
    protected InputStream inputStream = null;

    public GlenixSBRAttachment(Document attachedDocument, String attachmentCID, MessageDigest attachmentDigest) throws TransformerConfigurationException {
        this.attachedDocument = attachedDocument;
        this.attachmentCID = attachmentCID;
        this.attachmentDigest = attachmentDigest;
        TransformerFactory tf = TransformerFactory.newInstance();
        this.transformer = tf.newTransformer();
        this.transformer.setOutputProperty("omit-xml-declaration", "yes");
        this.transformer.setOutputProperty("method", "xml");
        this.transformer.setOutputProperty("encoding", "UTF-8");
        this.transformer.setOutputProperty("standalone", "yes");
    }

    public GlenixSBRAttachment(InputStream inputStream, String attachmentCID, MessageDigest attachmentDigest) {
        this.attachmentCID = attachmentCID;
        this.attachmentDigest = attachmentDigest;
        this.inputStream = inputStream;
    }

    public GlenixSBRAttachment(byte[] zippedData, String attachmentCID, MessageDigest attachmentDigest) {
        this.attachedDocument = null;
        this.zippedData = zippedData;
        this.attachmentCID = attachmentCID;
        this.attachmentDigest = attachmentDigest;
    }

    public Document getAttachedDocument() {
        return this.attachedDocument;
    }

    public void setAttachedDocument(Document attachedDocument) {
        this.attachedDocument = attachedDocument;
    }

    public String getAttachmentCID() {
        return this.attachmentCID;
    }

    public void setAttachmentCID(String attachmentCID) {
        this.attachmentCID = attachmentCID;
    }

    public String getDocumentName() {
        return this.DocumentName;
    }

    public void setDocumentName(String DocumentName) {
        this.DocumentName = DocumentName;
    }

    public String getDocumentType() {
        return this.DocumentType;
    }

    public void setDocumentType(String DocumentType2) {
        this.DocumentType = DocumentType2;
    }

    public String getDocumentID() {
        return this.DocumentID;
    }

    public void setDocumentID(String DocumentID) {
        this.DocumentID = DocumentID;
    }

    public String getRelatedDocumentID() {
        return this.RelatedDocumentID;
    }

    public void setRelatedDocumentID(String RelatedDocumentID) {
        this.RelatedDocumentID = RelatedDocumentID;
    }

    public String getMimeType() {
        return this.MimeType;
    }

    public void setMimeType(String MimeType) {
        this.MimeType = MimeType;
    }

    public String getCompressionType() {
        return this.CompressionType;
    }

    public void setCompressionType(String CompressionType) {
        this.CompressionType = CompressionType;
    }

    public String getSchema() {
        return this.Schema;
    }

    public void setSchema(String Schema2) {
        this.Schema = Schema2;
    }

    public String getPartID() {
        return this.PartID;
    }

    public void setPartID(String PartID) {
        this.PartID = PartID;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public MessageDigest getAttachmentDigest() {
        return this.attachmentDigest;
    }

    public void setAttachmentDigest(MessageDigest attachmentDigest) {
        this.attachmentDigest = attachmentDigest;
    }

    public InputStream getInputStream() throws IOException {
        if (this.inputStream != null) {
            return this.inputStream;
        }
        if (this.zippedData != null) {
            return new ByteArrayInputStream(this.zippedData);
        }
        PipedInputStream attinpipe = new PipedInputStream();
        final PipedOutputStream attoutpipe = new PipedOutputStream(attinpipe);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    GlenixSBRAttachment.this.transformer.transform(new DOMSource(GlenixSBRAttachment.this.attachedDocument), new StreamResult(new OutputStreamWriter((OutputStream)attoutpipe, "UTF-8")));
                    attoutpipe.flush();
                    attoutpipe.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }).start();
        return attinpipe;
    }

    public InputStream getLogInputStream() throws IOException {
        return null;
    }
}

