/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import au.com.glenix.AgentDetailsNode;
import au.com.glenix.KeyPairNode;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GlenixProfileDocument {
    Document doc = null;
    Element node = null;
    String firstName = null;
    String otherGivenNames = null;
    String lastName = null;
    Node firstNameNode = null;
    Node otherGivenNamesNode = null;
    Node lastNameNode = null;
    AgentDetailsNode agentDetailsNode = null;
    KeyPairNode keyPairNode = null;

    public GlenixProfileDocument(Document doc) {
        this.setDocument(doc);
    }

    public GlenixProfileDocument() {
        this((Document)null);
    }

    public GlenixProfileDocument(InputStream is) throws Exception {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        dbFactory.setNamespaceAware(true);
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        this.doc = dBuilder.parse(is);
        this.setDocument(this.doc);
    }

    public void setDocument(Document doc) {
        this.doc = doc;
        if (doc == null) {
            return;
        }
        this.node = doc.getDocumentElement();
        if (this.node != null) {
            int i = 0;
            NodeList nodeList = this.node.getChildNodes();
            while (i < nodeList.getLength()) {
                Node xnode;
                if ((xnode = nodeList.item(i++)) == null || xnode.getNodeType() != 1) continue;
                if (xnode.getNamespaceURI().equals("http://www.glenix.com.au/") && xnode.getNodeName().equals("firstName")) {
                    this.firstName = xnode.getTextContent();
                    this.firstNameNode = xnode;
                    continue;
                }
                if (xnode.getNamespaceURI().equals("http://www.glenix.com.au/") && xnode.getNodeName().equals("otherGivenNames")) {
                    this.otherGivenNames = xnode.getTextContent();
                    this.otherGivenNamesNode = xnode;
                    continue;
                }
                if (xnode.getNamespaceURI().equals("http://www.glenix.com.au/") && xnode.getNodeName().equals("lastName")) {
                    this.lastName = xnode.getTextContent();
                    this.lastNameNode = xnode;
                    continue;
                }
                if (xnode.getNamespaceURI().equals("http://www.glenix.com.au/") && xnode.getNodeName().equals("agentDetails")) {
                    this.agentDetailsNode = new AgentDetailsNode(xnode);
                    continue;
                }
                if (!xnode.getNamespaceURI().equals("http://www.glenix.com.au/") || !xnode.getNodeName().equals("keyPair")) continue;
                this.keyPairNode = new KeyPairNode(xnode);
            }
        }
    }

    public AgentDetailsNode getAgentDetailsNode() {
        return this.agentDetailsNode;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
        if (this.firstNameNode != null) {
            this.firstNameNode.setTextContent(firstName);
        }
    }

    public String getOtherGivenNames() {
        return this.otherGivenNames;
    }

    public void setOtherGivenNames(String otherGivenNames) {
        this.otherGivenNames = otherGivenNames;
        if (this.otherGivenNamesNode != null) {
            this.otherGivenNamesNode.setTextContent(otherGivenNames);
        }
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
        if (this.lastNameNode != null) {
            this.lastNameNode.setTextContent(lastName);
        }
    }

    public String getAgentNumber() {
        if (this.agentDetailsNode == null) {
            return null;
        }
        return this.agentDetailsNode.getAgentNumber();
    }

    public void setAgentNumber(String agentNumber) {
        if (this.agentDetailsNode == null) {
            this.agentDetailsNode = new AgentDetailsNode();
        }
        this.agentDetailsNode.setAgentNumber(agentNumber);
    }

    public String getAgentABN() {
        if (this.agentDetailsNode == null) {
            return null;
        }
        return this.agentDetailsNode.getAgentABN();
    }

    public void setAgentABN(String agentABN) {
        if (this.agentDetailsNode == null) {
            this.agentDetailsNode = new AgentDetailsNode();
        }
        this.agentDetailsNode.setAgentABN(agentABN);
    }

    public String getAgentABNBranch() {
        if (this.agentDetailsNode == null) {
            return null;
        }
        return this.agentDetailsNode.getAgentABNBranch();
    }

    public void setAgentABNBranch(String agentABNBranch) {
        if (this.agentDetailsNode == null) {
            this.agentDetailsNode = new AgentDetailsNode();
        }
        this.agentDetailsNode.setAgentABNBranch(agentABNBranch);
    }

    public String getProtectedPrivateKey() {
        if (this.keyPairNode == null) {
            return null;
        }
        return this.keyPairNode.getProtectedPrivateKey();
    }

    public void setProtectedPrivateKey(String protectedPrivateKey) {
        if (this.keyPairNode == null) {
            this.keyPairNode = new KeyPairNode();
        }
        this.keyPairNode.setProtectedPrivateKey(protectedPrivateKey);
    }

    public String getPublicKey() {
        if (this.keyPairNode == null) {
            return null;
        }
        return this.keyPairNode.getPublicKey();
    }

    public void setPublicKey(String publicKey) {
        if (this.keyPairNode == null) {
            this.keyPairNode = new KeyPairNode();
        }
        this.keyPairNode.setPublicKey(publicKey);
    }

    public Document getDocument() throws Exception {
        if (this.doc != null) {
            return this.doc;
        }
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        dbFactory.setNamespaceAware(true);
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        this.doc = dBuilder.newDocument();
        this.node = this.doc.createElementNS("http://www.glenix.com.au/", "profile");
        this.doc.appendChild(this.node);
        if (this.firstName != null) {
            this.firstNameNode = this.doc.createElementNS("http://www.glenix.com.au/", "firstName");
            this.firstNameNode.setTextContent(this.firstName);
            this.node.appendChild(this.firstNameNode);
        }
        if (this.otherGivenNames != null) {
            this.otherGivenNamesNode = this.doc.createElementNS("http://www.glenix.com.au/", "otherGivenNames");
            this.otherGivenNamesNode.setTextContent(this.otherGivenNames);
            this.node.appendChild(this.otherGivenNamesNode);
        }
        if (this.lastName != null) {
            this.lastNameNode = this.doc.createElementNS("http://www.glenix.com.au/", "lastName");
            this.lastNameNode.setTextContent(this.lastName);
            this.node.appendChild(this.lastNameNode);
        }
        if (this.agentDetailsNode != null) {
            this.node.appendChild(this.agentDetailsNode.getNode(this.doc));
        }
        if (this.keyPairNode != null) {
            this.node.appendChild(this.keyPairNode.getNode(this.doc));
        }
        return this.doc;
    }
}

