/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import java.util.Iterator;
import javax.xml.crypto.NodeSetData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;

public class GlenixNodeSet
implements NodeSetData,
Iterator {
    private Node ivNode;
    private NodeFilter ivNodeFilter;
    private Document ivDocument;
    private DocumentTraversal ivDocumentTraversal;
    private NodeIterator ivNodeIterator;
    private Node ivNextNode;

    public GlenixNodeSet(Node pNode, NodeFilter pNodeFilter) throws Exception {
        this.ivNode = pNode;
        this.ivNodeFilter = pNodeFilter;
        this.ivDocument = this.ivNode instanceof Document ? (Document)this.ivNode : this.ivNode.getOwnerDocument();
        this.ivDocumentTraversal = (DocumentTraversal)((Object)this.ivDocument);
    }

    private GlenixNodeSet(NodeIterator pNodeIterator) {
        this.ivNodeIterator = pNodeIterator;
    }

    @Override
    public Iterator iterator() {
        NodeIterator nodeIterator = this.ivDocumentTraversal.createNodeIterator(this.ivNode, -1, this.ivNodeFilter, false);
        return new GlenixNodeSet(nodeIterator);
    }

    private Node checkNextNode() {
        if (this.ivNextNode == null && this.ivNodeIterator != null) {
            this.ivNextNode = this.ivNodeIterator.nextNode();
            if (this.ivNextNode == null) {
                this.ivNodeIterator.detach();
                this.ivNodeIterator = null;
            }
        }
        return this.ivNextNode;
    }

    private Node consumeNextNode() {
        Node nextNode = this.checkNextNode();
        this.ivNextNode = null;
        return nextNode;
    }

    @Override
    public boolean hasNext() {
        return this.checkNextNode() != null;
    }

    public Node next() {
        return this.consumeNextNode();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Removing nodes is not supported.");
    }

    public static NodeFilter getRootNodeFilter() {
        return new NodeFilter(){

            @Override
            public short acceptNode(Node pNode) {
                if (pNode instanceof Element && pNode.getParentNode() instanceof Document) {
                    return 3;
                }
                return 1;
            }
        };
    }
}

