/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import java.io.IOException;
import java.io.InputStream;

public class GlenixMultiInputStreamEventDelimited
extends InputStream {
    private InputStream is;
    private byte[] buffer = new byte[20000];
    private boolean closed = false;
    private int next = 0;
    private int last = -1;
    private int boundaryIndex = -1;
    private byte[] boundary;
    private boolean isStreamClosed = false;
    private int boundaryLimit = -1;
    private int foundBoundaryCount = 0;
    private String name = null;
    private boolean closeMainOnClose = false;

    public GlenixMultiInputStreamEventDelimited(InputStream is, int boundaryLimit, String name) throws IOException {
        this.is = is;
        this.boundaryLimit = boundaryLimit;
        int readlength = is.read(this.buffer);
        if (readlength > 0) {
            this.last += readlength;
        }
        this.boundary = "<Record_Delimiter".getBytes();
        this.boundaryIndex = this.boundaryIndexOf(0);
        this.name = name;
    }

    public int boundaryIndexOf(int start) {
        if (this.boundaryLimit == 0) {
            return -1;
        }
        block0: for (int i = start; i <= this.last - this.boundary.length + 1; ++i) {
            for (int j = 0; j <= this.boundary.length; ++j) {
                if (j == this.boundary.length) {
                    --this.boundaryLimit;
                    return i;
                }
                if (this.buffer[i + j] != this.boundary[j]) continue block0;
            }
        }
        return -1;
    }

    @Override
    public int available() throws IOException {
        if (this.boundaryIndex >= 0) {
            return this.boundaryIndex - this.next;
        }
        if (this.isClosed()) {
            return this.last - this.next + 1;
        }
        if (this.boundaryLimit != 0) {
            return this.last - this.next - this.boundary.length + 1;
        }
        return this.last - this.next + 1;
    }

    private void replenish() throws IOException {
        int readlength;
        if (this.isStreamClosed) {
            return;
        }
        if (this.next > 500 && this.last - this.next + 1 <= this.next) {
            System.arraycopy(this.buffer, this.next, this.buffer, 0, this.last - this.next + 1);
            this.last -= this.next;
            if (this.boundaryIndex >= 0) {
                this.boundaryIndex -= this.next;
            }
            this.next = 0;
        }
        if ((readlength = this.is.read(this.buffer, this.last + 1, 19999 - this.last)) >= 0) {
            int oldlast = this.last;
            this.last += readlength;
            if (this.boundaryIndex < 0) {
                this.boundaryIndex = oldlast + 2 - this.boundary.length > this.next ? (oldlast + 2 - this.boundary.length > this.last ? this.boundaryIndexOf(this.last) : this.boundaryIndexOf(oldlast + 2 - this.boundary.length)) : this.boundaryIndexOf(this.next);
            }
        } else {
            this.is.close();
            this.isStreamClosed = true;
        }
    }

    @Override
    public int read() throws IOException {
        if (this.next == this.boundaryIndex) {
            return -1;
        }
        if (this.last - this.boundary.length + 1 <= this.next) {
            this.replenish();
        }
        if (this.boundaryIndex >= 0) {
            return this.buffer[this.next++] & 0xFF;
        }
        if (this.boundaryLimit != 0 || this.boundaryIndex >= 0 ? this.last - this.boundary.length + 1 > this.next : this.last >= this.next) {
            return this.buffer[this.next++] & 0xFF;
        }
        System.out.println(this.name + " READING SINGLE CHAR!!! END SHOULD NOT HAPPEN");
        return -1;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.next >= 9999 || this.last - this.next + 1 <= this.boundary.length) {
            this.replenish();
        }
        if (this.boundaryIndex >= 0) {
            if (this.next >= this.boundaryIndex) {
                return -1;
            }
            if (len > this.boundaryIndex - this.next) {
                len = this.boundaryIndex - this.next;
            }
        } else if (this.boundaryLimit != 0) {
            if (!this.isClosed() && len > this.last - this.next + 1 - this.boundary.length) {
                len = this.last - this.next + 1 - this.boundary.length;
            } else if (this.isClosed() && len > this.last - this.next + 1) {
                len = this.last - this.next + 1;
            }
        } else if (len > this.last - this.next + 1) {
            len = this.last - this.next + 1;
        }
        if (len <= 0) {
            if (this.isClosed()) {
                return -1;
            }
            return 0;
        }
        System.arraycopy(this.buffer, this.next, b, off, len);
        this.next += len;
        return len;
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.next >= 9999) {
            this.replenish();
        }
        if (this.boundaryIndex >= 0) {
            if (this.next >= this.boundaryIndex) {
                return -1L;
            }
            if (n > (long)(this.boundaryIndex - this.next + 1)) {
                n = this.boundaryIndex - this.next + 1;
            }
        } else if (this.boundaryLimit != 0) {
            if (n > (long)(this.last - this.next + 1 - this.boundary.length)) {
                n = this.last - this.next + 1 - this.boundary.length;
            }
        } else if (n > (long)(this.last - this.next + 1)) {
            n = this.last - this.next + 1;
        }
        this.next = (int)((long)this.next + n);
        return n;
    }

    @Override
    public void mark(int readlimit) {
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void reset() {
    }

    public void setCloseMainOnClose(boolean closeMainOnClose) {
        this.closeMainOnClose = closeMainOnClose;
    }

    @Override
    public void close() throws IOException {
        if (this.closeMainOnClose) {
            this.is.close();
        }
    }

    public void nextBoundary() throws IOException {
        if (this.next == this.boundaryIndex) {
            this.boundaryIndex += this.boundary.length;
            ++this.foundBoundaryCount;
            this.boundary = this.foundBoundaryCount % 2 == 0 ? "<Record_Delimiter".getBytes() : "<".getBytes();
            this.boundaryIndex = this.boundaryIndex > this.last ? -1 : this.boundaryIndexOf(this.boundaryIndex);
            this.replenish();
        }
    }

    public boolean isClosed() {
        return this.isStreamClosed;
    }
}

