/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import java.io.IOException;
import java.io.InputStream;

public class GlenixMultiInputStream
extends InputStream {
    private InputStream is;
    private byte[] buffer = new byte[20000];
    private boolean closed = false;
    private int next = 0;
    private int last = -1;
    private int boundaryIndex = -1;
    private byte[] boundary;
    private boolean isStreamClosed = false;
    private int boundaryLimit = -1;
    private String name = null;
    private boolean lastBoundaryDashDash = false;
    private boolean closeMainOnClose = false;

    public GlenixMultiInputStream(InputStream is, byte[] boundary, int boundaryLimit, String name, boolean lastBoundaryDashDash) throws IOException {
        this.is = is;
        this.boundaryLimit = boundaryLimit;
        this.lastBoundaryDashDash = lastBoundaryDashDash;
        int readlength = is.read(this.buffer);
        if (readlength > 0) {
            this.last += readlength;
        }
        this.boundary = new byte[boundary.length];
        System.arraycopy(boundary, 0, this.boundary, 0, boundary.length);
        this.boundaryIndex = this.boundaryIndexOf(0);
        this.name = name;
    }

    public int boundaryIndexOf(int start) {
        if (this.boundaryLimit == 0) {
            return -1;
        }
        block0: for (int i = start; i <= this.last - this.boundary.length + 1; ++i) {
            for (int j = 0; j <= this.boundary.length; ++j) {
                if (j == this.boundary.length) {
                    --this.boundaryLimit;
                    return i;
                }
                if (!(this.buffer[i + j] == this.boundary[j] || this.lastBoundaryDashDash && (j == this.boundary.length - 2 && this.buffer[i + j] == 45 && this.boundary[j] == 13 || j == this.boundary.length - 1 && this.buffer[i + j] == 45 && this.boundary[j] == 10))) continue block0;
            }
        }
        return -1;
    }

    public int boundaryIndexOfNewLine(int start) {
        byte[] newline = new byte[]{13, 10};
        int checklast = this.boundaryIndex;
        if (checklast < 0) {
            checklast = this.boundaryLimit == 0 ? this.last - 1 : this.last - this.boundary.length - 1;
        }
        block0: for (int i = start; i <= checklast; ++i) {
            for (int j = 0; j <= newline.length; ++j) {
                if (j == newline.length) {
                    return i;
                }
                if (this.buffer[i + j] != newline[j]) continue block0;
            }
        }
        return -1;
    }

    @Override
    public int available() throws IOException {
        if (this.boundaryIndex >= 0) {
            return this.boundaryIndex - this.next;
        }
        if (this.boundaryLimit != 0) {
            return this.last - this.next - this.boundary.length + 1;
        }
        return this.last - this.next + 1;
    }

    private void replenish() throws IOException {
        int readlength;
        if (this.isStreamClosed) {
            return;
        }
        if (this.next > 500 && this.last - this.next + 1 <= this.next) {
            System.arraycopy(this.buffer, this.next, this.buffer, 0, this.last - this.next + 1);
            this.last -= this.next;
            if (this.boundaryIndex >= 0) {
                this.boundaryIndex -= this.next;
            }
            this.next = 0;
        }
        if ((readlength = this.is.read(this.buffer, this.last + 1, 19999 - this.last)) >= 0) {
            int oldlast = this.last;
            this.last += readlength;
            if (this.boundaryIndex < 0 && this.boundaryLimit != 0) {
                this.boundaryIndex = oldlast + 2 - this.boundary.length > this.next ? (oldlast + 2 - this.boundary.length > this.last ? this.boundaryIndexOf(this.last) : this.boundaryIndexOf(oldlast + 2 - this.boundary.length)) : this.boundaryIndexOf(this.next);
            }
        } else {
            this.is.close();
            this.isStreamClosed = true;
        }
    }

    @Override
    public int read() throws IOException {
        if (this.next == this.boundaryIndex) {
            return -1;
        }
        if (this.last - this.boundary.length + 1 <= this.next) {
            this.replenish();
        }
        if (this.boundaryIndex >= 0) {
            return this.buffer[this.next++] & 0xFF;
        }
        if (this.boundaryLimit != 0 || this.boundaryIndex >= 0 ? this.last - this.boundary.length >= this.next : this.last >= this.next) {
            return this.buffer[this.next++] & 0xFF;
        }
        return -1;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.next >= 9999 || this.last - this.next + 1 <= this.boundary.length) {
            this.replenish();
        }
        if (this.boundaryIndex >= 0) {
            if (this.next >= this.boundaryIndex) {
                return -1;
            }
            if (len > this.boundaryIndex - this.next) {
                len = this.boundaryIndex - this.next;
            }
        } else if (this.boundaryLimit != 0) {
            if (len > this.last - this.next + 1 - this.boundary.length) {
                len = this.last - this.next + 1 - this.boundary.length;
            }
        } else if (len > this.last - this.next + 1) {
            len = this.last - this.next + 1;
        }
        if (len <= 0) {
            if (this.isClosed()) {
                return -1;
            }
            return 0;
        }
        System.arraycopy(this.buffer, this.next, b, off, len);
        this.next += len;
        return len;
    }

    public int readln(byte[] b, int off, int len) throws IOException {
        int newlineindex;
        if (this.next >= 9999 || this.last - this.next + 1 <= this.boundary.length) {
            this.replenish();
        }
        if ((newlineindex = this.boundaryIndexOfNewLine(this.next)) < 0) {
            return -1;
        }
        if (newlineindex == this.next) {
            this.skip(2L);
            return -1;
        }
        if (newlineindex > this.next) {
            if (len < newlineindex - this.next) {
                return -1;
            }
            int result = this.read(b, off, newlineindex - this.next);
            this.skip(2L);
            return result;
        }
        return -1;
    }

    public int readln(byte[] buf) throws IOException {
        return this.readln(buf, 0, buf.length);
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.next >= 9999) {
            this.replenish();
        }
        if (this.boundaryIndex >= 0) {
            if (this.next >= this.boundaryIndex) {
                return -1L;
            }
            if (n > (long)(this.boundaryIndex - this.next + 1)) {
                n = this.boundaryIndex - this.next + 1;
            }
        } else if (this.boundaryLimit != 0) {
            if (n > (long)(this.last - this.next + 1 - this.boundary.length)) {
                n = this.last - this.next + 1 - this.boundary.length;
            }
        } else if (n > (long)(this.last - this.next + 1)) {
            n = this.last - this.next + 1;
        }
        this.next = (int)((long)this.next + n);
        return n;
    }

    @Override
    public void mark(int readlimit) {
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void reset() {
    }

    public void setCloseMainOnClose(boolean closeMainOnClose) {
        this.closeMainOnClose = closeMainOnClose;
    }

    @Override
    public void close() throws IOException {
        if (this.closeMainOnClose) {
            this.is.close();
            this.isStreamClosed = true;
        }
    }

    public void nextBoundary() throws IOException {
        if (this.next != this.boundaryIndex) {
            while (!this.isStreamClosed && (this.boundaryIndex = this.boundaryIndexOf(this.next)) <= 0) {
                this.skip(20000L);
                this.replenish();
            }
        }
        if (this.next == this.boundaryIndex) {
            this.next += this.boundary.length;
            this.boundaryIndex += this.boundary.length;
            this.boundaryIndex = this.boundaryIndexOf(this.boundaryIndex);
            if (this.lastBoundaryDashDash && this.buffer[this.next - 2] == 45 && this.buffer[this.next - 1] == 45) {
                try {
                    this.is.close();
                    this.closed = true;
                    this.isStreamClosed = true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.replenish();
        }
    }

    public boolean isClosed() {
        return this.isStreamClosed;
    }
}

