/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import au.com.glenix.GlenixLabelDefaultProvisionComboController;
import au.com.glenix.trn.Provision;
import au.com.glenix.trn.Transaction;
import au.com.glenix.widget.GlenixController;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GlenixLabelProvisionComboController
extends GlenixLabelDefaultProvisionComboController {
    private void buildGlenixXBRLSub(Pane pane, Document resultDoc, Element resultElement) throws Exception {
        for (Node component : pane.getChildren()) {
            if (component instanceof GlenixController) {
                ((GlenixController)component).buildGlenixXBRL(resultDoc, resultElement);
                continue;
            }
            if (!(component instanceof Pane)) continue;
            this.buildGlenixXBRLSub((Pane)component, resultDoc, resultElement);
        }
    }

    @Override
    public void buildGlenixXBRL(Document resultDoc, Element resultElement) throws Exception {
        String nsp = GlenixController.getNSP(this.getGlenixElementNamespace());
        Element el = resultDoc.createElementNS(this.getGlenixElementNamespace(), nsp + ":" + this.getGlenixElementName());
        resultElement.appendChild(el);
        Element idel = resultDoc.createElementNS("http://www.glenix.com.au/", "gx:provisionIdentifier");
        idel.setTextContent(this.getGlenixElementValue());
        el.appendChild(idel);
    }

    @Override
    public void loadGlenixXBRL(Document loadDoc, Element loadElement) throws Exception {
        if (loadElement.getNamespaceURI() != null && loadElement.getNamespaceURI().equals(this.getGlenixElementNamespace()) && loadElement.getLocalName() != null && loadElement.getLocalName().equals(this.getGlenixElementName())) {
            NodeList nodeList = loadElement.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element idElement;
                org.w3c.dom.Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || (idElement = (Element)node).getNamespaceURI() == null || !idElement.getNamespaceURI().equals("http://www.glenix.com.au/") || idElement.getLocalName() == null || !idElement.getLocalName().equals("provisionIdentifier")) continue;
                this.setGlenixElementValue(idElement.getTextContent());
            }
        }
    }

    @Override
    public void setComboId(String id) {
        if (id == null) {
            this.filteredItems.setPredicate(p -> true);
            this.glenixCombo.valueProperty().set(null);
            this.glenixCombo.getSelectionModel().clearSelection();
            return;
        }
        ObservableList ol = this.glenixCombo.getItems();
        for (int i = 0; i < ol.size(); ++i) {
            Transaction t;
            Provision c;
            Object o = ol.get(i);
            if (o == null || !(o instanceof Transaction) || (c = (t = (Transaction)o).getProvision()) == null || !id.equals(c.getProvisionIdentifier())) continue;
            this.glenixCombo.valueProperty().set((Object)t);
            this.glenixCombo.getSelectionModel().clearAndSelect(i);
            return;
        }
        this.filteredItems.setPredicate(p -> true);
        this.glenixCombo.valueProperty().set(null);
        this.glenixCombo.getSelectionModel().clearSelection();
    }
}

