/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import au.com.glenix.trn.Provision;
import au.com.glenix.trn.Transaction;
import au.com.glenix.widget.GlenixLabelAbstractPane;
import java.util.HashMap;
import java.util.Map;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.util.Callback;
import javafx.util.StringConverter;

public class GlenixLabelDefaultProvisionCombo
extends GlenixLabelAbstractPane {
    protected ComboBox glenixCombo = new ComboBox();
    protected FilteredList<Transaction> filteredItems;
    private ChangeListener<Transaction> changeListener = null;

    public GlenixLabelDefaultProvisionCombo() throws Exception {
        this.glenixCombo.getStyleClass().add((Object)"glenixPaneCombo");
        this.getChildren().add((Object)this.glenixCombo);
        Callback<ListView<Transaction>, ListCell<Transaction>> cellFactory = new Callback<ListView<Transaction>, ListCell<Transaction>>(){

            public ListCell<Transaction> call(ListView<Transaction> p) {
                ListCell<Transaction> cell = new ListCell<Transaction>(){

                    protected void updateItem(Transaction t, boolean bln) {
                        super.updateItem((Object)t, bln);
                        if (t != null) {
                            this.setText(t.getProvisionName());
                        } else {
                            this.setText(null);
                        }
                    }
                };
                return cell;
            }
        };
        this.glenixCombo.setConverter((StringConverter)new StringConverter<Transaction>(){
            private Map<String, Transaction> map = new HashMap<String, Transaction>();

            public String toString(Transaction t) {
                if (t != null) {
                    String str = t.getProvisionName();
                    this.map.put(str, t);
                    return str;
                }
                return "";
            }

            public Transaction fromString(String string) {
                return this.map.get(string);
            }
        });
        this.glenixCombo.setButtonCell((ListCell)cellFactory.call(null));
        this.glenixCombo.setCellFactory((Callback)cellFactory);
        this.glenixCombo.setEditable(true);
        this.glenixCombo.valueProperty().addListener((ChangeListener)new ChangeListener<Transaction>(){

            public void changed(ObservableValue<? extends Transaction> observable, Transaction oldValue, Transaction newValue) {
                if (GlenixLabelDefaultProvisionCombo.this.changeListener != null) {
                    GlenixLabelDefaultProvisionCombo.this.changeListener.changed(observable, (Object)oldValue, (Object)newValue);
                }
            }
        });
    }

    @Override
    public Control getControl() {
        return this.glenixCombo;
    }

    public void setSingleTransactionChangeListener(ChangeListener<Transaction> changeListener) {
        this.changeListener = changeListener;
    }

    public void setComboId(String id) {
        if (id == null) {
            if (this.filteredItems != null) {
                this.filteredItems.setPredicate(p -> true);
            }
            this.glenixCombo.valueProperty().set(null);
            this.glenixCombo.getSelectionModel().clearSelection();
            return;
        }
        ObservableList ol = this.glenixCombo.getItems();
        for (int i = 0; i < ol.size(); ++i) {
            Transaction t;
            Provision c;
            Object o = ol.get(i);
            if (o == null || !(o instanceof Transaction) || (c = (t = (Transaction)o).getProvision()) == null || !id.equals(c.getProvisionIdentifier())) continue;
            this.glenixCombo.valueProperty().set((Object)t);
            this.glenixCombo.getSelectionModel().clearAndSelect(i);
            return;
        }
        if (this.filteredItems != null) {
            this.filteredItems.setPredicate(p -> true);
        }
        this.glenixCombo.valueProperty().set(null);
        this.glenixCombo.getSelectionModel().clearSelection();
    }

    @Override
    public String getGlenixElementValue() {
        Transaction t = (Transaction)this.glenixCombo.getSelectionModel().getSelectedItem();
        if (t != null) {
            return t.getProvisionIdentifier();
        }
        t = (Transaction)this.glenixCombo.valueProperty().getValue();
        if (t != null) {
            return t.getProvisionIdentifier();
        }
        return null;
    }

    @Override
    public void setGlenixElementValue(String glenixElementValue) {
        String im = this.getGlenixElementImmutableValue();
        if (im != null) {
            return;
        }
        this.setComboId(glenixElementValue);
    }

    public void setItems(ObservableList<Transaction> ol) {
        this.filteredItems = new FilteredList(ol, p -> true);
        this.glenixCombo.setItems(this.filteredItems);
        this.glenixCombo.getEditor().textProperty().addListener((obs, oldValue, newValue) -> {
            Transaction selected;
            if (this.glenixCombo.focusedProperty().get()) {
                this.glenixCombo.show();
            }
            if ((selected = (Transaction)this.glenixCombo.getSelectionModel().getSelectedItem()) == null || !selected.getProvisionName().equals(newValue)) {
                this.filteredItems.setPredicate(transaction -> {
                    if (newValue != null) {
                        if (transaction == null) {
                            return false;
                        }
                        String provisionName = transaction.getProvisionName();
                        return provisionName != null && provisionName.toLowerCase().contains(newValue.toLowerCase());
                    }
                    return true;
                });
            }
        });
    }

    public void addValueChangeListener(ChangeListener changeListener) {
        this.glenixCombo.valueProperty().addListener(changeListener);
    }

    public Transaction getSelectedProvisionTransaction() {
        return (Transaction)this.glenixCombo.getSelectionModel().getSelectedItem();
    }
}

